/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import util.BaseValueHolder;
import util.TestException;
import util.ValueHolder;

public class VHDataSerializer
extends DataSerializer {
    public Class<?>[] getSupportedClasses() {
        return new Class[]{BaseValueHolder.class};
    }

    public boolean toData(Object o, DataOutput out) throws IOException {
        if (!(o instanceof BaseValueHolder)) {
            return false;
        }
        BaseValueHolder vh = (BaseValueHolder)o;
        out.writeUTF(vh.myValue.getClass().getName());
        if (vh.myValue instanceof Long) {
            out.writeLong((Long)vh.myValue);
        } else if (vh.myValue instanceof String) {
            out.writeUTF((String)vh.myValue);
        } else if (vh.myValue instanceof Integer) {
            out.writeInt((Integer)vh.myValue);
        } else if (vh.myValue instanceof BigInteger) {
            byte[] theBytes = ((BigInteger)vh.myValue).toByteArray();
            out.writeInt(theBytes.length);
            out.write(theBytes);
        } else {
            throw new TestException("Unknown myValue class " + vh.myValue.getClass().getName());
        }
        if (!vh.extraObject.getClass().isArray() || vh.extraObject.getClass().getComponentType() != Byte.TYPE) {
            throw new TestException("Test does not support extraObject of class " + vh.extraObject.getClass().getName());
        }
        byte[] byteArr = (byte[])vh.extraObject;
        out.writeInt(byteArr.length);
        out.write((byte[])vh.extraObject);
        if (vh.modVal == null) {
            out.writeUTF("null");
        } else {
            out.writeUTF(vh.modVal.toString());
        }
        return true;
    }

    public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
        byte[] theBytes;
        int numBytes;
        ValueHolder vh = new ValueHolder();
        String className = in.readUTF();
        if (className.equals(Long.class.getName())) {
            vh.myValue = in.readLong();
        } else if (className.equals(String.class.getName())) {
            vh.myValue = in.readUTF();
        } else if (className.equals(Integer.class.getName())) {
            vh.myValue = in.readInt();
        } else if (className.equals(BigInteger.class.getName())) {
            numBytes = in.readInt();
            theBytes = new byte[numBytes];
            in.readFully(theBytes);
            vh.myValue = new BigInteger(theBytes);
        } else {
            throw new TestException("Unknown class name " + className);
        }
        numBytes = in.readInt();
        theBytes = new byte[numBytes];
        in.readFully(theBytes);
        vh.extraObject = theBytes;
        String aStr = in.readUTF();
        vh.modVal = aStr.equals("null") ? null : Integer.valueOf(aStr);
        return vh;
    }

    public int getId() {
        return 11223344;
    }
}

