/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import parReg.ParRegPrms;
import parReg.tx.ModRoutingObject;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationsClientPrms;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;

public class OperationsClient {
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int PUT_IF_ABSENT_OPERATION = 9;
    protected static final int REMOVE_OPERATION = 10;
    protected static final int REPLACE_OPERATION = 11;
    protected static final int ENTRY_PUTALL_OPERATION = 12;
    protected static String LOCK_SERVICE_NAME = "MyLockService";
    protected static String LOCK_NAME = "MyLock_";
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String VmIDStr = "VmId_";
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    protected RandomValues randomValues = new RandomValues();
    protected int upperThreshold;
    protected int lowerThreshold;
    protected boolean lockOperations;
    protected DistributedLockService distLockService;
    protected boolean useTransactions;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public void initializeOperationsClient() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = OperationsClientPrms.numOpsPerTask();
        this.upperThreshold = TestConfig.tab().intAt(OperationsClientPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(OperationsClientPrms.lowerThreshold, -1);
        this.useTransactions = OperationsClientPrms.useTransactions();
        this.lockOperations = TestConfig.tab().booleanAt(OperationsClientPrms.lockOperations, false);
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", minTaskGranularityMS " + this.minTaskGranularityMS + ", numOpsPerTask " + this.numOpsPerTask + ", useTransactions " + this.useTransactions + ", lockOperations " + this.lockOperations + ", upperThreshold " + this.upperThreshold + ", lowerThreshold " + this.lowerThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doEntryOperations(Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        boolean rolledback = false;
        if (this.useTransactions) {
            TxHelper.begin();
        }
        do {
            block39: {
                int whichOp = this.getOperation(OperationsClientPrms.entryOperations);
                int size = aRegion.size();
                if (size >= this.upperThreshold) {
                    whichOp = this.getOperation(OperationsClientPrms.upperThresholdOperations);
                } else if (size <= this.lowerThreshold) {
                    whichOp = this.getOperation(OperationsClientPrms.lowerThresholdOperations);
                }
                String lockName = null;
                boolean gotTheLock = false;
                if (this.lockOperations) {
                    lockName = LOCK_NAME + TestConfig.tab().getRandGen().nextInt(1, 20);
                    Log.getLogWriter().info("Trying to get distributed lock " + lockName + "...");
                    gotTheLock = this.distLockService.lock((Object)lockName, -1L, -1L);
                    if (!gotTheLock) {
                        throw new TestException("Did not get lock " + lockName);
                    }
                    Log.getLogWriter().info("Got distributed lock " + lockName + ": " + gotTheLock);
                }
                try {
                    switch (whichOp) {
                        case 1: {
                            this.addEntry(aRegion);
                            break;
                        }
                        case 3: {
                            this.invalidateEntry(aRegion, false);
                            break;
                        }
                        case 2: {
                            this.destroyEntry(aRegion, false);
                            break;
                        }
                        case 6: {
                            this.updateEntry(aRegion);
                            break;
                        }
                        case 7: {
                            this.getKey(aRegion);
                            break;
                        }
                        case 8: {
                            this.getNewKey(aRegion);
                            break;
                        }
                        case 5: {
                            this.invalidateEntry(aRegion, true);
                            break;
                        }
                        case 4: {
                            this.destroyEntry(aRegion, true);
                            break;
                        }
                        case 9: {
                            this.putIfAbsent(aRegion, true);
                            break;
                        }
                        case 10: {
                            this.remove(aRegion);
                            break;
                        }
                        case 11: {
                            this.replace(aRegion);
                            break;
                        }
                        case 12: {
                            this.putAll(aRegion);
                            break;
                        }
                        default: {
                            throw new TestException("Unknown operation " + whichOp);
                        }
                    }
                    if (!gotTheLock) break block39;
                    gotTheLock = false;
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    if (!this.useTransactions) {
                        throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        rolledback = true;
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (TransactionException te) {
                        Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                    }
                    if (!gotTheLock) break block39;
                    gotTheLock = false;
                    this.distLockService.unlock((Object)lockName);
                    Log.getLogWriter().info("Released distributed lock " + lockName);
                }
                catch (TransactionDataRebalancedException e2) {
                    if (!this.useTransactions) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e2) + ". " + TestHelper.getStackTrace(e2));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e2) + ".  Expected with concurrent execution, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    rolledback = true;
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                    if (!gotTheLock) break block39;
                    gotTheLock = false;
                    {
                        catch (Throwable throwable) {
                            if (gotTheLock) {
                                gotTheLock = false;
                                this.distLockService.unlock(lockName);
                                Log.getLogWriter().info("Released distributed lock " + lockName);
                            }
                            throw throwable;
                        }
                    }
                    this.distLockService.unlock((Object)lockName);
                    Log.getLogWriter().info("Released distributed lock " + lockName);
                }
                this.distLockService.unlock((Object)lockName);
                Log.getLogWriter().info("Released distributed lock " + lockName);
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
        if (this.useTransactions && !rolledback) {
            int n = 0;
            int commitPercentage = OperationsClientPrms.getCommitPercentage();
            n = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                }
                catch (ConflictException e) {
                    Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
        }
        Log.getLogWriter().info("Done in doEntryOperations with " + aRegion.getFullPath());
    }

    protected void addEntry(Region aRegion) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
    }

    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        Iterator it;
        Set aSet;
        Object key = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt <= 25 && (aSet = aRegion.keySet()).size() > 0 && (it = aSet.iterator()).hasNext()) {
            key = it.next();
        }
        if (key == null) {
            key = this.getNewKey();
        }
        BaseValueHolder anObj = this.getValueForKey(key);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath() + ".");
        }
        Object prevVal = null;
        prevVal = aRegion.putIfAbsent(key, (Object)anObj);
    }

    protected void putAll(Region r) {
        int beforeSize = r.size();
        String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
        int numNewKeysToPut = 0;
        if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
            numNewKeysToPut = this.upperThreshold - beforeSize;
            if (numNewKeysToPut <= 0) {
                numNewKeysToPut = 1;
            } else {
                int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                max = Math.min(numNewKeysToPut, max);
                int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                min = Math.min(min, max);
                numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
            }
        } else {
            numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
        }
        Map mapToPut = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKey();
            BaseValueHolder anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
        List keyList = this.getExistingKeys(r, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        if (keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                Object key = keyList.get(i);
                BaseValueHolder anObj = this.getUpdateObject(r, key);
                mapToPut.put(key, anObj);
                existingKeys.append(key + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        for (Object key : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + key + ", value " + TestHelper.toString(mapToPut.get(key)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aRegion.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    aRegion.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void remove(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("remove: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            Object oldVal = aRegion.get(name);
            this.remove(aRegion, name, oldVal);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    protected void remove(Region aRegion, Object name, Object oldVal) {
        try {
            int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (randInt <= 25) {
                oldVal = this.getUpdateObject(aRegion, name);
            }
            Log.getLogWriter().info("remove: removing " + name + " with previous value " + oldVal + ".");
            boolean removed = aRegion.remove(name, oldVal);
            Log.getLogWriter().info("remove: done removing " + name);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        BaseValueHolder anObj = this.getUpdateObject(aRegion, key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("Done with call to put (update)");
        }
    }

    protected void replace(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("replace: No names in region");
            return;
        }
        Object name = iter.next();
        this.replace(aRegion, name);
    }

    protected void replace(Region aRegion, Object name) {
        Object anObj = null;
        Object prevVal = null;
        boolean replaced = false;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        BaseValueHolder newObj = this.getUpdateObject(aRegion, name);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                anObj = this.getUpdateObject(aRegion, name);
            }
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ".");
            replaced = aRegion.replace(name, anObj, (Object)newObj);
        } else {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                name = this.getNewKey();
            }
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + ".");
            prevVal = aRegion.replace(name, (Object)newObj);
            if (prevVal != null) {
                replaced = true;
            }
        }
        Log.getLogWriter().info("Done with call to replace");
    }

    protected void getKey(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        } else {
            Log.getLogWriter().info("getKey: getting key " + key);
            anObj = aRegion.get(key);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.size();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key);
            anObj = aRegion.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    public BaseValueHolder getValueForKey(Object key) {
        String name = null;
        if (key instanceof ModRoutingObject) {
            ModRoutingObject routingObject = (ModRoutingObject)key;
            name = (String)routingObject.getKey();
        } else {
            name = (String)key;
        }
        return new ValueHolder(name, this.randomValues);
    }

    protected Object getNewKey() {
        String key = NameFactory.getNextPositiveObjectName();
        return key;
    }

    protected Object getRecentKey(Region aRegion, int recentHistory) {
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            return null;
        }
        long keyIndex = TestConfig.tab().getRandGen().nextLong(Math.max(maxNames - (long)recentHistory, 1L), maxNames);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        return key;
    }

    protected BaseValueHolder getUpdateObject(Region aRegion, Object key) {
        BaseValueHolder anObj = (BaseValueHolder)aRegion.get(key);
        BaseValueHolder newObj = null;
        newObj = anObj == null ? (key instanceof String ? new ValueHolder((String)key, this.randomValues) : new ValueHolder(key, this.randomValues)) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putIfAbsent")) {
            op = 9;
        } else if (operation.equals("remove")) {
            op = 10;
        } else if (operation.equals("replace")) {
            op = 11;
        } else if (operation.equals("putAll")) {
            op = 12;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected Object getExistingKey(Region aRegion) {
        Object key = null;
        Object[] keyList = aRegion.keySet().toArray();
        int index = TestConfig.tab().getRandGen().nextInt(0, keyList.length - 1);
        if (index > 0) {
            key = keyList[index];
        }
        return key;
    }

    protected List getExistingKeys(Region aRegion, int numKeysToGet) {
        Log.getLogWriter().info("Trying to get " + numKeysToGet + " existing keys...");
        ArrayList keyList = new ArrayList();
        Set aSet = aRegion.keySet();
        Iterator it = aSet.iterator();
        while (it.hasNext()) {
            keyList.add(it.next());
            if (keyList.size() < numKeysToGet) continue;
            return keyList;
        }
        return keyList;
    }
}

