/*
 * Decompiled with CFR 0.152.
 */
package util;

import hydra.Log;
import java.util.List;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;

public class DistributionStats {
    public static void reportDistributionStats() {
        DistributionStats.printDistributionStats();
    }

    public static void printDistributionStats() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("DISTRIBUTION STATS..............\n");
        buf.append("TotalSentMessages: ");
        int sent = DistributionStats.getStat("sentMessages", "max");
        buf.append(sent).append("\n");
        buf.append("MeanSentMessagesTime: ");
        if (sent != 0) {
            int sentTime = DistributionStats.getStat("sentMessagesTime", "mean");
            buf.append(sentTime).append("\n");
        } else {
            buf.append("none").append("\n");
        }
        buf.append("TotalReceivedMessages: ");
        int received = DistributionStats.getStat("receivedMessages", "max");
        buf.append(received).append("\n");
        buf.append("TotalProcessedMessages: ");
        int processed = DistributionStats.getStat("processedMessages", "max");
        buf.append(processed).append("\n");
        buf.append("MeanProcessedMessagesTime: ");
        if (processed != 0) {
            int processedTime = DistributionStats.getStat("processedMessagesTime", "mean");
            buf.append(processedTime).append("\n");
        } else {
            buf.append("none").append("\n");
        }
        Log.getLogWriter().info(buf.toString());
    }

    private static int getStat(String statName, String opType) {
        String spec = "* DistributionStats * " + statName + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combineAcrossArchives" + " " + "ops" + "=" + opType;
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            Log.getLogWriter().warning("Could not fetch stat " + statName);
            return 0;
        }
        PerfStatValue psv = (PerfStatValue)psvs.get(0);
        if (opType.equals("max")) {
            return (int)psv.getMax();
        }
        if (opType.equals("mean")) {
            return (int)psv.getMean();
        }
        String s = opType + " not implemented yet";
        throw new UnsupportedOperationException(s);
    }
}

