/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.jmx.JMXAdminDistributedSystem;
import hydra.AgentHelper;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import util.AdminHelperPrms;
import util.AdminTestException;

public class AdminTestDistributedSystemFactory {
    public static AdminDistributedSystem getDistributedSystem(DistributedSystemConfig dsConfig) {
        try {
            switch (AdminHelperPrms.getAdminInterface()) {
                case 0: {
                    Log.getLogWriter().fine("Creating an ADMIN AdminDistributedSystem implementation");
                    return AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)dsConfig);
                }
                case 1: {
                    Log.getLogWriter().fine("Creating a JMX AdminDistributedSystem implementation");
                    return AdminTestDistributedSystemFactory.createJMXDistributedSystem(dsConfig);
                }
            }
            String s = "Unknown Admin Interface type: " + AdminHelperPrms.getAdminInterface();
            throw new HydraConfigException(s);
        }
        catch (Exception e) {
            String s = "Problem creating AdminDistributedSystem implementation";
            throw new AdminTestException(s, e);
        }
    }

    private static AdminDistributedSystem createJMXDistributedSystem(DistributedSystemConfig config) {
        List agents = AgentHelper.getEndpoints();
        if (agents.isEmpty()) {
            String s = "No JMX Agents have been configured";
            throw new HydraConfigException(s);
        }
        AgentHelper.Endpoint agent = (AgentHelper.Endpoint)agents.iterator().next();
        String agentProtocol = "rmi";
        String urlString = "service:jmx:" + agentProtocol + "://" + agent.getHost() + "/jndi/rmi://" + agent.getHost() + ":" + agent.getPort() + "/jmxconnector";
        try {
            JMXServiceURL url = new JMXServiceURL(urlString);
            JMXConnector conn = JMXConnectorFactory.connect(url);
            MBeanServerConnection mbs = conn.getMBeanServerConnection();
            ObjectName bean = new ObjectName("GemFire:type=Agent");
            String bindAddress = HostHelper.getHostAddress(HostHelper.getIPAddress());
            return new JMXAdminDistributedSystem(config.getMcastAddress(), config.getMcastPort(), config.getLocators(), bindAddress, config.getRemoteCommand(), mbs, conn, bean);
        }
        catch (Exception ex) {
            String s = "While connecting to JMX Agent";
            throw new HydraRuntimeException(s, ex);
        }
    }
}

