/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.Region;
import diskReg.DiskRegUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.TestConfig;
import tx.Operation;
import tx.TxBB;
import tx.TxUtil;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class TxUtilKeyRange
extends TxUtil {
    protected static final int KEY_RANGE = 50;
    public HydraThreadLocal lowerKeyRange = new HydraThreadLocal();
    public HydraThreadLocal upperKeyRange = new HydraThreadLocal();

    @Override
    public void initialize() {
        long uniqueKeyCounter = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.UniqueKeyCounter);
        int lower = (int)((uniqueKeyCounter - 1L) * 50L + 1L);
        int upper = (int)(uniqueKeyCounter * 50L);
        this.lowerKeyRange.set(new Integer(lower));
        this.upperKeyRange.set(new Integer(upper));
        Log.getLogWriter().info("LowerKeyRange is " + this.lowerKeyRange.get() + ", upperKeyRange is " + this.upperKeyRange.get());
        super.initialize();
    }

    @Override
    public Object getRandomKey(Region aRegion, Object excludeKey) {
        long randomKeyIndex;
        long start = System.currentTimeMillis();
        int lower = (Integer)this.lowerKeyRange.get();
        int upper = (Integer)this.upperKeyRange.get();
        long startKeyIndex = randomKeyIndex = TestConfig.tab().getRandGen().nextLong(lower, upper);
        String key = NameFactory.getObjectNameForCounter(randomKeyIndex);
        while (true) {
            boolean done = false;
            if (!key.equals(excludeKey) && aRegion.containsKey((Object)key)) {
                done = true;
            }
            if (done) break;
            if (++randomKeyIndex > (long)upper) {
                randomKeyIndex = lower;
            }
            if (randomKeyIndex == startKeyIndex) {
                key = null;
                break;
            }
            key = NameFactory.getObjectNameForCounter(randomKeyIndex);
        }
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("Done in TxUtilKeyRange:getRandomKey, key is " + key + " " + aRegion.getFullPath() + " getRandomKey took " + (end - start) + " millis");
        return key;
    }

    @Override
    public Operation createEntry(Region aRegion, boolean exists) {
        long keyIndex;
        int lower = (Integer)this.lowerKeyRange.get();
        int upper = (Integer)this.upperKeyRange.get();
        long startKeyIndex = keyIndex = (long)TestConfig.tab().getRandGen().nextInt(lower, upper);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        boolean containsKey = aRegion.containsKey((Object)key);
        while (containsKey) {
            if (++keyIndex > (long)upper) {
                keyIndex = lower;
            }
            if (keyIndex == startKeyIndex) {
                return null;
            }
            key = NameFactory.getObjectNameForCounter(keyIndex);
            containsKey = aRegion.containsKey((Object)key);
        }
        ValueHolder vh = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer++));
        try {
            Log.getLogWriter().info("createEntryKeyRange: putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
            aRegion.put((Object)key, (Object)vh);
            Log.getLogWriter().info("createEntryKeyRange: done putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new Operation(aRegion.getFullPath(), key, "entry-create", null, vh.modVal);
    }

    public void printKeyRange(Region aRegion) {
        int lower = (Integer)this.lowerKeyRange.get();
        int upper = (Integer)this.upperKeyRange.get();
        StringBuffer aStr = new StringBuffer();
        for (int i = lower; i <= upper; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            aStr.append("key " + key + " containsKey: " + aRegion.containsKey((Object)key) + ", containsValueForKey: " + aRegion.containsValueForKey((Object)key) + ", getValueInVM: " + DiskRegUtil.getValueInVM(aRegion, key) + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }
}

