/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import parReg.ParRegPrms;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import util.BaseValueHolder;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class TxUtil {
    public static TxUtil txUtilInstance = null;
    public RandomValues randomValues = null;
    protected int maxKeys;
    public int modValInitializer = 0;
    protected boolean isSerialExecution;
    protected boolean isBridgeClient;
    protected HydraThreadLocal txState = new HydraThreadLocal();
    public boolean suspendResume = false;
    public static final int NO_REPLICATION_RESTRICTION = 0;
    public static final int NO_REPLICATION = 1;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String memberIdString = " memberId=";

    public static synchronized void StartTask_initialize() {
        String viewDataPolicies = TestConfig.tab().stringAt(TxPrms.viewDataPolicies, "none");
        if (viewDataPolicies.equals("none")) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(viewDataPolicies, "-");
        int i = 1;
        while (tokenizer.hasMoreTokens()) {
            String dataPolicy = tokenizer.nextToken();
            TxBB.getBB().getSharedMap().put(TxBB.DataPolicyPrefix + "client" + i, dataPolicy);
            ++i;
        }
        TxBB.getBB().printSharedMap();
    }

    public synchronized void initialize() {
        this.randomValues = new RandomValues();
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
    }

    public static void HydraTask_startBridgeServer() {
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    public static void HydraTask_stopBridgeServer() {
        BridgeHelper.stopBridgeServer();
        CacheHelper.closeCache();
    }

    public static synchronized void HydraTask_createRegionForest() {
        Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        CacheUtil.setCache(c);
        if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
            c.setCopyOnRead(true);
        }
        if (txUtilInstance == null) {
            txUtilInstance = new TxUtil();
            txUtilInstance.initialize();
            txUtilInstance.createRegionHierarchy();
        }
        txUtilInstance.summarizeRegionHier();
    }

    public static synchronized void HydraTask_createPartitionedRegions() {
        if (txUtilInstance == null) {
            txUtilInstance = new TxUtil();
            try {
                txUtilInstance.createPartitionedRegions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    public void createPartitionedRegions() {
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            CacheUtil.setCache(c);
            c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
            c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
            if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
                c.setCopyOnRead(true);
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            int numRegions = TestConfig.tab().intAt(TxPrms.numRootRegions);
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                Region aRegion = RegionHelper.createRegion(regionName, aFactory);
                if (aRegion.getAttributes().getPoolName() != null) {
                    aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                    this.isBridgeClient = true;
                    Log.getLogWriter().info("registered interest in ALL_KEYS for " + regionName);
                }
                this.recordRegionConfigInBB(aRegion.getFullPath(), regionConfig);
            }
        }
    }

    public static void HydraTask_populateRegions() {
        txUtilInstance.initialize();
        txUtilInstance.populateRegions();
    }

    public void populateRegions() {
        Set regions = CacheUtil.getCache().rootRegions();
        for (Region aRegion : regions) {
            this.createEntries(aRegion);
        }
    }

    public static void HydraTask_doOperations() {
        OpList opList = TxUtil.doOperations();
        TxBB.putOpList(opList);
        Log.getLogWriter().info("Read opList: " + TxBB.getOpList());
    }

    public static void logExecutionNumber() {
        long exeNum = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    public static boolean logRoundRobinNumber() {
        TxBB BB2 = TxBB.getBB();
        String rrStartThread = (String)BB2.getSharedMap().get(TxBB.RoundRobinStartThread);
        String currentThreadName = Thread.currentThread().getName();
        if (rrStartThread == null) {
            rrStartThread = currentThreadName;
            BB2.getSharedMap().put(TxBB.RoundRobinStartThread, rrStartThread);
        }
        if (currentThreadName.equals(rrStartThread)) {
            long rrNum = TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.RoundRobinNumber);
            Log.getLogWriter().info("Beginning round " + rrNum);
            return true;
        }
        return false;
    }

    public static long getRoundRobinNumber() {
        return TxBB.getBB().getSharedCounters().read(TxBB.RoundRobinNumber);
    }

    public void createRegionHierarchy() {
        int numRoots = TestConfig.tab().intAt(TxPrms.numRootRegions);
        int breadth = TestConfig.tab().intAt(TxPrms.numSubRegions);
        int depth = TestConfig.tab().intAt(TxPrms.regionDepth);
        Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        CacheUtil.setCache(c);
        c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
        c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
        Object r = null;
        for (int i = 0; i < numRoots; ++i) {
            String rootName = "root" + (i + 1);
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            String clientName = System.getProperty("clientName");
            String mapKey = TxBB.DataPolicyPrefix + clientName;
            String dataPolicy = (String)TxBB.getBB().getSharedMap().get(mapKey);
            if (dataPolicy != null) {
                aFactory.setDataPolicy(TestHelper.getDataPolicy(dataPolicy));
            }
            Region rootRegion = RegionHelper.createRegion(rootName, aFactory);
            Log.getLogWriter().info("Created root region " + rootName);
            if (rootRegion.getAttributes().getPoolName() != null) {
                rootRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                this.isBridgeClient = true;
                Log.getLogWriter().info("registered interest in ALL_KEYS for " + rootName);
            }
            this.recordRegionConfigInBB(rootRegion.getFullPath(), regionConfig);
            this.createEntries(rootRegion);
            this.createSubRegions(rootRegion, breadth, depth, "Region");
        }
    }

    private void createSubRegions(Region r, int numChildren, int levelsLeft, String parentName) {
        for (int i = 1; i <= numChildren; ++i) {
            String currentName = parentName + "-" + i;
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            String clientName = System.getProperty("clientName");
            String mapKey = TxBB.DataPolicyPrefix + clientName;
            String dataPolicy = (String)TxBB.getBB().getSharedMap().get(mapKey);
            if (dataPolicy != null) {
                aFactory.setDataPolicy(TestHelper.getDataPolicy(dataPolicy));
            }
            Region child = null;
            try {
                RegionAttributes regionAttrs = RegionHelper.getRegionAttributes(aFactory);
                if (regionAttrs.getDataPolicy().withPersistence() || regionAttrs.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    DiskStoreHelper.createDiskStore(regionAttrs.getDiskStoreName());
                }
                child = r.createSubregion(currentName, regionAttrs);
                Log.getLogWriter().info("Created subregion " + TestHelper.regionToString(child, true));
                if (child.getAttributes().getPoolName() != null) {
                    child.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                    Log.getLogWriter().info("registered interest in ALL_KEYS for " + currentName);
                }
                this.recordRegionConfigInBB(child.getFullPath(), regionConfig);
            }
            catch (RegionExistsException e) {
                child = r.getSubregion(currentName);
                Log.getLogWriter().info("Got subregion " + TestHelper.regionToString(child, true));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            this.createEntries(child);
            if (levelsLeft <= 1) continue;
            this.createSubRegions(child, numChildren, levelsLeft - 1, currentName);
        }
    }

    public void createEntries(Region aRegion) {
        this.maxKeys = TestConfig.tab().intAt(TxPrms.maxKeys, 10);
        long startKey = 0L;
        for (int i = 0; i < this.maxKeys; ++i) {
            String key = NameFactory.getObjectNameForCounter(startKey + (long)i);
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, startKey + (long)i);
            ValueHolder val = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer));
            ++this.modValInitializer;
            String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            try {
                aRegion.create((Object)key, (Object)val, (Object)callback);
            }
            catch (RegionDestroyedException e) {
                if (this.isSerialExecution) {
                    throw e;
                }
                Log.getLogWriter().info("Created " + i + " keys in " + aRegion.getFullPath() + " before getting " + (Object)((Object)e) + "; continuing test");
                break;
            }
            catch (EntryExistsException e) {
                Log.getLogWriter().fine("Created via distribution in region <" + aRegion.getFullPath() + "> " + key + " = " + ((Object)val).toString());
                continue;
            }
            Log.getLogWriter().fine("Created in region <" + aRegion.getFullPath() + "> " + key + " = " + ((Object)val).toString());
        }
    }

    public Region getRandomRegion(boolean allowRootRegion) {
        Region aRegion = null;
        String regionName = TestConfig.tab().stringAt(TxPrms.excludeRegionName, null);
        if (regionName != null) {
            aRegion = CacheUtil.getCache().getRegion(regionName);
        }
        return this.getRandomRegion(allowRootRegion, aRegion, 0);
    }

    public Region getRandomRegionNoReplication(boolean allowRootRegion) {
        Region aRegion = null;
        String regionName = TestConfig.tab().stringAt(TxPrms.excludeRegionName, null);
        if (regionName != null) {
            aRegion = CacheUtil.getCache().getRegion(regionName);
        }
        return this.getRandomRegion(allowRootRegion, null, 1);
    }

    public Region getRandomRegion(boolean allowRootRegion, Region excludeRegion, int restriction) {
        int i;
        Object[] rootRegionArr = CacheUtil.getCache().rootRegions().toArray();
        if (rootRegionArr.length == 0) {
            return null;
        }
        ArrayList<Object> regionList = new ArrayList<Object>();
        if (allowRootRegion) {
            for (i = 0; i < rootRegionArr.length; ++i) {
                regionList.add(rootRegionArr[i]);
            }
        }
        for (i = 0; i < rootRegionArr.length; ++i) {
            Region rootRegion = (Region)rootRegionArr[i];
            Object[] regionArr = this.getSubregions(rootRegion, true).toArray();
            for (int j = 0; j < regionArr.length; ++j) {
                regionList.add(regionArr[j]);
            }
        }
        if (regionList.size() == 0) {
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, regionList.size() - 1);
        Region aRegion = (Region)regionList.get(randInt);
        if (restriction != 0 || excludeRegion != null) {
            int startIndex = randInt;
            boolean done = true;
            do {
                done = true;
                try {
                    if (restriction == 1) {
                        boolean bl = done = !this.isHierReplicated(aRegion);
                    }
                    if (excludeRegion != null && aRegion.getFullPath().equals(excludeRegion.getFullPath())) {
                        done = false;
                    }
                }
                catch (RegionDestroyedException e) {
                    done = false;
                }
                if (done) break;
                if (++randInt == regionList.size()) {
                    randInt = 0;
                }
                if (randInt == startIndex) {
                    return null;
                }
                aRegion = (Region)regionList.get(randInt);
            } while (!done);
        }
        return aRegion;
    }

    public void dispAllKeys() {
        Cache c = CacheUtil.getCache();
        Set roots = c.rootRegions();
        for (Region aRegion : roots) {
            Set subRegions = this.getSubregions(aRegion, true);
            for (Region sRegion : subRegions) {
                Set keys = sRegion.keySet();
                for (String key : keys) {
                    BaseValueHolder value = null;
                    try {
                        value = (BaseValueHolder)sRegion.get((Object)key);
                    }
                    catch (Exception e) {
                        throw new HydraRuntimeException("Error in get(key)", e);
                    }
                    if (value != null) {
                        Log.getLogWriter().info("Key(" + key + ") = {" + value.getMyValue() + ", " + value.getModVal() + "}");
                        continue;
                    }
                    throw new HydraRuntimeException("Key(" + key + ") has value null");
                }
            }
        }
    }

    public void summarizeRegionHier() {
        StringBuffer aStr = new StringBuffer();
        Cache c = CacheUtil.getCache();
        Set roots = c.rootRegions();
        if (roots.size() == 0) {
            Log.getLogWriter().info("No region roots");
            return;
        }
        for (Region root : roots) {
            aStr.append(root.getFullPath() + " (" + root.getAttributes().getScope() + "): " + root.keySet().size() + " keys\n");
            class RegionComparator
            implements Comparator {
                RegionComparator() {
                }

                public int compare(Object o1, Object o2) {
                    return ((Region)o1).getFullPath().compareTo(((Region)o2).getFullPath());
                }

                @Override
                public boolean equals(Object anObj) {
                    return ((Region)this).getFullPath().equals(((Region)anObj).getFullPath());
                }
            }
            TreeSet aSet = new TreeSet(new RegionComparator());
            aSet.addAll(this.getSubregions(root, true));
            for (Region aRegion : aSet) {
                String regionName = aRegion.getFullPath();
                try {
                    TreeSet keySet = new TreeSet(aRegion.keySet());
                    aStr.append("   " + regionName + " (" + aRegion.getAttributes().getScope() + "): " + keySet.size() + " keys\n");
                    if (keySet.size() <= 0) continue;
                    Iterator keyIt = keySet.iterator();
                    aStr.append("      ");
                    while (keyIt.hasNext()) {
                        aStr.append(keyIt.next() + " ");
                    }
                    aStr.append("\n");
                }
                catch (RegionDestroyedException e) {
                    aStr.append("   " + regionName + " is destroyed\n");
                }
            }
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public static OpList doOperations() {
        boolean allowGetOperations = true;
        return TxUtil.doOperations(allowGetOperations);
    }

    public static OpList doOperations(boolean allowGetOperations) {
        HydraVector operations = TestConfig.tab().vecAt(TxPrms.operations);
        int numOps = TestConfig.tab().intAt(TxPrms.numOps);
        OpList opList = null;
        if (txUtilInstance != null) {
            opList = txUtilInstance.doOperations(operations, numOps, allowGetOperations);
        }
        return opList;
    }

    public OpList doOperations(Vector operations, int numOperationsToDo) {
        boolean allowGetOperations = true;
        return this.doOperations(operations, numOperationsToDo, allowGetOperations);
    }

    public OpList doOperations(Vector operations, int numOperationsToDo, boolean allowGetOperations) {
        Log.getLogWriter().info("Executing " + numOperationsToDo + " random operations...");
        long TIME_LIMIT_MS = 60000L;
        long timeOfLastOp = System.currentTimeMillis();
        OpList opList = new OpList();
        int numOpsCompleted = 0;
        while (numOpsCompleted < numOperationsToDo) {
            Region aRegion;
            Object[] rootRegionArr;
            Operation op = null;
            String operation = (String)operations.get(TestConfig.tab().getRandGen().nextInt(0, operations.size() - 1));
            if (!operation.equals("cache-close") && !operation.equals("region-create") && (rootRegionArr = CacheUtil.getCache().rootRegions().toArray()).length == 0) {
                if (operations.indexOf("region-create") < 0) {
                    throw new TestException("No regions are available and no create region operation is specified");
                }
                Log.getLogWriter().info("In doOperations, forcing region create because no regions are present");
                operation = "region-create";
            }
            if (operation.startsWith("entry-get") && !allowGetOperations) {
                operation = "entry-create";
            }
            Log.getLogWriter().info("Operation is " + operation);
            if (operation.equalsIgnoreCase("entry-create")) {
                op = this.createEntry(this.getRandomRegion(true), false);
            } else if (operation.equalsIgnoreCase("entry-update")) {
                aRegion = this.getRandomRegion(true);
                op = this.updateEntry(aRegion, this.getRandomKey(aRegion));
            } else if (operation.equalsIgnoreCase("entry-destroy")) {
                aRegion = this.getRandomRegion(true);
                op = this.destroyEntry(false, aRegion, this.getRandomKey(aRegion), false);
            } else if (operation.equalsIgnoreCase("entry-localDestroy")) {
                aRegion = this.getRandomRegionNoReplication(true);
                if (aRegion != null) {
                    op = this.destroyEntry(true, aRegion, this.getRandomKey(aRegion), false);
                }
            } else if (operation.equalsIgnoreCase("entry-inval")) {
                aRegion = this.getRandomRegion(true);
                op = this.invalEntry(false, aRegion, this.getRandomKey(aRegion), false);
            } else if (operation.equalsIgnoreCase("entry-localInval")) {
                aRegion = this.getRandomRegionNoReplication(true);
                if (aRegion != null) {
                    op = this.invalEntry(true, aRegion, this.getRandomKey(aRegion), false);
                }
            } else if (operation.equalsIgnoreCase("entry-getWithNewKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getEntryWithNewKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithExistingKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getWithExistingKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getWithPreviousKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getEntryWithPreviousKey(aRegion);
            } else if (operation.equalsIgnoreCase("region-create")) {
                op = this.createRegion();
            } else if (operation.equalsIgnoreCase("region-destroy")) {
                op = this.destroyRegion(false, this.getRandomRegion(true));
            } else if (operation.equalsIgnoreCase("region-localDestroy")) {
                aRegion = this.getRandomRegionNoReplication(true);
                if (aRegion != null) {
                    op = this.destroyRegion(true, aRegion);
                }
            } else if (operation.equalsIgnoreCase("region-inval")) {
                aRegion = this.getRandomRegion(true);
                op = this.invalRegion(false, this.getRandomRegion(true));
            } else if (operation.equalsIgnoreCase("region-localInval")) {
                aRegion = this.getRandomRegionNoReplication(true);
                if (aRegion != null) {
                    op = this.invalRegion(true, aRegion);
                }
            } else if (operation.equalsIgnoreCase("cache-close")) {
                op = this.closeCache();
            } else {
                throw new TestException("Unknown operation " + operation);
            }
            if (op == null) {
                if (System.currentTimeMillis() - timeOfLastOp <= 60000L) continue;
                throw new TestException("Could not execute a successful operation in 60000 millis; possible test config problem");
            }
            opList.add(op);
            ++numOpsCompleted;
            timeOfLastOp = System.currentTimeMillis();
        }
        Log.getLogWriter().info("Completed execution of " + opList);
        return opList;
    }

    public OpList doRepeatableReadOperations(int numOperationsToDo) {
        Log.getLogWriter().info("Executing " + numOperationsToDo + " random repeatable read operations...");
        List repeatableReadOps = this.isBridgeClient ? Operation.clientRepeatableReadOps : Operation.repeatableReadOps;
        OpList opList = new OpList();
        int numOpsCompleted = 0;
        GsRandom rand = TestConfig.tab().getRandGen();
        while (numOpsCompleted < numOperationsToDo) {
            List<Object> aList;
            String key;
            Region aRegion;
            Operation op = null;
            int nextRepeatableRead = (int)TxBB.getBB().getSharedCounters().incrementAndRead(TxBB.nextRepeatableRead);
            if (nextRepeatableRead >= repeatableReadOps.size()) {
                nextRepeatableRead = 0;
            }
            String operation = (String)repeatableReadOps.get(nextRepeatableRead);
            Log.getLogWriter().info("Repeatable read operation is " + operation);
            if (operation.equalsIgnoreCase("entry-getWithExistingKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getWithExistingKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-getEntryWithExistingKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.getEntryWithExistingKey(aRegion);
            } else if (operation.equalsIgnoreCase("entry-create")) {
                aRegion = this.getRandomRegion(true);
                op = this.createEntry(aRegion, true);
            } else if (operation.equalsIgnoreCase("entry-containsKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.containsKeyExisting(aRegion);
            } else if (operation.equalsIgnoreCase("entry-containsValueForKey")) {
                aRegion = this.getRandomRegion(true);
                op = this.containsValueForKeyExisting(aRegion);
            } else if (operation.equalsIgnoreCase("entry-containsValue")) {
                aRegion = this.getRandomRegion(true);
                op = this.containsValueExisting(aRegion);
            } else if (operation.equalsIgnoreCase("entry-inval")) {
                aRegion = this.getRandomRegion(true);
                key = NameFactory.getNextPositiveObjectName();
                op = this.invalEntry(false, aRegion, key, true);
            } else if (operation.equalsIgnoreCase("entry-localInval")) {
                aRegion = this.getRandomRegion(true);
                key = NameFactory.getNextPositiveObjectName();
                op = this.invalEntry(true, aRegion, key, true);
            } else if (operation.equalsIgnoreCase("entry-destroy")) {
                aRegion = this.getRandomRegion(true);
                key = NameFactory.getNextPositiveObjectName();
                op = this.destroyEntry(false, aRegion, key, true);
            } else if (operation.equalsIgnoreCase("entry-localDestroy")) {
                aRegion = this.getRandomRegion(true);
                key = NameFactory.getNextPositiveObjectName();
                op = this.destroyEntry(true, aRegion, key, true);
            } else if (operation.equalsIgnoreCase("entry-remove")) {
                aRegion = this.getRandomRegion(true);
                op = this.removeEntry(aRegion, false);
            } else if (operation.equalsIgnoreCase("region-keys")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.keySet().toArray() on " + aRegion.getFullPath());
                aList = Arrays.asList(aRegion.keySet().toArray());
                Log.getLogWriter().info("Done calling aRegion.keySet().toArray() on " + aRegion.getFullPath() + " with result " + aList);
                op = new Operation(aRegion.getFullPath(), null, "region-keys", null, null);
            } else if (operation.equalsIgnoreCase("region-keySet")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.keySet().toArray() on " + aRegion.getFullPath());
                aList = Arrays.asList(aRegion.keySet().toArray());
                Log.getLogWriter().info("Done calling aRegion.keySet().toArray() on " + aRegion.getFullPath() + " with result " + aList);
                op = new Operation(aRegion.getFullPath(), null, "region-keySet", null, null);
            } else if (operation.equalsIgnoreCase("region-values")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.values().toArray() on " + aRegion.getFullPath());
                aList = Arrays.asList(aRegion.values().toArray());
                Log.getLogWriter().info("Done calling aRegion.values().toArray() on " + aRegion.getFullPath() + " with result " + aList);
                op = new Operation(aRegion.getFullPath(), null, "region-values", null, null);
            } else if (operation.equalsIgnoreCase("region-entries")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.entries(false).toArray() on " + aRegion.getFullPath());
                aList = Arrays.asList(aRegion.entries(false).toArray());
                Log.getLogWriter().info("Done calling aRegion.entries(false).toArray() on " + aRegion.getFullPath() + " with result " + aList);
                op = new Operation(aRegion.getFullPath(), null, "region-entries", null, null);
            } else if (operation.equalsIgnoreCase("region-entrySet")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.entrySet().toArray() on " + aRegion.getFullPath());
                aList = Arrays.asList(aRegion.entrySet().toArray());
                Log.getLogWriter().info("Done calling aRegion.entrySet().toArray() on " + aRegion.getFullPath() + " with result " + aList);
                op = new Operation(aRegion.getFullPath(), null, "region-entrySet", null, null);
            } else {
                throw new TestException("Test config problem; Unknown repeatable read op " + operation);
            }
            if (op == null) continue;
            op.setRepeatableRead(true);
            opList.add(op);
            ++numOpsCompleted;
        }
        Log.getLogWriter().info("Completed execution of " + opList);
        return opList;
    }

    public OpList doNonrepeatableReadOperations(int numOperationsToDo) {
        Log.getLogWriter().info("Executing " + numOperationsToDo + " random NON-repeatable read operations...");
        OpList opList = new OpList();
        GsRandom rand = TestConfig.tab().getRandGen();
        for (int numOpsCompleted = 0; numOpsCompleted < numOperationsToDo; ++numOpsCompleted) {
            Region aRegion;
            Operation op = null;
            String operation = (String)Operation.nonrepeatableReadOps.get(rand.nextInt(0, Operation.nonrepeatableReadOps.size() - 1));
            Log.getLogWriter().info("Nonrepeatable read operation is " + operation);
            if (operation.equalsIgnoreCase("region-keys")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.keySet() on " + aRegion.getFullPath());
                aRegion.keySet();
                Log.getLogWriter().info("Done calling aRegion.keySet() on " + aRegion.getFullPath());
                op = new Operation(aRegion.getFullPath(), null, "region-keys", null, null);
            } else if (operation.equalsIgnoreCase("region-keySet")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.keySet() on " + aRegion.getFullPath());
                aRegion.keySet();
                Log.getLogWriter().info("Done calling aRegion.keySet() on " + aRegion.getFullPath());
                op = new Operation(aRegion.getFullPath(), null, "region-keySet", null, null);
            } else if (operation.equalsIgnoreCase("region-values")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.values() on " + aRegion.getFullPath());
                aRegion.values();
                Log.getLogWriter().info("Done calling aRegion.values() on " + aRegion.getFullPath());
                op = new Operation(aRegion.getFullPath(), null, "region-values", null, null);
            } else if (operation.equalsIgnoreCase("region-entries")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.entries(true) on " + aRegion.getFullPath());
                aRegion.entries(true);
                Log.getLogWriter().info("Done calling aRegion.entries(true) on " + aRegion.getFullPath());
                op = new Operation(aRegion.getFullPath(), null, "region-entries", null, null);
            } else if (operation.equalsIgnoreCase("region-entrySet")) {
                aRegion = this.getRandomRegion(true);
                Log.getLogWriter().info("Calling aRegion.entrySet() on " + aRegion.getFullPath());
                aRegion.entrySet();
                Log.getLogWriter().info("Done calling aRegion.entrySet() on " + aRegion.getFullPath());
                op = new Operation(aRegion.getFullPath(), null, "region-entrySet", null, null);
            } else {
                throw new TestException("Test config problem; Unknown nonrepeatable read op " + operation);
            }
            opList.add(op);
        }
        Log.getLogWriter().info("Completed execution of " + opList);
        return opList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Operation createEntry(Region aRegion, boolean exists) {
        Object key = null;
        if (exists) {
            key = this.getRandomKey(aRegion);
            if (key == null) {
                Log.getLogWriter().info("Could not get with an existing key " + aRegion.getFullPath() + " because no keys are available");
                return null;
            }
        } else {
            key = this.getNewKey(aRegion);
        }
        Object oldValue = null;
        ValueHolder vh = new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
        String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        try {
            if (this.supportsConcurrentMapOps(aRegion) && TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("createEntry: putting key (putIfAbsent) " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
                Object v = aRegion.putIfAbsent(key, (Object)vh);
                if (v != null) {
                    if (!exists) throw new TestException(TestHelper.getStackTrace());
                    Log.getLogWriter().info("putIfAbsent returned " + v + ".  Expected as this entry already existed");
                }
            } else {
                Log.getLogWriter().info("createEntry: putting key (create) " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
                aRegion.create(key, (Object)vh, (Object)callback);
            }
            Log.getLogWriter().info("createEntry: done putting key " + key + ", object " + vh.toString() + " in region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), key, "entry-create", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (!this.isSerialExecution) return null;
            throw e;
        }
        catch (EntryExistsException e) {
            if (!exists) throw new TestException(TestHelper.getStackTrace(e));
            Log.getLogWriter().info("Caught expected " + e.toString());
            return new Operation(aRegion.getFullPath(), key, "entry-create", oldValue, vh.modVal);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation updateEntry(Region aRegion, Object key) {
        if (key == null) {
            Log.getLogWriter().info("Could not update a key in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        BaseValueHolder vh = null;
        Log.getLogWriter().info("updateEntry: Getting value to prepare for update for key " + key + " in region " + aRegion.getFullPath());
        Object oldValue = this.getValueInVM(aRegion, key);
        if (oldValue instanceof BaseValueHolder) {
            vh = (BaseValueHolder)oldValue;
            oldValue = ((BaseValueHolder)oldValue).modVal;
        } else {
            vh = new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
        }
        Log.getLogWriter().info("updateEntry: Value to update is " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        vh = (BaseValueHolder)CopyHelper.copy((Object)vh);
        vh.modVal = new Integer(vh.modVal + 1);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        try {
            Log.getLogWriter().info("updateEntry: Putting new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
            if (this.supportsConcurrentMapOps(aRegion) && TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("updateEntry: Putting (replace) new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
                aRegion.replace(key, (Object)vh);
            } else {
                Log.getLogWriter().info("updateEntry: Putting (put) new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
                aRegion.put(key, (Object)vh, (Object)callback);
            }
            Log.getLogWriter().info("updateEntry: Done putting new value " + vh + " for key " + key + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new Operation(aRegion.getFullPath(), key, "entry-update", oldValue, vh.modVal);
    }

    public List<Operation> putAll(Region r) {
        ArrayList<Operation> opList = new ArrayList<Operation>();
        Random random = new Random();
        int beforeSize = r.size();
        String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
        int numNewKeysToPut = 0;
        if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
            numNewKeysToPut = random.nextInt(5);
            if (numNewKeysToPut <= 0) {
                numNewKeysToPut = 1;
            } else {
                int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                max = Math.min(numNewKeysToPut, max);
                int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                min = Math.min(min, max);
                numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
            }
        } else {
            numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
        }
        LinkedHashMap<Object, BaseValueHolder> mapToPut = new LinkedHashMap<Object, BaseValueHolder>();
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKey(r);
            ValueHolder anObj = new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
            mapToPut.put(key, anObj);
            opList.add(new Operation(r.getFullPath(), key, "entry-create", null, anObj.modVal));
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
        ArrayList<Object> keyList = new ArrayList<Object>();
        int keyCount = 0;
        while (keyCount < numPutAllExistingKeys) {
            Object key = this.getRandomKey(r);
            if (key != null) {
                keyList.add(key);
                ++keyCount;
            }
            if (beforeSize >= numPutAllExistingKeys) continue;
            break;
        }
        StringBuffer existingKeys = new StringBuffer();
        if (keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                Object key = keyList.get(i);
                BaseValueHolder anObj = this.getUpdateObject(r, key);
                mapToPut.put(key, anObj);
                Object oldValue = this.getValueInVM(r, key);
                if (oldValue instanceof BaseValueHolder) {
                    oldValue = ((BaseValueHolder)oldValue).modVal;
                }
                opList.add(new Operation(r.getFullPath(), key, "entry-update", oldValue, anObj.modVal));
                existingKeys.append(key + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        for (Object key : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + key + ", value " + TestHelper.toString(mapToPut.get(key)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
        return opList;
    }

    private BaseValueHolder getUpdateObject(Region r, Object key) {
        BaseValueHolder vh = null;
        Object oldValue = this.getValueInVM(r, key);
        if (oldValue instanceof BaseValueHolder) {
            vh = (BaseValueHolder)oldValue;
            oldValue = ((BaseValueHolder)oldValue).modVal;
        } else {
            vh = new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
        }
        Log.getLogWriter().info("updateEntry: Value to update is " + vh + " for key " + key + " in region " + r.getFullPath());
        vh = (BaseValueHolder)CopyHelper.copy((Object)vh);
        vh.modVal = new Integer(vh.modVal + 1);
        return vh;
    }

    public Operation destroyEntry(boolean isLocalDestroy, Region aRegion, Object key, boolean entryNotFoundExcOK) {
        if (key == null) {
            Log.getLogWriter().info("Could not destroy an entry in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object conditionValue = this.getValueInVM(aRegion, key, false);
            Object oldValue = this.getValueInVM(aRegion, key, true);
            if (conditionValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)conditionValue).modVal;
            }
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyEntry: locally destroying key " + key + " in region " + aRegion.getFullPath());
                aRegion.localDestroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done locally destroying key " + key + " in region " + aRegion.getFullPath());
                return new Operation(aRegion.getFullPath(), key, "entry-localDestroy", oldValue, null);
            }
            Log.getLogWriter().info("destroyEntry: destroying key " + key + " in region " + aRegion.getFullPath());
            if (this.supportsConcurrentMapOps(aRegion) && TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying (remove(" + key + ", " + conditionValue + ")) in region " + aRegion.getFullPath());
                boolean removed = aRegion.remove(key, conditionValue);
                if (!removed) {
                    if (this.isSerialExecution) {
                        throw new TestException("remove(" + key + ", " + conditionValue + ") returned false, expected successful remove\n" + TestHelper.getStackTrace());
                    }
                    return null;
                }
            } else {
                Log.getLogWriter().info("destroyEntry: destroying (destroy) key " + key + " in region " + aRegion.getFullPath());
                aRegion.destroy(key, (Object)callback);
            }
            Log.getLogWriter().info("destroyEntry: done destroying key " + key + " in region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), key, "entry-destroy", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                if (entryNotFoundExcOK) {
                    Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e));
                    return null;
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
            return null;
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation removeEntry(Region aRegion, boolean exists) {
        Object key = null;
        if (exists) {
            key = this.getRandomKey(aRegion);
            if (key == null) {
                Log.getLogWriter().info("Could not get with an existing key " + aRegion.getFullPath() + " because no keys are available");
                return null;
            }
        } else {
            key = NameFactory.getNextPositiveObjectName();
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Log.getLogWriter().info("removeEntry: removing key " + key + " in region " + aRegion.getFullPath());
            Object result = aRegion.remove(key);
            Log.getLogWriter().info("removeEntry: done removing key " + key + " in region " + aRegion.getFullPath() + ", result is " + result);
            return new Operation(aRegion.getFullPath(), key, "entry-remove", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation invalEntry(boolean isLocalInval, Region aRegion, Object key, boolean entryNotFoundExcOK) {
        if (key == null) {
            Log.getLogWriter().info("Could not invalidate an entry in " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            if (isLocalInval) {
                Log.getLogWriter().info("invalEntry: locally invalidating key " + key + " in region " + aRegion.getFullPath());
                aRegion.localInvalidate(key, (Object)callback);
                Log.getLogWriter().info("invalEntry: done locally invalidating key " + key + " in region " + aRegion.getFullPath());
                Object newValue = this.getValueInVM(aRegion, key);
                return new Operation(aRegion.getFullPath(), key, "entry-localInval", oldValue, newValue);
            }
            Log.getLogWriter().info("invalEntry: invalidating key " + key + " in region " + aRegion.getFullPath());
            aRegion.invalidate(key, (Object)callback);
            Log.getLogWriter().info("invalEntry: done invalidating key " + key + " in region " + aRegion.getFullPath());
            Object newValue = this.getValueInVM(aRegion, key);
            return new Operation(aRegion.getFullPath(), key, "entry-inval", oldValue, newValue);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution) {
                if (entryNotFoundExcOK) {
                    Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e));
                    return null;
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
            return null;
        }
    }

    public Operation getWithExistingKey(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not get with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getWithExistingKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            BaseValueHolder vh = (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getWithExistingKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithExistingKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation getAll(Region r) {
        int beforeSize = r.size();
        int numGetAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
        ArrayList<Object> keyList = new ArrayList<Object>();
        int keyCount = 0;
        while (keyCount < numGetAllExistingKeys) {
            Object key = this.getRandomKey(r);
            if (key != null) {
                keyList.add(key);
                ++keyCount;
            }
            if (beforeSize >= numGetAllExistingKeys) continue;
            break;
        }
        Log.getLogWriter().info("Doing a getAll with keys:" + keyList + " count is:" + keyList.size());
        Map result = r.getAll(keyList);
        Log.getLogWriter().info("completed getAll: result size:" + result.size());
        return new Operation(r.getFullPath(), keyList.toArray(), "getAll", null, null);
    }

    public Operation getEntryWithExistingKey(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not get with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntryWithExistingKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Region.Entry entry = aRegion.getEntry(key);
            BaseValueHolder vh = (BaseValueHolder)entry.getValue();
            Log.getLogWriter().info("getEntryWithExistingKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getEntryWithExistingKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getEntryWithExistingKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation containsKeyExisting(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not do containsKey with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("containsKeyExisting: calling containsKey for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            boolean result = aRegion.containsKey(key);
            Log.getLogWriter().info("containsKeyExisting: result is " + result);
            return new Operation(aRegion.getFullPath(), key, "entry-containsKey", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation containsValueForKeyExisting(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not do containsValueForKey with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("containsValueForKeyExisting: calling containsValueForKey for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            boolean result = aRegion.containsValueForKey(key);
            Log.getLogWriter().info("containsValueForKeyExisting: result is " + result);
            return new Operation(aRegion.getFullPath(), key, "entry-containsValueForKey", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation containsValueExisting(Region aRegion) {
        Object key = this.getRandomKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("Could not do containsValue with an existing key " + aRegion.getFullPath() + " because no keys are available");
            return null;
        }
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("containsValueExisting: calling containsValue for key " + key + " in region " + aRegion.getFullPath());
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            boolean result = aRegion.containsValue(key);
            Log.getLogWriter().info("containsValueExisting: result is " + result);
            return new Operation(aRegion.getFullPath(), key, "entry-containsValue", oldValue, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation getEntryWithPreviousKey(Region aRegion) {
        long keysUsed = NameFactory.getPositiveNameCounter();
        String key = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            if (oldValue instanceof BaseValueHolder) {
                oldValue = ((BaseValueHolder)oldValue).modVal;
            }
            Log.getLogWriter().info("getEntryWithPreviousKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = (BaseValueHolder)aRegion.get((Object)key);
            Log.getLogWriter().info("getEntryWithPreviousKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithPreviousKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Object getNewKey(Region aRegion) {
        String key = NameFactory.getNextPositiveObjectName();
        boolean found = false;
        if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
            DistributedMember myDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            do {
                DistributedMember primaryDM;
                if ((primaryDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)key)) != null && primaryDM.equals(myDM)) {
                    found = true;
                    continue;
                }
                key = NameFactory.getNextPositiveObjectName();
            } while (!found);
        }
        return key;
    }

    public Operation getEntryWithNewKey(Region aRegion) {
        Object key = this.getNewKey(aRegion);
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntryWithNewKey: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getEntryWithNewKey: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, "entry-getWithNewKey", oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation putEntry(Region aRegion, Object key, BaseValueHolder value, String opName) {
        Object oldValue = this.getValueInVM(aRegion, key);
        if (oldValue instanceof BaseValueHolder) {
            oldValue = ((BaseValueHolder)oldValue).modVal;
        }
        try {
            String callback = updateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Log.getLogWriter().info("putEntry: putting key " + key + ", object " + value + " in region " + aRegion.getFullPath());
            aRegion.put(key, (Object)value, (Object)callback);
            Log.getLogWriter().info("putEntry: done putting key " + key + ", object " + value + " in region " + aRegion.getFullPath());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new Operation(aRegion.getFullPath(), key, opName, oldValue, value.modVal);
    }

    public Operation getEntry(Region aRegion, Object key, String opName) {
        try {
            Object oldValue = this.getValueInVM(aRegion, key);
            Log.getLogWriter().info("getEntry: getting value for key " + key + " in region " + aRegion.getFullPath());
            BaseValueHolder vh = (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("getEntry: got value for key " + key + ": " + vh + " in region " + aRegion.getFullPath());
            if (vh == null) {
                return new Operation(aRegion.getFullPath(), key, opName, oldValue, null);
            }
            return new Operation(aRegion.getFullPath(), key, opName, oldValue, vh.modVal);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation invalRegion(boolean isLocalInval, Region aRegion) {
        try {
            String callback = regionInvalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalInval) {
                Log.getLogWriter().info("invalRegion: locally invalidating region " + aRegion.getFullPath());
                aRegion.localInvalidateRegion((Object)callback);
                Log.getLogWriter().info("invalRegion: done locally invalidating region " + aRegion.getFullPath());
                return new Operation(aRegion.getFullPath(), null, "region-localInval", null, null);
            }
            Log.getLogWriter().info("invalRegion: invalidating region " + aRegion.getFullPath());
            aRegion.invalidateRegion((Object)callback);
            Log.getLogWriter().info("invalRegion: done invalidating region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), null, "region-inval", null, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation destroyRegion(boolean isLocalDestroy, Region aRegion) {
        if (aRegion == null) {
            return null;
        }
        try {
            this.recordDestroyedRegion(aRegion);
            String callback = regionDestroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyRegion: locally destroying region " + aRegion.getFullPath());
                aRegion.localDestroyRegion((Object)callback);
                Log.getLogWriter().info("destroyRegion: done locally destroying region " + aRegion.getFullPath());
                return new Operation(aRegion.getFullPath(), null, "region-localDestroy", null, null);
            }
            Log.getLogWriter().info("destroyRegion: destroying region " + aRegion.getFullPath());
            aRegion.destroyRegion((Object)callback);
            Log.getLogWriter().info("destroyRegion: done destroying region " + aRegion.getFullPath());
            return new Operation(aRegion.getFullPath(), null, "region-destroy", null, null);
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            return null;
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public Operation createRegion() {
        ArrayList list = (ArrayList)TxBB.getBB().getSharedMap().get(TxBB.DestroyedRegionsKey);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String regionPath = (String)list.get(i);
                Object[] tmp = this.createRegionWithPath(regionPath, false);
                Region aRegion = (Region)tmp[0];
                boolean regionCreated = (Boolean)tmp[1];
                if (!regionCreated) continue;
                return new Operation(regionPath, null, "region-create", null, null);
            }
        } else {
            Map aMap = this.getRegionConfigMap();
            for (String regionPath : aMap.keySet()) {
                Object value = aMap.get(regionPath);
                if (!(value instanceof String)) continue;
                Object[] tmp = this.createRegionWithPath(regionPath, false);
                Region aRegion = (Region)tmp[0];
                boolean regionCreated = (Boolean)tmp[1];
                if (!regionCreated) continue;
                return new Operation(regionPath, null, "region-create", null, null);
            }
        }
        return null;
    }

    public Operation closeCache() {
        CacheUtil.setCache(null);
        CacheHelper.closeCache();
        return new Operation(null, null, "cache-close", null, null);
    }

    public Object getRandomKey(Region aRegion) {
        return this.getRandomKey(aRegion, null);
    }

    public Object getRandomKey(Region aRegion, Object excludeKey) {
        if (this.suspendResume) {
            this.txState.set(TxHelper.internalSuspend());
        }
        if (aRegion == null) {
            return null;
        }
        HashSet aSet = null;
        try {
            aSet = PartitionRegionHelper.isPartitionedRegion((Region)aRegion) ? PartitionRegionHelper.getLocalData((Region)aRegion).keySet() : new HashSet(aRegion.keySet());
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            if (this.suspendResume) {
                TxHelper.internalResume((TXStateInterface)this.txState.get());
            }
            return null;
        }
        Object[] keyArr = aSet.toArray();
        if (keyArr.length == 0) {
            Log.getLogWriter().info("Could not get a random key from " + aRegion.getFullPath() + " because the region has no keys");
            if (this.suspendResume) {
                TxHelper.internalResume((TXStateInterface)this.txState.get());
            }
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, keyArr.length - 1);
        Object key = keyArr[randInt];
        if (key.equals(excludeKey)) {
            if (keyArr.length == 1) {
                if (this.suspendResume) {
                    TxHelper.internalResume((TXStateInterface)this.txState.get());
                }
                return null;
            }
            if (++randInt == keyArr.length) {
                randInt = 0;
            }
            key = keyArr[randInt];
        }
        if (this.suspendResume) {
            TxHelper.internalResume((TXStateInterface)this.txState.get());
        }
        return key;
    }

    public Object getNewValue(Object key) {
        return new ValueHolder(key, this.randomValues, new Integer(this.modValInitializer++));
    }

    public Object[] createRegionWithPath(String regionName, boolean fill) {
        Region aRegion;
        StringTokenizer st;
        String currentRegionName;
        Cache theCache;
        boolean regionCreated;
        block22: {
            regionCreated = false;
            theCache = CacheUtil.getCache();
            aRegion = theCache.getRegion(currentRegionName = (st = new StringTokenizer(regionName, "/", false)).nextToken());
            if (aRegion == null) {
                try {
                    String regionConfig = this.getRegionConfigFromBB("/" + currentRegionName);
                    AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
                    String clientName = System.getProperty("clientName");
                    String mapKey = TxBB.DataPolicyPrefix + clientName;
                    String dataPolicy = (String)TxBB.getBB().getSharedMap().get(mapKey);
                    if (dataPolicy != null) {
                        aFactory.setDataPolicy(TestHelper.getDataPolicy(dataPolicy));
                    }
                    RegionAttributes attrs = RegionHelper.getRegionAttributes(aFactory);
                    aRegion = theCache.createVMRegion(currentRegionName, attrs);
                    Log.getLogWriter().info("Created root region " + aRegion.getFullPath());
                    if (aRegion.getAttributes().getPoolName() != null) {
                        aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                        Log.getLogWriter().info("registerInterest(ALL_KEYS) for " + currentRegionName);
                    }
                    if (fill) {
                        this.createEntries(aRegion);
                    }
                    regionCreated = true;
                }
                catch (TimeoutException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                catch (RegionExistsException e) {
                    if (this.isSerialExecution) {
                        throw new TestException("Test error; unexpected " + TestHelper.getStackTrace(e));
                    }
                    aRegion = CacheUtil.getCache().getRegion(currentRegionName);
                    if (aRegion != null) break block22;
                    return new Object[]{null, new Boolean(false)};
                }
            }
        }
        Region previousRegion = aRegion;
        while (st.hasMoreTokens()) {
            block23: {
                currentRegionName = st.nextToken();
                String regionPath = previousRegion.getFullPath() + "/" + currentRegionName;
                try {
                    aRegion = theCache.getRegion(regionPath);
                }
                catch (RegionDestroyedException e) {
                    if (this.isSerialExecution) {
                        throw e;
                    }
                    return new Object[]{null, new Boolean(false)};
                }
                if (aRegion == null) {
                    try {
                        String regionConfig = this.getRegionConfigFromBB(regionPath);
                        AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
                        String clientName = System.getProperty("clientName");
                        String mapKey = TxBB.DataPolicyPrefix + clientName;
                        String dataPolicy = (String)TxBB.getBB().getSharedMap().get(mapKey);
                        if (dataPolicy != null) {
                            aFactory.setDataPolicy(TestHelper.getDataPolicy(dataPolicy));
                        }
                        RegionAttributes attr = RegionHelper.getRegionAttributes(aFactory);
                        Log.getLogWriter().info("Attempting to create region " + currentRegionName + " with " + TestHelper.regionAttributesToString(attr));
                        aRegion = previousRegion.createSubregion(currentRegionName, attr);
                        Log.getLogWriter().info("Created region " + aRegion.getFullPath());
                        if (aRegion.getAttributes().getPoolName() != null) {
                            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                            Log.getLogWriter().info("registerInterest(ALL_KEYS) for " + currentRegionName);
                        }
                        if (fill) {
                            this.createEntries(aRegion);
                        }
                        regionCreated = true;
                    }
                    catch (RegionDestroyedException e) {
                        if (this.isSerialExecution) {
                            throw e;
                        }
                        return new Object[]{null, new Boolean(false)};
                    }
                    catch (TimeoutException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    catch (RegionExistsException e) {
                        if (this.isSerialExecution) {
                            throw new TestException("Test error; unexpected " + TestHelper.getStackTrace(e));
                        }
                        aRegion = CacheUtil.getCache().getRegion(regionPath);
                        if (aRegion != null) break block23;
                        return new Object[]{null, new Boolean(false)};
                    }
                }
            }
            previousRegion = aRegion;
        }
        return new Object[]{aRegion, new Boolean(regionCreated)};
    }

    public void clearDestroyedRegions() {
        TxBB.getBB().getSharedMap().put(TxBB.DestroyedRegionsKey, new ArrayList());
        Log.getLogWriter().info("Cleared destroyed region list from blackboard");
    }

    public void recordDestroyedRegion(Region aRegion) {
        if (!this.isSerialExecution) {
            return;
        }
        ArrayList<String> list = (ArrayList<String>)TxBB.getBB().getSharedMap().get(TxBB.DestroyedRegionsKey);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(aRegion.getFullPath());
        Set regionSet = aRegion.subregions(true);
        for (Region currRegion : regionSet) {
            list.add(currRegion.getFullPath());
        }
        TxBB.getBB().getSharedMap().put(TxBB.DestroyedRegionsKey, list);
        Log.getLogWriter().info("TxBB.DestroyedRegionsKey = " + list);
    }

    public void createDestroyedRegionsFromBB(boolean fill) {
        if (!this.isSerialExecution) {
            throw new TestException("Do not call this from concurrent tests as DestroyedRegionsKey is not maintained");
        }
        ArrayList list = (ArrayList)TxBB.getBB().getSharedMap().get(TxBB.DestroyedRegionsKey);
        Log.getLogWriter().info("In createDestroyedRegionsFromBB with destroyed regions " + list);
        for (int i = 0; i < list.size(); ++i) {
            String regionPath = (String)list.get(i);
            this.createRegionWithPath(regionPath, fill);
        }
        Log.getLogWriter().info("Done in createDestroyedRegionsFromBB");
    }

    public void createAllDestroyedRegions(boolean fill) {
        Map aMap = this.getRegionConfigMap();
        Iterator it = aMap.keySet().iterator();
        Log.getLogWriter().info("In createAllDestroyedRegions");
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = aMap.get(key);
            if (!(value instanceof String)) continue;
            this.createRegionWithPath(key, fill);
        }
        Log.getLogWriter().info("Done in createAllDestroyedRegions");
    }

    public static boolean inTxThreadWithTxInProgress() {
        return TxHelper.getTransactionId() != null;
    }

    public static boolean inTxVm() {
        Integer txVmPid = (Integer)TxBB.getBB().getSharedMap().get(TxBB.TX_VM_PID);
        if (txVmPid == null) {
            return false;
        }
        int myVmPid = ProcessMgr.getProcessId();
        return txVmPid == myVmPid;
    }

    public boolean isHierReplicated(Region aRegion) {
        boolean isReplicated = aRegion.getAttributes().getDataPolicy().withReplication();
        if (isReplicated) {
            return true;
        }
        Object[] regionArr = this.getSubregions(aRegion, true).toArray();
        for (int j = 0; j < regionArr.length; ++j) {
            Region subR = (Region)regionArr[j];
            if (!subR.getAttributes().getDataPolicy().withReplication()) continue;
            return true;
        }
        return false;
    }

    public Set getSubregions(Region aRegion, boolean recursive) {
        try {
            Set regionSet = aRegion.subregions(recursive);
            return regionSet;
        }
        catch (RegionDestroyedException e) {
            String errorRegionName;
            if (this.isSerialExecution) {
                throw e;
            }
            String regionName = aRegion.getFullPath();
            if (!regionName.equals(errorRegionName = e.getRegionFullPath())) {
                throw e;
            }
            return new HashSet();
        }
    }

    public Map getRegionConfigMap() {
        Map aMap = (Map)TxBB.getBB().getSharedMap().get(TxBB.RegConfigForPIDKey);
        if (aMap == null) {
            return new HashMap();
        }
        return aMap;
    }

    public void recordRegionConfigInBB(String fullPathOfRegion, String regionConfig) {
        Map aMap = this.getRegionConfigMap();
        aMap.put(fullPathOfRegion, regionConfig);
        TxBB.getBB().getSharedMap().put(TxBB.RegConfigForPIDKey, aMap);
    }

    public String getRegionConfigFromBB(String fullPathOfRegion) {
        Map aMap = this.getRegionConfigMap();
        String regionConfig = (String)aMap.get(fullPathOfRegion);
        return regionConfig;
    }

    public boolean containsKey(Region aRegion, Object key) {
        if (this.suspendResume) {
            this.txState.set(TxHelper.internalSuspend());
        }
        boolean result = aRegion.containsKey(key);
        if (this.suspendResume) {
            TxHelper.internalResume((TXStateInterface)this.txState.get());
        }
        return result;
    }

    public Object getValueInVM(Region aRegion, Object key) {
        return this.getValueInVM(aRegion, key, true);
    }

    public Object getValueInVM(Region aRegion, Object key, boolean translateToInvalidToken) {
        Object value = null;
        Region.Entry entry = aRegion.getEntry(key);
        if (entry != null) {
            try {
                value = entry.getValue();
                if (value == null && translateToInvalidToken) {
                    value = Token.INVALID;
                }
            }
            catch (EntryDestroyedException e) {
                value = null;
            }
        }
        return value;
    }

    public boolean supportsConcurrentMapOps(Region aRegion) {
        DataPolicy dataPolicy = aRegion.getAttributes().getDataPolicy();
        return !dataPolicy.equals(DataPolicy.NORMAL) && !dataPolicy.equals(DataPolicy.EMPTY);
    }
}

