/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.Region;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import tx.Operation;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;

public class CollectionInfo {
    Set keys = null;
    Collection values = null;
    Set entries = null;
    Region.Entry entry = null;
    Iterator keySetIterator;
    Iterator entrySetIterator;
    Iterator valuesIterator;
    String parentRegionName = null;
    Set subRegions = null;

    CollectionInfo(Region aRegion, Operation op) {
        if (aRegion == null) {
            throw new TestException("Unexpected null Region for operation " + op.toString());
        }
        if (op.isEntryOperation()) {
            this.keys = aRegion.keySet();
            this.keySetIterator = this.keys.iterator();
            this.values = aRegion.values();
            this.valuesIterator = this.values.iterator();
            this.entries = aRegion.entrySet(false);
            this.entrySetIterator = this.entries.iterator();
            this.entry = aRegion.getEntry(op.getKey());
        } else {
            String regionName = op.getRegionName();
            this.parentRegionName = regionName.substring(0, regionName.lastIndexOf(47));
            Region parentRegion = CacheUtil.getCache().getRegion(this.parentRegionName);
            this.subRegions = parentRegion.subregions(false);
        }
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        if (this.keys != null) {
            aStr.append("keySet contains " + this.keys.size() + " elements, Keys = " + this.keys + "\n");
        }
        if (this.values != null) {
            try {
                aStr.append("Values contains " + this.values.size() + " elements, Values = " + this.values + "\n");
            }
            catch (Exception e) {
                throw new TestException("Caught unexpected Exception " + e + " " + TestHelper.getStackTrace(e));
            }
        }
        if (this.entries != null) {
            aStr.append("entrySet contains " + this.entries.size() + " elements, Entries = " + this.entries + "\n");
        }
        if (this.entry != null) {
            if (this.entry.isDestroyed()) {
                aStr.append("Entry has been destroyed\n");
            } else {
                aStr.append("Entry = " + this.entry.toString() + "\n");
            }
        }
        if (this.subRegions != null) {
            aStr.append("SubRegions contains " + this.subRegions.size() + " elements, subRegions = " + this.subRegions.toString() + "\n");
        }
        return aStr.toString();
    }
}

