/*
 * Decompiled with CFR 0.152.
 */
package tx;

import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import hydra.BridgeHelper;
import hydra.ClientDescription;
import hydra.GsRandom;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import tx.TxUtil;
import util.CacheUtil;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class BridgeConflictTest {
    public static BridgeConflictTest testInstance = null;
    private HydraThreadLocal txState = new HydraThreadLocal();
    protected int testConfiguration;
    protected static final String NOT_IN_TRANS = "Not in transaction";
    protected static final int ONE_THREAD_PER_MULTI_VMS = 1;
    protected static final int MULTI_THREADS_PER_ONE_VM = 2;
    protected static final int UNDEFINED = 3;

    public static synchronized void HydraTask_initializeConcTest() {
        if (testInstance == null) {
            testInstance = new BridgeConflictTest();
            BridgeConflictTest.testInstance.testConfiguration = 3;
            testInstance.initialize();
        }
    }

    public static synchronized void HydraTask_initializeSerialTest() {
        if (testInstance == null) {
            testInstance = new BridgeConflictTest();
            BridgeConflictTest.testInstance.testConfiguration = 3;
            int numVMs = BridgeConflictTest.getNumVMs();
            if (numVMs == 1) {
                if (BridgeConflictTest.getNumThreads() == 1) {
                    throw new TestException("Test cannot run with 1 VM and 1 thread");
                }
                BridgeConflictTest.testInstance.testConfiguration = 2;
            } else {
                int numThreads = BridgeConflictTest.getNumThreads();
                if (BridgeConflictTest.getNumThreads() != 1) {
                    throw new TestException("Test cannot run with multi-VMs (" + numVMs + ") having > 1 threads (" + numThreads + ")");
                }
                BridgeConflictTest.testInstance.testConfiguration = 1;
            }
            testInstance.initialize();
        }
    }

    protected static int getNumVMs() {
        int numVMs = TestHelper.getNumVMs();
        int bridgeVMs = BridgeHelper.getEndpoints().size();
        if (bridgeVMs > 0) {
            numVMs -= bridgeVMs;
        }
        return numVMs;
    }

    protected static int getNumThreads() {
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        int numThreads = cd.getVmThreads();
        return numThreads;
    }

    protected void initialize() {
        Log.getLogWriter().info("Test instance is " + this);
    }

    public static void HydraTask_serialConflictTest() {
        testInstance.serialConflictTest();
    }

    public static void HydraTask_serialTxOnlyConflictTest() {
        testInstance.serialTxOnlyConflictTest();
    }

    public static void HydraTask_serialTxOnlyRepeatableRead() {
        TxUtil.txUtilInstance.suspendResume = true;
        testInstance.serialTxOnlyRepeatableRead();
    }

    public static void HydraTask_endTask() {
        SharedCounters sc = TxBB.getBB().getSharedCounters();
        long commitSuccess = sc.read(TxBB.TX_SUCCESS);
        long commitFailure = sc.read(TxBB.TX_FAILURE);
        long rollBack = sc.read(TxBB.TX_ROLLBACK);
        long notInTrans = sc.read(TxBB.NOT_IN_TRANS);
        Log.getLogWriter().info("CommitSuccess count:   " + commitSuccess + "CommitFailure count:   " + commitFailure + "RollBack count     :   " + rollBack + "Tasks not in tx count: " + notInTrans);
    }

    public static void HydraTask_concConflictTest() {
        testInstance.concConflictTest();
    }

    protected void concConflictTest() {
        GsRandom rand = TestConfig.tab().getRandGen();
        int tasksInTxPercentage = TxPrms.getTasksInTxPercentage();
        if (rand.nextInt(1, 100) <= tasksInTxPercentage) {
            TxHelper.begin();
        } else {
            TxBB.inc(TxBB.NOT_IN_TRANS);
        }
        TxUtil.doOperations();
        if (TxHelper.exists()) {
            int commitPercentage = TxPrms.getCommitPercentage();
            if (rand.nextInt(1, 100) <= commitPercentage) {
                try {
                    TxHelper.commit();
                    TxBB.inc(TxBB.TX_SUCCESS);
                }
                catch (ConflictException e) {
                    TxBB.inc(TxBB.TX_FAILURE);
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + "; continuing test");
                }
            } else {
                TxHelper.rollback();
                TxBB.inc(TxBB.TX_ROLLBACK);
            }
        }
        TxUtil.txUtilInstance.createAllDestroyedRegions(true);
    }

    protected void serialTxOnlyConflictTest() {
        boolean firstInRound = TxUtil.logRoundRobinNumber();
        TxUtil.logExecutionNumber();
        long rrNumber = TxUtil.getRoundRobinNumber();
        long whichRound = rrNumber % 3L;
        if (whichRound == 1L) {
            Log.getLogWriter().info("In round " + rrNumber + " to open transactions, firstInRound is " + firstInRound);
            TxHelper.begin();
            if (firstInRound) {
                TxBB.getBB().getSharedMap().put("Op1PID", "" + ProcessMgr.getProcessId());
                TxUtil.txUtilInstance.summarizeRegionHier();
                OpList originalOps = TxUtil.doOperations();
                OpList opListToWrite = new OpList();
                for (int i = 0; i < originalOps.numOps(); ++i) {
                    Operation op = originalOps.getOperation(i);
                    OpList tmpOpList = new OpList();
                    tmpOpList.add(op);
                    this.recordNewOps(opListToWrite, tmpOpList);
                }
                TxBB.getBB().getSharedMap().put(TxBB.OpListKey, opListToWrite);
                this.txState.set(TxHelper.internalSuspend());
            } else {
                boolean useSameRegionOrKey;
                OpList newOps;
                OpList priorOps = (OpList)TxBB.getBB().getSharedMap().get(TxBB.OpListKey);
                boolean commitStatus = this.recordCommitStatusTxOnly(priorOps, newOps = this.doOps(priorOps, 1, useSameRegionOrKey = TestConfig.tab().getRandGen().nextInt(1, 100) <= 75));
                if (commitStatus) {
                    this.recordNewOps(priorOps, newOps);
                }
                this.txState.set(TxHelper.internalSuspend());
            }
        } else if (whichRound == 2L) {
            TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
            Log.getLogWriter().info("In round " + rrNumber + " to close transactions, firstInRound is " + firstInRound);
            if (firstInRound) {
                TxHelper.commitExpectSuccess();
                TxBB.inc(TxBB.TX_SUCCESS);
            } else {
                boolean commitSuccess = TxBB.getCommitStatus();
                Log.getLogWriter().info("Attempting a commit with expected commit success: " + commitSuccess);
                if (commitSuccess) {
                    TxHelper.commitExpectSuccess();
                    TxBB.inc(TxBB.TX_SUCCESS);
                } else {
                    TxHelper.commitExpectFailure();
                    TxBB.inc(TxBB.TX_FAILURE);
                }
            }
        } else {
            Log.getLogWriter().info("In round " + rrNumber + " to replace destroyed regions, firstInRound is " + firstInRound);
            TxUtil.txUtilInstance.createAllDestroyedRegions(true);
        }
    }

    protected void serialTxOnlyRepeatableRead() {
        boolean firstInRound = TxUtil.logRoundRobinNumber();
        TxUtil.logExecutionNumber();
        long rrNumber = TxUtil.getRoundRobinNumber();
        long whichRound = rrNumber % 3L;
        if (whichRound == 1L) {
            Log.getLogWriter().info("In round " + rrNumber + " to open transactions, firstInRound is " + firstInRound);
            TxHelper.begin();
            if (!firstInRound) {
                TxBB.getBB().getSharedMap().put("Op1PID", "" + ProcessMgr.getProcessId());
                OpList readOps = null;
                if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 80) {
                    readOps = TxUtil.txUtilInstance.doRepeatableReadOperations(1);
                    TxBB.getBB().getSharedMap().put(TxBB.RepeatableRead, new Boolean(true));
                } else {
                    readOps = TxUtil.txUtilInstance.doNonrepeatableReadOperations(1);
                    TxBB.getBB().getSharedMap().put(TxBB.RepeatableRead, new Boolean(false));
                }
                TxBB.getBB().getSharedMap().put(TxBB.OpListKey, readOps);
            }
            this.logTxSet();
            this.txState.set(TxHelper.internalSuspend());
        } else if (whichRound == 2L) {
            TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
            Log.getLogWriter().info("In round " + rrNumber + ", firstInRound is " + firstInRound);
            OpList readOps = (OpList)TxBB.getBB().getSharedMap().get(TxBB.OpListKey);
            boolean readOpsContainRR = (Boolean)TxBB.getBB().getSharedMap().get(TxBB.RepeatableRead);
            if (firstInRound) {
                OpList newOps = this.doOps(readOps, 1, true);
                TxBB.getBB().getSharedMap().put(TxBB.OpListKey2, newOps);
                this.logTxSet();
                TxHelper.commitExpectSuccess();
                TxBB.inc(TxBB.TX_SUCCESS);
            } else {
                OpList t1_ops = (OpList)TxBB.getBB().getSharedMap().get(TxBB.OpListKey2);
                boolean useSameRegionOrKey = true;
                if (readOpsContainRR) {
                    useSameRegionOrKey = TestConfig.tab().getRandGen().nextInt(1, 100) <= 75;
                }
                OpList newOps = this.doOps(readOps, 1, useSameRegionOrKey);
                boolean commitStatus = this.getCommitStatusRR(readOps, t1_ops, newOps, readOpsContainRR);
                this.logTxSet();
                Log.getLogWriter().info("Determining commit status,\nReadOps: " + readOps + "\nfirst thread ops (committed): " + t1_ops + "\nsecond thread ops: " + newOps + "\nCommit status for second thread is " + commitStatus);
                this.verifyRepeatableReads(readOps, t1_ops, newOps, readOpsContainRR);
                Log.getLogWriter().info("Attempting a commit with expected commit success: " + commitStatus);
                if (commitStatus) {
                    TxHelper.commitExpectSuccess();
                    TxBB.inc(TxBB.TX_SUCCESS);
                } else {
                    TxHelper.commitExpectFailure();
                    TxBB.inc(TxBB.TX_FAILURE);
                }
            }
        }
    }

    protected void serialConflictTest() {
        boolean firstInRound = TxUtil.logRoundRobinNumber();
        TxUtil.logExecutionNumber();
        long rrNumber = TxUtil.getRoundRobinNumber();
        long whichRound = rrNumber % 3L;
        if (whichRound == 1L) {
            Log.getLogWriter().info("In round " + rrNumber + " to open transactions, firstInRound is " + firstInRound);
            if (firstInRound) {
                TxBB.getBB().getSharedMap().put("Op1PID", "" + ProcessMgr.getProcessId());
                TxUtil.txUtilInstance.summarizeRegionHier();
                TxHelper.begin();
                OpList originalOps = TxUtil.doOperations();
                TxBB.getBB().getSharedMap().put(TxBB.OpListKey, originalOps);
                this.txState.set(TxHelper.internalSuspend());
            } else {
                boolean inTrans = this.executeInTx();
                if (inTrans) {
                    TxHelper.begin();
                    inTrans = true;
                } else {
                    Log.getLogWriter().info("Running outside a transaction...");
                }
                OpList priorOps = (OpList)TxBB.getBB().getSharedMap().get(TxBB.OpListKey);
                boolean useSameRegionOrKey = TestConfig.tab().getRandGen().nextInt(1, 100) <= 75;
                OpList newOps = this.doOps(priorOps, 1, useSameRegionOrKey);
                this.recordCommitStatus(inTrans, priorOps, newOps);
                this.txState.set(TxHelper.internalSuspend());
            }
        } else if (whichRound == 2L) {
            TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
            Log.getLogWriter().info("In round " + rrNumber + " to close transactions, firstInRound is " + firstInRound);
            if (firstInRound) {
                boolean expectedCommit = (Boolean)TxBB.getBB().getSharedMap().get(TxBB.FirstInRoundCommitStatus);
                if (expectedCommit) {
                    Log.getLogWriter().info("Attempting a commit; expect success");
                    TxHelper.commitExpectSuccess();
                    TxBB.inc(TxBB.TX_SUCCESS);
                } else {
                    Log.getLogWriter().info("Attempting a commit; expect failure");
                    TxHelper.commitExpectFailure();
                    TxBB.inc(TxBB.TX_FAILURE);
                }
            } else {
                Object expectedCommit = TxBB.getBB().getSharedMap().get(TxBB.SecondInRoundCommitStatus);
                if (expectedCommit.equals(NOT_IN_TRANS)) {
                    if (TxHelper.exists()) {
                        throw new TestException("Transaction exists is true, but expected to not be in a tx");
                    }
                    Log.getLogWriter().info("Not in transaction; not committing");
                    TxBB.inc(TxBB.NOT_IN_TRANS);
                } else if (expectedCommit.equals(new Boolean(true))) {
                    Log.getLogWriter().info("Attempting a commit; expect success");
                    TxHelper.commitExpectSuccess();
                    TxBB.inc(TxBB.TX_SUCCESS);
                } else {
                    Log.getLogWriter().info("Attempting a commit; expect failure");
                    TxHelper.commitExpectFailure();
                    TxBB.inc(TxBB.TX_FAILURE);
                }
            }
        } else {
            Log.getLogWriter().info("In round " + rrNumber + " to replace destroyed transactions, firstInRound is " + firstInRound);
            TxUtil.txUtilInstance.createAllDestroyedRegions(true);
        }
    }

    protected OpList doOps(OpList opList, int numOps, boolean targetSame) {
        String aStr = "Attempting " + numOps + " operations to ";
        if (!targetSame) {
            aStr = aStr + "not ";
        }
        aStr = aStr + "target same regions/keys as " + opList;
        Log.getLogWriter().info(aStr);
        OpList resultOpList = new OpList();
        int currentOpIndex = TestConfig.tab().getRandGen().nextInt(0, opList.numOps() - 1);
        int lastSuccessfulIndex = -1;
        while (resultOpList.numOps() < numOps) {
            if (++currentOpIndex >= opList.numOps()) {
                currentOpIndex = 0;
            }
            Operation operation = opList.getOperation(currentOpIndex);
            if (lastSuccessfulIndex == -1) {
                lastSuccessfulIndex = currentOpIndex;
            } else if (lastSuccessfulIndex == currentOpIndex) {
                currentOpIndex = 0;
            }
            Operation executedOp = null;
            executedOp = targetSame ? this.doOpWithSame(operation) : this.doOpWithDifferent(opList, operation);
            int opCount = resultOpList.numOps();
            resultOpList.add(executedOp);
            if (resultOpList.numOps() == opCount) continue;
            lastSuccessfulIndex = currentOpIndex;
        }
        aStr = "Executed the following operations: " + resultOpList + "\nthat ";
        if (!targetSame) {
            aStr = aStr + "do not ";
        }
        aStr = aStr + "operate on same region and/or key as\n" + opList;
        Log.getLogWriter().info(aStr);
        return resultOpList;
    }

    protected Operation doOpWithSame(Operation operation) {
        Object key;
        Operation executedOp = null;
        String regionName = operation.getRegionName();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        Object keyToUse = key = operation.getKey();
        boolean containsKey = key == null ? false : TxUtil.txUtilInstance.containsKey(aRegion, key);
        GsRandom rand = TestConfig.tab().getRandGen();
        int randInt = rand.nextInt(1, 100);
        if (aRegion == null) {
            Log.getLogWriter().info("In doOpWithSame: " + regionName + " does not existing in this VM; creating it and putting");
            aRegion = (Region)TxUtil.txUtilInstance.createRegionWithPath(regionName, false)[0];
            executedOp = this.putNewOrPreviousKey(aRegion);
            return executedOp;
        }
        if (key == null || !containsKey) {
            keyToUse = TxUtil.txUtilInstance.getRandomKey(aRegion);
            Log.getLogWriter().info("For " + regionName + ", key is " + key + ", containsKey is " + containsKey + ", another key in region is " + keyToUse);
        }
        if (keyToUse == null) {
            randInt = rand.nextInt(1, 100);
            if (randInt <= 50) {
                Log.getLogWriter().info("In doOpWithSame: " + regionName + " is empty, creating new entry");
                executedOp = this.putNewOrPreviousKey(aRegion);
            } else {
                randInt = rand.nextInt(1, 100);
                if (randInt <= 50) {
                    long keysUsed = NameFactory.getPositiveNameCounter();
                    keyToUse = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
                    Log.getLogWriter().info("In doOpWithSame: " + regionName + " is empty, getting with previous key");
                    executedOp = TxUtil.txUtilInstance.getEntry(aRegion, keyToUse, "entry-getWithPreviousKey");
                } else {
                    keyToUse = NameFactory.getNextPositiveObjectName();
                    Log.getLogWriter().info("In doOpWithSame: " + regionName + " is empty, getting with new key");
                    executedOp = TxUtil.txUtilInstance.getEntry(aRegion, keyToUse, "entry-getWithNewKey");
                }
            }
            return executedOp;
        }
        Log.getLogWriter().info("In doOpWithSame: choosing an entry operation");
        randInt = rand.nextInt(1, 100);
        executedOp = randInt <= 20 ? this.putNewOrPreviousKey(aRegion) : (randInt <= 40 ? TxUtil.txUtilInstance.destroyEntry(false, aRegion, keyToUse, false) : (randInt <= 60 && !operation.isPreviouslyInvalid() ? TxUtil.txUtilInstance.invalEntry(false, aRegion, keyToUse, false) : (randInt <= 80 ? TxUtil.txUtilInstance.updateEntry(aRegion, keyToUse) : TxUtil.txUtilInstance.getEntry(aRegion, keyToUse, "entry-getWithExistingKey"))));
        Log.getLogWriter().info("Executed operation\n" + executedOp + "\nto use same region and/or key as \n" + operation);
        if (executedOp == null) {
            throw new TestException("Problem in test configuration, executedOp is " + executedOp);
        }
        return executedOp;
    }

    protected Operation doOpWithDifferent(OpList opList, Operation operation) {
        Operation executedOp = null;
        String regionName = operation.getRegionName();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        Object key = operation.getKey();
        if (aRegion == null) {
            Log.getLogWriter().info("In doOpWithDifferent: " + regionName + " does not exist; creating it");
            aRegion = (Region)TxUtil.txUtilInstance.createRegionWithPath(regionName, false)[0];
            executedOp = new Operation(regionName, null, "region-create", null, null);
        } else if (key != null) {
            Object newKey;
            ArrayList<Integer> options = new ArrayList<Integer>();
            Region newRegion = TxUtil.txUtilInstance.getRandomRegion(true, aRegion, 0);
            if (newRegion != null && !this.entryOpConflictsWith(opList, newRegion.getFullPath(), key)) {
                options.add(new Integer(1));
            }
            if ((newKey = TxUtil.txUtilInstance.getRandomKey(aRegion, key)) != null && !this.entryOpConflictsWith(opList, regionName, newKey)) {
                options.add(new Integer(2));
            }
            options.add(new Integer(3));
            int randInt = TestConfig.tab().getRandGen().nextInt(0, options.size() - 1);
            int choice = (Integer)options.get(randInt);
            Log.getLogWriter().info("In doOpWithDifferent: choosing option " + choice);
            executedOp = choice == 1 ? this.doAnyEntryOperation(newRegion, key) : (choice == 2 ? this.doAnyEntryOperation(aRegion, newKey) : TxUtil.txUtilInstance.getEntry(aRegion, NameFactory.getNextPositiveObjectName(), "entry-getWithExistingKey"));
        } else {
            if (!operation.isRegionOperation()) {
                throw new TestException("Unknown operation " + operation);
            }
            Log.getLogWriter().info("In doOpWithDifferent: doing a get");
            executedOp = this.getWithAnyKey(aRegion);
        }
        Log.getLogWriter().info("Executed operation\n" + executedOp + "\nto not write same region and/or key as \n" + opList);
        if (executedOp == null) {
            throw new TestException("Problem in test configuration, executedOp is " + executedOp);
        }
        return executedOp;
    }

    private Operation doAnyEntryOperation(Region aRegion, Object key) {
        Operation executedOp = null;
        boolean containsKey = TxUtil.txUtilInstance.containsKey(aRegion, key);
        if (containsKey) {
            int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
            executedOp = randInt <= 25 ? TxUtil.txUtilInstance.updateEntry(aRegion, key) : (randInt <= 50 ? TxUtil.txUtilInstance.destroyEntry(false, aRegion, key, false) : TxUtil.txUtilInstance.getEntry(aRegion, key, "entry-getWithExistingKey"));
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            ValueHolder vh = new ValueHolder(key, TxUtil.txUtilInstance.randomValues, new Integer(TxUtil.txUtilInstance.modValInitializer++));
            executedOp = TxUtil.txUtilInstance.putEntry(aRegion, key, vh, "entry-create");
        } else {
            executedOp = TxUtil.txUtilInstance.getEntry(aRegion, key, "entry-getWithPreviousKey");
        }
        return executedOp;
    }

    protected boolean entryOpConflictsWith(OpList opList, String regionName, Object key) {
        for (int i = 0; i < opList.numOps(); ++i) {
            Operation op = opList.getOperation(i);
            if (op.getOpName().equals("region-create")) continue;
            if (op.isGetWithLoad()) {
                return true;
            }
            Operation fakeOp = new Operation(regionName, key, "entry-update", null, null);
            if (!op.affectedBy(fakeOp)) continue;
            return true;
        }
        return false;
    }

    protected Operation putNewOrPreviousKey(Region aRegion) {
        String key = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            long keysUsed = NameFactory.getPositiveNameCounter();
            key = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
            ValueHolder vh = new ValueHolder((Object)key, TxUtil.txUtilInstance.randomValues, new Integer(TxUtil.txUtilInstance.modValInitializer++));
            return TxUtil.txUtilInstance.putEntry(aRegion, key, vh, aRegion.containsKey((Object)key) ? "entry-update" : "entry-create");
        }
        key = NameFactory.getNextPositiveObjectName();
        ValueHolder vh = new ValueHolder((Object)key, TxUtil.txUtilInstance.randomValues, new Integer(TxUtil.txUtilInstance.modValInitializer++));
        return TxUtil.txUtilInstance.putEntry(aRegion, key, vh, "entry-create");
    }

    protected Operation getWithAnyKey(Region aRegion) {
        Object key;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt <= 33 && (key = TxUtil.txUtilInstance.getRandomKey(aRegion)) != null) {
            return TxUtil.txUtilInstance.getEntry(aRegion, key, "entry-getWithExistingKey");
        }
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            long keysUsed = NameFactory.getPositiveNameCounter();
            String key2 = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)keysUsed));
            if (TxUtil.txUtilInstance.containsKey(aRegion, key2)) {
                return TxUtil.txUtilInstance.getEntry(aRegion, key2, "entry-getWithExistingKey");
            }
            return TxUtil.txUtilInstance.getEntry(aRegion, key2, "entry-getWithPreviousKey");
        }
        key = NameFactory.getNextPositiveObjectName();
        return TxUtil.txUtilInstance.getEntry(aRegion, key, "entry-getWithNewKey");
    }

    protected boolean recordCommitStatusTxOnly(OpList priorOps, OpList newOps) {
        SharedMap sm = TxBB.getBB().getSharedMap();
        if (newOps == null) {
            Log.getLogWriter().info("recordCommitStatusTxOnly: No ops were done");
            TxBB.recordCommitStatus(true);
            return true;
        }
        boolean thisThreadHasConflicts = this.thread2HasConflict(priorOps, newOps);
        boolean expectedCommitStatus = !thisThreadHasConflicts;
        TxBB.recordCommitStatus(expectedCommitStatus);
        return expectedCommitStatus;
    }

    protected boolean getCommitStatusRR(OpList readOps, OpList t1_ops, OpList newOps, boolean readOpsContainsRR) {
        for (int newOpIndex = 0; newOpIndex < newOps.numOps(); ++newOpIndex) {
            Operation newOp = newOps.getOperation(newOpIndex);
            for (int t1_opIndex = 0; t1_opIndex < newOps.numOps(); ++t1_opIndex) {
                Operation t1_op = t1_ops.getOperation(t1_opIndex);
                for (int readOpIndex = 0; readOpIndex < readOps.numOps(); ++readOpIndex) {
                    Operation readOp = readOps.getOperation(readOpIndex);
                    boolean newOpIsWrite = newOp.isWriteOperation();
                    boolean t1_opIsWrite = t1_op.isWriteOperation();
                    boolean readOpIsRepeatable = readOp.isRepeatableRead();
                    boolean newOpSameKeyAsT1 = newOp.usesSameRegionAndKey(t1_op);
                    boolean newOpSameKeyAsRead = newOp.usesSameRegionAndKey(readOp);
                    if (!newOpSameKeyAsRead && newOp.usesSameRegion(readOp) && readOp.isRepeatableRead() && readOp.isRegionSetOperation()) {
                        newOpSameKeyAsRead = true;
                    }
                    boolean t1_opIsDoubleInvalidate = t1_op.isDoubleInvalidate();
                    boolean t1_opIsEntryCreate = t1_op.isEntryCreate();
                    Log.getLogWriter().info("newOpIsWrite: " + newOpIsWrite + ", t1_opIsWrite: " + t1_opIsWrite + ", newOpSameKeyAsT1: " + newOpSameKeyAsT1 + ", newOpSameKeyAsRead: " + newOpSameKeyAsRead + ", readOpIsRepeatable: " + readOpIsRepeatable + ", t1_opIsDoubleInvalidate: " + t1_opIsDoubleInvalidate + ", t1_opIsEntryCreate: " + t1_opIsEntryCreate);
                    if (t1_opIsWrite && readOp.isGetWithLoad() && readOp.usesSameRegionAndKey(t1_op) && !t1_opIsDoubleInvalidate) {
                        return false;
                    }
                    if (!newOpIsWrite || !t1_opIsWrite || !newOpSameKeyAsT1 || !newOpSameKeyAsRead || !readOpIsRepeatable || t1_opIsDoubleInvalidate) continue;
                    if (t1_opIsEntryCreate) {
                        if (this.testConfiguration != 1 || readOp.getOldValue() == null) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    protected void verifyRepeatableReads(OpList readOps, OpList t1_ops, OpList newOps, boolean readOpsContainsRR) {
        for (int newOpIndex = 0; newOpIndex < newOps.numOps(); ++newOpIndex) {
            Operation newOp = newOps.getOperation(newOpIndex);
            for (int readOpIndex = 0; readOpIndex < readOps.numOps(); ++readOpIndex) {
                Operation readOp = readOps.getOperation(readOpIndex);
                if (!readOp.usesSameRegionAndKey(readOp) || !newOp.isRepeatableRead() || newOp.getNewValue().equals(readOp.getNewValue())) continue;
                throw new TestException("Read op " + readOp + " and newOp " + newOp + " should have read the same value for repeatable reads, but readOp value is " + readOp.getNewValue() + " and newOp value is " + newOp.getNewValue());
            }
        }
    }

    protected void recordCommitStatus(boolean inTrans, OpList priorOps, OpList newOps) {
        SharedMap sm = TxBB.getBB().getSharedMap();
        if (newOps == null) {
            sm.put(TxBB.FirstInRoundCommitStatus, new Boolean(true));
            if (inTrans) {
                sm.put(TxBB.SecondInRoundCommitStatus, new Boolean(true));
            } else {
                sm.put(TxBB.SecondInRoundCommitStatus, NOT_IN_TRANS);
            }
            Log.getLogWriter().info("No new ops, inTrans is " + inTrans + ", TxBB.FirstInRoundCommitStatus = " + sm.get(TxBB.FirstInRoundCommitStatus) + ", TxBB.SecondInRoundCommitStatus = " + sm.get(TxBB.SecondInRoundCommitStatus));
            return;
        }
        boolean thread1Conflicts = this.thread1HasConflict(priorOps, newOps, inTrans);
        if (thread1Conflicts) {
            sm.put(TxBB.FirstInRoundCommitStatus, new Boolean(false));
            if (inTrans) {
                sm.put(TxBB.SecondInRoundCommitStatus, new Boolean(true));
            } else {
                sm.put(TxBB.SecondInRoundCommitStatus, NOT_IN_TRANS);
            }
        } else {
            sm.put(TxBB.FirstInRoundCommitStatus, new Boolean(true));
            if (inTrans) {
                boolean thread2Conflicts = this.thread2HasConflict(priorOps, newOps);
                if (thread2Conflicts) {
                    sm.put(TxBB.SecondInRoundCommitStatus, new Boolean(false));
                } else {
                    sm.put(TxBB.SecondInRoundCommitStatus, new Boolean(true));
                }
            } else {
                sm.put(TxBB.SecondInRoundCommitStatus, NOT_IN_TRANS);
            }
        }
        Log.getLogWriter().info("inTrans is " + inTrans + ", TxBB.FirstInRoundCommitStatus = " + sm.get(TxBB.FirstInRoundCommitStatus) + ", TxBB.SecondInRoundCommitStatus = " + sm.get(TxBB.SecondInRoundCommitStatus));
    }

    protected boolean thread1HasConflict(OpList opList1, OpList opList2, boolean inTrans) {
        StringBuffer logStr = new StringBuffer();
        logStr.append("In thread1HasConflict: test configuration is " + this.testConfigurationToString() + "\nopList from thread1: " + opList1 + "\nopList from thread2, inTrans is " + inTrans + ": " + opList2);
        for (int list1Index = 0; list1Index < opList1.numOps(); ++list1Index) {
            Operation op1 = opList1.getOperation(list1Index);
            for (int list2Index = 0; list2Index < opList2.numOps(); ++list2Index) {
                Operation op2 = opList2.getOperation(list2Index);
                boolean hasConflict = this.op1HasConflict(op1, op2, inTrans, logStr);
                if (!hasConflict) continue;
                Log.getLogWriter().info(logStr + "\nThread1 has conflict");
                return true;
            }
        }
        Log.getLogWriter().info(logStr + "\nThread1 does NOT have conflict");
        return false;
    }

    protected boolean op1HasConflict(Operation op1, Operation op2, boolean op2InTrans, StringBuffer logStr) {
        String op1Name = op1.getOpName();
        String op2Name = op2.getOpName();
        if (!op1.affectedBy(op2)) {
            logStr.append("\n  op2 (" + op2Name + ") does not affect op1 (" + op1Name + ")");
            return false;
        }
        if (op1.isDoubleInvalidate()) {
            logStr.append("\n  op1 (" + op1Name + ") is a double invalidate and does not affect op2 (" + op2Name + ")");
            return false;
        }
        if (op2.isDoubleInvalidate()) {
            logStr.append("\n  op2 (" + op2Name + ") is a double invalidate and does not affect op1 (" + op1Name + ")");
            return false;
        }
        boolean op2HasEffectOnOp1 = false;
        switch (this.testConfiguration) {
            case 1: {
                if (op2InTrans) {
                    op2HasEffectOnOp1 = op2Name.equals("region-destroy") || op2Name.equals("region-inval");
                    break;
                }
                op2HasEffectOnOp1 = op2Name.equals("entry-update") || op2Name.equals("entry-destroy") || op2Name.equals("entry-inval") || op2Name.equals("region-destroy") || op2Name.equals("region-inval") || (op2Name.equals("entry-create") || op2.isGetWithLoad()) && op1.usesSameRegionAndKey(op2) && op1.isWriteOperation() || (op2Name.equals("entry-create") || op2.isGetWithLoad()) && op1.getRegionName() != null;
                break;
            }
            case 2: {
                if (op2InTrans) {
                    op2HasEffectOnOp1 = op2Name.equals("region-destroy") || op2Name.equals("region-localDestroy") || op2Name.equals("region-inval") || op2Name.equals("region-localInval");
                    break;
                }
                op2HasEffectOnOp1 = !op2Name.equals("region-create") && op2.isWriteOperation() && op2.usesSameRegionAndKey(op1);
                break;
            }
            default: {
                throw new TestException("Unknown testConfiguration: " + this.testConfiguration);
            }
        }
        logStr.append("\n  op2 (" + op2Name + ") has immediate effect on op1 (" + op1Name + "): " + op2HasEffectOnOp1);
        boolean causesConflict = op2HasEffectOnOp1;
        if (op2HasEffectOnOp1) {
            if (op1.isEntryCreate() && op2.isEntryCreate()) {
                boolean createdSameEntry;
                boolean bl = createdSameEntry = op1.getRegionName().equals(op2.getRegionName()) && op1.getKey().equals(op2.getKey());
                if (!op1.usesSameRegionAndKey(op2)) {
                    causesConflict = false;
                }
            } else if (op2.isDoubleInvalidate()) {
                causesConflict = false;
            } else if (op2.isInvalidate() && (op1.isEntryCreate() || op1.isPreviouslyInvalid())) {
                causesConflict = false;
            } else if (op1.isGetOperation()) {
                causesConflict = op1.isGetWithLoad();
            } else if (op1.isRegionOperation()) {
                causesConflict = false;
            }
            if (this.clientIsEmpty("client1")) {
                causesConflict = false;
            }
        }
        logStr.append("\n    thread1HasConflict (if it commits first): " + causesConflict);
        return causesConflict;
    }

    protected boolean clientIsEmpty(String clientName) {
        String mapKey = TxBB.DataPolicyPrefix + clientName;
        String dataPolicy = (String)TxBB.getBB().getSharedMap().get(mapKey);
        boolean isEmpty = false;
        if (dataPolicy != null) {
            isEmpty = dataPolicy.equalsIgnoreCase("empty");
        }
        String s = isEmpty ? " " : " not ";
        Log.getLogWriter().info(clientName + " dataPolicy is" + s + "empty");
        return isEmpty;
    }

    protected boolean thread2HasConflict(OpList opList1, OpList opList2) {
        StringBuffer logStr = new StringBuffer();
        logStr.append("In thread2HasConflict: test configuration is " + this.testConfigurationToString() + "\nopList from thread1: " + opList1 + "\nopList from thread2: " + opList2);
        for (int list1Index = 0; list1Index < opList1.numOps(); ++list1Index) {
            Operation op1 = opList1.getOperation(list1Index);
            for (int list2Index = 0; list2Index < opList2.numOps(); ++list2Index) {
                Operation op2 = opList2.getOperation(list2Index);
                boolean hasConflict = this.op2HasConflict(op1, op2, logStr);
                if (!hasConflict) continue;
                Log.getLogWriter().info(logStr + "\nThread2 has conflict");
                return true;
            }
        }
        Log.getLogWriter().info(logStr + "\nThread2 does NOT have conflict");
        return false;
    }

    protected boolean op2HasConflict(Operation op1, Operation op2, StringBuffer logStr) {
        String op1Name = op1.getOpName();
        String op2Name = op2.getOpName();
        if (!op2.affectedBy(op1)) {
            logStr.append("\n  op1 (" + op1Name + ") does not affect op2 (" + op2Name + ")");
            return false;
        }
        if (op1.isDoubleInvalidate()) {
            logStr.append("\n  op1 (" + op1Name + ") is a double invalidate and does not affect op2 (" + op2Name + ")");
            return false;
        }
        boolean op1HasEffectOnOp2 = false;
        switch (this.testConfiguration) {
            case 1: {
                op1HasEffectOnOp2 = op1Name.equals("entry-create") && op1.usesSameRegionAndKey(op2) && !op2.isGetOperation() && !op2Name.equals("entry-create") || op1.isGetWithLoad() && op1.usesSameRegionAndKey(op2) && op2.isWriteOperation() && !op2Name.equals("entry-create") || (op1Name.equals("entry-update") || op1Name.equals("entry-destroy") || op1Name.equals("entry-inval")) && !op2Name.equals("entry-create") || (op1Name.equals("entry-create") || op1.isGetWithLoad()) && op2.isWriteOperation();
                break;
            }
            case 2: {
                op1HasEffectOnOp2 = op1.isWriteOperation();
                break;
            }
            default: {
                throw new TestException("Unknown testConfiguration: " + this.testConfiguration);
            }
        }
        logStr.append("\n  op1 (" + op1Name + ") has an effect on op2 (" + op2Name + "): " + op1HasEffectOnOp2);
        boolean causesConflict = op1HasEffectOnOp2;
        if (op1HasEffectOnOp2) {
            if (op1.isEntryCreate() && op2.isEntryCreate()) {
                if (!op1.usesSameRegionAndKey(op2)) {
                    causesConflict = false;
                }
            } else if (op1.isDoubleInvalidate()) {
                causesConflict = false;
            } else if (op1.isInvalidate() && op2.isEntryCreate()) {
                causesConflict = false;
            } else if (op2.isGetOperation()) {
                causesConflict = op2.isGetWithLoad();
            } else if (op2.isRegionOperation()) {
                causesConflict = false;
            } else if (this.testConfiguration == 1) {
                if (op1.isEntryInvalidate() && op2.isEntryOperation() && op1.usesSameRegionAndKey(op2) && op2.isPreviouslyInvalid() && op2.getOldValue().toString().equals("INVALID")) {
                    causesConflict = false;
                }
            } else if ((this.testConfiguration == 2 && op1.isEntryDestroy() || this.testConfiguration == 1 && op1.getOpName().equals("entry-destroy")) && op2.getOpName().equals("entry-create")) {
                causesConflict = false;
            }
            if (this.clientIsEmpty("client2")) {
                causesConflict = false;
            }
        }
        logStr.append("\n    thread2HasConflict (if it commits after thread1): " + causesConflict);
        return causesConflict;
    }

    protected void recordNewOps(OpList priorOps, OpList newOps) {
        for (int newOpsIndex = 0; newOpsIndex < newOps.numOps(); ++newOpsIndex) {
            Operation newOp = newOps.getOperation(newOpsIndex);
            boolean replaced = false;
            for (int priorOpsIndex = 0; priorOpsIndex < priorOps.numOps(); ++priorOpsIndex) {
                Operation priorOp = priorOps.getOperation(priorOpsIndex);
                boolean isAffectedBy = priorOp.affectedBy(newOp);
                boolean isSameRegAndKey = newOp.usesSameRegionAndKey(priorOp);
                if (!isAffectedBy || !isSameRegAndKey) continue;
                boolean needToOverride = true;
                if (newOp.isDoubleInvalidate()) {
                    needToOverride = false;
                } else if (newOp.isGetOperation()) {
                    boolean loaderWasInvoked;
                    boolean bl = loaderWasInvoked = newOp.getOldValue() == null || newOp.isPreviouslyInvalid();
                    if (loaderWasInvoked) {
                        if (priorOp.isEntryDestroy() && this.testConfiguration == 1) {
                            needToOverride = false;
                        }
                    } else {
                        needToOverride = false;
                    }
                }
                if (!needToOverride) continue;
                Object previousOp = priorOps.set(priorOpsIndex, newOp);
                replaced = true;
                Log.getLogWriter().info("Replacing priorOp " + priorOp + " with new op " + newOp);
                break;
            }
            if (replaced) continue;
            Log.getLogWriter().info("Adding new op " + newOp);
            priorOps.add(newOp);
        }
        Log.getLogWriter().info("Recording ops to blackboard: " + priorOps);
        TxBB.getBB().getSharedMap().put(TxBB.OpListKey, priorOps);
    }

    protected void checkTxSet(OpList ops) {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        HashSet<Region> allRegions = new HashSet<Region>();
        for (Region aRegion : rootRegions) {
            allRegions.add(aRegion);
            allRegions.addAll(aRegion.subregions(true));
        }
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : allRegions) {
            HashSet txSet = new HashSet(((LocalRegion)aRegion).testHookTXKeys());
            Log.getLogWriter().info("Checking txSet for region " + aRegion.getFullPath() + ": " + txSet + ", with opList: " + ops);
            HashSet<Object> opListKeySet = new HashSet<Object>();
            for (int i = 0; i < ops.numOps(); ++i) {
                Operation op = ops.getOperation(i);
                if (!op.getRegionName().equals(aRegion.getFullPath())) continue;
                opListKeySet.add(op.getKey());
            }
            HashSet missingInTxSet = new HashSet(opListKeySet);
            HashSet extraInTxSet = new HashSet(txSet);
            missingInTxSet.removeAll(txSet);
            extraInTxSet.removeAll(opListKeySet);
            if (missingInTxSet.size() != 0) {
                aStr.append("The following keys " + missingInTxSet + " were missing from the tx set for " + aRegion.getFullPath() + ", but were found in the OpList: " + ops);
            }
            if (extraInTxSet.size() == 0) continue;
            aStr.append("The following keys " + extraInTxSet + " were extra in the tx set for " + aRegion.getFullPath() + ", but were NOT found in the OpList: " + ops);
        }
        if (aStr.length() != 0) {
            throw new TestException(aStr.toString());
        }
    }

    protected void logTxSet() {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        HashSet<Region> allRegions = new HashSet<Region>();
        for (Region aRegion : rootRegions) {
            allRegions.add(aRegion);
            allRegions.addAll(aRegion.subregions(true));
        }
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : allRegions) {
            HashSet txSet = new HashSet(((LocalRegion)aRegion).testHookTXKeys());
            if (txSet.size() == 0) continue;
            aStr.append("For " + aRegion.getFullPath() + " tx set is " + txSet + "\n");
        }
        if (aStr.length() == 0) {
            Log.getLogWriter().info("All regions have an empty tx set");
        } else {
            Log.getLogWriter().info(aStr.toString());
        }
    }

    protected boolean executeInTx() {
        boolean useTx = false;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            useTx = true;
        }
        return useTx;
    }

    public String toString() {
        return "testConfiguration: " + this.testConfigurationToString();
    }

    protected String testConfigurationToString() {
        switch (this.testConfiguration) {
            case 1: {
                return "OneThreadPerMultiVMs";
            }
            case 2: {
                return "MultiThreadsPerOneVM";
            }
            case 3: {
                return "Undefined";
            }
        }
        throw new TestException("Unknown testConfiguration: " + this.testConfiguration);
    }
}

