/*
 * Decompiled with CFR 0.152.
 */
package target;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import hydra.Log;
import hydra.RegionHelper;
import java.util.Map;
import target.TargetBB;
import util.TestHelper;

class PutAllThread
extends Thread {
    private boolean isDisconnected = false;
    private Map dataMap;
    private Region tRegion;

    public PutAllThread(Region tRegion, Map dataMap) {
        this.dataMap = dataMap;
        this.tRegion = tRegion;
    }

    @Override
    public void run() {
        try {
            Log.getLogWriter().info("Begin the region.putAll(map)");
            Log.getLogWriter().info("Size of the region before the putAll  : " + this.tRegion.size());
            this.tRegion = RegionHelper.getRegion("testRegion");
            if (this.tRegion.isEmpty()) {
                Log.getLogWriter().info("The region is empty");
            }
            TargetBB.getBB().getSharedMap().put("numCreates", new Integer(0));
            this.tRegion.putAll(this.dataMap);
            Log.getLogWriter().info("region.putAll(map) completed");
        }
        catch (DistributedSystemDisconnectedException e) {
            Log.getLogWriter().info("DISCONNECTED" + e.getMessage());
            this.isDisconnected = true;
        }
        catch (CacheClosedException e) {
            Log.getLogWriter().info("DISCONNECTED " + e.getMessage());
            this.isDisconnected = true;
        }
        catch (Exception e) {
            Log.getLogWriter().info("Exception : " + e + TestHelper.getStackTrace());
        }
        finally {
            Log.getLogWriter().info("Number of entries in the region : " + TargetBB.getBB().getSharedMap().get("numCreates"));
        }
    }

    public boolean isDisconnected() {
        return this.isDisconnected;
    }
}

