/*
 * Decompiled with CFR 0.152.
 */
package swarm;

import java.sql.SQLException;
import java.util.List;
import swarm.DUnitClassRun;
import swarm.Swarm;
import swarm.TextHelper;

public class DUnitClassInfo {
    private final int id;
    private final String name;

    public DUnitClassInfo(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return TextHelper.getShortName(this.name);
    }

    public String getVeryShortName() {
        return TextHelper.getVeryShortName(this.name);
    }

    public int getMethodCount() {
        try {
            return Swarm.getDUnitMethodInfosForClass(this.getId()).size();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<DUnitClassRun> getLast5Runs() {
        try {
            return Swarm.getLastNDUnitClassRuns(this.getId(), 5);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<DUnitClassRun> getLast10Runs() {
        try {
            return Swarm.getLastNDUnitClassRuns(this.getId(), 10);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<DUnitClassRun> getLast2Runs() {
        try {
            return Swarm.getLastNDUnitClassRuns(this.getId(), 2);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

