/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Region;
import hydra.BridgeHelper;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import parReg.KnownKeysTest;
import parReg.ParRegBB;
import parReg.ParRegUtil;
import splitBrain.ControllerBB;
import splitBrain.MembershipNotifierHook;
import splitBrain.SBUtil;
import splitBrain.SplitBrainBB;
import splitBrain.SplitBrainPrms;
import splitBrain.UnhealthyUtil;
import util.PRObserver;
import util.StopStartPrms;

public class SBKnownKeysTest
extends KnownKeysTest {
    protected Region controllerRegion;

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new SBKnownKeysTest();
            SBKnownKeysTest instance = (SBKnownKeysTest)testInstance;
            instance.initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(SBKnownKeysTest.testInstance.aRegion);
            }
            ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
            instance.controllerRegion = RegionHelper.createRegion("accessorControllerReg");
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        PRObserver.installObserverHook();
        if (testInstance == null) {
            testInstance = new SBKnownKeysTest();
            SBKnownKeysTest instance = (SBKnownKeysTest)testInstance;
            instance.initInstance("dataStoreRegion");
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            ControllerBB.getBB().getSharedMap().put("" + ProcessMgr.getProcessId(), new Integer(RemoteTestModule.getMyVmid()));
            Log.getLogWriter().info("Installing MembershipNotifierHook");
            SBUtil.addMembershipHook(new MembershipNotifierHook());
            instance.controllerRegion = RegionHelper.createRegion("dataStoreControllerReg");
        }
    }

    public static void HydraTask_initialize() {
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.indexOf("dataStore") >= 0) {
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.NumVMsInDS);
        } else if (clientName.indexOf("accessor") >= 0 && !isBridgeConfiguration) {
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.NumVMsInDS);
        }
    }

    public static void HydraTask_causeUnhealthiness() {
        ((SBKnownKeysTest)testInstance).causeUnhealthiness();
        long counter = SplitBrainBB.getBB().getSharedCounters().read(SplitBrainBB.OpsComplete);
        if (counter > 0L) {
            throw new StopSchedulingTaskOnClientOrder("Ops tasks have signaled completion");
        }
    }

    public static void initDataStoreAfterDisconnect() {
        ((SBKnownKeysTest)testInstance).initInstance("dataStoreRegion");
        Log.getLogWriter().info(SBKnownKeysTest.testInstance.aRegion.getFullPath() + " size is " + SBKnownKeysTest.testInstance.aRegion.size());
        ((SBKnownKeysTest)SBKnownKeysTest.testInstance).controllerRegion = RegionHelper.createRegion("dataStoreControllerReg");
        SBKnownKeysTest cfr_ignored_0 = (SBKnownKeysTest)testInstance;
        if (isBridgeConfiguration) {
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static void HydraTask_doOps() {
        try {
            KnownKeysTest.HydraTask_doOps();
            ControllerBB.checkForError();
        }
        catch (StopSchedulingTaskOnClientOrder order) {
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.OpsComplete);
            throw order;
        }
    }

    public static void initDataStoreAfterForcedDisconnect() {
        ((SBKnownKeysTest)testInstance).initInstance("dataStoreRegion");
        Log.getLogWriter().info(SBKnownKeysTest.testInstance.aRegion.getFullPath() + " size is " + SBKnownKeysTest.testInstance.aRegion.size());
        ((SBKnownKeysTest)SBKnownKeysTest.testInstance).controllerRegion = RegionHelper.createRegion("dataStoreControllerReg");
        SBKnownKeysTest cfr_ignored_0 = (SBKnownKeysTest)testInstance;
        if (isBridgeConfiguration) {
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    protected void causeUnhealthiness() {
        int i;
        PRObserver.initialize();
        SBKnownKeysTest.logExecutionNumber();
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        SplitBrainBB.getBB().getSharedCounters().zero(SplitBrainBB.NumVMsStopped);
        SplitBrainBB.getBB().getSharedCounters().add(SplitBrainBB.NumVMsStopped, numVMsToStop);
        Log.getLogWriter().info("In SBKnownKeys.causeUnhealthiness, choosing " + numVMsToStop + " vm(s) to target...");
        List vmList = this.getDataStoreVms();
        ArrayList targetVms = new ArrayList();
        ArrayList<String> unhealthinessList = new ArrayList<String>();
        ArrayList<Boolean> playDeadList = new ArrayList<Boolean>();
        for (i = 1; i <= numVMsToStop; ++i) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
            targetVms.add(vmList.get(randInt));
            vmList.remove(randInt);
            unhealthinessList.add(TestConfig.tab().stringAt(SplitBrainPrms.unhealthiness));
            playDeadList.add(new Boolean(TestConfig.tab().booleanAt(SplitBrainPrms.playDead)));
        }
        UnhealthyUtil.causeUnhealthiness(targetVms, this.controllerRegion);
        for (i = 0; i < targetVms.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)targetVms.get(i);
            ControllerBB.reset(info.getVmid());
        }
        PRObserver.waitForRebalRecov(targetVms, 1, 2, null, null, false);
    }

    protected static void logExecutionNumber() {
        long exeNum = SplitBrainBB.getBB().getSharedCounters().incrementAndRead(SplitBrainBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected void checkForLastIteration() {
        long taskStartTime = 0L;
        String bbKey = "TaskStartTime";
        Object anObj = SplitBrainBB.getBB().getSharedMap().get("TaskStartTime");
        int secondsToRun = TestConfig.tab().intAt(SplitBrainPrms.secondsToRun, 1800);
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            SplitBrainBB.getBB().getSharedMap().put("TaskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + secondsToRun + " seconds; time remaining is " + ((long)secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }
}

