/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.DynamicRegionListener;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.BridgeMembership;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCondition;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import splitBrain.ControllerBB;
import splitBrain.ForcedDiscUtil;
import splitBrain.MLRioBB;
import splitBrain.MLRioDynamicRegionListener;
import splitBrain.MLRioPrms;
import splitBrain.MembershipNotifierHook;
import splitBrain.RegionEntryComparator;
import splitBrain.SBUtil;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationsClient;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class MLRioTest
extends OperationsClient {
    protected static final int ITERATIONS = 1000;
    protected static MLRioTest testInstance;
    protected RandomValues randomValues = null;
    protected int numRootRegions;
    protected int numDynamicRegions;
    protected boolean isNewWanConfig = ConfigPrms.getGatewaySenderConfig() != null;
    static Boolean firstTimePublishing;

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new MLRioTest();
            testInstance.initializeOperationsClient();
            testInstance.initializeBridgeServer();
        }
    }

    protected void initializeBridgeServer() {
        String cacheXmlFile = "bridgeCache_" + RemoteTestModule.MyPid + ".xml";
        DistributedSystem ds = DistributedSystemHelper.connectWithXml(cacheXmlFile);
        File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
        d.mkdirs();
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(d, null));
        ArrayList<String> regionNames = new ArrayList<String>();
        this.numRootRegions = TestConfig.tab().intAt(MLRioPrms.numRootRegions, 1);
        for (int i = 0; i < this.numRootRegions; ++i) {
            regionNames.add(NameFactory.REGION_NAME_PREFIX + (i + 1));
        }
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), null, ConfigPrms.getRegionConfig(), regionNames, ConfigPrms.getBridgeConfig(), ConfigPrms.getPoolConfig(), ConfigPrms.getDiskStoreConfig(), null, cacheXmlFile);
        CacheHelper.createCacheFromXml(cacheXmlFile);
        BridgeMembershipListener membershipListener = MLRioPrms.getBridgeMembershipListener();
        if (membershipListener != null) {
            BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)membershipListener);
            Log.getLogWriter().info("Registered BridgeMembershipListener " + membershipListener);
        }
        if (!this.isNewWanConfig) {
            this.createGatewayHub();
        }
        Log.getLogWriter().info("Installing MembershipNotifierHook");
        SBUtil.addMembershipHook(new MembershipNotifierHook());
        this.numDynamicRegions = TestConfig.tab().intAt(MLRioPrms.numDynamicRegions, 1);
        this.randomValues = new RandomValues();
    }

    public static synchronized void HydraTask_startGatewayHubTask() {
        testInstance.startGatewayHub(ConfigPrms.getGatewayConfig());
    }

    protected void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    public static synchronized void HydraTask_createGatewaySenderIds() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static synchronized void HydraTask_createAndStartNewWanComponents() {
        testInstance.createAndStartNewWanComponents();
    }

    protected void createAndStartNewWanComponents() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        if (receiverConfig == null) {
            throw new TestException("New wan receiver config is null.");
        }
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        if (senderConfig == null) {
            throw new TestException("New wan sender config is null.");
        }
        GatewaySenderHelper.createAndStartGatewaySenders(senderConfig);
    }

    public static synchronized void HydraTask_initializeBridgeClient() {
        if (testInstance == null) {
            testInstance = new MLRioTest();
            testInstance.initializeOperationsClient();
            testInstance.initializeBridgeClient();
        }
    }

    protected void initializeBridgeClient() {
        if (CacheHelper.getCache() == null) {
            this.initCacheWithXml(ConfigPrms.getCacheConfig(), ConfigPrms.getRegionConfig(), ConfigPrms.getPoolConfig());
            DynamicRegionFactory.get().registerDynamicRegionListener((DynamicRegionListener)new MLRioDynamicRegionListener());
            MLRioBB.getBB().getSharedCounters().increment(MLRioBB.dynamicRegionClients);
            BridgeMembershipListener membershipListener = MLRioPrms.getBridgeMembershipListener();
            if (membershipListener != null) {
                BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)membershipListener);
                Log.getLogWriter().info("Registered BridgeMembershipListener " + membershipListener);
            }
        }
        this.randomValues = new RandomValues();
    }

    public static void HydraTask_createDynamicRegions() {
        testInstance.createDynamicRegions();
    }

    protected void createDynamicRegions() {
        Region parentRegion2 = null;
        Object aRegion = null;
        String drName = null;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region parentRegion2 : rootRegions) {
            this.numDynamicRegions = TestConfig.tab().intAt(MLRioPrms.numDynamicRegions, 1);
            for (int i = 0; i < this.numDynamicRegions; ++i) {
                drName = parentRegion2.getName() + "_DYNAMIC_" + (i + 1);
                this.createDynamicRegion(parentRegion2.getFullPath(), drName);
            }
        }
    }

    public static void HydraTask_waitForDynamicRegions() {
        testInstance.waitForDynamicRegions();
    }

    private void waitForDynamicRegions() {
        int numDynamicRegions = TestConfig.tab().intAt(MLRioPrms.numDynamicRegions, 1);
        int numRootRegions = TestConfig.tab().intAt(MLRioPrms.numRootRegions);
        long numClients = MLRioBB.getBB().getSharedCounters().read(MLRioBB.dynamicRegionClients);
        long expectedRegions = (long)(numDynamicRegions * numRootRegions) * numClients;
        TestHelper.waitForCounter(MLRioBB.getBB(), "dynamicRegionCreates", MLRioBB.dynamicRegionCreates, expectedRegions, true, 120000L);
    }

    public void initCacheWithXml(String cacheConfig, String regionConfig, String poolConfig) {
        String cacheXmlFile = "edgeCache_" + RemoteTestModule.MyPid + ".xml";
        DistributedSystem ds = DistributedSystemHelper.connectWithXml(cacheXmlFile);
        File d = new File("DynamicRegionData" + RemoteTestModule.MyPid);
        d.mkdirs();
        String poolName = PoolHelper.getPoolDescription(ConfigPrms.getPoolConfig()).getName();
        DynamicRegionFactory.Config dynamicRegionConfig = new DynamicRegionFactory.Config(d, poolName, true, true);
        ArrayList<String> regionNames = new ArrayList<String>();
        this.numRootRegions = TestConfig.tab().intAt(MLRioPrms.numRootRegions, 1);
        for (int i = 0; i < this.numRootRegions; ++i) {
            regionNames.add(NameFactory.REGION_NAME_PREFIX + (i + 1));
        }
        CacheHelper.generateCacheXmlFile(cacheConfig, dynamicRegionConfig, regionConfig, regionNames, null, poolConfig, cacheXmlFile);
        CacheHelper.createCacheFromXml(cacheXmlFile);
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    public static void HydraTask_forceDisconnect() {
        testInstance.forceDisconnect();
    }

    protected void forceDisconnect() {
        Region fdRegion;
        int numRegionsInVm;
        Cache theCache;
        DistributedSystem ds;
        block4: {
            long executionNumber = MLRioBB.getBB().getSharedCounters().incrementAndRead(MLRioBB.executionNumber);
            Log.getLogWriter().info("forceDisconnect EXECUTION_NUMBER = " + executionNumber);
            ds = DistributedSystemHelper.getDistributedSystem();
            theCache = CacheHelper.getCache();
            numRegionsInVm = this.numRootRegions + this.numRootRegions * this.numDynamicRegions;
            ControllerBB.enableSickness();
            ControllerBB.enablePlayDead();
            SBUtil.beSick();
            SBUtil.playDead();
            fdRegion = this.getRandomRootRegion();
            Log.getLogWriter().info("Calling put on " + fdRegion.getName() + " to cause a forced disconnect");
            try {
                fdRegion.put((Object)new Long(executionNumber), (Object)new Long(System.currentTimeMillis()));
            }
            catch (Exception e) {
                if (MLRioTest.isCausedByForcedDisconnect(e)) break block4;
                throw new TestException("Unexpected Exception " + e + " thrown on put to fdRegion " + fdRegion.getName() + " " + TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done calling put on " + fdRegion.getName() + " to cause a forced disconnect");
        Log.getLogWriter().info("Waiting for " + numRegionsInVm + " ForcedDisconnect events");
        ForcedDiscUtil.waitForForcedDiscConditions(ds, theCache, numRegionsInVm);
        ControllerBB.reset(RemoteTestModule.getMyVmid());
        Log.getLogWriter().info("Re-initializing BridgeServer and Gateway ...");
        this.initializeBridgeServer();
        if (this.isNewWanConfig) {
            this.createAndStartNewWanComponents();
        } else {
            this.startGatewayHub(ConfigPrms.getGatewayConfig());
        }
    }

    public static void HydraTask_healthController() {
        testInstance.healthController();
    }

    protected void healthController() {
        Region fdRegion;
        long numPublishers;
        int numRegionsInVm;
        Cache theCache;
        DistributedSystem ds;
        int maxExecutions;
        long executionNumber;
        block8: {
            executionNumber = MLRioBB.getBB().getSharedCounters().incrementAndRead(MLRioBB.executionNumber);
            Log.getLogWriter().info("healthController EXECUTION_NUMBER = " + executionNumber);
            maxExecutions = TestConfig.tab().intAt(MLRioPrms.maxExecutions, 10);
            if (executionNumber == (long)maxExecutions) {
                Log.getLogWriter().info("Last round of execution, maxExecutions = " + maxExecutions);
            }
            ds = DistributedSystemHelper.getDistributedSystem();
            theCache = CacheHelper.getCache();
            numRegionsInVm = this.numRootRegions + this.numRootRegions * this.numDynamicRegions;
            TestHelper.waitForCounter(MLRioBB.getBB(), "numPublishers", MLRioBB.numPublishers, 1L, false, 500L);
            numPublishers = MLRioBB.getBB().getSharedCounters().read(MLRioBB.numPublishers);
            TestHelper.waitForCounter(MLRioBB.getBB(), "Publishing", MLRioBB.Publishing, numPublishers, true, 180000L);
            MLRioBB.getBB();
            MLRioBB.clearMembershipCounters();
            ControllerBB.enableSickness();
            ControllerBB.enablePlayDead();
            SBUtil.beSick();
            SBUtil.playDead();
            fdRegion = this.getRandomRootRegion();
            Log.getLogWriter().info("Calling put on " + fdRegion.getName() + " to cause a forced disconnect");
            try {
                fdRegion.put((Object)new Long(executionNumber), (Object)new Long(System.currentTimeMillis()));
            }
            catch (Exception e) {
                if (MLRioTest.isCausedByForcedDisconnect(e)) break block8;
                throw new TestException("Unexpected Exception " + e + " thrown on put to fdRegion " + fdRegion.getName() + " " + TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done calling put on " + fdRegion.getName() + " to cause a forced disconnect");
        Log.getLogWriter().info("Waiting for " + numRegionsInVm + " ForcedDisconnect events");
        ForcedDiscUtil.waitForForcedDiscConditions(ds, theCache, numRegionsInVm);
        String sWanSites = TestConfig.getInstance().getSystemProperty("wanSites");
        long numWanSites = new Long(sWanSites);
        String sEdgeVMsPerHost = TestConfig.getInstance().getSystemProperty("edgeVMsPerHost");
        long edgeVMsPerHost = new Long(sEdgeVMsPerHost);
        String sEdgeHostsPerSite = TestConfig.getInstance().getSystemProperty("edgeHostsPerSite");
        long edgeHostsPerSite = new Long(sEdgeHostsPerSite);
        if (this.isNewWanConfig) {
            TestHelper.waitForCounter(MLRioBB.getBB(), "actualClientCrashedEvents", MLRioBB.actualClientCrashedEvents, numWanSites - 1L, false, 30000L);
        } else {
            TestHelper.waitForCounter(MLRioBB.getBB(), "actualClientCrashedEvents", MLRioBB.actualClientCrashedEvents, numWanSites - 1L, true, 30000L);
        }
        TestHelper.waitForCounterSum(MLRioBB.getBB(), "actualServerCrashedEvents", "actualServerDepartedEvents", edgeHostsPerSite * edgeVMsPerHost, false, 60000L);
        TestHelper.waitForCounter(MLRioBB.getBB(), "donePublishing", MLRioBB.donePublishing, numPublishers, true, 60000L);
        MasterController.sleepForMs(5000);
        MLRioBB.getBB().getSharedCounters().zero(MLRioBB.validationComplete);
        Log.getLogWriter().info("Cleared MLRioBB.validationComplete counter");
        SharedLock hcLock = MLRioBB.getBB().getSharedLock();
        hcLock.lock();
        SharedCondition cond = hcLock.getCondition("healthControllerComplete");
        Log.getLogWriter().info("notifying all VMs for MLRioBB.SharedLock.SharedCondition.healthControllerComplete");
        cond.signalAll();
        Log.getLogWriter().info("notifed all VMs for MLRioBB.SharedLock.SharedCondition.healthControllerComplete");
        hcLock.unlock();
        Log.getLogWriter().info("unlocked MLRioBB.SharedLock");
        ControllerBB.reset(RemoteTestModule.getMyVmid());
        Log.getLogWriter().info("Re-initializing BridgeServer and Gateway ...");
        this.initializeBridgeServer();
        if (!this.isNewWanConfig) {
            this.startGatewayHub(ConfigPrms.getGatewayConfig());
        } else {
            this.createAndStartNewWanComponents();
        }
        if (executionNumber == (long)maxExecutions) {
            throw new StopSchedulingOrder("numExecutions = " + executionNumber);
        }
    }

    public static void HydraTask_networkController() {
        testInstance.networkController();
    }

    protected void networkController() {
        long executionNumber = MLRioBB.getBB().getSharedCounters().incrementAndRead(MLRioBB.executionNumber);
        Log.getLogWriter().info("networkController EXECUTION_NUMBER = " + executionNumber);
        int maxExecutions = TestConfig.tab().intAt(MLRioPrms.maxExecutions, 10);
        if (executionNumber == (long)maxExecutions) {
            Log.getLogWriter().info("Last round of execution, maxExecutions = " + maxExecutions);
        }
        TestHelper.waitForCounter(MLRioBB.getBB(), "numPublishers", MLRioBB.numPublishers, 1L, false, 500L);
        long numPublishers = MLRioBB.getBB().getSharedCounters().read(MLRioBB.numPublishers);
        TestHelper.waitForCounter(MLRioBB.getBB(), "Publishing", MLRioBB.Publishing, numPublishers, true, 180000L);
        MLRioBB.getBB();
        MLRioBB.clearMembershipCounters();
        SBUtil.dropConnection();
        TestHelper.waitForCounter(MLRioBB.getBB(), "forcedDisconnects", MLRioBB.forcedDisconnects, 1L, false, 60000L);
        TestHelper.waitForCounter(MLRioBB.getBB(), "donePublishing", MLRioBB.donePublishing, numPublishers, true, 60000L);
        MasterController.sleepForMs(5000);
        SBUtil.restoreConnection();
        Log.getLogWriter().info("Re-starting losingSide BridgeServer/Gateway ...");
        Object[] losingSideServers = StopStartVMs.getOtherVMs(1, "wan_1_Lose");
        Log.getLogWriter().info("Stopping VMs : " + losingSideServers);
        List clientVmInfoList = (List)losingSideServers[0];
        List stopModeList = (List)losingSideServers[1];
        StopStartVMs.stopStartVMs(clientVmInfoList, stopModeList);
        Log.getLogWriter().info("Done restarting losingSide VMs");
        MLRioBB.getBB().getSharedCounters().zero(MLRioBB.validationComplete);
        Log.getLogWriter().info("Cleared MLRioBB.validationComplete counter");
        SharedLock hcLock = MLRioBB.getBB().getSharedLock();
        hcLock.lock();
        SharedCondition cond = hcLock.getCondition("healthControllerComplete");
        Log.getLogWriter().info("notifying all VMs for MLRioBB.SharedLock.SharedCondition.healthControllerComplete");
        cond.signalAll();
        Log.getLogWriter().info("notifed all VMs for MLRioBB.SharedLock.SharedCondition.healthControllerComplete");
        hcLock.unlock();
        Log.getLogWriter().info("unlocked MLRioBB.SharedLock");
        MLRioBB.getBB().getSharedCounters().zero(MLRioBB.forcedDisconnects);
        if (executionNumber == (long)maxExecutions) {
            throw new StopSchedulingOrder("numExecutions = " + executionNumber);
        }
    }

    public static void HydraTask_putSequentialKeys() {
        testInstance.putSequentialKeys();
        testInstance.validateSequentialKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSequentialKeys() {
        Boolean bl = firstTimePublishing;
        synchronized (bl) {
            if (firstTimePublishing.equals(Boolean.TRUE)) {
                long numPublishers = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
                MLRioBB.getBB().getSharedCounters().setIfLarger(MLRioBB.numPublishers, numPublishers);
                firstTimePublishing = Boolean.FALSE;
            }
        }
        TestHelper.checkForEventError(MLRioBB.getBB());
        long executionNumber = MLRioBB.getBB().getSharedCounters().read(MLRioBB.executionNumber);
        Log.getLogWriter().info("putSequentialKeys EXECUTION_NUMBER = " + executionNumber);
        int maxExecutions = TestConfig.tab().intAt(MLRioPrms.maxExecutions, 10);
        if (executionNumber == (long)maxExecutions) {
            Log.getLogWriter().info("Last round of execution, maxExecutions = " + maxExecutions);
        }
        boolean isDynamicRegion = this.numDynamicRegions > 0;
        Region aRegion = this.getRandomRegion(!isDynamicRegion);
        while (aRegion == null) {
            Log.getLogWriter().info("getRandomRegion returned null, sleeping 1 ms to waiting for dynamicRegionCreation");
            MasterController.sleepForMs(1000);
            aRegion = this.getRandomRegion(!isDynamicRegion);
        }
        Log.getLogWriter().info("Working on Region " + aRegion.getName());
        String key = NameFactory.getNextPositiveObjectName();
        Long val = new Long(NameFactory.getCounterForName(key));
        Log.getLogWriter().info("Working on key " + key + " in Region " + aRegion.getFullPath());
        for (int i = 1; i <= 1000; ++i) {
            aRegion.put((Object)key, (Object)new ValueHolder(val, this.randomValues, new Integer(i)));
            if (i != 500) continue;
            long ctr = MLRioBB.getBB().getSharedCounters().incrementAndRead(MLRioBB.Publishing);
            Log.getLogWriter().info("putSequentialKeys: incremented MLRioBB.Publishing = " + ctr);
        }
        long ctr = MLRioBB.getBB().getSharedCounters().incrementAndRead(MLRioBB.donePublishing);
        Log.getLogWriter().info("putSequentialKeys: incremented MLRioBB.donePublishing = " + ctr);
        SharedLock hcLock = MLRioBB.getBB().getSharedLock();
        hcLock.lock();
        SharedCondition cond = hcLock.getCondition("healthControllerComplete");
        Log.getLogWriter().info("Waiting to be notified for MLRioBB.SharedLock.SharedCondition.healthControllerComplete");
        try {
            cond.await();
            Log.getLogWriter().info("Notified for MLRioBB.SharedLock.SharedCondition.healthControllerComplete");
        }
        catch (InterruptedException e) {
            Log.getLogWriter().info("SharedCondition await() interrupted, continuing ...");
        }
        finally {
            hcLock.unlock();
            Log.getLogWriter().info("Unlocked for MLRioBB.SharedLock");
        }
        MLRioBB.getBB().getSharedCounters().zero(MLRioBB.Publishing);
        MLRioBB.getBB().getSharedCounters().zero(MLRioBB.donePublishing);
        Log.getLogWriter().info("putSequentialKeys: reset MLRioBB Publishing and donePublishing counters");
        if (executionNumber == (long)maxExecutions) {
            throw new StopSchedulingOrder("numExecutions = " + executionNumber);
        }
    }

    public static void HydraTask_doEntryOperations() {
        testInstance.doEntryOperations();
    }

    protected void doEntryOperations() {
        GsRandom rng = TestConfig.tab().getRandGen();
        boolean isDynamicRegion = this.numDynamicRegions > 0;
        Region aRegion = this.getRandomRegion(!isDynamicRegion);
        while (aRegion == null) {
            Log.getLogWriter().info("getRandomRegion returned null, sleeping 1 ms to waiting for dynamicRegionCreation");
            MasterController.sleepForMs(1000);
            aRegion = this.getRandomRegion(!isDynamicRegion);
        }
        Log.getLogWriter().info("Working on Region " + aRegion.getName());
        this.doEntryOperations(aRegion);
    }

    public static void closeCacheAndDisconnectFromDS() {
        CacheHelper.closeCache();
        DistributedSystemHelper.disconnect();
    }

    protected void validateSequentialKeys() {
        SilenceListener.waitForSilence(30L, 5000L);
        Region aRegion22 = null;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion22 : rootRegions) {
            Set subRegions = aRegion22.subregions(true);
            for (Region aRegion22 : subRegions) {
                this.validateRegion(aRegion22, true);
            }
        }
        Log.getLogWriter().info("Validation complete");
        MLRioBB.getBB().getSharedCounters().increment(MLRioBB.validationComplete);
        long numPublishers = MLRioBB.getBB().getSharedCounters().read(MLRioBB.numPublishers);
        TestHelper.waitForCounter(MLRioBB.getBB(), "validationComplete", MLRioBB.validationComplete, numPublishers, true, 120000L);
    }

    public static void HydraCloseTask_validateKeysInRegion() {
        testInstance.validateKeysInRegion();
    }

    protected void validateKeysInRegion() {
        SilenceListener.waitForSilence(30L, 5000L);
        Region aRegion22 = null;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion22 : rootRegions) {
            Set subRegions = aRegion22.subregions(true);
            for (Region aRegion22 : subRegions) {
                this.validateRegion(aRegion22, false);
            }
        }
        Log.getLogWriter().info("Validation complete");
    }

    protected void validateRegion(Region aRegion, boolean verifyModVal) {
        Log.getLogWriter().info("Validating entries for Region " + aRegion.getName());
        Set serverKeys = aRegion.keySetOnServer();
        int expectedRegionSize = serverKeys.size();
        Set localKeys = aRegion.keySet();
        int regionSize = localKeys.size();
        if (regionSize == 0 && expectedRegionSize == 0) {
            return;
        }
        StringBuffer aStr = new StringBuffer();
        Set myEntries = aRegion.entrySet();
        Object[] entries = myEntries.toArray();
        RegionEntryComparator myComparator = new RegionEntryComparator();
        Arrays.sort(entries, myComparator);
        Log.getLogWriter().info("Checking " + regionSize + " entries against " + expectedRegionSize + " entries in the server's region");
        aStr.append("Expecting " + expectedRegionSize + " entries in Region " + aRegion.getFullPath() + ", found " + entries.length + "\n");
        for (int i = 0; i < entries.length; ++i) {
            Region.Entry entry = (Region.Entry)entries[i];
            String key = (String)entry.getKey();
            BaseValueHolder val = (BaseValueHolder)entry.getValue();
            if (verifyModVal) {
                aStr.append("\t" + key + " : " + val.modVal + "\n");
                continue;
            }
            if (val != null) {
                aStr.append("\t" + key + " : " + val.myValue + "\n");
                continue;
            }
            aStr.append("\t" + key + " :  null\n");
        }
        if (regionSize <= 10) {
            Log.getLogWriter().info(aStr.toString());
        }
        aStr = new StringBuffer();
        if (regionSize != expectedRegionSize) {
            aStr.append("Expected " + expectedRegionSize + " keys in Region " + aRegion.getFullPath() + " but found " + regionSize + "\n");
        }
        Log.getLogWriter().info("Checking for missing or extra keys in client region");
        ArrayList unexpectedKeys = new ArrayList(localKeys);
        unexpectedKeys.removeAll(serverKeys);
        if (unexpectedKeys.size() > 0) {
            aStr.append("Extra keys (not found on server): " + unexpectedKeys + "\n");
        }
        ArrayList missingKeys = new ArrayList(serverKeys);
        missingKeys.removeAll(localKeys);
        if (missingKeys.size() > 0) {
            aStr.append("Missing keys (found on server, but not locally) = " + missingKeys + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString() + " " + TestHelper.getStackTrace());
        }
        for (int i = 0; i < entries.length; ++i) {
            Region.Entry entry = (Region.Entry)entries[i];
            String key = (String)entry.getKey();
            BaseValueHolder val = (BaseValueHolder)entry.getValue();
            if (!verifyModVal || val.modVal == 1000) continue;
            throw new TestException("Mod value for key " + key + " is " + val.modVal + ", expected " + 1000);
        }
    }

    protected Region getRandomRegion(boolean allowRootRegion) {
        Region rootRegion = this.getRandomRootRegion();
        Set subregionsSet = rootRegion.subregions(true);
        Log.getLogWriter().fine("getRandomRegion (" + rootRegion.getName() + " has the following subregions: " + subregionsSet);
        if (subregionsSet.size() == 0) {
            if (allowRootRegion) {
                return rootRegion;
            }
            return null;
        }
        ArrayList<Object> aList = null;
        try {
            Object[] array = subregionsSet.toArray();
            aList = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                aList.add(array[i]);
            }
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        if (allowRootRegion) {
            aList.add(rootRegion);
        }
        if (aList.size() == 0) {
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
        Region aRegion = (Region)aList.get(randInt);
        if (aRegion == null) {
            throw new TestException("Bug 30171 detected: aRegion is null");
        }
        return aRegion;
    }

    protected Region createDynamicRegion(String parentName, String drName) {
        Region dr = null;
        Log.getLogWriter().info("Creating dynamic region " + parentName + "/" + drName);
        try {
            dr = DynamicRegionFactory.get().createDynamicRegion(parentName, drName);
        }
        catch (CacheException ce) {
            throw new TestException(TestHelper.getStackTrace(ce));
        }
        Log.getLogWriter().info("Created dynamic region " + TestHelper.regionToString(dr, true));
        return dr;
    }

    protected Region getRandomRootRegion() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().fine("getRandomRootRegion found " + rootRegions);
        int randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
        Object[] regionList = rootRegions.toArray();
        Region rootRegion = (Region)regionList[randInt];
        return rootRegion;
    }

    public static synchronized void HydraEndTask_verifyConflation() {
        if (testInstance == null) {
            testInstance = new MLRioTest();
            testInstance.verifyConflation();
        }
    }

    protected void verifyConflation() {
        SharedCounters sc = MLRioBB.getBB().getSharedCounters();
        long missedUpdates = sc.read(MLRioBB.missedUpdates);
        Log.getLogWriter().info("verifyConflation: missedUpdates = " + missedUpdates);
        double eventsConflated = this.getConflatedEventCount();
        Log.getLogWriter().info("verifyConflation: eventsConflated = " + eventsConflated);
        if (eventsConflated <= 0.0) {
            throw new TestException("Tuning required.  Test expected Gateway batchConflation, but GatewayStatistics.eventsNotQueuedConflated = " + eventsConflated);
        }
    }

    protected double getConflatedEventCount() {
        String spec = null;
        spec = this.isNewWanConfig ? "*bridge* GatewaySenderStatistics * eventsNotQueuedConflated filter=none combine=combineAcrossArchives ops=max" : "*bridge* GatewayStatistics * eventsNotQueuedConflated filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double eventsConflated = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            eventsConflated += stat.getMax();
        }
        return eventsConflated;
    }

    private static boolean isCausedByForcedDisconnect(Exception e) {
        Log.getLogWriter().info("checkForForcedDisconnect processed Exception " + e);
        String errStr = e.toString();
        boolean causedByForcedDisconnect = errStr.indexOf("com.gemstone.gemfire.ForcedDisconnectException") >= 0;
        return causedByForcedDisconnect;
    }

    static {
        firstTimePublishing = Boolean.TRUE;
    }
}

