/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.util.Iterator;
import splitBrain.ControllerBB;
import splitBrain.ControllerListener;
import splitBrain.ForcedDiscUtil;
import splitBrain.MembershipNotifierHook;
import splitBrain.SBUtil;
import splitBrain.SplitBrainBB;
import splitBrain.SplitBrainPrms;
import util.BaseValueHolder;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class ForcedDiscTest {
    public static ForcedDiscTest testInstance;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    protected RandomValues randomValues = new RandomValues();
    public Region aRegion;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected int numVMsToStop;
    protected int secondsToRun;
    protected boolean lockOperations;
    protected DistributedLockService distLockService;
    protected boolean isBridgeConfiguration;
    protected boolean isBridgeClient;
    protected boolean expectingForcedDisconnect;
    protected int numExceptionThreads;
    protected static Object syncObject;
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String VmIDStr = "VmId_";

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new ForcedDiscTest();
            testInstance.initializeRegion("clientRegion");
            testInstance.initializeInstance();
            if (ForcedDiscTest.testInstance.isBridgeConfiguration) {
                ForcedDiscTest.testInstance.isBridgeClient = true;
                ForcedDiscTest.registerInterest(ForcedDiscTest.testInstance.aRegion);
            } else {
                Log.getLogWriter().info("Installing MembershipNotifierHook");
                SBUtil.addMembershipHook(new MembershipNotifierHook());
            }
        }
    }

    public static synchronized void HydraTask_initializeServer() {
        if (testInstance == null) {
            testInstance = new ForcedDiscTest();
            testInstance.initializeRegion("serverRegion");
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            ForcedDiscTest.testInstance.isBridgeClient = false;
        }
        Log.getLogWriter().info("Installing MembershipNotifierHook");
        SBUtil.addMembershipHook(new MembershipNotifierHook());
    }

    public void initializeInstance() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = TestConfig.tab().intAt(SplitBrainPrms.numOpsPerTask, Integer.MAX_VALUE);
        this.upperThreshold = TestConfig.tab().intAt(SplitBrainPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(SplitBrainPrms.lowerThreshold, -1);
        this.secondsToRun = TestConfig.tab().intAt(SplitBrainPrms.secondsToRun, 600);
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        this.isBridgeConfiguration = bridgeNames != null;
        this.isBridgeClient = false;
        this.lockOperations = TestConfig.tab().booleanAt(SplitBrainPrms.lockOperations, false);
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", minTaskGranularityMS " + this.minTaskGranularityMS + ", numOpsPerTask " + this.numOpsPerTask + ", lockOperations " + this.lockOperations + ", upperThreshold " + this.upperThreshold + ", lowerThreshold " + this.lowerThreshold + ", isBridgeConfiguration " + this.isBridgeConfiguration);
    }

    public void initializeRegion(String regDescriptName) {
        block2: {
            CacheHelper.createCache("cache1");
            String key = VmIDStr + RemoteTestModule.getMyVmid();
            String xmlFile = key + ".xml";
            try {
                CacheHelper.generateCacheXmlFile("cache1", regDescriptName, xmlFile);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block2;
                throw e;
            }
        }
        this.aRegion = RegionHelper.createRegion(regDescriptName);
    }

    protected void reinitializeClient() {
        testInstance.initializeRegion("clientRegion");
        if (ForcedDiscTest.testInstance.isBridgeConfiguration) {
            ForcedDiscTest.registerInterest(ForcedDiscTest.testInstance.aRegion);
        } else {
            Log.getLogWriter().info("Installing MembershipNotifierHook");
            SBUtil.addMembershipHook(new MembershipNotifierHook());
        }
        ControllerBB.signalInitIsComplete();
    }

    protected void reinitializeServer() {
        testInstance.initializeRegion("serverRegion");
        BridgeHelper.startBridgeServer("bridge");
        Log.getLogWriter().info("Installing MembershipNotifierHook");
        SBUtil.addMembershipHook(new MembershipNotifierHook());
        ControllerBB.signalInitIsComplete();
    }

    protected void reinitialize() {
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        if (ds == null || !ds.isConnected()) {
            DistributedSystemHelper.disconnect();
            if (this.isBridgeConfiguration) {
                if (this.isBridgeClient) {
                    this.reinitializeClient();
                } else {
                    this.reinitializeServer();
                }
            } else {
                this.reinitializeClient();
            }
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public static void HydraTask_doEntryOps() {
        try {
            testInstance.doEntryOperations(ForcedDiscTest.testInstance.aRegion);
        }
        catch (Exception e) {
            testInstance.handleException(e);
        }
        testInstance.checkForTimeToStop();
    }

    public static void HydraTask_causeForcedDisconnect() {
        ForcedDiscTest.logExecutionNumber();
        testInstance.causeForcedDisconnect();
        testInstance.checkForLastIteration();
        testInstance.checkForTimeToStop();
    }

    public static void HydraTask_cycleWellness() {
        ForcedDiscTest.logExecutionNumber();
        ControllerListener.validateForcedDisconnects = false;
        try {
            testInstance.cycleWellness();
        }
        catch (Exception e) {
            testInstance.handleExceptionWithCycleWellness(e);
        }
    }

    public static void HydraTask_doEntryOpsWithCycleWellness() {
        try {
            testInstance.doEntryOperations(ForcedDiscTest.testInstance.aRegion);
        }
        catch (Exception e) {
            testInstance.handleExceptionWithCycleWellness(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doEntryOperations(Region aRegion) {
        Log.getLogWriter().info("In doEntryOperations with " + aRegion.getFullPath());
        startTime = System.currentTimeMillis();
        numOps = 0;
        do {
            whichOp = this.getOperation(SplitBrainPrms.entryOperations);
            size = aRegion.size();
            if (size >= this.upperThreshold) {
                whichOp = this.getOperation(SplitBrainPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getOperation(SplitBrainPrms.lowerThresholdOperations);
            }
            lockName = null;
            gotTheLock = false;
            if (this.lockOperations) {
                lockName = ForcedDiscTest.LOCK_NAME + TestConfig.tab().getRandGen().nextInt(1, 20);
                Log.getLogWriter().info("Trying to get distributed lock " + lockName + "...");
                gotTheLock = this.distLockService.lock((Object)lockName, -1L, -1L);
                if (!gotTheLock) {
                    throw new TestException("Did not get lock " + lockName);
                }
                Log.getLogWriter().info("Got distributed lock " + lockName + ": " + gotTheLock);
            }
            Log.getLogWriter().info("expecting forced disconnect: " + this.expectingForcedDisconnect);
            try {
                switch (whichOp) {
                    case 1: {
                        this.addEntry(aRegion);
                        ** break;
lbl27:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.invalidateEntry(aRegion, false);
                        ** break;
lbl31:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.destroyEntry(aRegion, false);
                        ** break;
lbl35:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this.updateEntry(aRegion);
                        ** break;
lbl39:
                        // 1 sources

                        break;
                    }
                    case 7: {
                        this.getKey(aRegion);
                        ** break;
lbl43:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        this.getNewKey(aRegion);
                        ** break;
lbl47:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        this.invalidateEntry(aRegion, true);
                        ** break;
lbl51:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        this.destroyEntry(aRegion, true);
                        ** break;
lbl55:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            finally {
                if (gotTheLock) {
                    gotTheLock = false;
                    this.distLockService.unlock((Object)lockName);
                    Log.getLogWriter().info("Released distributed lock " + lockName);
                }
            }
            ControllerBB.checkForError();
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
        Log.getLogWriter().info("Done in doEntryOperations with " + aRegion.getFullPath());
    }

    protected void addEntry(Region aRegion) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = ForcedDiscTest.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aRegion.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    aRegion.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = ForcedDiscTest.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = ForcedDiscTest.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        BaseValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            Log.getLogWriter().info("Done with call to put (update)");
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("Done with call to put (update)");
        }
    }

    protected void getKey(Region aRegion) {
        Object key = ForcedDiscTest.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        } else {
            Log.getLogWriter().info("getKey: getting key " + key);
            anObj = aRegion.get(key);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.size();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key);
            anObj = aRegion.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void causeForcedDisconnect() {
        this.numExceptionThreads = 0;
        ControllerBB.checkForError();
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        Cache theCache = CacheHelper.getCache();
        this.expectingForcedDisconnect = true;
        boolean fdBySlowListener = false;
        ControllerBB.enablePlayDead();
        SBUtil.playDead();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            SBUtil.beSick();
        } else {
            fdBySlowListener = true;
            ControllerBB.enableSlowListener();
        }
        ControllerBB.checkForError();
        ForcedDiscUtil.waitForForcedDiscConditions(ds, theCache);
        ControllerBB.waitMembershipFailureComplete();
        ControllerBB.reset(RemoteTestModule.getMyVmid());
        ControllerBB.checkForError();
        int expectedNumExceptionThr = Integer.getInteger("numThreads") - 1;
        while (this.numExceptionThreads != expectedNumExceptionThr) {
            Log.getLogWriter().info("Waiting for " + expectedNumExceptionThr + " threads in this vm to get an exception due to a forced disconnect, current number of exception threads is " + this.numExceptionThreads);
            MasterController.sleepForMs(2000);
        }
        Log.getLogWriter().info("Done waiting for " + expectedNumExceptionThr + " threads in this vm to get an exception due to a forced disconnect, current number of exception threads is " + this.numExceptionThreads);
        this.expectingForcedDisconnect = false;
        this.reinitialize();
        Log.getLogWriter().info("Notifying all threads that reinitialization is complete");
        Object object = syncObject;
        synchronized (object) {
            syncObject.notifyAll();
        }
        Log.getLogWriter().info("Done notifying all threads that reinitialization is complete");
        ControllerBB.checkForError();
        int numThreadsInThisVM = Integer.getInteger("numThreads");
    }

    protected void cycleWellness() {
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        Cache theCache = CacheHelper.getCache();
        ControllerBB.checkForError();
        boolean fdBySlowListener = false;
        SBUtil.playDead();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            SBUtil.beSick();
        } else {
            fdBySlowListener = true;
            ControllerBB.enableSlowListener();
        }
        ControllerBB.checkForError();
        ForcedDiscUtil.waitForForcedDiscConditions(ds, theCache);
        ControllerBB.reset(RemoteTestModule.getMyVmid());
        ControllerBB.checkForError();
        this.reinitialize();
    }

    protected BaseValueHolder getValueForKey(Object key) {
        return new ValueHolder((String)key, this.randomValues);
    }

    protected Object getNewKey() {
        return NameFactory.getNextPositiveObjectName();
    }

    protected Object getRecentKey(Region aRegion, int recentHistory) {
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            return null;
        }
        long keyIndex = TestConfig.tab().getRandGen().nextLong(Math.max(maxNames - (long)recentHistory, 1L), maxNames);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        return key;
    }

    protected BaseValueHolder getUpdateObject(Region aRegion, String key) {
        BaseValueHolder anObj = (BaseValueHolder)aRegion.get((Object)key);
        BaseValueHolder newObj = anObj == null ? new ValueHolder(key, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    protected static void logExecutionNumber() {
        long exeNum = SplitBrainBB.getBB().getSharedCounters().incrementAndRead(SplitBrainBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected static void registerInterest(Region aRegion) {
        Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES");
        aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
    }

    public static Object getExistingKey(Region aRegion) {
        Object key = null;
        Iterator it = aRegion.keys().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    protected synchronized void checkForLastIteration() {
        long taskStartTime = 0L;
        String bbKey = "TaskStartTime";
        Object anObj = SplitBrainBB.getBB().getSharedMap().get("TaskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            SplitBrainBB.getBB().getSharedMap().put("TaskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(this.secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            SplitBrainBB.getBB().getSharedCounters().increment(SplitBrainBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + this.secondsToRun + " seconds; time remaining is " + ((long)this.secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(Exception anExcept) {
        if (anExcept instanceof CancelException) {
            if (!this.expectingForcedDisconnect) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof LockServiceDestroyedException) {
            if (!this.expectingForcedDisconnect) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else {
            throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
        }
        Log.getLogWriter().info("Caught " + anExcept + "; expected, continuing test");
        Object object = this.getClass();
        synchronized (object) {
            ++this.numExceptionThreads;
        }
        Log.getLogWriter().info("Waiting for reinitialization");
        try {
            object = syncObject;
            synchronized (object) {
                syncObject.wait();
            }
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Done waiting for reinitialization");
    }

    protected void checkForTimeToStop() {
        long counter = SplitBrainBB.getBB().getSharedCounters().read(SplitBrainBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Tasks have signalled it's time to stop");
        }
    }

    protected void handleExceptionWithCycleWellness(Exception anExcept) {
        if (anExcept instanceof CancelException || anExcept instanceof RegionDestroyedException || anExcept instanceof LockServiceDestroyedException) {
            Log.getLogWriter().info("Caught " + anExcept + "; continuing test");
            MasterController.sleepForMs(2000);
        } else if (anExcept instanceof LockNotHeldException) {
            String errStr = anExcept.toString();
            if (errStr.indexOf("MyLock_") <= 0) {
                throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
            }
        } else {
            throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
        }
    }

    static {
        syncObject = new Object();
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock_";
    }
}

