/*
 * Decompiled with CFR 0.152.
 */
package security;

import com.gemstone.gemfire.cache.operations.OperationContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import security.CredentialGenerator;
import security.DummyAuthzCredentialGenerator;
import security.XmlAuthzCredentialGenerator;

public abstract class AuthzCredentialGenerator {
    protected CredentialGenerator cGen;
    private Properties sysProps;

    public static AuthzCredentialGenerator create(ClassCode classCode) {
        switch (classCode.classType) {
            case 1: {
                return new DummyAuthzCredentialGenerator();
            }
            case 2: {
                return new XmlAuthzCredentialGenerator();
            }
        }
        return null;
    }

    public boolean init(CredentialGenerator cGen) {
        this.cGen = cGen;
        try {
            this.sysProps = this.init();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public Properties getSystemProperties() {
        return this.sysProps;
    }

    public CredentialGenerator getCredentialGenerator() {
        return this.cGen;
    }

    public abstract ClassCode classCode();

    public abstract String getAuthorizationCallback();

    public Properties getAllowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        int numTries = this.getNumPrincipalTries(opCodes, regionNames);
        if (numTries <= 0) {
            numTries = 1;
        }
        for (int tries = 0; tries < numTries; ++tries) {
            Principal principal = this.getAllowedPrincipal(opCodes, regionNames, (index + tries) % numTries);
            try {
                return this.cGen.getValidCredentials(principal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return null;
    }

    public Properties getDisallowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int index) {
        int numTries = this.getNumPrincipalTries(opCodes, regionNames);
        if (numTries <= 0) {
            numTries = 1;
        }
        for (int tries = 0; tries < numTries; ++tries) {
            Principal principal = this.getDisallowedPrincipal(opCodes, regionNames, (index + tries) % numTries);
            try {
                return this.cGen.getValidCredentials(principal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return null;
    }

    protected abstract Properties init() throws IllegalArgumentException;

    protected abstract int getNumPrincipalTries(OperationContext.OperationCode[] var1, String[] var2);

    protected abstract Principal getAllowedPrincipal(OperationContext.OperationCode[] var1, String[] var2, int var3);

    protected abstract Principal getDisallowedPrincipal(OperationContext.OperationCode[] var1, String[] var2, int var3);

    public static final class ClassCode {
        private static final byte ID_DUMMY = 1;
        private static final byte ID_XML = 2;
        private static byte nextOrdinal = 0;
        private static final ClassCode[] VALUES = new ClassCode[10];
        private static final Map CodeNameMap = new HashMap();
        public static final ClassCode DUMMY = new ClassCode("templates.security.DummyAuthorization.create", 1);
        public static final ClassCode XML = new ClassCode("templates.security.XmlAuthorization.create", 2);
        private final String name;
        private final byte ordinal;
        private final byte classType;

        private ClassCode(String name, byte classType) {
            this.name = name;
            this.classType = classType;
            byte by = nextOrdinal;
            nextOrdinal = (byte)(by + 1);
            this.ordinal = by;
            ClassCode.VALUES[this.ordinal] = this;
            CodeNameMap.put(name, this);
        }

        public boolean isDummy() {
            return this.classType == 1;
        }

        public boolean isXml() {
            return this.classType == 2;
        }

        public static ClassCode fromOrdinal(byte ordinal) {
            return VALUES[ordinal];
        }

        public static ClassCode parse(String operationName) {
            return (ClassCode)CodeNameMap.get(operationName);
        }

        public static List getAll() {
            ArrayList codes = new ArrayList();
            Iterator iter = CodeNameMap.values().iterator();
            while (iter.hasNext()) {
                codes.add(iter.next());
            }
            return codes;
        }

        public byte toOrdinal() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClassCode)) {
                return false;
            }
            ClassCode other = (ClassCode)obj;
            return other.ordinal == this.ordinal;
        }

        public final boolean equals(ClassCode opCode) {
            return opCode != null && opCode.ordinal == this.ordinal;
        }

        public final int hashCode() {
            return this.ordinal;
        }
    }
}

