/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RegionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import resumeTx.ResumeTxBB;
import util.BaseValueHolder;

public class VerifyTx
implements Function,
Declarable {
    public void execute(FunctionContext context) {
        boolean success = true;
        StringBuffer errStr = new StringBuffer();
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        ArrayList argumentList = (ArrayList)context.getArguments();
        String forDM = (String)argumentList.get(0);
        TransactionId txId = (TransactionId)argumentList.get(1);
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " on txId " + txId);
        Map destroyedEntries = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.DESTROYED_ENTRIES);
        Log.getLogWriter().fine("destroyedEntries = " + destroyedEntries);
        for (String regionName : destroyedEntries.keySet()) {
            Region aRegion = RegionHelper.getRegion(regionName);
            List keys = (List)destroyedEntries.get(regionName);
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                if (!aRegion.containsKey(key)) continue;
                Log.getLogWriter().info("Expected containsKey to be false, for " + regionName + ":" + key + ", but it was true (key was destroyed in " + txId + ")");
                errStr.append("Expected containsKey to be false, for " + regionName + ":" + key + ", but it was true (key was destroyed in " + txId + ") \n");
            }
        }
        Map expectedKeysValues = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.EXPECTED_KEYS_VALUES);
        Log.getLogWriter().fine("expectedKeysValues = " + expectedKeysValues);
        for (String regionName : expectedKeysValues.keySet()) {
            Region aRegion = RegionHelper.getRegion(regionName);
            Map keyValuePair = (Map)expectedKeysValues.get(regionName);
            for (Object key : keyValuePair.keySet()) {
                Object value = keyValuePair.get(key);
                if (!aRegion.containsKey(key)) {
                    Log.getLogWriter().info("Expected containsKey() to be true for " + regionName + ":" + key + ", but it was false.  txId = " + txId);
                    errStr.append("Expected containsKey() to be true for " + regionName + ":" + key + ", but it was false, txId = " + txId + "\n");
                }
                if (value == null && aRegion.containsValueForKey(key)) {
                    Log.getLogWriter().info("Expected containsValueForKey to be false, for " + regionName + ":" + key + ", but it was true, txId = " + txId);
                    errStr.append("Expected containsValueForKey to be false, for " + regionName + ":" + key + ", but it was true, txId = " + txId + "\n");
                }
                if (value != null && !aRegion.containsValueForKey(key)) {
                    Log.getLogWriter().info("Expected containsValueForKey() to be true for " + regionName + ":" + key + ", but it was false, txId = " + txId);
                    errStr.append("Expected containsValueForKey() to be true for " + regionName + ":" + key + ", but it was false, txId = " + txId + "\n");
                }
                Object actualValue = null;
                Region.Entry entry = aRegion.getEntry(key);
                if (entry != null) {
                    actualValue = entry.getValue();
                }
                if (actualValue instanceof BaseValueHolder) {
                    actualValue = ((BaseValueHolder)actualValue).modVal;
                    Log.getLogWriter().fine("actualValue for " + regionName + ":" + key + " is an Integer " + actualValue);
                    if (actualValue.equals(value)) continue;
                    Log.getLogWriter().info("Expected value for " + regionName + ":" + key + " to be " + value + ", but found " + actualValue + " txId = " + txId);
                    errStr.append("Expected value for " + regionName + ":" + key + " to be " + value + ", but found " + actualValue + ", txId = " + txId + "\n");
                    continue;
                }
                Log.getLogWriter().info("WARNING: actual value retrieved from cache is not a ValueHolder, is " + actualValue);
            }
        }
        if (errStr.length() > 0) {
            success = false;
            ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.ERRSTR, errStr.toString());
        }
        Log.getLogWriter().info("VerifyTx returning " + success);
        context.getResultSender().lastResult((Object)new Boolean(success));
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return true;
    }
}

