/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import resumeTx.ActiveTxWrapper;
import resumeTx.TxInfo;
import resumeTx.TxInfoWrapper;

public class RtxUtilVersionHelper {
    public static Map<TXId, TxInfo> convertWrapperMapToActiveTxMap(Map<ActiveTxWrapper, TxInfoWrapper> wrapperMap) throws ClassNotFoundException, IOException {
        HashMap<TXId, TxInfo> activeTxnMap = new HashMap<TXId, TxInfo>();
        Iterator<ActiveTxWrapper> iterator = wrapperMap.keySet().iterator();
        while (iterator.hasNext()) {
            ActiveTxWrapper obj;
            ActiveTxWrapper wrapper = obj = iterator.next();
            TxInfoWrapper txInfoWrapper = wrapperMap.get(wrapper);
            TXId txId = null;
            txId = (TXId)BlobHelper.deserializeBlob((byte[])wrapper.serializedTXId, (Version)Version.GFE_70, null);
            TxInfo txInfo = (TxInfo)BlobHelper.deserializeBlob((byte[])txInfoWrapper.getTxInfoByteArray(), (Version)Version.GFE_70, null);
            activeTxnMap.put(txId, txInfo);
        }
        return activeTxnMap;
    }

    public static Map<ActiveTxWrapper, TxInfoWrapper> convertActiveTxMapToWrapperMap(Map<TXId, TxInfo> activeTxnMap) throws ClassNotFoundException, IOException {
        HashMap<ActiveTxWrapper, TxInfoWrapper> wrapperMap = new HashMap<ActiveTxWrapper, TxInfoWrapper>();
        Iterator<TXId> iterator = activeTxnMap.keySet().iterator();
        while (iterator.hasNext()) {
            TXId obj;
            TXId txId = obj = iterator.next();
            TxInfo txInfo = activeTxnMap.get(txId);
            byte[] serializedTXId = BlobHelper.serializeToBlob((Object)txId, (Version)Version.GFE_70);
            ActiveTxWrapper wrapper = ActiveTxWrapper.getWrappedActiveTx(serializedTXId);
            byte[] serializedTxInfo = BlobHelper.serializeToBlob((Object)txInfo, (Version)Version.GFE_70);
            TxInfoWrapper txInfoWrapper = TxInfoWrapper.getWrappedTxInfo(serializedTxInfo);
            wrapperMap.put(wrapper, txInfoWrapper);
        }
        return wrapperMap;
    }

    public static List<byte[]> convertTransactionIDListToByteArrayList(List<TransactionId> txIdList) throws Exception {
        List<byte[]> list = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < txIdList.size(); ++i) {
            list.add(BlobHelper.serializeToBlob((Object)txIdList.get(i), (Version)Version.GFE_70));
        }
        return list;
    }

    public static List<TransactionId> convertByteArrayListToTransactionIDList(List<byte[]> list) throws Exception {
        List<TransactionId> txIdList = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < list.size(); ++i) {
            txIdList.add((TransactionId)BlobHelper.deserializeBlob((byte[])list.get(i), (Version)Version.GFE_70, null));
        }
        return txIdList;
    }
}

