/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.PartitionDescription;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import resumeTx.ModRoutingObject;
import resumeTx.ResumeTxBB;
import resumeTx.ResumeTxPrms;
import resumeTx.ResumeTxTest;
import resumeTx.RtxUtilVersionHelper;
import tx.TxBB;
import tx.TxPrms;
import tx.TxUtil;
import util.CacheUtil;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class RtxUtil
extends TxUtil {
    public static synchronized void HydraTask_createPartitionedRegions() {
        if (txUtilInstance == null) {
            txUtilInstance = new RtxUtil();
            try {
                txUtilInstance.createPartitionedRegions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_populateRegions() {
        txUtilInstance.initialize();
        ((RtxUtil)txUtilInstance).setNumDataStores();
        txUtilInstance.populateRegions();
    }

    protected void setNumDataStores() {
        Set prRegionsInCache = PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache());
        if (!prRegionsInCache.isEmpty()) {
            Set membersHostingPR = ((PartitionRegionInfo)prRegionsInCache.iterator().next()).getPartitionMemberInfo();
            int numDataStores = membersHostingPR.size();
            Log.getLogWriter().info("Writing setNumDataStores to BB " + numDataStores);
            ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.NUM_DATASTORES, new Integer(numDataStores));
        }
    }

    public static synchronized void HydraTask_createColocatedRegions() {
        if (txUtilInstance == null) {
            txUtilInstance = new RtxUtil();
            try {
                ((RtxUtil)txUtilInstance).createColocatedRegions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    public void createColocatedRegions() {
        super.initialize();
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            CacheUtil.setCache(c);
            c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
            c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
            if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
                c.setCopyOnRead(true);
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            PartitionDescription pd = rd.getPartitionDescription();
            PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
            PartitionAttributes prAttrs = null;
            String colocatedWith = null;
            int numRegions = ResumeTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                if (i > 0) {
                    colocatedWith = regionBase + "_" + i;
                    prFactory.setColocatedWith(colocatedWith);
                    prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                }
                Region region = RegionHelper.createRegion(regionName, aFactory);
            }
        }
    }

    public static synchronized void HydraTask_createClientRegions() {
        if (txUtilInstance == null) {
            txUtilInstance = new RtxUtil();
            ((RtxUtil)txUtilInstance).createClientRegions();
        }
    }

    public void createClientRegions() {
        super.initialize();
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            CacheUtil.setCache(c);
            c.getCacheTransactionManager().setListener(TxPrms.getTxListener());
            c.getCacheTransactionManager().setWriter(TxPrms.getTxWriter());
            if (TxBB.getUpdateStrategy().equalsIgnoreCase("useCopyOnRead")) {
                c.setCopyOnRead(true);
            }
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            int numRegions = ResumeTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                Region aRegion = RegionHelper.createRegion(regionName, aFactory);
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("registered interest in ALL_KEYS for " + regionName);
            }
        }
    }

    public static void HydraTask_primeBuckets() {
        ((RtxUtil)txUtilInstance).primeBuckets();
    }

    protected void primeBuckets() {
        Set prRegionsInCache = PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache());
        int numDataStores = 0;
        int configuredBucketCount = 0;
        int numBuckets = 0;
        if (!prRegionsInCache.isEmpty()) {
            PartitionRegionInfo prRegionInfo = (PartitionRegionInfo)prRegionsInCache.iterator().next();
            Set membersHostingPR = prRegionInfo.getPartitionMemberInfo();
            numDataStores = membersHostingPR.size();
            ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.NUM_DATASTORES, new Integer(numDataStores));
            configuredBucketCount = prRegionInfo.getConfiguredBucketCount();
            numBuckets = configuredBucketCount * numDataStores;
        }
        Log.getLogWriter().info("primeBuckets: total number of buckets in test (dataStores(" + numDataStores + ") * configuredBucketCount(" + configuredBucketCount + ") = " + numBuckets + ")");
        for (int i = 0; i < numBuckets; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            Set rootRegions = CacheHelper.getCache().rootRegions();
            for (Region aRegion : rootRegions) {
                ValueHolder vh = new ValueHolder((Object)key, this.randomValues, new Integer(this.modValInitializer++));
                String callback = "Create event originated in pid " + ProcessMgr.getProcessId() + " memberId=" + DistributedSystemHelper.getDistributedSystem().getDistributedMember();
                Log.getLogWriter().info("populateRegion: calling create for key " + key + ", object " + TestHelper.toString(vh) + ", region is " + aRegion.getFullPath());
                aRegion.create((Object)key, (Object)vh, (Object)callback);
                Log.getLogWriter().info("populateRegion: done creating key " + key);
            }
        }
        this.dumpLocalKeys();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getNewKey(Region aRegion) {
        key = null;
        found = false;
        if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
            myDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            useColocatedEntries = ResumeTxPrms.getUseColocatedEntries();
            do {
                if ((primaryDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)(key = NameFactory.getNextPositiveObjectName()))) == null || !primaryDM.equals(myDM)) continue;
                Log.getLogWriter().fine("getNewKey() ... primaryDM.equals(myDM) = " + primaryDM.toString());
                if (useColocatedEntries) {
                    txId = TxHelper.getTransactionId();
                    activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
                    try {
                        activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
                        Log.getLogWriter().fine("getRandomKey: " + ResumeTxTest.activeTxnsToString(activeTxns));
                        if (activeTxns == null) ** GOTO lbl26
                        txInfo = activeTxns.get(txId);
                        filterRoutingObject = txInfo.getRoutingObject();
                        aRoutingObject = new ModRoutingObject(key);
                        if (filterRoutingObject.hashCode() != aRoutingObject.hashCode()) ** GOTO lbl26
                        Log.getLogWriter().fine("Found colocated entries : " + filterRoutingObject.getKey() + " and " + aRoutingObject.getKey() + " both have the same hashCode " + filterRoutingObject.hashCode());
                        found = true;
                    }
                    catch (Exception e) {
                        throw new TestException(e.toString() + e.getStackTrace().toString());
                    }
                } else {
                    found = true;
                }
lbl26:
                // 5 sources

            } while (!found);
        } else {
            key = NameFactory.getNextPositiveObjectName();
        }
        return key;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getRandomKey(Region aRegion, Object excludeKey) {
        if (this.suspendResume) {
            this.txState.set(TxHelper.internalSuspend());
        }
        if (aRegion == null) {
            return null;
        }
        aSet = null;
        try {
            if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) {
                if (ResumeTxPrms.getUseColocatedEntries()) {
                    aSet = new HashSet<E>(PartitionRegionHelper.getLocalPrimaryData((Region)aRegion).keySet());
                    txId = TxHelper.getTransactionId();
                    activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
                    try {
                        activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
                        Log.getLogWriter().fine("getRandomKey: " + ResumeTxTest.activeTxnsToString(activeTxns));
                        if (activeTxns == null || (filterRoutingObject = (txInfo = activeTxns.get(txId)).getRoutingObject()) == null) ** GOTO lbl27
                        it = aSet.iterator();
                        while (it.hasNext()) {
                            aKey = it.next();
                            aRoutingObject = new ModRoutingObject(aKey);
                            if (filterRoutingObject.hashCode() == aRoutingObject.hashCode()) continue;
                            it.remove();
                        }
                    }
                    catch (Exception e) {
                        throw new TestException(e.toString() + e.getStackTrace().toString());
                    }
                } else {
                    aSet = new HashSet<E>(PartitionRegionHelper.getLocalData((Region)aRegion).keySet());
                }
lbl27:
                // 3 sources

                Log.getLogWriter().fine("getRandomKey: local keySet = " + aSet);
            } else {
                aSet = new HashSet<E>(aRegion.keySet());
            }
        }
        catch (RegionDestroyedException e) {
            if (this.isSerialExecution) {
                throw e;
            }
            if (this.suspendResume) {
                TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
            }
            return null;
        }
        keyArr = aSet.toArray();
        if (keyArr.length == 0) {
            Log.getLogWriter().info("Could not get a random key from " + aRegion.getFullPath() + " because the region has no keys");
            if (this.suspendResume) {
                TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
            }
            return null;
        }
        randInt = TestConfig.tab().getRandGen().nextInt(0, keyArr.length - 1);
        key = keyArr[randInt];
        if (key.equals(excludeKey)) {
            if (keyArr.length == 1) {
                if (this.suspendResume) {
                    TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
                }
                return null;
            }
            if (++randInt == keyArr.length) {
                randInt = 0;
            }
            key = keyArr[randInt];
        }
        if (this.suspendResume) {
            TxHelper.internalResume((TXStateInterface)((TXStateProxy)this.txState.get()));
        }
        return key;
    }

    public static void HydraTask_dumpLocalKeys() {
        ((RtxUtil)txUtilInstance).dumpLocalKeys();
    }

    protected void dumpLocalKeys() {
        StringBuffer aStr = new StringBuffer();
        DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        aStr.append("Keys hosted as primary " + dm.toString() + " by region (key=<routingHashCode>)\n");
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Region localRegion = PartitionRegionHelper.getLocalData((Region)aRegion);
            Set keySet = localRegion.keySet();
            HashMap primaryKeys = new HashMap();
            for (Object key : keySet) {
                DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, key);
                if (!primary.equals(dm)) continue;
                ModRoutingObject ro = new ModRoutingObject(key);
                primaryKeys.put(key, ro.hashCode());
            }
            aStr.append("   " + aRegion.getName() + ": " + primaryKeys + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }
}

