/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import resumeTx.ResumeTxPrms;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class RollbackTx
implements Function,
Declarable {
    public void execute(FunctionContext context) {
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isHA = ResumeTxPrms.getHighAvailability();
        boolean isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        boolean rolledBack = false;
        ArrayList argumentList = (ArrayList)context.getArguments();
        String forDM = (String)argumentList.get(0);
        TransactionId txId = (TransactionId)argumentList.get(1);
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " on txId " + txId);
        if (TxHelper.tryResume(txId, 10L, TimeUnit.SECONDS)) {
            Log.getLogWriter().fine("RollbackTx RESUMED " + txId);
            TxHelper.rollback();
            rolledBack = true;
        } else {
            if (isSerialExecution) {
                throw new TestException(txId + " is not suspended in this member, cannot rollback, " + TestHelper.getStackTrace());
            }
            Log.getLogWriter().fine(txId + " is not suspended in this member with tryResume time limit, cannot rollback.  Expected with concurrent execution, continuing test.");
        }
        Log.getLogWriter().info("RollbackTx returning " + rolledBack + " for txId = " + txId);
        context.getResultSender().lastResult((Object)rolledBack);
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

