/*
 * Decompiled with CFR 0.152.
 */
package resultsUtil;

import hydra.HostHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import resultsUtil.BatteryTestLogInfo;
import resultsUtil.FileLineReader;
import resultsUtil.MasterLogInfo;
import resultsUtil.SummaryInfo;

public class RegressionSummary {
    public static final int CreateNew = 1;
    public static final int ContinueFromExisting = 2;
    private BatteryTestLogInfo btInfo = null;
    private String btDir = null;
    private String logDir = null;
    private int howToCreateSummary = -1;
    private SummaryInfo summInfo = null;

    public RegressionSummary(int howToCreateSummary, String btDir, String logDir) {
        this.howToCreateSummary = howToCreateSummary;
        this.btDir = btDir;
        this.logDir = logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSummaryFromOneLiner(File oneLinerFile) throws FileNotFoundException, Exception {
        String spaceStr = "                    ";
        try (FileLineReader flr = null;){
            flr = new FileLineReader(oneLinerFile);
            String line = flr.readNextLine();
            int lineCount = 1;
            while (line != null) {
                if (lineCount > this.summInfo.getNumTests()) {
                    StringBuffer testSummary = new StringBuffer();
                    String[] components = line.split("\\s+");
                    String testName = components[0];
                    String status = components[1];
                    String testTime = components[2];
                    String resultDir = components[3];
                    String resultDirName = this.getDirName(resultDir);
                    String testDir = this.btDir + File.separator + resultDirName;
                    MasterLogInfo.saveMasterLogInfo(testDir);
                    if (status.equals("F") || status.equals("H")) {
                        String failure = this.getTestFailure(testDir);
                        testSummary.append(status + " " + failure);
                    } else {
                        testSummary.append(status);
                    }
                    testSummary.append(spaceStr);
                    testSummary.append("(elapsed: " + testTime + ") ");
                    String diskUsage = this.getDiskUsage(testDir);
                    this.summInfo.addToDiskUsage(diskUsage);
                    testSummary.append("(disk: " + diskUsage + ") ");
                    this.summInfo.addTest(testSummary.toString());
                }
                line = flr.readNextLine();
                ++lineCount;
            }
        }
    }

    private void doSummary(File dir) throws Exception, FileNotFoundException {
        File[] fileList = dir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File aFile = fileList[i];
            String name = aFile.getName();
            if (!name.equals("oneliner.txt")) continue;
            this.doSummaryFromOneLiner(aFile);
            this.summInfo.updateAndCombine(this.btInfo);
            return;
        }
    }

    public void doSummary() throws Exception {
        File dir = new File(this.btDir);
        if (!dir.exists()) {
            throw new Exception(dir.getAbsolutePath() + " does not exist; expected directory containing oneliner.txt");
        }
        if (!this.isBtDir(dir)) {
            throw new Exception(dir.getAbsolutePath() + " does not contain oneliner.txt");
        }
        this.btInfo = new BatteryTestLogInfo(dir.getAbsolutePath());
        if (this.howToCreateSummary == 2) {
            this.summInfo = new SummaryInfo(this.btDir + File.separator + this.getAutoGeneratedSummFileName());
        } else if (this.howToCreateSummary == 1) {
            this.summInfo = new SummaryInfo();
        } else {
            throw new Exception("Unknown howToCreateSummary " + this.howToCreateSummary);
        }
        this.doSummary(dir);
        if (this.logDir == null) {
            System.out.println(this.summInfo);
        } else {
            this.logStringToFile(this.logDir, this.summInfo.toString());
        }
    }

    private void logStringToFile(String logDirStr, String aStr) throws FileNotFoundException {
        File logDir = new File(logDirStr);
        if (!logDir.exists()) {
            System.out.println("logDir " + logDirStr + " does not exist");
            return;
        }
        String fileName = this.getAutoGeneratedSummFileName();
        StringBuffer tmp = new StringBuffer(fileName);
        for (int i = 0; i < tmp.length(); ++i) {
            if (tmp.charAt(i) != ' ') continue;
            tmp.setCharAt(i, '-');
        }
        fileName = tmp.toString();
        PrintWriter aFile = new PrintWriter(new FileOutputStream(new File(fileName)));
        aFile.print(aStr);
        aFile.flush();
        aFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMemoryUsage(String dirPath) {
        File perfReportfile = RegressionSummary.getFileInDir(dirPath, "perfreport.txt");
        if (perfReportfile == null) {
            return "Unable to get memory usage for this test; perfreport.txt does not exist";
        }
        try (FileLineReader flr = null;){
            flr = new FileLineReader(perfReportfile);
            String line = flr.readNextLine();
            StringBuffer vmStats = new StringBuffer();
            while (line != null) {
                boolean isVMStat;
                boolean isRssStat = line.indexOf("rssSize") >= 0;
                boolean bl = isVMStat = line.indexOf("VMStats") >= 0;
                if (isRssStat || isVMStat) {
                    StringBuffer statsStr = new StringBuffer();
                    do {
                        if (line.indexOf("--------") >= 0) continue;
                        statsStr.append(line.trim() + " ");
                    } while ((line = flr.readNextLine()) != null && line.indexOf("=====") < 0);
                    if (isRssStat && statsStr.indexOf("min=") >= 0) {
                        String string = statsStr.toString();
                        return string;
                    }
                    if (isVMStat) {
                        vmStats.append(statsStr.toString());
                    }
                }
                line = flr.readNextLine();
            }
            if (vmStats.indexOf("min=") >= 0) {
                String string = vmStats.toString();
                return string;
            }
            String string = "Unable to get memory usage for this test; unable to find *ProcessStats or VMStats";
            return string;
        }
    }

    private String getDiskUsage(String dirPath) throws FileNotFoundException, InterruptedException, IOException {
        String[] components;
        if (HostHelper.isWindows()) {
            return "unknown";
        }
        File aDir = new File(dirPath);
        if (!aDir.exists()) {
            return "unknown";
        }
        String dirName = this.getDirName(dirPath);
        String cmd = "du -sh " + dirPath;
        String result = this.execute(cmd, 10000);
        if (result.indexOf(dirName) > 0 && (components = result.trim().split("\\s+")).length >= 1) {
            return components[0];
        }
        return "unknown";
    }

    public static File getFileInDir(String dirPath, String fileName) {
        File aDir = new File(dirPath);
        if (!aDir.exists()) {
            return null;
        }
        File[] fileList = aDir.listFiles();
        boolean found = false;
        for (int i = 0; i < fileList.length; ++i) {
            File aFile = fileList[i];
            String name = aFile.getName();
            if (!name.matches(fileName)) continue;
            return aFile;
        }
        return null;
    }

    private String getDirName(String fullPath) {
        int index1 = fullPath.lastIndexOf("/");
        int index2 = fullPath.lastIndexOf("\\");
        int index = Math.max(index1, index2);
        String dirName = fullPath.substring(index + 1, fullPath.length());
        return dirName;
    }

    private boolean isBtDir(File aDir) {
        if (aDir == null) {
            return false;
        }
        if (!aDir.exists()) {
            return false;
        }
        if (!aDir.isDirectory()) {
            return false;
        }
        File[] fileList = aDir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].getName().equals("oneliner.txt")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTestFailure(String dirPath) {
        int MAX_ERROR_LENGTH = 1000;
        File aDir = new File(dirPath);
        if (!aDir.exists()) {
            return "unable to locate results directory " + dirPath;
        }
        File[] fileList = aDir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File aFile = fileList[i];
            String name = aFile.getName();
            if (!name.equals("errors.txt")) continue;
            File errorsTxtFile = aFile;
            try (FileLineReader flr = null;){
                flr = new FileLineReader(errorsTxtFile);
                String line = flr.readNextLine();
                while (line != null) {
                    if (line.indexOf("HANG") == 0) {
                        String string = line.substring(0, Math.min(line.length(), 1000));
                        return string;
                    }
                    if (line.indexOf("ERROR") == 0) {
                        String string = line.substring(0, Math.min(line.length(), 1000));
                        return string;
                    }
                    if (line.indexOf("-----------------") == 0) {
                        String string = "Unable to determine test failure";
                        return string;
                    }
                    line = flr.readNextLine();
                }
                continue;
            }
        }
        return "Unable to find test failure";
    }

    protected String execute(String cmd, int waitMillis) throws InterruptedException, IOException {
        long startTime = System.currentTimeMillis();
        final Process aProcess = Runtime.getRuntime().exec(cmd);
        Thread waitForProcessThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    aProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        waitForProcessThread.start();
        waitForProcessThread.join(waitMillis);
        if (waitForProcessThread.isAlive()) {
            aProcess.destroy();
            waitForProcessThread.join();
            return "";
        }
        String aStr = RegressionSummary.getOutputFrom(aProcess);
        return aStr;
    }

    private static String getOutputFrom(Process aProcess) throws InterruptedException, IOException {
        String line;
        BufferedReader bfOut = null;
        BufferedReader bfErr = null;
        InputStream in = aProcess.getInputStream();
        bfOut = new BufferedReader(new InputStreamReader(in));
        InputStream err = aProcess.getErrorStream();
        bfErr = new BufferedReader(new InputStreamReader(err));
        aProcess.waitFor();
        StringBuffer resultBuff = new StringBuffer();
        while ((line = bfOut.readLine()) != null) {
            resultBuff.append(line);
            resultBuff.append("\n");
        }
        while ((line = bfErr.readLine()) != null) {
            resultBuff.append(line);
            resultBuff.append("\n");
        }
        return resultBuff.toString();
    }

    protected String getAutoGeneratedSummFileName() {
        String fileName = null;
        fileName = this.btInfo.getRegressionSuiteName() == null ? "summ-B" + this.btInfo.getBuildNumber() + "-" + this.btInfo.getHostName() + "-" + this.btInfo.getRegressionSuiteDate() + ".txt" : "summ-B" + this.btInfo.getBuildNumber() + "-" + this.btInfo.getRegressionSuiteName() + "-" + this.btInfo.getHostName() + "-" + this.btInfo.getRegressionSuiteDate() + ".txt";
        StringBuffer tmp = new StringBuffer(fileName);
        for (int i = 0; i < tmp.length(); ++i) {
            if (tmp.charAt(i) != ' ') continue;
            tmp.setCharAt(i, '-');
        }
        fileName = tmp.toString();
        return fileName;
    }

    public static void main(String[] args) throws Exception {
        String btDir;
        if (args.length != 0) {
            System.out.println("Usage: java RegressionSummary\n       -DbtDir=<dir path>\n          Directory that contains at a minimum oneliner.txt.\n          In addition, this can generate a better summary if this\n          directory also contains a batterytest.log file and test\n          result directories. If not specified, use the current directory.\n       -DlogDir=<dir path>\n          Log the summary to this directory to an automatically generated\n          filename. If not specified, then log the summary to stdout\n       -DhowToCreateSummary=<createNew|continueFromExisting>\n          If createNew (the default if not specified), then create a new\n          summary file. If continueFromExisting, any existing summary\n          file in logDir will be modified in order to update it if it\n          is not complete.\n");
            System.exit(0);
        }
        if ((btDir = System.getProperty("btDir")) == null) {
            btDir = System.getProperty("user.dir");
        }
        String logDir = System.getProperty("logDir");
        String how = System.getProperty("howToCreateSummary");
        RegressionSummary regrSumm = null;
        regrSumm = how == null || how.equalsIgnoreCase("createNew") ? new RegressionSummary(1, btDir, logDir) : new RegressionSummary(2, btDir, logDir);
        regrSumm.doSummary();
    }
}

