/*
 * Decompiled with CFR 0.152.
 */
package resultsUtil;

import java.io.File;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import resultsUtil.FileLineReader;

public class BatteryTestLogInfo {
    private Date firstDate = null;
    private Date lastDate = null;
    private String buildNumber = null;
    private String hostName = null;
    private String regressionSuiteDate = null;
    private String regressionSuiteName = null;
    private String productVersion = null;

    public BatteryTestLogInfo(String batteryTestLogDir) {
        File btLogFile = this.getBatteryTestLogFile(batteryTestLogDir);
        if (btLogFile != null) {
            this.initFromFile(btLogFile);
        }
    }

    private File getBatteryTestLogFile(String batteryTestLogDirName) {
        File batteryTestLogDir = new File(batteryTestLogDirName);
        if (!batteryTestLogDir.exists()) {
            System.out.println(batteryTestLogDir + " does not exist; expected directory containing batterytest.log");
            return null;
        }
        File[] fileList = batteryTestLogDir.listFiles();
        boolean found = false;
        for (int i = 0; i < fileList.length; ++i) {
            File aFile = fileList[i];
            String name = aFile.getName();
            if (!name.equals("batterytest.log")) continue;
            return aFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFromFile(File btLogFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd kk:mm:ss.SSS");
        try (FileLineReader flr = null;){
            flr = new FileLineReader(btLogFile);
            String firstDateLine = null;
            String lastDateLine = null;
            String hostKey = "Host name: ";
            String regressionNameKey = "testFileName = ";
            String regressionDateKey = "resultDir = ";
            String productVersionKey = "Product Version:";
            String buildNumberKey = "Build Id: ";
            String line = flr.readNextLine();
            String dateRegex = ".*(\\d\\d\\d\\d)/(\\d\\d)/(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d).(\\d\\d\\d).*";
            while (line != null) {
                int index;
                int index2;
                if (line.matches(dateRegex)) {
                    if (firstDateLine == null) {
                        firstDateLine = line;
                    }
                    lastDateLine = line;
                }
                if (this.buildNumber == null) {
                    String snapshotsStr = "snapshots.";
                    index2 = line.indexOf("snapshots.");
                    if (index2 >= 0) {
                        this.buildNumber = line.substring(index2 + "snapshots.".length(), line.indexOf(File.separator, index2));
                    }
                }
                if (this.hostName == null && (index = line.indexOf("Host name: ")) >= 0) {
                    this.hostName = line.substring(index + "Host name: ".length(), line.length());
                }
                if (this.regressionSuiteName == null) {
                    String alteredLine = line.replaceAll("\\\\", "/");
                    index2 = line.indexOf("testFileName = ");
                    if (index2 >= 0) {
                        String searchStr = "tests/classes/";
                        index2 = alteredLine.indexOf(searchStr);
                        if (index2 < 0) {
                            searchStr = "tests/";
                            index2 = alteredLine.indexOf(searchStr);
                        }
                        if (index2 >= 0) {
                            String subStr = alteredLine.substring(index2 + searchStr.length(), alteredLine.length());
                            String[] tokens = subStr.split("[/\\\\]");
                            this.regressionSuiteName = "";
                            for (int i = 0; i < tokens.length; ++i) {
                                this.regressionSuiteName = this.regressionSuiteName + tokens[i];
                                if (i >= tokens.length - 1) continue;
                                this.regressionSuiteName = this.regressionSuiteName + ".";
                            }
                        }
                    }
                }
                if (this.regressionSuiteDate == null && (index = line.indexOf("resultDir = ")) >= 0) {
                    String[] tokens = line.split("[/\\\\]");
                    this.regressionSuiteDate = tokens[tokens.length - 1];
                }
                if (this.productVersion == null && (index = line.indexOf("Product Version:")) >= 0) {
                    this.productVersion = line.substring(index + "Product Version:".length(), line.length()).trim();
                }
                if (this.buildNumber == null && (index = line.indexOf("Build Id: ")) >= 0) {
                    String[] tokens = line.split("[\\s]+");
                    this.buildNumber = tokens[tokens.length - 2] + "-" + tokens[tokens.length - 1];
                }
                line = flr.readNextLine();
            }
            if (firstDateLine != null) {
                int index = firstDateLine.indexOf(" ") + 1;
                this.firstDate = dateFormat.parse(firstDateLine, new ParsePosition(index));
            }
            if (lastDateLine != null) {
                int index = lastDateLine.indexOf(" ") + 1;
                this.lastDate = dateFormat.parse(lastDateLine, new ParsePosition(lastDateLine.indexOf("20")));
            }
        }
    }

    public String toString() {
        return "BatteryTestInfo with firstDate " + this.firstDate + "\n                     lastDate " + this.lastDate + "\n                     hostName " + this.hostName + "\n                     buildNumber " + this.buildNumber + "\n                     regressionSuiteName " + this.regressionSuiteName + "\n                     regressionSuiteDate " + this.regressionSuiteDate + "\n                     productVersion " + this.productVersion;
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRegressionSuiteName() {
        return this.regressionSuiteName;
    }

    public String getRegressionSuiteDate() {
        return this.regressionSuiteDate;
    }

    public String getProductVersion() {
        return this.productVersion;
    }
}

