/*
 * Decompiled with CFR 0.152.
 */
package recovDelay;

import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import recovDelay.BucketInfo;
import util.TestException;

public class PrState
implements Serializable {
    protected Integer vmId = null;
    protected List bucketInfoList = null;

    public static Map getPrMap(Region aRegion) {
        List<List<BucketInfo>> bucketList = BucketInfo.getAllBuckets(aRegion);
        return PrState.getPrMap(bucketList);
    }

    public static Map getPrMap(List masterBucketList) {
        TreeMap<Integer, PrState> prStateMap = new TreeMap<Integer, PrState>();
        for (int bucketId = 0; bucketId < masterBucketList.size(); ++bucketId) {
            List bucketCopiesList = (List)masterBucketList.get(bucketId);
            if (bucketCopiesList == null) continue;
            for (int i = 0; i < bucketCopiesList.size(); ++i) {
                BucketInfo info = (BucketInfo)bucketCopiesList.get(i);
                int vmId = info.getVmId();
                PrState state = (PrState)prStateMap.get(new Integer(vmId));
                if (state == null) {
                    state = new PrState();
                    state.setVmId(vmId);
                    state.setBucketInfoList(new ArrayList());
                    prStateMap.put(new Integer(vmId), state);
                }
                state.getBucketInfoList().add(info);
            }
        }
        return prStateMap;
    }

    public static String comparePrState(Map expectedMap, Map actualMap, boolean allowDifferentPrimaries) {
        StringBuffer returnStr;
        block6: {
            block5: {
                Iterator it;
                Log.getLogWriter().info("Comparing expected pr state map containing vmIds " + expectedMap.keySet() + " with actual pr state map containing vmIds " + actualMap.keySet());
                returnStr = new StringBuffer();
                if (expectedMap.keySet().equals(actualMap.keySet())) break block5;
                Set missingMembers = expectedMap.keySet();
                missingMembers.removeAll(actualMap.keySet());
                Set extraMembers = actualMap.keySet();
                extraMembers.removeAll(expectedMap.keySet());
                if (missingMembers.size() > 0) {
                    it = missingMembers.iterator();
                    while (it.hasNext()) {
                        returnStr.append("Expected the PR state to contain member with vmId " + it.next() + ", but it is missing.\n");
                    }
                }
                if (extraMembers.size() <= 0) break block6;
                it = extraMembers.iterator();
                while (it.hasNext()) {
                    returnStr.append("The existing PR state contains member with vmId " + it.next() + ", but it was unexpected.\n");
                }
                break block6;
            }
            for (Object vmIdKey : expectedMap.keySet()) {
                PrState expectedPrState = (PrState)expectedMap.get(vmIdKey);
                PrState actualPrState = (PrState)actualMap.get(vmIdKey);
                if (!expectedPrState.vmId.equals(actualPrState.vmId)) {
                    throw new TestException("Test error, vmId in " + expectedPrState + " and " + actualPrState + " are located in the pr state map with key " + vmIdKey);
                }
                int vmId = expectedPrState.vmId;
                returnStr.append(BucketInfo.compareBucketLists(vmId, expectedPrState.bucketInfoList, actualPrState.bucketInfoList, allowDifferentPrimaries));
            }
        }
        return returnStr.toString();
    }

    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (!(anObj instanceof PrState)) {
            return false;
        }
        PrState arg = (PrState)anObj;
        if (this.vmId != arg.vmId) {
            return false;
        }
        if (this.bucketInfoList.size() != arg.bucketInfoList.size()) {
            return false;
        }
        for (int i = 0; i < this.bucketInfoList.size(); ++i) {
            BucketInfo argInfo;
            BucketInfo info = (BucketInfo)this.bucketInfoList.get(i);
            if (info.equals(argInfo = (BucketInfo)arg.bucketInfoList.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Member with vmId " + this.vmId + " contains " + this.bucketInfoList.size() + " buckets, ");
        if (this.bucketInfoList == null || this.bucketInfoList.size() == 0) {
            aStr.append("   no buckets are hosted on this member");
        } else {
            aStr.append(BucketInfo.bucketListToString(this.bucketInfoList));
        }
        return aStr.toString();
    }

    public static String prMapToString(Map prMap) {
        StringBuffer aStr = new StringBuffer();
        Iterator it = prMap.keySet().iterator();
        while (it.hasNext()) {
            PrState state = (PrState)prMap.get(it.next());
            aStr.append(state + "\n");
        }
        return aStr.toString();
    }

    public static String getPrPicture(Region aRegion) {
        return aRegion.getFullPath() + "\n" + PrState.prMapToString(PrState.getPrMap(aRegion));
    }

    public static String getPrPicture(Region aRegion, int bucketId) {
        StringBuffer aStr = new StringBuffer();
        aStr.append(aRegion.getFullPath() + "\n");
        Map aMap = PrState.getPrMap(aRegion);
        for (Integer vmID : aMap.keySet()) {
            PrState state = (PrState)aMap.get(vmID);
            aStr.append("Member with vmId " + vmID + " contains " + state.bucketInfoList.size() + " buckets\n");
            List infoList = state.bucketInfoList;
            for (BucketInfo info : infoList) {
                if (info.bucketId != bucketId) continue;
                aStr.append("   " + info + "\n");
            }
        }
        return aStr.toString();
    }

    public int getVmId() {
        return this.vmId;
    }

    public void setVmId(int vmIdArg) {
        this.vmId = vmIdArg;
    }

    public List getBucketInfoList() {
        return this.bucketInfoList;
    }

    public void setBucketInfoList(List listArg) {
        this.bucketInfoList = listArg;
    }
}

