/*
 * Decompiled with CFR 0.152.
 */
package recovDelay;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import hydra.Log;
import hydra.RemoteTestModule;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import util.BaseValueHolder;
import util.TestException;
import util.TestHelper;

public class BucketInfo
implements Serializable {
    private static final long serialVersionUID = 62846770744058408L;
    protected int bucketId = -1;
    protected InternalDistributedMember member = null;
    protected int vmId = -1;
    protected boolean isPrimary = false;
    protected Map<Object, Object> entriesMap = null;
    protected Map<Object, VersionTag> versions = null;

    public BucketInfo(int bucketIdArg, InternalDistributedMember memberArg, int vmIdArg, boolean isPrimaryArg, Map entriesMapArg, Map<Object, VersionTag> versions) {
        this.bucketId = bucketIdArg;
        this.member = memberArg;
        this.vmId = vmIdArg;
        this.isPrimary = isPrimaryArg;
        this.entriesMap = entriesMapArg;
        this.versions = versions;
    }

    public static List<List<BucketInfo>> getAllBuckets(Region prReg) {
        Vector<ArrayList<BucketInfo>> bucketVec = new Vector<ArrayList<BucketInfo>>();
        try {
            PartitionedRegion pr = (PartitionedRegion)prReg;
            int totalBuckets = pr.getTotalNumberOfBuckets();
            for (int bucketId = 0; bucketId < totalBuckets; ++bucketId) {
                List aList = pr.getBucketOwnersForValidation(bucketId);
                if (aList.size() == 0) {
                    bucketVec.setSize(Math.max(bucketId + 1, bucketVec.size()));
                    bucketVec.setElementAt(null, bucketId);
                    continue;
                }
                List listOfMaps = pr.getAllBucketEntries(bucketId);
                BucketInfo.removePayload(listOfMaps);
                for (int j = 0; j < aList.size(); ++j) {
                    Object[] tmpArr = (Object[])aList.get(j);
                    InternalDistributedMember member = (InternalDistributedMember)tmpArr[0];
                    Boolean isPrimary = (Boolean)tmpArr[1];
                    String host = member.getHost();
                    int pid = member.getVmPid();
                    Integer vmId = null;
                    try {
                        vmId = new Integer(RemoteTestModule.Master.getVmid(host, pid));
                    }
                    catch (RemoteException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    BucketDump entriesMap = null;
                    for (int k = 0; k < listOfMaps.size() && !(entriesMap = (BucketDump)listOfMaps.get(k)).getMember().equals(member); ++k) {
                    }
                    if (entriesMap == null) {
                        throw new TestException("Could not find entriesMap for bucketId " + bucketId);
                    }
                    HashMap valuesMap = new HashMap(entriesMap.getValues());
                    BucketInfo info = new BucketInfo(bucketId, member, vmId, isPrimary, valuesMap, entriesMap.getVersions());
                    bucketVec.setSize(Math.max(bucketId + 1, bucketVec.size()));
                    ArrayList<BucketInfo> bucketCopyList = (ArrayList<BucketInfo>)bucketVec.get(bucketId);
                    if (bucketCopyList == null) {
                        bucketCopyList = new ArrayList<BucketInfo>();
                        bucketVec.setElementAt(bucketCopyList, bucketId);
                    }
                    bucketCopyList.add(info);
                }
            }
        }
        catch (ReplyException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ForceReattemptException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new ArrayList<List<BucketInfo>>(bucketVec);
    }

    public String toString() {
        return "BucketId " + this.bucketId + "; isPrimary " + this.isPrimary + "; vmId " + this.vmId + "; member " + this.member + "; numKeys " + this.entriesMap.size();
    }

    protected String getKeysStr(Map entriesMap) {
        Iterator it = entriesMap.keySet().iterator();
        int count = 0;
        StringBuffer aStr = new StringBuffer();
        while (it.hasNext()) {
            aStr.append(it.next() + " ");
            if (++count % 10 != 0) continue;
            aStr.append("\n");
        }
        return aStr.toString();
    }

    public static String compareBucketLists(int vmId, List expectedList, List actualList, boolean allowDifferentPrimaries) {
        StringBuffer returnStr;
        block8: {
            HashMap<Integer, BucketInfo> actualBucketMap;
            HashMap<Integer, BucketInfo> expectedBucketMap;
            block7: {
                Iterator it;
                expectedBucketMap = new HashMap<Integer, BucketInfo>();
                for (int i = 0; i < expectedList.size(); ++i) {
                    BucketInfo info = (BucketInfo)expectedList.get(i);
                    expectedBucketMap.put(new Integer(info.getBucketId()), info);
                }
                actualBucketMap = new HashMap<Integer, BucketInfo>();
                for (int i = 0; i < actualList.size(); ++i) {
                    BucketInfo info = (BucketInfo)actualList.get(i);
                    actualBucketMap.put(new Integer(info.getBucketId()), info);
                }
                TreeSet expectedBucketIdSet = new TreeSet(expectedBucketMap.keySet());
                TreeSet actualBucketIdSet = new TreeSet(actualBucketMap.keySet());
                Log.getLogWriter().info("Expected bucketIds for vmId " + vmId + ": " + expectedBucketIdSet);
                Log.getLogWriter().info("Actual bucketIds for vmId " + vmId + ": " + actualBucketIdSet);
                if (expectedList.size() != expectedBucketIdSet.size()) {
                    throw new TestException("Test error, bucketInfoList " + expectedList + " contains duplicate bucket ids");
                }
                HashSet missingBucketIds = new HashSet(expectedBucketIdSet);
                missingBucketIds.removeAll(actualBucketIdSet);
                HashSet extraBucketIds = new HashSet(actualBucketIdSet);
                extraBucketIds.removeAll(expectedBucketIdSet);
                returnStr = new StringBuffer();
                if (missingBucketIds.size() <= 0 && extraBucketIds.size() <= 0) break block7;
                if (missingBucketIds.size() > 0) {
                    it = missingBucketIds.iterator();
                    while (it.hasNext()) {
                        returnStr.append("Expected member with vm id " + vmId + " to contain bucket with id " + it.next() + ", but it is missing.\n");
                    }
                }
                if (extraBucketIds.size() <= 0) break block8;
                it = extraBucketIds.iterator();
                while (it.hasNext()) {
                    returnStr.append("The member with vm id " + vmId + " contains bucket with id " + it.next() + ", but it is unexpected in this member.\n");
                }
                break block8;
            }
            for (Object bucketIdKey : expectedBucketMap.keySet()) {
                BucketInfo expectedInfo = (BucketInfo)expectedBucketMap.get(bucketIdKey);
                BucketInfo actualInfo = (BucketInfo)actualBucketMap.get(bucketIdKey);
                returnStr.append(expectedInfo.compare(actualInfo, allowDifferentPrimaries));
            }
        }
        return returnStr.toString();
    }

    public String compare(BucketInfo info, boolean allowDifferentPrimaries) {
        StringBuffer returnStr = new StringBuffer();
        if (this.bucketId != info.bucketId) {
            returnStr.append("Bucket id in <" + this + " is not equal to bucket id in " + info + ">\n");
        }
        if (!this.member.toString().equals(info.member.toString())) {
            returnStr.append("Member in <" + this + " is not equal to member in " + info + ">\n");
        }
        if (this.vmId != info.vmId) {
            returnStr.append("vmId in <" + this + " is not equal to vmId in " + info + ">\n");
        }
        if (!allowDifferentPrimaries && this.isPrimary != info.isPrimary) {
            returnStr.append("isPrimary in <" + this + "> is not equal to isPrimary in <" + info + ">\n");
        }
        if (this.entriesMap.size() != info.entriesMap.size()) {
            returnStr.append("entriesMap in <" + this + " is a different size than entriesMap in " + info + ">\n");
        }
        return returnStr.toString();
    }

    public static String masterBucketListToString(List bucketList) {
        StringBuffer aStr = new StringBuffer();
        for (int bucketId = 0; bucketId < bucketList.size(); ++bucketId) {
            List aList = (List)bucketList.get(bucketId);
            if (aList == null || aList.size() == 0) {
                aStr.append("No buckets exist for bucket id " + bucketId + "\n");
                continue;
            }
            aStr.append(BucketInfo.bucketListToString(aList));
        }
        return aStr.toString();
    }

    public static String bucketListToString(List bucketList) {
        StringBuffer aStr = new StringBuffer();
        int insertPoint = aStr.length();
        int primaryCount = 0;
        for (int i = 0; i < bucketList.size(); ++i) {
            BucketInfo info = (BucketInfo)bucketList.get(i);
            aStr.append(info.toString() + "\n");
            if (!info.isPrimary) continue;
            ++primaryCount;
        }
        aStr.insert(insertPoint, "Primary count: " + primaryCount + "\n");
        return aStr.toString();
    }

    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (!(anObj instanceof BucketInfo)) {
            return false;
        }
        BucketInfo arg = (BucketInfo)anObj;
        if (this.bucketId != arg.bucketId) {
            return false;
        }
        if (this.vmId != arg.vmId) {
            return false;
        }
        if (this.isPrimary != arg.isPrimary) {
            return false;
        }
        if (!this.member.toString().equals(arg.member)) {
            return false;
        }
        return this.entriesMap.equals(arg.entriesMap);
    }

    protected static void removePayload(List<BucketDump> listOfMaps) {
        for (int i = 0; i < listOfMaps.size(); ++i) {
            Map aMap = listOfMaps.get(i).getValues();
            for (Object value : aMap.values()) {
                if (!(value instanceof BaseValueHolder)) continue;
                ((BaseValueHolder)value).extraObject = null;
            }
        }
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public InternalDistributedMember getMember() {
        return this.member;
    }

    public int getVmId() {
        return this.vmId;
    }

    public boolean getIsPrimary() {
        return this.isPrimary;
    }

    public Map getEntriesMap() {
        return this.entriesMap;
    }
}

