/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import rebalance.RebalanceBB;
import rebalance.RebalanceUtil;

public class RecoveryStopStart {
    public static String DataStoreVmStr = "DataStoreVM_";

    public static void HydraTask_stopStartDataStoreVm() {
        List vmList = RecoveryStopStart.getDataStoreVms();
        ArrayList stopModes = new ArrayList();
        int randInt = TestConfig.tab().getRandGen().nextInt(0, vmList.size() - 1);
        ClientVmInfo targetVm = (ClientVmInfo)vmList.get(randInt);
        String stopModeStr = TestConfig.tab().stringAt(ParRegPrms.stopModes);
        SharedCounters counters = RebalanceBB.getBB().getSharedCounters();
        Log.getLogWriter().info("clearing recoveryRegionCount prior to stop of " + targetVm);
        counters.zero(RebalanceBB.recoveryRegionCount);
        Log.getLogWriter().info("cleared recoveryRegionCount prior to stop of " + targetVm);
        try {
            ClientVmMgr.stop("Test is synchronously stopping " + targetVm + " with " + stopModeStr, ClientVmMgr.toStopMode(stopModeStr), -31, targetVm);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Caught Exception " + e + " while stopping DataStoreVm " + targetVm);
        }
        RebalanceUtil.waitForRecovery();
        Log.getLogWriter().info("clearing recoveryRegionCount after stop and before start of " + targetVm);
        counters.zero(RebalanceBB.recoveryRegionCount);
        Log.getLogWriter().info("cleared recoveryRegionCount after stop of and before start of " + targetVm);
        try {
            ClientVmMgr.start("Test is synchronously starting " + targetVm, targetVm);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Caught Exception " + e + " while starting DataStoreVm " + targetVm);
        }
        Log.getLogWriter().info("Done in RecoveryStopStart.stopStartDataStoreVm()");
    }

    protected static List getDataStoreVms() {
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        Map aMap = ParRegBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(DataStoreVmStr)) continue;
            aList.add(new ClientVmInfo((Integer)aMap.get(key), null, null));
        }
        return aList;
    }
}

