/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import hydra.Log;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.ExpCounterValue;
import util.TestException;

public class RebalanceEventCountersBB
extends Blackboard {
    static String BB_NAME = "PartitionRebalanceEventCounters_Blackboard";
    static String BB_TYPE = "RMI";
    private static RebalanceEventCountersBB bbInstance = new RebalanceEventCountersBB(BB_NAME, BB_TYPE);
    public static int STARTING;
    public static int STARTED;
    public static int CANCELLED;
    public static int FINISHED;
    public static int BUCKET_CREATES;
    public static int BUCKET_DESTROYS;
    public static int BUCKET_TRANSFERS;
    public static int PRIMARY_TRANSFERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RebalanceEventCountersBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<RebalanceEventCountersBB> clazz = RebalanceEventCountersBB.class;
        synchronized (RebalanceEventCountersBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new RebalanceEventCountersBB(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public RebalanceEventCountersBB() {
    }

    public RebalanceEventCountersBB(String name, String type) {
        super(name, type, RebalanceEventCountersBB.class);
    }

    public static void checkEventCounters(ArrayList aList) {
        StringBuffer aStr = new StringBuffer();
        RebalanceEventCountersBB bb = RebalanceEventCountersBB.getBB();
        SharedCounters sc = bb.getSharedCounters();
        bb.printSharedCounters();
        for (int i = 0; i < aList.size(); ++i) {
            ExpCounterValue expCtrVal = (ExpCounterValue)aList.get(i);
            int counterIndex = expCtrVal.getCounterIndex();
            long expectedValue = expCtrVal.getExpectedValue();
            long actualValue = sc.read(counterIndex);
            String counterName = RebalanceEventCountersBB.getNameForIndex(counterIndex);
            Log.getLogWriter().info("Checking " + counterName + ": expecting " + expectedValue + ", found " + actualValue);
            if (actualValue == expectedValue) continue;
            aStr.append("Expected " + expectedValue + " " + counterName + " events, but found " + actualValue + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("All Counter Values are correct");
    }

    private static String getNameForIndex(int index) {
        RebalanceEventCountersBB bb = RebalanceEventCountersBB.getBB();
        String[] counterNames = bb.getCounterNames();
        if (index >= counterNames.length) {
            throw new TestException("Counter index " + index + " is outside of bounds for RebalanceEventCountersBB of size " + counterNames.length);
        }
        return counterNames[index];
    }

    public static void zeroAllCounters() {
        SharedCounters sc = RebalanceEventCountersBB.getBB().getSharedCounters();
        sc.zero(STARTING);
        sc.zero(STARTED);
        sc.zero(CANCELLED);
        sc.zero(FINISHED);
        sc.zero(BUCKET_CREATES);
        sc.zero(BUCKET_DESTROYS);
        sc.zero(BUCKET_TRANSFERS);
        sc.zero(PRIMARY_TRANSFERS);
        Log.getLogWriter().info("Cleared RebalanceEventCounters");
    }
}

