/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.FunctionExecutionPeer1;
import quickstart.FunctionExecutionPeer2;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class FunctionExecutionTest
extends QuickstartTestCase {
    protected ProcessWrapper regionVM1;
    protected ProcessWrapper regionVM2;

    public FunctionExecutionTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.regionVM1 != null) {
            this.regionVM1.destroy();
        }
        if (this.regionVM2 != null) {
            this.regionVM2.destroy();
        }
    }

    public void testFunctionExecution() throws Exception {
        FunctionExecutionTest.getLogWriter().info("[testFunctionExecution] start PartitionRegion on Peer1");
        this.regionVM1 = new ProcessWrapper(FunctionExecutionPeer1.class);
        this.regionVM1.execute(this.createProperties());
        this.regionVM1.waitForOutputToMatch("^Please start Other Peer And Then Press Enter to continue\\.$");
        this.regionVM2 = new ProcessWrapper(FunctionExecutionPeer2.class);
        this.regionVM2.execute(this.createProperties());
        this.regionVM2.waitForOutputToMatch("^Press Enter to continue\\.$");
        this.regionVM2.sendInput();
        this.regionVM2.waitForOutputToMatch("^Press Enter to continue\\.$");
        this.regionVM2.sendInput();
        this.regionVM2.waitForOutputToMatch("^Press Enter to continue\\.$");
        this.regionVM2.sendInput();
        this.regionVM2.waitForOutputToMatch("^Closing the cache and disconnecting\\.$");
        this.regionVM1.sendInput();
        this.regionVM1.waitForOutputToMatch("^Closing the cache and disconnecting\\.$");
        this.regionVM1.waitFor();
        this.regionVM2.waitFor();
        this.printProcessOutput(this.regionVM1, "PEER1");
        this.printProcessOutput(this.regionVM2, "PEER2");
        this.assertOutputMatchesGoldenFile(this.regionVM1.getOutput(), "FunctionExecutionPeer1.txt");
        this.assertOutputMatchesGoldenFile(this.regionVM2.getOutput(), "FunctionExecutionPeer2.txt");
    }
}

