/*
 * Decompiled with CFR 0.152.
 */
package query.remote;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.SelectResults;
import hydra.Log;
import hydra.RegionHelper;
import query.remote.QueryResultsValidator;
import query.remote.RemoteQueryTest;
import util.TestException;

public class EvictionQueryResultsValidator
implements QueryResultsValidator {
    @Override
    public boolean validateQueryResults(Object resultSet, int queryIndex, String queryString) {
        boolean validated;
        block7: {
            block6: {
                Log.getLogWriter().info("Executed query : " + queryString);
                Region reg = RegionHelper.getRegion(RemoteQueryTest.edgeRegionName);
                int lruMemorySize = reg.getAttributes().getEvictionAttributes().getMaximum();
                validated = false;
                if (!(resultSet instanceof SelectResults)) break block6;
                int resultSetSize = ((SelectResults)resultSet).size();
                switch (queryIndex) {
                    case 0: {
                        if (resultSetSize == lruMemorySize) {
                            validated = true;
                            break;
                        }
                        break block7;
                    }
                    case 1: 
                    case 2: {
                        if (resultSetSize == lruMemorySize / 2) {
                            validated = true;
                            break;
                        }
                        break block7;
                    }
                    default: {
                        throw new TestException("Not valid Query");
                    }
                }
                break block7;
            }
            Log.getLogWriter().info("Result set not instanceof SelectResults");
        }
        return validated;
    }
}

