/*
 * Decompiled with CFR 0.152.
 */
package query.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Country;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.Log;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import util.TestException;

public class IndexWithRegionOperationsTest {
    static IndexWithRegionOperationsTest indexTest = new IndexWithRegionOperationsTest();
    static final int REGION_OPERATIONS = 30;
    static final int INDEX_OPERATIONS = 4;
    static volatile int counter1 = 0;
    static volatile int counter2 = 0;
    static DistributedSystem ds = null;
    static Properties props = new Properties();
    static Cache cache;
    static Region nonMirroredRegion;
    static Region mirroredRegion;
    static Region globalRegion;
    static Region pbtRegion;
    static int PUT;
    static int GET;
    static int UPDATE;
    static int DESTROY;
    static int INVALIDATE;
    static int REMOVE;
    static String[] queries;
    static final int QUERY_EXECUTED = 2;
    static volatile int queryCntr;
    static Object queryCntrLock;

    public static synchronized void HydraTask_initialize() {
        if (indexTest == null) {
            indexTest = new IndexWithRegionOperationsTest();
        }
        indexTest.initialize();
    }

    protected void initialize() {
        if (nonMirroredRegion == null) {
            this.createNonMirroredRegion();
        }
        if (mirroredRegion == null) {
            this.createMirroredRegion();
        }
        if (globalRegion == null) {
            this.createGlobalRegion();
        }
        if (pbtRegion == null) {
            this.createPersistBackUpRegion();
        }
    }

    public static void createCache() {
        try {
            ds = DistributedSystem.connect((Properties)props);
            cache = CacheFactory.create((DistributedSystem)ds);
        }
        catch (Exception e) {
            Log.getLogWriter().info("Got expected Exception: caught while creating cache");
            e.printStackTrace();
        }
    }

    public void createNonMirroredRegion() {
        try {
            if (cache == null || cache.isClosed()) {
                IndexWithRegionOperationsTest.createCache();
            }
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setIndexMaintenanceSynchronous(true);
            factory.setValueConstraint(Country.class);
            nonMirroredRegion = cache.createVMRegion("CountriesNM", factory.createRegionAttributes());
            Log.getLogWriter().info("non mirrored region created");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Got expected Exception: caught while creating non-mirrored region");
            e.printStackTrace();
        }
    }

    public void createMirroredRegion() {
        try {
            if (cache == null || cache.isClosed()) {
                IndexWithRegionOperationsTest.createCache();
            }
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setMirrorType(MirrorType.KEYS_VALUES);
            factory.setIndexMaintenanceSynchronous(true);
            factory.setValueConstraint(Country.class);
            mirroredRegion = cache.createVMRegion("CountriesM", factory.createRegionAttributes());
            Log.getLogWriter().info("mirrored region created");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Got expected Exception: caught while creating mirrored region");
            e.printStackTrace();
        }
    }

    public void createGlobalRegion() {
        try {
            if (cache == null || cache.isClosed()) {
                IndexWithRegionOperationsTest.createCache();
            }
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.GLOBAL);
            factory.setIndexMaintenanceSynchronous(true);
            factory.setValueConstraint(Country.class);
            globalRegion = cache.createVMRegion("CountriesG", factory.createRegionAttributes());
            Log.getLogWriter().info("global region created");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Got expected Exception: caught while creating global region");
            e.printStackTrace();
        }
    }

    protected void createPersistBackUpRegion() {
        try {
            if (cache == null || cache.isClosed()) {
                IndexWithRegionOperationsTest.createCache();
            }
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            long l = ds.getId();
            String str = Long.toString(l);
            File[] f = new File[]{new File("persist" + str)};
            f[0].mkdir();
            factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(f).create("CountriesPBT").getName());
            factory.setDiskSynchronous(false);
            pbtRegion = cache.createVMRegion("CountriesPBT", factory.createRegionAttributes());
            Log.getLogWriter().info("CountriesPBT region created");
        }
        catch (Exception ex) {
            Log.getLogWriter().info("Got expected Exception: caught while creating persist back up true type region");
            ex.printStackTrace();
        }
    }

    public static void HydraTask_PerformIndex() {
        if (indexTest == null) {
            indexTest = new IndexWithRegionOperationsTest();
        }
        indexTest.performIndex();
    }

    public static void HydraTask_PerformRegionOperations() {
        if (indexTest == null) {
            indexTest = new IndexWithRegionOperationsTest();
        }
        indexTest.performRegionOperation();
    }

    public static void HydraTask_PerformExecuteQuery() {
        if (indexTest == null) {
            indexTest = new IndexWithRegionOperationsTest();
        }
        indexTest.performExecuteQuery();
    }

    protected void performIndex() {
        int j = ++counter1 % 4;
        try {
            Region region = IndexWithRegionOperationsTest.getRegion(j);
            if (region == null) {
                throw new TestException("Null Region");
            }
            block7: for (int i = 1; i < 3; ++i) {
                switch (i % 2) {
                    case 1: {
                        Log.getLogWriter().info("creating indexes on region: " + region.getName());
                        this.createIndex(region);
                        continue block7;
                    }
                    case 0: {
                        Log.getLogWriter().info("removing indexes from region: " + region.getName());
                        this.removeIndex(region);
                        continue block7;
                    }
                    default: {
                        Log.getLogWriter().info("No mathing operations found for: " + i % 2 + "Trying again...");
                    }
                }
            }
        }
        catch (IndexNameConflictException ince) {
            Log.getLogWriter().info("Index with the same name already exists while index creation");
        }
        catch (Exception e) {
            Log.getLogWriter().info("Got expected Exception: caught while performning index operations on region" + e);
            e.printStackTrace();
        }
    }

    protected void createIndex(Region region) throws Exception {
        QueryService qs = cache.getQueryService();
        try {
            if (region.getName().equalsIgnoreCase("CountriesNM")) {
                qs.createIndex("villageName-nm", IndexType.FUNCTIONAL, "v.name", "/CountriesNM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("cityName-nm", IndexType.FUNCTIONAL, "ct.name", "/CountriesNM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("districtName-nm", IndexType.FUNCTIONAL, "d.name", "/CountriesNM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("stateName-nm", IndexType.FUNCTIONAL, "s.name", "/CountriesNM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName1-nm", IndexType.FUNCTIONAL, "c.name", "/CountriesNM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName2-nm", IndexType.FUNCTIONAL, "c.name", "/CountriesNM c");
                Log.getLogWriter().info("Index creation is done on region " + region.getName());
            } else if (region.getName().equalsIgnoreCase("CountriesM")) {
                qs.createIndex("villageName-m", IndexType.FUNCTIONAL, "v.name", "/CountriesM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("cityName-m", IndexType.FUNCTIONAL, "ct.name", "/CountriesM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("districtName-m", IndexType.FUNCTIONAL, "d.name", "/CountriesM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("stateName-m", IndexType.FUNCTIONAL, "s.name", "/CountriesM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName1-m", IndexType.FUNCTIONAL, "c.name", "/CountriesM c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName2-m", IndexType.FUNCTIONAL, "c.name", "/CountriesM c");
                Log.getLogWriter().info("Index creation is done on region " + region.getName());
            } else if (region.getName().equalsIgnoreCase("CountriesG")) {
                qs.createIndex("villageName-g", IndexType.FUNCTIONAL, "v.name", "/CountriesG c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("cityName-g", IndexType.FUNCTIONAL, "ct.name", "/CountriesG c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("districtName-g", IndexType.FUNCTIONAL, "d.name", "/CountriesG c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("stateName-g", IndexType.FUNCTIONAL, "s.name", "/CountriesG c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName1-g", IndexType.FUNCTIONAL, "c.name", "/CountriesG c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName2-g", IndexType.FUNCTIONAL, "c.name", "/CountriesG c");
                Log.getLogWriter().info("Index creation is done on region " + region.getName());
            } else if (region.getName().equalsIgnoreCase("CountriesPBT")) {
                qs.createIndex("villageName-pbt", IndexType.FUNCTIONAL, "v.name", "/CountriesPBT c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("cityName-pbt", IndexType.FUNCTIONAL, "ct.name", "/CountriesPBT c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("districtName-pbt", IndexType.FUNCTIONAL, "d.name", "/CountriesPBT c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("stateName-pbt", IndexType.FUNCTIONAL, "s.name", "/CountriesPBT c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName1-pbt", IndexType.FUNCTIONAL, "c.name", "/CountriesPBT c, c.states s, s.districts d, d.cities ct, d.villages v");
                qs.createIndex("countryName2-pbt", IndexType.FUNCTIONAL, "c.name", "/CountriesPBT c");
                Log.getLogWriter().info("Index creation is done on region " + region.getName());
            }
        }
        catch (Exception e) {
            Log.getLogWriter().info("Got expected Exception: caught while creating index on region " + e);
        }
    }

    protected void removeIndex(Region region) throws Exception {
        Index idx2 = null;
        QueryService qs = cache.getQueryService();
        if (qs != null) {
            try {
                Collection indexes = qs.getIndexes(region);
                if (indexes == null) {
                    Log.getLogWriter().info("No indexes are found on this region: " + region.getName() + " Collection of indexes is found null");
                    return;
                }
                if (indexes.size() == 0) {
                    Log.getLogWriter().info("No indexes are found on this region: " + region.getName() + "Size of collection of indexes is found zero");
                    return;
                }
                Log.getLogWriter().info("-------- Region " + region.getName() + " has " + indexes.size() + " indexes");
                for (Index idx2 : indexes) {
                    String name = idx2.getName();
                    qs.removeIndex(idx2);
                    Log.getLogWriter().info("Index " + name + " removed successfully");
                }
            }
            catch (Exception e) {
                Log.getLogWriter().info("Got expected Exception: caught while removing index from region: " + region.getName() + "/n Index Name is: " + idx2.getName());
                e.printStackTrace();
            }
        } else {
            Log.getLogWriter().info("No query service is found for this cache while index removal");
        }
    }

    protected void performRegionOperation() {
        int j = ++counter2 % 4;
        try {
            Region region = IndexWithRegionOperationsTest.getRegion(j);
            if (region == null) {
                throw new TestException("Null Region");
            }
            block12: for (int i = 1; i < 31; ++i) {
                switch (i % 7) {
                    case 0: {
                        IndexWithRegionOperationsTest.doClear(region);
                        continue block12;
                    }
                    case 1: {
                        IndexWithRegionOperationsTest.doPut(region);
                        continue block12;
                    }
                    case 2: {
                        IndexWithRegionOperationsTest.doUpdate(region);
                        continue block12;
                    }
                    case 3: {
                        IndexWithRegionOperationsTest.doGet(region);
                        continue block12;
                    }
                    case 4: {
                        IndexWithRegionOperationsTest.doDestroy(region);
                        continue block12;
                    }
                    case 5: {
                        IndexWithRegionOperationsTest.doInvalidate(region);
                        continue block12;
                    }
                    case 6: {
                        IndexWithRegionOperationsTest.doRemove(region);
                        continue block12;
                    }
                    default: {
                        Log.getLogWriter().info("No mathing operations found for: " + i % 7 + "Trying again...");
                    }
                }
            }
        }
        catch (EntryNotFoundException enfe) {
            Log.getLogWriter().info("Entry Not Found while performing operation on entry");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void doPut(Region region) throws Exception {
        int temp = 0;
        for (int i = PUT - 50; i < PUT; ++i) {
            region.put((Object)new Integer(i), (Object)new Country(i, 2, 2, 2, 2));
            ++temp;
        }
        PUT = temp;
        Log.getLogWriter().info("Performed put on region: " + region.getName());
    }

    public static void doUpdate(Region region) throws Exception {
        int temp = 0;
        for (int i = UPDATE - 10; i < UPDATE; ++i) {
            region.put((Object)new Integer(i), (Object)new Country(i + 10, 2, 2, 2, 2));
            ++temp;
        }
        GET = 50 + temp;
        Log.getLogWriter().info("Performed update on region: " + region.getName());
    }

    public static void doGet(Region region) throws Exception {
        int temp = 0;
        for (int i = GET - 10; i < GET; ++i) {
            region.get((Object)new Integer(i));
            ++temp;
        }
        GET = 50 + temp;
        Log.getLogWriter().info("Performed get on region: " + region.getName());
    }

    public static void doDestroy(Region region) throws Exception {
        int temp = 0;
        for (int i = DESTROY - 10; i < DESTROY - 5; ++i) {
            region.destroy((Object)new Integer(i));
            ++temp;
        }
        DESTROY = 50 + temp;
        Log.getLogWriter().info("Performed destroy on region: " + region.getName());
    }

    public static void doInvalidate(Region region) throws Exception {
        int temp = 0;
        for (int i = INVALIDATE - 10; i < INVALIDATE; ++i) {
            region.invalidate((Object)new Integer(i));
            ++temp;
        }
        INVALIDATE = 50 + temp;
        Log.getLogWriter().info("Performed invalidate on region: " + region.getName());
    }

    public static void doRemove(Region region) throws Exception {
        int temp = 0;
        for (int i = REMOVE - 10; i < REMOVE; ++i) {
            region.remove((Object)new Integer(i));
            ++temp;
        }
        REMOVE = 50 + temp;
        Log.getLogWriter().info("Performed put remove region: " + region.getName());
    }

    public static void doClear(Region region) throws Exception {
        region.clear();
        Log.getLogWriter().info("Performed clear on region: " + region.getName());
    }

    public static synchronized void HydraTask_closetask() {
        indexTest.closeTask();
    }

    protected void closeTask() {
        this.closeCache();
    }

    protected void closeCache() {
        try {
            if (!cache.isClosed()) {
                cache.close();
            }
            if (ds.isConnected()) {
                ds.disconnect();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Region getRegion(int i) {
        Region region = null;
        switch (i) {
            case 0: {
                region = nonMirroredRegion;
                break;
            }
            case 1: {
                region = mirroredRegion;
                break;
            }
            case 2: {
                region = globalRegion;
                break;
            }
            case 3: {
                region = pbtRegion;
                break;
            }
            default: {
                Log.getLogWriter().info("No mathing region found for: " + i + " Trying again...");
            }
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performExecuteQuery() {
        Object q = null;
        try {
            long totalTime = 0L;
            SelectResults rs = null;
            System.out.println("Query No: " + queryCntr + "...execution");
            String sqlStr = queries[queryCntr];
            QueryService qs = cache.getQueryService();
            q = qs.newQuery(sqlStr);
            totalTime = 0L;
            for (int i = 0; i < 2; ++i) {
                long startTime = System.currentTimeMillis();
                rs = (SelectResults)q.execute();
                long endTime = System.currentTimeMillis();
                totalTime += endTime - startTime;
            }
            long avgExecutionTime = totalTime / 2L;
            Object object = queryCntrLock;
            synchronized (object) {
                if (++queryCntr == queries.length - 1) {
                    queryCntr = 0;
                }
            }
            Log.getLogWriter().info("Average query execution time for query execution is: " + avgExecutionTime + " . Result set size is: " + rs.size() + " . Query string is: " + q.getQueryString() + " .");
        }
        catch (Exception ex) {
            Log.getLogWriter().warning("Got expected Exception: caught while executing query: " + q.toString());
            ex.printStackTrace();
        }
    }

    static {
        PUT = 200;
        GET = 10;
        UPDATE = 10;
        DESTROY = 20;
        INVALIDATE = 30;
        REMOVE = 40;
        queries = new String[]{"SELECT DISTINCT * FROM /CountriesNM cnm, cnm.states snm, snm.districts dnm, dnm.villages vnm, dnm.cities ctnm, /CountriesM cm, cm.states sm, sm.districts dm, dm.villages vm, dm.cities ctm WHERE vnm.name = vm.name ", "SELECT DISTINCT * FROM /CountriesNM cnm, cnm.states snm, snm.districts dnm, dnm.villages vnm, dnm.cities ctnm, /CountriesPBT cpbt, cpbt.states spbt, spbt.districts dpbt, dpbt.villages vpbt, dpbt.cities ctpbt WHERE ctnm.name = ctpbt.name ", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, sg.districts dg, dg.villages vg, dg.cities ctg, /CountriesPBT cpbt, cpbt.states spbt, spbt.districts dpbt, dpbt.villages vpbt, dpbt.cities ctpbt WHERE cg.name = cpbt.name ", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, sg.districts dg, dg.villages vg, dg.cities ctg, /CountriesM cm, cm.states sm, sm.districts dm, dm.villages vm, dm.cities ctm WHERE sg.name = sm.name ", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, /CountriesM cm, cm.states sm, /CountriesPBT cpbt, cpbt.states spbt WHERE sg.name = sm.name AND sg.name = sg.name", "SELECT DISTINCT * FROM /CountriesNM cnm, cnm.states snm, snm.districts dnm, dnm.villages vnm, dnm.cities ctnm, /CountriesM cm, cm.states sm, sm.districts dm, dm.villages vm, dm.cities ctm WHERE vnm.name = 'MAHARASHTRA_VILLAGE1' AND ctm.name = 'MUMBAI' ", "SELECT DISTINCT * FROM /CountriesNM cnm, cnm.states snm, snm.districts dnm, dnm.villages vnm, dnm.cities ctnm, /CountriesPBT cpbt, cpbt.states spbt, spbt.districts dpbt, dpbt.villages vpbt, dpbt.cities ctpbt WHERE ctnm.name = 'MUMBAI' AND ctpbt.name = 'PUNE' ", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, sg.districts dg, dg.villages vg, dg.cities ctg, /CountriesPBT cpbt, cpbt.states spbt, spbt.districts dpbt, dpbt.villages vpbt, dpbt.cities ctpbt WHERE cg.name = 'INDIA' AND  cpbt.name = 'INDIA'", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, /CountriesM cm, cm.states sm, /CountriesPBT cpbt, cpbt.states spbt WHERE sg.name = 'MAHARASHTRA' AND sm.name = 'MAHARASHTRA' AND spbt.name = 'MAHARASHTRA'", "SELECT DISTINCT * FROM /CountriesNM cnm, cnm.states snm, snm.districts dnm, dnm.villages vnm, dnm.cities ctnm, /CountriesM cm, cm.states sm, sm.districts dm, dm.villages vm, dm.cities ctm WHERE vnm.name = vm.name AND vnm.name = 'MAHARASHTRA_VILLAGE1'", "SELECT DISTINCT * FROM /CountriesNM cnm, cnm.states snm, snm.districts dnm, dnm.villages vnm, dnm.cities ctnm, /CountriesPBT cpbt, cpbt.states spbt, spbt.districts dpbt, dpbt.villages vpbt, dpbt.cities ctpbt WHERE ctnm.name = ctpbt.name AND ctpbt.name = 'PUNE'", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, sg.districts dg, dg.villages vg, dg.cities ctg, /CountriesPBT cpbt, cpbt.states spbt, spbt.districts dpbt, dpbt.villages vpbt, dpbt.cities ctpbt WHERE cg.name = cpbt.name AND cg.name = 'INDIA'", "SELECT DISTINCT * FROM /CountriesG cg, cg.states sg, sg.districts dg, dg.villages vg, dg.cities ctg, /CountriesM cm, cm.states sm, sm.districts dm, dm.villages vm, dm.cities ctm WHERE sg.name = sm.name AND sg.name = 'MAHARASHTRA' AND sm.name = 'MAHARASHTRA'"};
        queryCntr = 0;
        queryCntrLock = "queryCntrLock";
    }
}

