/*
 * Decompiled with CFR 0.152.
 */
package query.index;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.index.CompactRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.MapRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache.query.internal.index.RangeIndex;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import distcache.gemfire.GemFireCachePrms;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import query.index.IndexPrms;
import util.TestException;
import util.TestHelper;

public class IndexTest {
    protected static IndexTest indexTest;

    public void createIndex(int regionNumber) {
        String indexType = TestConfig.tab().stringAt(IndexPrms.indexType, "compactRange");
        if (indexType.equals("compactRange")) {
            this.createCompactRangeIndex(regionNumber);
        } else if (indexType.equals("mapRange")) {
            this.createMapIndex(regionNumber);
        } else if (indexType.equals("rangeIndex")) {
            this.createRangeIndex(regionNumber);
        } else if (indexType.equals("hashIndex")) {
            this.createHashIndex(regionNumber);
        } else if (indexType.equals("all")) {
            this.createCompactRangeIndex(regionNumber);
            this.createMapIndex(regionNumber);
            this.createRangeIndex(regionNumber);
        } else if (indexType.equals("allAndHash")) {
            this.createCompactRangeIndex(regionNumber);
            this.createMapIndex(regionNumber);
            this.createRangeIndex(regionNumber);
            this.createHashIndex(regionNumber);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createIndex(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    long numOfIndexes = 1L;
                    numOfIndexes = TestConfig.tab().longAt(IndexPrms.numOfIndexes, 1L);
                    qs.createIndex("statusIndex", IndexType.FUNCTIONAL, "status", "/" + RegionName2);
                    Log.getLogWriter().info("Index statusIndex Created successfully");
                    if (numOfIndexes >= 2L) {
                        qs.createIndex("idIndex", IndexType.FUNCTIONAL, "ID", "/" + RegionName2);
                        Log.getLogWriter().info("Index idIndex Created successfully");
                    }
                    if (numOfIndexes >= 3L) {
                        qs.createIndex("mktValueIndex", IndexType.FUNCTIONAL, "pVal.mktValue", "/" + RegionName2 + " pf, pf.positions.values pVal TYPE Position", "import parReg.\"query\".Position;");
                        Log.getLogWriter().info("Index mktValueIndex Created successfully");
                    }
                    if (numOfIndexes < 4L) return;
                    qs.createIndex("nameIndex", IndexType.PRIMARY_KEY, "name", "/" + RegionName2);
                    Log.getLogWriter().info("Index nameIndex Created successfully");
                    return;
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    return;
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("Caught expected IndexExistsException, continuing tests");
                    return;
                }
                catch (QueryException e) {
                    throw new HydraRuntimeException("Could not create Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Hey !!!!! Could not obtain QueryService for the cache ");
            }
            return;
        } else {
            Log.getLogWriter().info("Hey !!!!! Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createCompactRangeIndex(int regionNumber) {
        String RegionName2 = "QueryRegion" + regionNumber;
        Log.getLogWriter().info("Creating Compact range index on region: " + RegionName2);
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    Index i1 = qs.createIndex("statusCompactRangeIndex" + regionNumber, "status", "/" + RegionName2);
                    Index i2 = qs.createIndex("idCompactRangeIndex" + regionNumber, "ID", "/" + RegionName2);
                    Log.getLogWriter().info("Index idCompactRangeIndex Created successfully");
                    if (region instanceof PartitionedRegion) {
                        PartitionedIndex pindex = (PartitionedIndex)i1;
                        List indexes = pindex.getBucketIndexes();
                        for (Object index : indexes) {
                            if (index instanceof CompactRangeIndex) continue;
                            throw new TestException("IndexType was found to be: " + index.getClass() + " but Expected to be CompactRangeIndex.");
                        }
                        PartitionedIndex pindex2 = (PartitionedIndex)i2;
                        indexes = pindex2.getBucketIndexes();
                        for (Object index : indexes) {
                            if (index instanceof CompactRangeIndex) continue;
                            throw new TestException("IndexType was found to be: " + index.getClass() + " but Expected to be CompactRangeIndex.");
                        }
                        return;
                    }
                    if (!(i1 instanceof CompactRangeIndex)) {
                        throw new TestException("IndexType was found to be: " + i1.getClass() + " but Expected to be CompactRangeIndex.");
                    }
                    if (i2 instanceof CompactRangeIndex) return;
                    throw new TestException("IndexType was found to be: " + i2.getClass() + " but Expected to be CompactRangeIndex.");
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    return;
                }
                catch (QueryException e) {
                    throw new TestException("Could not create Index " + (Object)((Object)e));
                }
            } else {
                Log.getLogWriter().info("Could not obtain QueryService for the cache ");
            }
            return;
        } else {
            Log.getLogWriter().info("Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createHashIndex(int regionNumber) {
        String RegionName2 = "QueryRegion" + regionNumber;
        Log.getLogWriter().info("Creating hash index on region: " + RegionName2);
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    Index i1 = qs.createHashIndex("statusHashIndex" + regionNumber, "status", "/" + RegionName2);
                    Index i2 = qs.createHashIndex("idHashIndex" + regionNumber, "ID", "/" + RegionName2);
                    Log.getLogWriter().info("Index idHashIndex Created successfully");
                    if (region instanceof PartitionedRegion) {
                        PartitionedIndex pindex = (PartitionedIndex)i1;
                        List indexes = pindex.getBucketIndexes();
                        for (Object index : indexes) {
                            if (index instanceof CompactRangeIndex) continue;
                            throw new TestException("IndexType was found to be: " + index.getClass() + " but Expected to be CompactRangeIndex.");
                        }
                        PartitionedIndex pindex2 = (PartitionedIndex)i2;
                        indexes = pindex2.getBucketIndexes();
                        for (Object index : indexes) {
                            if (index instanceof CompactRangeIndex) continue;
                            throw new TestException("IndexType was found to be: " + index.getClass() + " but Expected to be CompactRangeIndex.");
                        }
                        return;
                    }
                    if (!(i1 instanceof CompactRangeIndex)) {
                        throw new TestException("IndexType was found to be: " + i1.getClass() + " but Expected to be CompactRangeIndex.");
                    }
                    if (i2 instanceof CompactRangeIndex) return;
                    throw new TestException("IndexType was found to be: " + i2.getClass() + " but Expected to be CompactRangeIndex.");
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    return;
                }
                catch (QueryException e) {
                    throw new TestException("Could not create Index " + (Object)((Object)e));
                }
            } else {
                Log.getLogWriter().info("Could not obtain QueryService for the cache ");
            }
            return;
        } else {
            Log.getLogWriter().info("Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createRangeIndex(int regionNumber) {
        String RegionName2 = "QueryRegion" + regionNumber;
        Log.getLogWriter().info("Creating range index on region: " + RegionName2);
        Region region = RegionHelper.getRegion(RegionName2);
        region.getAttributes().getEvictionAttributes().getAction().isOverflowToDisk();
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            EvictionAttributes evAttr = region.getAttributes().getEvictionAttributes();
            if (evAttr.getAlgorithm() != null && evAttr.getAction() != null && !evAttr.getAlgorithm().equals(EvictionAlgorithm.NONE) && !evAttr.getAction().equals(EvictionAction.NONE)) {
                Log.getLogWriter().info("Region :" + RegionName2 + " is an overflow region. So no range index creation");
                return;
            }
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    Index i1 = qs.createIndex("statusRangeIndex" + regionNumber, "status", "/" + RegionName2 + " pf, pf.positions");
                    Log.getLogWriter().info("Index statusRangeIndex Created successfully");
                    Index i2 = qs.createIndex("idRangeIndex" + regionNumber, "ID", "/" + RegionName2 + " pf, pf.positions");
                    Log.getLogWriter().info("Index idRangeIndex Created successfully");
                    if (region instanceof PartitionedRegion) {
                        PartitionedIndex pindex = (PartitionedIndex)i1;
                        List indexes = pindex.getBucketIndexes();
                        for (Object index : indexes) {
                            if (index instanceof RangeIndex) continue;
                            throw new TestException("IndexType was found to be: " + index.getClass() + "but Expected to be RangeIndex.");
                        }
                        PartitionedIndex pindex2 = (PartitionedIndex)i2;
                        indexes = pindex2.getBucketIndexes();
                        for (Object index : indexes) {
                            if (index instanceof RangeIndex) continue;
                            throw new TestException("IndexType was found to be: " + index.getClass() + "but Expected to be RangeIndex.");
                        }
                        return;
                    }
                    if (!(i1 instanceof RangeIndex)) {
                        throw new TestException("IndexType was found to be: " + i1.getClass() + "but Expected to be RangeIndex.");
                    }
                    if (i2 instanceof RangeIndex) return;
                    throw new TestException("IndexType was found to be: " + i2.getClass() + "but Expected to be CompactRangeIndex.");
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    return;
                }
                catch (QueryException e) {
                    throw new TestException("Could not create Index " + (Object)((Object)e));
                }
            } else {
                Log.getLogWriter().info("Could not obtain QueryService for the cache ");
            }
            return;
        } else {
            Log.getLogWriter().info("Region.isDestroyed() returned true for region : " + RegionName2);
        }
    }

    public void createMapIndex(int regionNumber) {
        String RegionName2 = "QueryRegion" + regionNumber;
        Log.getLogWriter().info("Creating Map range index on region: " + RegionName2);
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
        } else {
            EvictionAttributes evAttr = region.getAttributes().getEvictionAttributes();
            Log.getLogWriter().info("*************************************************");
            Log.getLogWriter().info("INSIDE CreateMapIndex");
            Log.getLogWriter().info("RegionName: " + RegionName2);
            Log.getLogWriter().info("EvAttr: " + evAttr);
            Log.getLogWriter().info("evAttr.getAlgorithm() " + evAttr.getAlgorithm().toString());
            Log.getLogWriter().info("evAttr.getAction() " + evAttr.getAction().toString());
            Log.getLogWriter().info("*************************************************");
            if (evAttr.getAlgorithm() != null && evAttr.getAction() != null && !evAttr.getAlgorithm().equals(EvictionAlgorithm.NONE) && !evAttr.getAction().equals(EvictionAction.NONE)) {
                Log.getLogWriter().info("Region :" + RegionName2 + " is an overflow region. So no map range index creation");
                return;
            }
            if (!region.isDestroyed()) {
                Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
                QueryService qs = CacheHelper.getCache().getQueryService();
                if (qs != null) {
                    try {
                        Index i1 = qs.createIndex("mapRangeIndex1" + regionNumber, "pf.positions[*]", "/" + RegionName2 + " pf");
                        Index i2 = qs.createIndex("mapRangeIndex2" + regionNumber, "pf.positions['SUN','IBM','YHOO']", "/" + RegionName2 + " pf");
                        if (region instanceof PartitionedRegion) {
                            PartitionedIndex pindex = (PartitionedIndex)i1;
                            List indexes = pindex.getBucketIndexes();
                            for (Object index : indexes) {
                                if (index instanceof MapRangeIndex) continue;
                                throw new TestException("IndexType was found to be: " + index.getClass() + "but Expected to be RangeIndex.");
                            }
                            PartitionedIndex pindex2 = (PartitionedIndex)i2;
                            indexes = pindex2.getBucketIndexes();
                            for (Object index : indexes) {
                                if (index instanceof MapRangeIndex) continue;
                                throw new TestException("IndexType was found to be: " + index.getClass() + "but Expected to be RangeIndex.");
                            }
                        } else {
                            if (!(i1 instanceof MapRangeIndex)) {
                                throw new TestException("IndexType was found to be: " + i1.getClass() + "but Expected to be MapRangeIndex.");
                            }
                            if (!(i2 instanceof MapRangeIndex)) {
                                throw new TestException("IndexType was found to be: " + i2.getClass() + "but Expected to be MapRangeIndex.");
                            }
                        }
                        Log.getLogWriter().info("Index mapRangeIndex1" + regionNumber + " created successfully!!");
                        Log.getLogWriter().info("Index mapRangeIndex2" + regionNumber + " created successfully!!");
                    }
                    catch (IndexNameConflictException e) {
                        Log.getLogWriter().info("Caught expected IndexNameConflictException, continuing tests");
                    }
                    catch (IndexInvalidException e) {
                        e.printStackTrace();
                        throw new TestException("Caught IndexInvalidException: " + (Object)((Object)e));
                    }
                    catch (QueryException e) {
                        throw new TestException("Could not create Index " + (Object)((Object)e));
                    }
                } else {
                    Log.getLogWriter().info("Could not obtain QueryService for the cache ");
                }
            } else {
                Log.getLogWriter().info("Region.isDestroyed() returned true for region : " + RegionName2);
            }
        }
    }

    public static synchronized void HydraTask_RemoveIndex() {
        if (indexTest == null) {
            indexTest = new IndexTest();
        }
        indexTest.removeIndex(GemFireCachePrms.getRegionName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeIndex(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    Collection indexes = qs.getIndexes(region);
                    if (indexes == null) {
                        return;
                    }
                    if (indexes.size() == 0) {
                        return;
                    }
                    Iterator iter = indexes.iterator();
                    if (!iter.hasNext()) return;
                    Index idx = (Index)iter.next();
                    String name = idx.getName();
                    qs.removeIndex(idx);
                    Log.getLogWriter().info("Index " + name + " removed successfully");
                    return;
                }
                catch (Exception e) {
                    throw new TestException("Could not remove Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Could not obtain QueryService for the cache ");
            }
        }
    }
}

