/*
 * Decompiled with CFR 0.152.
 */
package query;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.query.CacheUtils;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Utils;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.index.CompactRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache.query.internal.index.RangeIndex;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.pdx.PdxInstance;
import event.EventBB;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import objects.PRPortfolio;
import objects.Portfolio;
import parReg.ParRegUtil;
import pdx.PdxTest;
import query.QueryBB;
import query.QueryPrms;
import query.QueryTest;
import query.QueryValidator;
import query.index.IndexBB;
import query.index.IndexPrms;
import query.index.IndexValidator;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.PRObserver;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class SerialQueryAndEntryOpsTest
extends QueryTest {
    private static SerialQueryAndEntryOpsTest serialTest = new SerialQueryAndEntryOpsTest();
    public static AtomicBoolean firstTimeInvocation = new AtomicBoolean(false);
    protected static String SELECT_STRING = "select distinct * from ";
    protected String[] queries = new String[]{" where ID = 100", " where status = 'active'", " pf, pf.positions.values where ID = 100", " pf, pf.positions.values where status = 'active'", " pf where pf.positions['SUN'] != null", " pf where pf.status LIKE 'act%'", " pf where pf.status LIKE 'act_ve'"};
    final int threshold = 30000;
    Map<Integer, String> queryToIndexMap = new HashMap<Integer, String>(){
        {
            this.put(0, "idCompactRangeIndex");
            this.put(1, "statusCompactRangeIndex");
            this.put(2, "idRangeIndex");
            this.put(3, "statusRangeIndex");
            this.put(4, "mapRangeIndex2");
            this.put(5, "statusCompactRangeIndex");
            this.put(6, "statusCompactRangeIndex");
        }
    };
    SelectResults[][][] r = null;

    @Override
    protected String randRgn() {
        if (this.numOfRegions <= 0) {
            this.numOfRegions = TestConfig.tab().intAt(QueryPrms.numOfRegions, 1);
        }
        return "/QueryRegion" + new Random().nextInt(this.numOfRegions);
    }

    public static synchronized void HydraTask_initialize() {
        if (queryTest == null) {
            queryTest = new SerialQueryAndEntryOpsTest();
            queryTest.initialize();
        }
    }

    public static synchronized void HydraTask_createIndexes() {
        if (queryTest == null) {
            queryTest = new SerialQueryAndEntryOpsTest();
        }
        queryTest.createIndex_task();
    }

    public static synchronized void HydraTask_attachQueryObserver() {
        QueryObserverImplBB observer = new QueryObserverImplBB();
        QueryObserverHolder.setInstance((QueryObserver)observer);
    }

    @Override
    protected int getNumVMsWithListeners() {
        return TestHelper.getNumVMs();
    }

    @Override
    protected void addObject(Region aRegion, boolean aBoolean) {
        super.addObject(aRegion, aBoolean);
        this.validateQuery(aRegion);
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        super.invalidateObject(aRegion, isLocalInvalidate);
        this.validateQuery(aRegion);
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        super.destroyObject(aRegion, isLocalDestroy);
        this.validateQuery(aRegion);
    }

    @Override
    protected void updateObject(Region aRegion) {
        super.updateObject(aRegion);
        this.validateQuery(aRegion);
    }

    @Override
    protected void readObject(Region aRegion) {
        super.updateObject(aRegion);
        this.validateQuery(aRegion);
    }

    public static void HydraTask_validateCountStar() throws Throwable {
        new QueryTest().verifyCountQueryResults();
    }

    protected void validateQuery(Region aRegion) {
        try {
            Log.getLogWriter().info("Performing the query validation check");
            QueryValidator queryValidator = QueryBB.getQueryValidatorObject();
            if (queryValidator == null) {
                throw new TestException("QueryValidator found null");
            }
            Query query = CacheHelper.getCache().getQueryService().newQuery("SELECT DISTINCT * FROM /" + aRegion.getName() + ".keys");
            Object key = queryValidator.getKey();
            if (key == null) {
                throw new TestException("key cannot be null");
            }
            boolean exists = queryValidator.getKeyExists();
            Object result = query.execute();
            if (exists) {
                if (!((SelectResults)result).contains(key)) {
                    Log.getLogWriter().info("Operation done : " + queryValidator.getOperation());
                    throw new TestException("Key " + key + " not found in the Query result");
                }
                Log.getLogWriter().info("Key found : " + key + " in Query result");
                boolean hasValue = queryValidator.getHasValue();
                query = CacheHelper.getCache().getQueryService().newQuery("SELECT DISTINCT itr.value FROM /" + aRegion.getName() + ".entries itr where itr.key = $1");
                Object[] params = new Object[]{key};
                result = query.execute(params);
                if (hasValue) {
                    if (((Collection)result).size() != 1) {
                        throw new TestException("Size of result is not 1, and this key expected to have value");
                    }
                    Iterator iter = ((Collection)result).iterator();
                    Object resultValue = iter.next();
                    Object value = queryValidator.getValue();
                    if (value instanceof Map) {
                        String className = TestConfig.tab().stringAt(QueryPrms.objectType);
                        Portfolio portfolio = (Portfolio)PdxTest.getVersionedInstance(className);
                        portfolio.restoreFromPdxHelperMap((Map)value);
                        value = portfolio;
                    }
                    if (CacheHelper.getCache().getPdxReadSerialized() && resultValue instanceof PdxInstance) {
                        resultValue = ((PdxInstance)resultValue).getObject();
                    }
                    String valueStr = value.toString();
                    String resultValStr = resultValue.toString();
                    Log.getLogWriter().info("result: " + resultValStr);
                    Log.getLogWriter().info("valueStr: " + valueStr);
                    if (!valueStr.equals(resultValStr)) {
                        Log.getLogWriter().info("Result = " + Utils.printResult((Object)result));
                        Log.getLogWriter().info("Value = " + value.toString());
                        Log.getLogWriter().info("ResultValue = " + resultValue.toString());
                        throw new TestException("Values do not match");
                    }
                } else {
                    Iterator iter = ((Collection)result).iterator();
                    Object resultValue = iter.next();
                    if (resultValue != null) {
                        throw new TestException("Value is not null");
                    }
                }
            } else {
                if (((SelectResults)result).contains(key)) {
                    throw new TestException("Key " + key + "found in the Query result, actually it is expected to be destroyed");
                }
                Log.getLogWriter().info("Key : " + key + " not found in Query result, so it is properly destroyed");
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query validation" + TestHelper.getStackTrace(e));
        }
    }

    @Override
    protected void checkEventCounters() {
        this.checkEventCounters(true);
    }

    protected void checkEventCounters(boolean numCloseIsExact) {
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInval = counters.read(EventBB.NUM_INVALIDATE);
        long numRegionDestroy = counters.read(EventBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(EventBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(EventBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(EventBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(EventBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(EventBB.NUM_LOCAL_REGION_INVALIDATE);
        long numClose = counters.read(EventBB.NUM_CLOSE);
        int numVmsWithList = this.getNumVMsWithListeners();
        Log.getLogWriter().info("num VMs/C clients with listener installed: " + numVmsWithList);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", numCreate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", numDestroy * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotRemote", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", numInval * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotRemote", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", numUpdate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotRemote", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", numRegionInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", numRegionInval * (long)numVmsWithList + numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", numRegionInval * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", numRegionInval + numLocalRegionInval));
        al.add(new ExpCounterValue("numClose", numClose, numCloseIsExact));
        EventCountersBB.getBB().checkEventCounters(al);
    }

    private boolean isRangeIndexPresent(String regionName) {
        boolean present = false;
        Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
        for (Index index : indexes) {
            if (!(index instanceof RangeIndex) || index instanceof CompactRangeIndex || !index.getCanonicalizedFromClause().startsWith(regionName)) continue;
            present = true;
            break;
        }
        Log.getLogWriter().info("ISRANGEINDEXPRESENT " + regionName + " PRESENT = " + present);
        return present;
    }

    @Override
    protected void doQuery(boolean logAddition) {
        boolean isIndexValidation = TestConfig.tab().booleanAt(QueryPrms.isIndexUsageValidation, false);
        if (isIndexValidation) {
            String indexType = TestConfig.tab().stringAt(IndexPrms.indexType, "compactRange");
            Set regions = CacheHelper.getCache().rootRegions();
            Log.getLogWriter().info("Printing all root regions in the Cache: " + regions.toString());
            Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
            Log.getLogWriter().info("Printing all indexes in the Cache: " + indexes.toString());
            for (Index index : indexes) {
                Log.getLogWriter().info("Index name " + index.getName());
                Log.getLogWriter().info("Index canonicalized from clause " + index.getCanonicalizedFromClause());
                Log.getLogWriter().info("Index canonicalized index expression " + index.getCanonicalizedIndexedExpression());
                Log.getLogWriter().info("Index canonicalized projection attributes " + index.getCanonicalizedProjectionAttributes());
            }
            for (int i = 0; i < this.queries.length; ++i) {
                Log.getLogWriter().info(" query = " + this.queries[i]);
                if (this.numOfRegions <= 0) {
                    this.numOfRegions = TestConfig.tab().intAt(QueryPrms.numOfRegions, 1);
                }
                for (int regionNum = 0; regionNum < this.numOfRegions; ++regionNum) {
                    boolean isOverflow = false;
                    Region region = RegionHelper.getRegion("/QueryRegion" + regionNum);
                    EvictionAttributes evAttr = region.getAttributes().getEvictionAttributes();
                    if (evAttr != null && evAttr.getAction().equals(EvictionAction.OVERFLOW_TO_DISK)) {
                        isOverflow = true;
                        Log.getLogWriter().info("REPLACING EXPECTED INDEX Regionname: " + "/QueryRegion" + regionNum);
                        this.queryToIndexMap.put(2, "idCompactRangeIndex");
                        this.queryToIndexMap.put(3, "statusCompactRangeIndex");
                    }
                    if (indexType.equals("hashIndex") || indexType.equals("allAndHash")) {
                        Log.getLogWriter().info("REPLACING EXPECTED INDEX Regionname: " + "/QueryRegion" + regionNum + " due to hash index");
                        this.queryToIndexMap.put(0, "idHashIndex");
                        this.queryToIndexMap.put(1, "statusHashIndex");
                        this.queryToIndexMap.put(2, "idHashIndex");
                        this.queryToIndexMap.put(3, "statusHashIndex");
                    }
                    Query query = CacheHelper.getCache().getQueryService().newQuery(SELECT_STRING + "/QueryRegion" + regionNum + this.queries[i]);
                    try {
                        Log.getLogWriter().info("Executing query :::" + query.getQueryString());
                        IndexValidator iv = new IndexValidator(null);
                        IndexBB.getBB();
                        IndexBB.putIndexValidator(iv);
                        long start = System.nanoTime();
                        Object result = query.execute();
                        QueryBB.getBB().getSharedCounters().add(QueryBB.TOTAL_QUERY_EXEC_TIME, System.nanoTime() - start);
                        IndexBB.getBB().getSharedCounters().increment(IndexBB.TOTAL_USES);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_QUERY_EXECS);
                        Log.getLogWriter().info("NumQueries :::" + numQueries.incrementAndGet());
                        Log.getLogWriter().info("Query Result::: " + result.toString());
                        Log.getLogWriter().info("Query Result size::: " + ((Collection)result).size());
                        if (i != 4 || !isOverflow) {
                            Log.getLogWriter().info("i: " + i + "QueryToIndexMap.get(i)  " + this.queryToIndexMap.get(i));
                            this.validateIndex(this.queryToIndexMap.get(i) + regionNum, query.getQueryString());
                        }
                        this.queryToIndexMap.put(2, "idRangeIndex");
                        this.queryToIndexMap.put(3, "statusRangeIndex");
                        continue;
                    }
                    catch (QueryExecutionTimeoutException e) {
                        Log.getLogWriter().info("HERE Caught QueryExecutionTimeoutException " + e.getMessage());
                        continue;
                    }
                    catch (Exception e) {
                        throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
                    }
                }
            }
        } else {
            super.doQuery(logAddition);
        }
    }

    protected void validateIndex(String expectedIndexName, String query) {
        try {
            Log.getLogWriter().info("Performing the index usage validation check");
            IndexValidator indexValidator = IndexBB.getIndexValidatorObject();
            if (indexValidator == null) {
                throw new TestException("indexValidator found null");
            }
            String index = indexValidator.getIndexName();
            Log.getLogWriter().info("Expected Index name: " + expectedIndexName);
            Log.getLogWriter().info("Actual Index name " + index);
            if (index == null) {
                throw new TestException("No index was used by the query: " + query + " ExpectedIndexName: " + expectedIndexName);
            }
            if (!index.equals(expectedIndexName)) {
                if (expectedIndexName.equals("idRangeIndex") && (index.equals("idCompactRangeIndex") || index.equals("idHashIndex"))) {
                    return;
                }
                if (expectedIndexName.equals("statusRangeIndex") && index.equals("statusCompactRangeIndex")) {
                    return;
                }
                throw new TestException("The name of the index used did not match Expected: " + expectedIndexName + " Actual " + indexValidator.getIndexName() + " query : " + query);
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query validation" + TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyIndexSize_QueryData_EatExpectedException() {
        try {
            SerialQueryAndEntryOpsTest.HydraTask_verifyIndexSize_QueryData();
        }
        catch (CacheClosedException cce) {
            Log.getLogWriter().warning("Caught CacheClosed exception.. ignoring");
        }
        catch (QueryInvocationTargetException e) {
            Log.getLogWriter().warning("Caught query invocation target exception.. ignoring");
        }
        catch (PartitionOfflineException e) {
            Log.getLogWriter().warning("Caught PartitionOfflineException.. ignoring");
        }
        catch (Exception e) {
            throw new TestException("Unexpectedly Caught Exception while executing query", e);
        }
    }

    public static void queryData_EatExpectedException() {
        try {
            SerialQueryAndEntryOpsTest.queryData();
        }
        catch (CacheClosedException cce) {
            Log.getLogWriter().warning("Caught CacheClosed exception.. ignoring");
        }
        catch (QueryInvocationTargetException e) {
            Log.getLogWriter().warning("Caught query invocation target exception.. ignoring");
        }
        catch (PartitionOfflineException e) {
            Log.getLogWriter().warning("Caught PartitionOfflineException.. ignoring");
        }
        catch (ServerOperationException e) {
            Log.getLogWriter().warning("Caught exception type: " + ((Object)((Object)e)).getClass().getName());
            Log.getLogWriter().warning("Caught exception cause: " + e.getCause());
            if (e.getCause() != null) {
                Log.getLogWriter().warning("Caught exception cause-messge: " + e.getCause().getMessage());
                Log.getLogWriter().warning("Caught exception cause-localizedmessge: " + e.getCause().getLocalizedMessage());
            }
            if (e.getCause() instanceof QueryInvocationTargetException) {
                Log.getLogWriter().warning("Caught ServerOperationException due to query invocation target exception.. ignoring");
            }
            throw new TestException("Unexpectedly Caught Exception while executing query", e);
        }
        catch (Exception e) {
            throw new TestException("Unexpectedly Caught Exception while executing query", e);
        }
    }

    public static void queryData() throws Exception {
        PRPortfolio pf;
        String query1 = "select * from /QueryRegion0 qr where qr.id = 1000";
        String query2 = "select * from /QueryRegion0 qr where qr.status = 'active'";
        String query3 = "select * from /QueryRegion0 qr where qr.status = 'active' AND qr.ID > 20000";
        boolean isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
        QueryService qs = null;
        qs = !isBridgeConfiguration ? CacheHelper.getCache().getQueryService() : (SerialQueryAndEntryOpsTest.queryTest.pool != null ? SerialQueryAndEntryOpsTest.queryTest.pool.getQueryService() : CacheHelper.getCache().getQueryService());
        Query query = qs.newQuery(query1);
        SelectResults sr = (SelectResults)query.execute();
        Region region = CacheHelper.getCache().getRegion("/QueryRegion0");
        long regionSize = SerialQueryAndEntryOpsTest.queryTest.maxObjects;
        Log.getLogWriter().info("Region size is: " + regionSize);
        if (regionSize != (long)SerialQueryAndEntryOpsTest.queryTest.maxObjects) {
            throw new TestException("Region size expected to be queryTest.maxObjects i.e. " + SerialQueryAndEntryOpsTest.queryTest.maxObjects + " but was found to be: " + regionSize);
        }
        if (sr.size() != 1) {
            throw new TestException("Unexpected result size  expected: 1 actual :" + sr.size());
        }
        PRPortfolio pfo = (PRPortfolio)sr.asList().get(0);
        if (pfo.ID != 1000) {
            throw new TestException("Query returned wrong result ID Expected :1000 Actual: " + pfo.ID);
        }
        query = qs.newQuery(query2);
        sr = (SelectResults)query.execute();
        if ((long)sr.size() != regionSize / 2L) {
            throw new Exception("Unexpected result size Expected " + regionSize / 2L + " Actual: " + sr.size());
        }
        for (Object obj : sr) {
            pf = (PRPortfolio)obj;
            if (pf.status.equals("active")) continue;
            throw new TestException("Query returned wrong result status Expected 'active' for all objects, but for Portfolio Object id: " + pf.ID + " , status was found to be: " + pf.status);
        }
        query = qs.newQuery(query3);
        sr = (SelectResults)query.execute();
        if ((long)sr.size() != (regionSize - 20000L) / 2L - 1L) {
            throw new Exception("Unexpected result size Expected " + ((regionSize - 20000L) / 2L - 1L) + " Actual: " + sr.size());
        }
        for (Object obj : sr) {
            pf = (PRPortfolio)obj;
            if (!pf.status.equals("active")) {
                throw new TestException("Query returned wrong result, status Expected 'active' for all objects, but for Portfolio Object id: " + pf.ID + " , status was found to be: " + pf.status);
            }
            if (pf.ID > 20000) continue;
            throw new TestException("Query returned wrong result, ID Expected >=20000 for all objects, but found Portfolio Object id: " + pf.ID);
        }
    }

    static void verifyNonPartitionedIndex(Index index, Region region) {
        long keys = region.keySet().size();
        long numKeys = index.getStatistics().getNumberOfKeys();
        long numValues = index.getStatistics().getNumberOfValues();
        SerialQueryAndEntryOpsTest.verifyIndex(index, numKeys, numValues, keys, 2L);
    }

    static void verifyIndex(Index index, long numKeys, long numValues, long keys, long statusIndexExpectedKeys) {
        if (index.getName().startsWith("idCompactRangeIndex") || index.getName().startsWith("idCompactRangeEntryIndex")) {
            Log.getLogWriter().info("Compact index on ID: ");
            if (numKeys != keys) {
                Log.getLogWriter().info("NumKeys: " + numKeys + " LocalKeys: " + keys);
                throw new TestException("Local index keys and local region keys size mismatch for ID index");
            }
            if (numValues != keys) {
                Log.getLogWriter().info("NumValues: " + numValues + " LocalKeys: " + keys);
                throw new TestException("Local index values and local region keys size mismatch for ID index");
            }
        } else if (index.getName().startsWith("statusCompactRangeIndex") || index.getName().startsWith("statusCompactRangeEntryIndex")) {
            Log.getLogWriter().info("Compact index on STATUS: ");
            if (numValues != keys) {
                Log.getLogWriter().info("NumValues: " + numValues + " LocalKeys: " + keys);
                throw new TestException("Local index values and local region keys size mismatch for status index");
            }
            if (numKeys != statusIndexExpectedKeys) {
                Log.getLogWriter().info("numKeys: " + numKeys);
                throw new TestException("Local index keys and local bucket IDs size mismatch for status index");
            }
        } else if (index.getName().startsWith("idRangeIndex") || index.getName().startsWith("idRangeEntryIndex")) {
            Log.getLogWriter().info("Range index on ID: ");
            if (numKeys != keys) {
                Log.getLogWriter().info("NumKeys: " + numKeys + " LocalKeys: " + keys);
                throw new TestException("Local index keys and local region keys size mismatch for ID index");
            }
            if (numValues != 2L * keys) {
                Log.getLogWriter().info("NumValues: " + numValues + " LocalKeys: " + keys);
                throw new TestException("Local index values and local region keys size mismatch for ID index");
            }
        } else if (index.getName().startsWith("statusRangeIndex") || index.getName().startsWith("statusRangeEntryIndex")) {
            Log.getLogWriter().info("Range index on status: ");
            if (numValues != 2L * keys) {
                Log.getLogWriter().info("NumValues: " + numValues + " LocalKeys: " + keys);
                throw new TestException("Local index values and local region keys size mismatch for status index");
            }
            if (numKeys != statusIndexExpectedKeys) {
                Log.getLogWriter().info("numKeys: " + numKeys);
                throw new TestException("Local index keys and local bucket IDs size mismatch for status index");
            }
        }
    }

    static void verifyPartitionedIndex(Index index, Region region) {
        PartitionedRegion region1 = (PartitionedRegion)region;
        Set bIds = ((LocalDataSet)PartitionRegionHelper.getLocalData((Region)region1)).getBucketSet();
        Log.getLogWriter().info("Region contents - Local Bucket IDs for QueryRegion1 ::::" + bIds.toString());
        Log.getLogWriter().info("Bucket ids on this node:  " + bIds.toString());
        for (Object key : bIds) {
            BucketRegion br = region1.getBucketRegion(key);
            if (br != null) continue;
            Log.getLogWriter().info("Server-side region contents  Bucket region not found for key:" + key);
        }
        List bucketIndexes = ((PartitionedIndex)index).getBucketIndexes();
        Log.getLogWriter().info("Bucket indexes size: " + bucketIndexes.size());
        Log.getLogWriter().info("BIds size: " + bIds.size());
        if (bIds.size() != bucketIndexes.size()) {
            Log.getLogWriter().info("Mistmatch occurred in bucket index count and bucket region count, starting a while loop to check if the data is still being populated");
            long initialBucketRegionCount = bIds.size();
            long initialBucketIndexCount = bucketIndexes.size();
            long newBucketIndexCount = -1L;
            long newBucketRegionCount = -1L;
            while (newBucketIndexCount != initialBucketIndexCount || newBucketRegionCount != initialBucketRegionCount) {
                Log.getLogWriter().info("Sleeping for 10 seconds.. ");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                bIds = ((LocalDataSet)PartitionRegionHelper.getLocalData((Region)region1)).getBucketSet();
                bucketIndexes = ((PartitionedIndex)index).getBucketIndexes();
                initialBucketIndexCount = newBucketIndexCount;
                initialBucketRegionCount = newBucketRegionCount;
                newBucketIndexCount = bucketIndexes.size();
                newBucketRegionCount = bIds.size();
                Log.getLogWriter().info("After Sleeping for 5 seconds.. ");
                Log.getLogWriter().info("New bucket index count: " + newBucketIndexCount);
                Log.getLogWriter().info("New Bucket Region Count:  " + newBucketRegionCount);
            }
            if (newBucketIndexCount != newBucketRegionCount) {
                throw new TestException("Bucket regions and bucket indexes size mismatch");
            }
        }
        long numKeys = index.getStatistics().getNumberOfKeys();
        long numValues = index.getStatistics().getNumberOfValues();
        long localKeys = region1.getLocalSize();
        long regionKeysCount = region.keySet().size();
        Log.getLogWriter().info("Region size = " + regionKeysCount);
        Log.getLogWriter().info("NumBuckets = " + bIds.size());
        Log.getLogWriter().info("Local region size = " + localKeys);
        SerialQueryAndEntryOpsTest.verifyIndex(index, numKeys, numValues, localKeys, 2 * bIds.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_verifyIndexSize_QueryData() throws Exception {
        SerialQueryAndEntryOpsTest.queryData();
        Class<SerialQueryAndEntryOpsTest> clazz = SerialQueryAndEntryOpsTest.class;
        synchronized (SerialQueryAndEntryOpsTest.class) {
            Region region;
            if (firstTimeInvocation.compareAndSet(false, true)) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
            Log.getLogWriter().info("Printing all data For all indexes:  ");
            Log.getLogWriter().info("Total indexes::  " + indexes.size());
            for (Index index : indexes) {
                region = index.getRegion();
                long keys = region.keySet().size();
                long numKeys = index.getStatistics().getNumberOfKeys();
                long numValues = index.getStatistics().getNumberOfValues();
                long numInnerKeys = 0L;
                long numInnerValues = 0L;
                if (index instanceof CompactRangeIndex) {
                    Log.getLogWriter().info("Index name : " + index.getName());
                    Log.getLogWriter().info("Index type : CompactRangeIndex ");
                    CompactRangeIndex crIndex = (CompactRangeIndex)index;
                    numInnerKeys = crIndex.getIndexStorage().size();
                    CloseableIterator iterator = null;
                    try {
                        iterator = crIndex.getIndexStorage().iterator(null);
                        while (iterator.hasNext()) {
                            iterator.next();
                            ++numInnerValues;
                        }
                        continue;
                    }
                    finally {
                        if (iterator != null) {
                            iterator.close();
                        }
                        continue;
                    }
                }
                if (index instanceof RangeIndex) {
                    Log.getLogWriter().info("Index name : " + index.getName());
                    Log.getLogWriter().info("Index type : RangeIndex ");
                    RangeIndex rangeIndex = (RangeIndex)index;
                    numInnerKeys = rangeIndex.getValueToEntriesMap().keySet().size();
                    numInnerValues = rangeIndex.getValueToEntriesMap().values().size();
                    continue;
                }
                if (!(index instanceof PartitionedIndex)) continue;
                Log.getLogWriter().info("Index name : " + index.getName());
                Log.getLogWriter().info("Index type : PartitionedIndex ");
                PartitionedIndex pIndex = (PartitionedIndex)index;
                List bucketIndexes = pIndex.getBucketIndexes();
                Log.getLogWriter().info("Bucket indexes size: " + bucketIndexes.size());
                for (Object obj : bucketIndexes) {
                    Index bucketIndex = (Index)obj;
                    if (index instanceof CompactRangeIndex) {
                        CompactRangeIndex crIndex = (CompactRangeIndex)index;
                        numInnerKeys += (long)crIndex.getIndexStorage().size();
                        CloseableIterator iterator = null;
                        try {
                            iterator = crIndex.getIndexStorage().iterator(null);
                            while (iterator.hasNext()) {
                                iterator.next();
                                ++numInnerValues;
                            }
                            continue;
                        }
                        finally {
                            if (iterator != null) {
                                iterator.close();
                            }
                            continue;
                        }
                    }
                    if (!(index instanceof RangeIndex)) continue;
                    RangeIndex rangeIndex = (RangeIndex)index;
                    numInnerKeys += (long)rangeIndex.getValueToEntriesMap().keySet().size();
                    numInnerValues += (long)rangeIndex.getValueToEntriesMap().values().size();
                }
            }
            if (indexes.size() != 8) {
                throw new TestException("Number of indexes was expected to be 8, found: " + indexes.size());
            }
            for (Index index : indexes) {
                region = index.getRegion();
                if (index instanceof PartitionedIndex) {
                    SerialQueryAndEntryOpsTest.verifyPartitionedIndex(index, region);
                    continue;
                }
                SerialQueryAndEntryOpsTest.verifyNonPartitionedIndex(index, region);
            }
            SerialQueryAndEntryOpsTest.queryData();
            return;
        }
    }

    public static void HydraTask_calculateAndVerifyIndexSizesForPR() {
        long[] counterValues = IndexBB.getBB().getSharedCounters().getCounterValues();
        for (int i = 0; i < counterValues.length; ++i) {
            IndexBB.getBB().getSharedCounters().zero(i);
        }
        SerialQueryAndEntryOpsTest.HydraTask_calculateIndexSizesForPR();
        SerialQueryAndEntryOpsTest.HydraTask_verifyIndexSizes();
    }

    public static void HydraTask_calculateIndexSizesForPR() {
        long statusRangeNumBuckets = 0L;
        long statusCompactRangeNumBuckets = 0L;
        long idRangeNumBuckets = 0L;
        long idCompactNumBuckets = 0L;
        long idRangeNumKeys = 0L;
        long idCompactRangeNumKeys = 0L;
        long statusRangeNumValues = 0L;
        long statusCompactRangeNumValues = 0L;
        long idRangeNumValues = 0L;
        long idCompactRangeNumValues = 0L;
        Set regions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Printing all root regions in the Cache: " + regions.toString());
        Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
        for (Index index : indexes) {
            long numKeys = 0L;
            long numValues = 0L;
            Region region = index.getRegion();
            SharedCounters counters = IndexBB.getBB().getSharedCounters();
            if (index instanceof PartitionedIndex) {
                List bucketIndexes = ((PartitionedIndex)index).getBucketIndexes();
                Log.getLogWriter().info("NumBuckets = " + bucketIndexes.size());
                if (index.getName().startsWith("idCompactRangeIndex")) {
                    counters.add(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_NUMBUCKETS, bucketIndexes.size());
                    Log.getLogWriter().info("NUM Buckets counter: " + counters.read(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_NUMBUCKETS));
                    idCompactNumBuckets += (long)bucketIndexes.size();
                } else if (index.getName().startsWith("statusCompactRangeIndex")) {
                    counters.add(IndexBB.NUM_PR_COMPACTRANGE_STATUS_INDEX_NUMBUCKETS, bucketIndexes.size());
                    statusCompactRangeNumBuckets += (long)bucketIndexes.size();
                } else if (index.getName().startsWith("idRangeIndex")) {
                    counters.add(IndexBB.NUM_PR_RANGE_ID_INDEX_NUMBUCKETS, bucketIndexes.size());
                    idRangeNumBuckets += (long)bucketIndexes.size();
                } else if (index.getName().startsWith("statusRangeIndex")) {
                    counters.add(IndexBB.NUM_PR_RANGE_STATUS_INDEX_NUMBUCKETS, bucketIndexes.size());
                    statusRangeNumBuckets += (long)bucketIndexes.size();
                }
                numKeys = index.getStatistics().getNumberOfKeys();
                numValues = index.getStatistics().getNumberOfValues();
                long regionKeysCount = region.keySet().size();
                Log.getLogWriter().info("Region size = " + regionKeysCount);
                if (index.getName().startsWith("idCompactRangeIndex")) {
                    Log.getLogWriter().info("IndexName: " + index.getName());
                    Log.getLogWriter().info("IndexName: " + index.getName() + "  numKeys: " + numKeys);
                    Log.getLogWriter().info("IndexName: " + index.getName() + "  numValues: " + numValues);
                    Log.getLogWriter().info("IndexName: " + index.getName() + "  bucketSize" + bucketIndexes.size());
                    counters.add(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_KEYS, numKeys);
                    counters.add(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_VALUES, numValues);
                    counters.add(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_NUMBUCKETS, bucketIndexes.size());
                    idCompactRangeNumKeys += numKeys;
                    idCompactRangeNumValues += numValues;
                    continue;
                }
                if (index.getName().startsWith("statusCompactRangeIndex")) {
                    Log.getLogWriter().info("IndexName: " + index.getName());
                    Log.getLogWriter().info("IndexName: statusCompactRangeIndex numKeys: " + numKeys);
                    Log.getLogWriter().info("IndexName: statusCompactRangeIndex numValues: " + numValues);
                    Log.getLogWriter().info("IndexName: statusCompactRangeIndex bucketSize" + bucketIndexes.size());
                    counters.add(IndexBB.NUM_PR_COMPACTRANGE_STATUS_INDEX_VALUES, numValues);
                    statusCompactRangeNumValues += numValues;
                    continue;
                }
                if (index.getName().startsWith("idRangeIndex")) {
                    Log.getLogWriter().info("IndexName: " + index.getName());
                    Log.getLogWriter().info("IndexName: idRangeIndex : numKeys: " + numKeys);
                    Log.getLogWriter().info("IndexName: idRangeIndex : numValues: " + numValues);
                    Log.getLogWriter().info("IndexName: idRangeIndex : bucketSize" + bucketIndexes.size());
                    counters.add(IndexBB.NUM_PR_RANGE_ID_INDEX_KEYS, numKeys);
                    counters.add(IndexBB.NUM_PR_RANGE_ID_INDEX_VALUES, numValues);
                    idRangeNumKeys += numKeys;
                    idRangeNumValues += numValues;
                    continue;
                }
                if (!index.getName().startsWith("statusRangeIndex")) continue;
                Log.getLogWriter().info("IndexName: " + index.getName());
                Log.getLogWriter().info("IndexName: statusRangeIndex :  numKeys: " + numKeys);
                Log.getLogWriter().info("IndexName: statusRangeIndex : numValues: " + numValues);
                Log.getLogWriter().info("IndexName: statusRangeIndex  : bucketSize" + bucketIndexes.size());
                counters.add(IndexBB.NUM_PR_RANGE_STATUS_INDEX_VALUES, numValues);
                statusRangeNumValues += numValues;
                continue;
            }
            numKeys = index.getStatistics().getNumberOfKeys();
            numValues = index.getStatistics().getNumberOfValues();
        }
        Log.getLogWriter().info("*******PRINTING BUCKET DATA FOR THIS VM***********");
        Log.getLogWriter().info("* statusRangeNumBuckets = " + statusRangeNumBuckets);
        Log.getLogWriter().info("*statusCompactRangeNumBuckets = " + statusCompactRangeNumBuckets);
        Log.getLogWriter().info("*idRangeNumBuckets = " + idRangeNumBuckets);
        Log.getLogWriter().info("*idCompactNumBuckets = " + idCompactNumBuckets);
        Log.getLogWriter().info("*****************************************************");
        Log.getLogWriter().info("*idRangeNumKeys = " + idRangeNumKeys);
        Log.getLogWriter().info("*idCompactRangeNumKeys = " + idCompactRangeNumKeys);
        Log.getLogWriter().info("*****************************************************");
        Log.getLogWriter().info("*statusRangeNumValues = " + statusRangeNumValues);
        Log.getLogWriter().info("*statusCompactRangeNumValues = " + statusCompactRangeNumValues);
        Log.getLogWriter().info("*idRangeNumValues = " + idRangeNumValues);
        Log.getLogWriter().info("*idCompactRangeNumValues = " + idCompactRangeNumValues);
        Log.getLogWriter().info("*******END PRINTING BUCKET DATA FOR THIS VM***********");
    }

    public static void verifyIndexSizes(Index index, Region region) {
        long numKeys = index.getStatistics().getNumberOfKeys();
        long numValues = index.getStatistics().getNumberOfValues();
        long numUpdates = index.getStatistics().getNumUpdates();
        long regionKeysCount = region.keySet().size();
        Log.getLogWriter().info(index.getName() + " IndexName = " + index.getName());
        Log.getLogWriter().info(index.getName() + " NumKeys = " + numKeys);
        Log.getLogWriter().info(index.getName() + " NumValues = " + numValues);
        Log.getLogWriter().info(index.getName() + " NumUpdates = " + numUpdates);
        Log.getLogWriter().info(index.getName() + " RegionKeyCount = " + regionKeysCount);
        if (index.getName().startsWith("idCompactRangeIndex")) {
            if (numKeys != regionKeysCount && numValues != regionKeysCount) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
            if (numUpdates != regionKeysCount) {
                throw new TestException("The num updates in index did not match with expectations. Expected = " + regionKeysCount + " Actual = " + numUpdates);
            }
        } else if (index.getName().startsWith("statusCompactRangeIndex")) {
            if (numKeys != 2L && numValues != regionKeysCount) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
            if (numUpdates != regionKeysCount) {
                throw new TestException("The num updates in index did not match with expectations. Expected = " + regionKeysCount + " Actual = " + numUpdates);
            }
        } else if (index.getName().startsWith("idRangeIndex")) {
            if (numKeys != regionKeysCount && numValues != regionKeysCount * 2L) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
            if (numUpdates != 2L * regionKeysCount) {
                throw new TestException("The num updates in index did not match with expectations. Expected = " + 2L * regionKeysCount + " Actual = " + numUpdates);
            }
        } else if (index.getName().startsWith("statusRangeIndex")) {
            if (numKeys != 2L && numValues != regionKeysCount * 2L) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
            if (numUpdates != 2L * regionKeysCount) {
                throw new TestException("The num updates in index did not match with expectations. Expected = " + 2L * regionKeysCount + " Actual = " + numUpdates);
            }
        }
    }

    public static void verifyIndexSizes_PR(PartitionedIndex index, PartitionedRegion region) {
        SharedCounters counters = IndexBB.getBB().getSharedCounters();
        long numKeys = 0L;
        long numValues = 0L;
        long numBuckets = 0L;
        Set regions = CacheHelper.getCache().rootRegions();
        long keysPerRegion = region.keySet().size();
        long overallRegionKeysCount_withCopies = 0L;
        for (Region rgn : regions) {
            boolean isOverflowAndIndexIsRangeIndex;
            int redundantCopies = ((PartitionedRegion)rgn).getPartitionAttributes().getRedundantCopies();
            Log.getLogWriter().info("Before if  statement: overallRegionKeysCount_withCopies = " + overallRegionKeysCount_withCopies);
            Log.getLogWriter().info("Region name = " + rgn.getName());
            Log.getLogWriter().info("redundant copies = " + redundantCopies);
            Log.getLogWriter().info("RegionName: " + rgn.getName());
            EvictionAttributes evAttr = rgn.getAttributes().getEvictionAttributes();
            Log.getLogWriter().info("EvAttr: " + evAttr);
            Log.getLogWriter().info("evAttr.getAlgorithm() " + evAttr.getAlgorithm().toString());
            Log.getLogWriter().info("evAttr.getAction() " + evAttr.getAction().toString());
            boolean isOverflow = false;
            if (evAttr.getAlgorithm() != null && evAttr.getAction() != null && !evAttr.getAlgorithm().equals(EvictionAlgorithm.NONE) && !evAttr.getAction().equals(EvictionAction.NONE)) {
                isOverflow = true;
            }
            Log.getLogWriter().info("RegionName: " + rgn.getName() + " isOverflow:" + isOverflow);
            boolean bl = isOverflowAndIndexIsRangeIndex = isOverflow && (index.getName().contains("statusRangeIndex") || index.getName().contains("idRangeIndex"));
            if (!isOverflowAndIndexIsRangeIndex) {
                Log.getLogWriter().info("Inside if statement: overallRegionKeysCount_withCopies = " + overallRegionKeysCount_withCopies);
                Log.getLogWriter().info("Region name = " + rgn.getName());
                Log.getLogWriter().info("redundant copies = " + redundantCopies);
                overallRegionKeysCount_withCopies += keysPerRegion * (long)(redundantCopies + 1);
            }
            Log.getLogWriter().info("After if  statement: overallRegionKeysCount_withCopies = " + overallRegionKeysCount_withCopies);
            Log.getLogWriter().info("Region name = " + rgn.getName());
            Log.getLogWriter().info("redundant copies = " + redundantCopies);
        }
        if (index.getName().startsWith("idCompactRangeIndex")) {
            numKeys = counters.read(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_KEYS);
            numValues = counters.read(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_VALUES);
            numBuckets = counters.read(IndexBB.NUM_PR_COMPACTRANGE_ID_INDEX_NUMBUCKETS);
            Log.getLogWriter().info(index.getName() + " numKeys: " + numKeys);
            Log.getLogWriter().info(index.getName() + " numValues: " + numValues);
            Log.getLogWriter().info(index.getName() + " numBuckets: " + numBuckets);
            Log.getLogWriter().info("RegionKeysCount: " + overallRegionKeysCount_withCopies);
            if (numKeys != overallRegionKeysCount_withCopies && numValues != overallRegionKeysCount_withCopies) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
        } else if (index.getName().startsWith("statusCompactRangeIndex")) {
            numValues = counters.read(IndexBB.NUM_PR_COMPACTRANGE_STATUS_INDEX_VALUES);
            numBuckets = counters.read(IndexBB.NUM_PR_COMPACTRANGE_STATUS_INDEX_NUMBUCKETS);
            Log.getLogWriter().info("statusCompactRangeIndex numValues: " + numValues);
            Log.getLogWriter().info("statusCompactRangeIndex numBuckets: " + numBuckets);
            Log.getLogWriter().info("RegionKeysCount: " + overallRegionKeysCount_withCopies);
            if (numValues != overallRegionKeysCount_withCopies) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
        } else if (index.getName().startsWith("idRangeIndex")) {
            numKeys = counters.read(IndexBB.NUM_PR_RANGE_ID_INDEX_KEYS);
            numValues = counters.read(IndexBB.NUM_PR_RANGE_ID_INDEX_VALUES);
            numBuckets = counters.read(IndexBB.NUM_PR_RANGE_ID_INDEX_NUMBUCKETS);
            Log.getLogWriter().info(index.getName() + " numKeys: " + numKeys);
            Log.getLogWriter().info(index.getName() + " numValues: " + numValues);
            Log.getLogWriter().info(index.getName() + " numBuckets: " + numBuckets);
            Log.getLogWriter().info("RegionKeysCount: " + overallRegionKeysCount_withCopies);
            if (numKeys != overallRegionKeysCount_withCopies && numValues != overallRegionKeysCount_withCopies * 2L) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
        } else if (index.getName().startsWith("statusRangeIndex")) {
            numValues = counters.read(IndexBB.NUM_PR_RANGE_STATUS_INDEX_VALUES);
            numBuckets = counters.read(IndexBB.NUM_PR_RANGE_STATUS_INDEX_NUMBUCKETS);
            Log.getLogWriter().info(index.getName() + " numValues: " + numValues);
            Log.getLogWriter().info(index.getName() + " numBuckets: " + numBuckets);
            Log.getLogWriter().info("RegionKeysCount: " + overallRegionKeysCount_withCopies);
            if (numValues != overallRegionKeysCount_withCopies * 2L) {
                throw new TestException("The num Keys and values in index did not match with expectations");
            }
        }
    }

    public static void HydraTask_verifyIndexSizes() {
        Set regions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Printing all root regions in the Cache: " + regions.toString());
        Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
        for (Index index : indexes) {
            Region region = index.getRegion();
            if (region instanceof PartitionedRegion) {
                SerialQueryAndEntryOpsTest.verifyIndexSizes_PR((PartitionedIndex)index, (PartitionedRegion)region);
                continue;
            }
            SerialQueryAndEntryOpsTest.verifyIndexSizes(index, region);
        }
        Log.getLogWriter().info("Printing all indexes in the Cache: " + indexes.toString());
        for (Index index : indexes) {
            Log.getLogWriter().info("Index name " + index.getName());
            Log.getLogWriter().info("Index canonicalized from clause " + index.getCanonicalizedFromClause());
            Log.getLogWriter().info("Index canonicalized index expression " + index.getCanonicalizedIndexedExpression());
            Log.getLogWriter().info("Index canonicalized projection attributes " + index.getCanonicalizedProjectionAttributes());
        }
    }

    public static void HydraTask_getQueryResultsWithIndexes() {
        serialTest.getQueryResultsWithIndexes();
    }

    public static void HydraTask_verifyQueryResultsWithAndWithoutIndexes() {
        serialTest.verifyQueryResultsWithAndWithoutIndexes();
    }

    protected void getQueryResultsWithIndexes() {
        boolean isIndexValidation = TestConfig.tab().booleanAt(QueryPrms.isIndexUsageValidation, false);
        this.r = new SelectResults[this.numOfRegions][this.queries.length][2];
        int threshold = 30000;
        try {
            String indexType = TestConfig.tab().stringAt(IndexPrms.indexType, "compactRange");
            if (!indexType.equals("all")) {
                this.queryToIndexMap.put(2, "idCompactRangeIndex");
                this.queryToIndexMap.put(3, "statusCompactRangeIndex");
            }
            for (int i = 0; i < this.queries.length; ++i) {
                QueryObserverImplLocal qol = new QueryObserverImplLocal();
                QueryObserverHolder.setInstance((QueryObserver)qol);
                for (int regionNum = 0; regionNum < this.numOfRegions; ++regionNum) {
                    Query query = CacheHelper.getCache().getQueryService().newQuery(SELECT_STRING + "/QueryRegion" + regionNum + this.queries[i]);
                    String regionName = "/QueryRegion" + regionNum;
                    Region region = CacheHelper.getCache().getRegion(regionName);
                    Log.getLogWriter().info("Obtaining index " + this.queryToIndexMap.get(i) + " on Region: " + regionName);
                    Index index = CacheHelper.getCache().getQueryService().getIndex(region, this.queryToIndexMap.get(i) + regionNum);
                    Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
                    if (index == null) {
                        Log.getLogWriter().info("Encountered BUG: 44192 while Obtaining index " + this.queryToIndexMap.get(i) + " on Region: " + region.getFullPath());
                        Log.getLogWriter().info("Encountered BUG: 44192 while Obtaining index " + this.queryToIndexMap.get(i) + " on Region: " + region.getName());
                        Log.getLogWriter().info("Encountered BUG: 44192 while Obtaining index " + this.queryToIndexMap.get(i) + " on Region: " + regionName);
                        Log.getLogWriter().info("********************Printing all indexes in the Cache: " + indexes.toString());
                        if (indexes != null) {
                            for (Index indexItr : indexes) {
                                Log.getLogWriter().info("Index name " + indexItr.getName());
                                if (indexItr.getName().equals(this.queryToIndexMap.get(i) + regionNum)) {
                                    index = indexItr;
                                }
                                Log.getLogWriter().info("Index type " + indexItr.getClass().getName());
                                Log.getLogWriter().info("Index canonicalized from clause " + indexItr.getCanonicalizedFromClause());
                                Log.getLogWriter().info("Index canonicalized index expression " + indexItr.getCanonicalizedIndexedExpression());
                                Log.getLogWriter().info("Index canonicalized projection attributes " + indexItr.getCanonicalizedProjectionAttributes());
                            }
                        }
                    }
                    if (index == null) {
                        throw new TestException("Could not find index with name: " + this.queryToIndexMap.get(i));
                    }
                    if (!(index instanceof PartitionedIndex)) {
                        long totalUses = index.getStatistics().getTotalUses();
                        this.r[regionNum][i][0] = (SelectResults)query.execute();
                        if (index.getStatistics().getTotalUses() > totalUses) continue;
                        throw new TestException("Total use count is expected to be increased but found to be reduced or unaffected");
                    }
                    this.r[regionNum][i][0] = (SelectResults)query.execute();
                }
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyQueryResultsWithAndWithoutIndexes() {
        Set regions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Printing all root regions in the Cache: " + regions.toString());
        SerialQueryAndEntryOpsTest serialQueryAndEntryOpsTest = this;
        synchronized (serialQueryAndEntryOpsTest) {
            for (Region region : regions) {
                Log.getLogWriter().info("Region name " + region.getName());
                Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
                Log.getLogWriter().info("All indexes on region: " + region.getName() + " Indexes : =" + indexes.toString());
                Log.getLogWriter().info("Printing all indexes in the Cache: " + indexes.toString());
                if (indexes == null) continue;
                for (Index index : indexes) {
                    Log.getLogWriter().info("Index name " + index.getName());
                    Log.getLogWriter().info("Index canonicalized from clause " + index.getCanonicalizedFromClause());
                    Log.getLogWriter().info("Index canonicalized index expression " + index.getCanonicalizedIndexedExpression());
                    Log.getLogWriter().info("Index canonicalized projection attributes " + index.getCanonicalizedProjectionAttributes());
                    CacheHelper.getCache().getQueryService().removeIndex(index);
                }
            }
        }
        try {
            for (int i = 0; i < this.queries.length; ++i) {
                QueryObserverImplLocal qol = new QueryObserverImplLocal();
                QueryObserverHolder.setInstance((QueryObserver)qol);
                Query query = CacheHelper.getCache().getQueryService().newQuery(SELECT_STRING + "/QueryRegion0" + this.queries[i]);
                for (int regionNum = 0; regionNum < this.numOfRegions; ++regionNum) {
                    this.r[regionNum][i][1] = (SelectResults)query.execute();
                }
                if (qol.indexName == null) continue;
                throw new TestException("The query unexpectedly used an index: " + qol.indexName);
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
        }
        for (int regionNum = 0; regionNum < this.numOfRegions; ++regionNum) {
            if (CacheUtils.compareResultsOfWithAndWithoutIndex((SelectResults[][])this.r[regionNum])) continue;
            throw new TestException("The results with and without indexes did not match");
        }
    }

    public static void HydraTask_stopStartVMs_bridgeVMs() {
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        Object[] tmpArr = StopStartVMs.getOtherVMsWithExclude(numVMsToStop, "locator");
        List vms = (List)tmpArr[0];
        List stopModes = (List)tmpArr[1];
        for (int i = 0; i < vms.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)vms.get(i);
            PRObserver.initialize(info.getVmid());
        }
        StopStartVMs.stopStartVMs(vms, stopModes);
    }

    public static void HydraTask_stopStartVMs_queryPRData() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SerialQueryAndEntryOpsTest.HydraTask_stopStartVMs_bridgeVMs();
        try {
            SerialQueryAndEntryOpsTest.HydraTask_verifyIndexSize_QueryData();
        }
        catch (QueryInvocationTargetException e) {
            throw new TestException("Unexpectedly Caught QueryInvocationTargetException" + (Object)((Object)e));
        }
        catch (Exception e) {
            throw new TestException("Unexpectedly Caught " + e);
        }
    }

    public static void HydraTask_stopVM_verifyIndex_queryPRData_startVM() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        Object[] tmpArr = StopStartVMs.getOtherVMsWithExclude(numVMsToStop, "edge");
        List vms = (List)tmpArr[0];
        List stopModes = (List)tmpArr[1];
        for (int i = 0; i < vms.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)vms.get(i);
            PRObserver.initialize(info.getVmid());
        }
        StopStartVMs.stopVMs(vms, stopModes);
        try {
            Region region = CacheHelper.getCache().getRegion("/QueryRegion0");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ParRegUtil.doRebalance();
            SerialQueryAndEntryOpsTest.HydraTask_verifyIndexSize_QueryData();
        }
        catch (QueryInvocationTargetException e) {
            throw new TestException("Unexpectedly Caught QueryInvocationTargetException" + (Object)((Object)e));
        }
        catch (Exception e) {
            throw new TestException("Unexpectedly Caught " + e);
        }
        StopStartVMs.startVMs(vms);
    }

    static class QueryObserverImplLocal
    extends QueryObserverAdapter {
        String indexName = null;

        QueryObserverImplLocal() {
        }

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexName = index.getName();
            Log.getLogWriter().info("BeforeIndexLoopkup :" + index.getName());
        }

        public void afterIndexLookup(Collection results) {
        }

        public void beforeIndexLookup(Index index, int lowerBoundOperator, Object lowerBoundKey, int upperBoundOperator, Object upperBoundKey, Set NotEqualKeys) {
            this.indexName = index.getName();
            Log.getLogWriter().info("BeforeIndexLoopkup :" + index.getName());
        }
    }

    static class QueryObserverImplBB
    extends QueryObserverAdapter {
        IndexValidator iv = null;

        QueryObserverImplBB() {
        }

        public void beforeIndexLookup(Index index, int oper, Object key) {
            Log.getLogWriter().info("BeforeIndexLoopkup :" + index.getName());
            IndexBB.getBB();
            IndexValidator iv = IndexBB.getIndexValidatorObject();
            iv.setIndexName(index.getName());
            IndexBB.getBB();
            IndexBB.putIndexValidator(iv);
        }

        public void afterIndexLookup(Collection results) {
        }

        public void beforeIndexLookup(Index index, int lowerBoundOperator, Object lowerBoundKey, int upperBoundOperator, Object upperBoundKey, Set NotEqualKeys) {
            Log.getLogWriter().info("BeforeIndexLoopkup :" + index.getName());
            IndexBB.getBB();
            IndexValidator iv = IndexBB.getIndexValidatorObject();
            iv.setIndexName(index.getName());
            IndexBB.getBB();
            IndexBB.putIndexValidator(iv);
        }
    }
}

