/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.LogWriter;
import hydra.ConfigLexer;
import hydra.FileUtil;
import hydra.HydraConfigException;
import hydra.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import perffmwk.StatConfig;
import perffmwk.StatConfigException;
import perffmwk.TrimSpec;

public class TrimSpecParser {
    public static void parseFile(String fn, StatConfig statconfig) throws FileNotFoundException {
        TrimSpecParser.parseFile(fn, statconfig, false);
    }

    public static void parseFile(String fn, StatConfig statconfig, boolean verbose) throws FileNotFoundException {
        TrimSpecParser parser = new TrimSpecParser();
        if (verbose) {
            TrimSpecParser.log().info("\n/////  BEGIN " + fn);
        }
        String text = parser.getText(fn);
        if (verbose) {
            TrimSpecParser.log().info("\n" + text);
        }
        ConfigLexer lex = new ConfigLexer();
        Vector tokens = ConfigLexer.tokenize(text);
        if (tokens == null) {
            TrimSpecParser.log().warning("Trim specification file " + fn + " is empty");
            return;
        }
        parser.parse(statconfig, tokens);
        if (verbose) {
            TrimSpecParser.log().info("\n/////  END   " + fn);
        }
    }

    private void parse(StatConfig statconfig, Vector tokens) {
        Vector<String> stmt = new Vector<String>();
        ListIterator i = tokens.listIterator();
        block2: while (i.hasNext()) {
            while (i.hasNext()) {
                String token = (String)i.next();
                if (token.equals(";")) {
                    if (stmt.size() <= 0) continue;
                    try {
                        this.parseStmt(statconfig, stmt);
                    }
                    catch (StatConfigException e) {
                        e.printStackTrace();
                        throw new StatConfigException("Malformed statement:" + this.reconstruct(stmt), (Exception)((Object)e));
                    }
                    stmt.setSize(0);
                    continue block2;
                }
                stmt.add(token);
            }
        }
        if (stmt.size() > 0) {
            throw new StatConfigException("Missing semicolon delimiter (;) at end of statement:" + this.reconstructMostly(stmt));
        }
    }

    private void parseStmt(StatConfig statconfig, Vector stmt) {
        String token = (String)stmt.elementAt(0);
        if (!token.equalsIgnoreCase("trimspec")) {
            throw new StatConfigException("Unknown statement type");
        }
        this.parseTrimSpec(statconfig, stmt);
    }

    private void parseTrimSpec(StatConfig statconfig, Vector stmt) {
        TrimSpec trimspec = this.parseTrimSpec(stmt);
        statconfig.addTrimSpec(trimspec);
    }

    private TrimSpec parseTrimSpec(Vector stmt) {
        ListIterator i = stmt.listIterator();
        i.next();
        String name = this.parseJavaIdentifier(i);
        TrimSpec trimspec = new TrimSpec(name);
        this.parseTrimSpecParams(i, trimspec);
        return trimspec;
    }

    private void parseTrimSpecParams(ListIterator i, TrimSpec trimspec) {
        while (i.hasNext()) {
            Long timestamp;
            String time;
            String token = (String)i.next();
            if (token.equalsIgnoreCase("start")) {
                time = this.parseTime(i);
                timestamp = this.parseTimestamp(i);
                trimspec.setStart(time, timestamp);
                continue;
            }
            if (token.equalsIgnoreCase("end")) {
                time = this.parseTime(i);
                timestamp = this.parseTimestamp(i);
                trimspec.setEnd(time, timestamp);
                continue;
            }
            throw new StatConfigException("Unexpected token: " + token);
        }
    }

    private String parseTime(ListIterator i) {
        this.parseEquals(i);
        try {
            return (String)i.next() + " " + (String)i.next() + " " + (String)i.next();
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Date is missing or incomplete");
        }
    }

    private Long parseTimestamp(ListIterator i) {
        try {
            String token = (String)i.next();
            if (token.startsWith("(") && token.endsWith(")")) {
                String timestamp = token.substring(1, token.length() - 1);
                return this.parseLong(timestamp);
            }
            i.previous();
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private Long parseLong(String token) {
        try {
            return Long.valueOf(token);
        }
        catch (NumberFormatException e) {
            String s = "Attempt to set to non-numeric value: " + token;
            throw new HydraConfigException(s);
        }
    }

    private String parseJavaIdentifier(ListIterator i) {
        try {
            String token = (String)i.next();
            return token;
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Missing java identifier");
        }
    }

    private void parseEquals(ListIterator i) {
        try {
            String token = (String)i.next();
            if (!token.equals("=")) {
                throw new StatConfigException("Missing equals (=) operator, unexpected token: " + token);
            }
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Missing equals (=) operator");
        }
    }

    private String reconstruct(Vector stmt) {
        return this.reconstructMostly(stmt) + ";";
    }

    private String reconstructMostly(Vector stmt) {
        StringBuffer buf = new StringBuffer(100);
        ListIterator i = stmt.listIterator();
        while (i.hasNext()) {
            buf.append(" ");
            buf.append((String)i.next());
        }
        return buf.toString();
    }

    private String getText(String fn) throws FileNotFoundException {
        try {
            return FileUtil.getText(fn);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StatConfigException("Error reading trim specification file " + fn, e);
        }
    }

    public static void main(String[] args) {
        Log.createLogWriter("parser", "info");
        String fn = args[0];
        StatConfig statconfig = new StatConfig(System.getProperty("user.dir"));
        try {
            TrimSpecParser.parseFile(fn, statconfig);
            System.out.println(statconfig);
        }
        catch (FileNotFoundException e) {
            System.out.println("Trim specification file " + fn + " not found.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (StatConfigException e) {
            System.out.println("Error in trim specification file: " + fn);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

