/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.LogWriter;
import hydra.ConfigLexer;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.TestConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import perffmwk.Expr;
import perffmwk.RuntimeStatSpec;
import perffmwk.StatConfig;
import perffmwk.StatConfigException;
import perffmwk.StatSpec;
import perffmwk.StatSpecId;

public class StatSpecParser {
    public static RuntimeStatSpec parseRuntimeStatSpec(String spec) {
        ConfigLexer lex = new ConfigLexer();
        Vector stmt = ConfigLexer.tokenize(spec);
        StatSpecParser parser = new StatSpecParser();
        RuntimeStatSpec statspec = parser.parseRuntimeStatSpec(stmt);
        return statspec;
    }

    public static void parseFile(String fn, StatConfig statconfig) throws FileNotFoundException {
        StatSpecParser.parseFile(fn, statconfig, false);
    }

    public static void parseFile(String fn, StatConfig statconfig, boolean verbose) throws FileNotFoundException {
        StatSpecParser parser = new StatSpecParser();
        if (verbose) {
            StatSpecParser.log().info("\n/////  BEGIN " + fn);
        }
        String text = parser.getText(fn);
        if (verbose) {
            StatSpecParser.log().info("\n" + text);
        }
        ConfigLexer lex = new ConfigLexer();
        Vector tokens = ConfigLexer.tokenize(text);
        if (tokens == null) {
            StatSpecParser.log().warning("Statistics specification file " + fn + " is empty");
            return;
        }
        parser.parse(statconfig, tokens);
        if (verbose) {
            StatSpecParser.log().info("\n/////  END   " + fn);
        }
    }

    private void parse(StatConfig statconfig, Vector tokens) {
        Vector<String> stmt = new Vector<String>();
        ListIterator i = tokens.listIterator();
        block4: while (i.hasNext()) {
            while (i.hasNext()) {
                String token = (String)i.next();
                if (token.equals(";")) {
                    if (stmt.size() <= 0) continue;
                    try {
                        this.parseStmt(statconfig, stmt);
                    }
                    catch (StatConfigException e) {
                        e.printStackTrace();
                        throw new StatConfigException("Malformed statement:" + this.reconstruct(stmt), (Exception)((Object)e));
                    }
                    stmt.setSize(0);
                    continue block4;
                }
                try {
                    token = this.expandSystemProperties(statconfig, token);
                }
                catch (StatConfigException e) {
                    stmt.add(token);
                    stmt.add("...");
                    e.printStackTrace();
                    throw new StatConfigException("Malformed statement:" + this.reconstruct(stmt), (Exception)((Object)e));
                }
                stmt.add(token);
            }
        }
        if (stmt.size() > 0) {
            throw new StatConfigException("Missing semicolon delimiter (;) at end of statement:" + this.reconstructMostly(stmt));
        }
    }

    private void parseStmt(StatConfig statconfig, Vector stmt) {
        String token = (String)stmt.elementAt(0);
        if (token.equalsIgnoreCase("include")) {
            this.parseInclude(statconfig, stmt);
        } else if (token.equalsIgnoreCase("includeIfPresent")) {
            this.parseIncludeIfPresent(statconfig, stmt);
        } else if (token.equalsIgnoreCase("statspec")) {
            this.parseStatSpec(statconfig, stmt);
        } else if (token.equalsIgnoreCase("expr")) {
            this.parseExpr(statconfig, stmt);
        } else {
            throw new StatConfigException("Unknown statement type: " + token);
        }
    }

    private void parseInclude(StatConfig statconfig, Vector stmt) {
        ListIterator i = stmt.listIterator();
        i.next();
        String fn = this.parseIdentifier(i);
        if (i.hasNext()) {
            throw new StatConfigException("Missing ; at end of include statement: " + stmt);
        }
        try {
            try {
                fn = EnvHelper.expandEnvVars(fn);
            }
            catch (HydraConfigException e) {
                fn = EnvHelper.expandEnvVars(fn, TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription());
            }
            StatSpecParser.parseFile(fn, statconfig);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (StatConfigException e) {
            throw new StatConfigException("Error in statistics specification file: " + fn, (Exception)((Object)e));
        }
    }

    private void parseIncludeIfPresent(StatConfig statconfig, Vector stmt) {
        ListIterator i = stmt.listIterator();
        i.next();
        String fn = this.parseIdentifier(i);
        if (i.hasNext()) {
            throw new StatConfigException("Missing ; at end of includeIfPresent statement: " + stmt);
        }
        try {
            try {
                fn = EnvHelper.expandEnvVars(fn);
            }
            catch (HydraConfigException e) {
                fn = EnvHelper.expandEnvVars(fn, TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription());
            }
            StatSpecParser.parseFile(fn, statconfig);
        }
        catch (FileNotFoundException e) {
        }
        catch (StatConfigException e) {
            throw new StatConfigException("Error in statistics specification file: " + fn, (Exception)((Object)e));
        }
    }

    private void parseStatSpec(StatConfig statconfig, Vector stmt) {
        StatSpec statspec = this.parseStatSpec(stmt);
        statspec.setStatConfig(statconfig);
        statconfig.addStatSpec(statspec);
    }

    private void parseExpr(StatConfig statconfig, Vector stmt) {
        Expr expr = this.parseExprParts(statconfig, stmt);
        expr.setStatConfig(statconfig);
        statconfig.addStatSpec(expr);
    }

    private RuntimeStatSpec parseRuntimeStatSpec(Vector stmt) {
        ListIterator i = stmt.listIterator();
        RuntimeStatSpec statspec = new RuntimeStatSpec();
        this.parseStatSpecId(i, statspec);
        this.parseStatSpecParams(i, statspec);
        return statspec;
    }

    private StatSpec parseStatSpec(Vector stmt) {
        ListIterator i = stmt.listIterator();
        i.next();
        String name = this.parseJavaIdentifier(i);
        StatSpec statspec = new StatSpec(name);
        this.parseStatSpecId(i, statspec);
        this.parseStatSpecParams(i, statspec);
        return statspec;
    }

    private Expr parseExprParts(StatConfig statconfig, Vector stmt) {
        ListIterator i = stmt.listIterator();
        i.next();
        String name = this.parseJavaIdentifier(i);
        Expr expr = new Expr(name);
        this.parseEquals(i);
        String numerator = this.parseJavaIdentifier(i);
        StatSpec numeratorSpec = statconfig.getStatSpec(numerator);
        if (numeratorSpec == null) {
            String s = "Expr " + name + " cannot find statspec " + numerator;
            throw new HydraConfigException(s);
        }
        expr.setNumerator(numeratorSpec);
        this.parseDiv(i);
        String denominator = this.parseJavaIdentifier(i);
        StatSpec denominatorSpec = statconfig.getStatSpec(denominator);
        if (denominatorSpec == null) {
            String s = "Expr " + name + " cannot find statspec " + denominator;
            throw new HydraConfigException(s);
        }
        expr.setDenominator(denominatorSpec);
        if (!i.hasNext()) {
            String s = "Expr " + name + " is missing " + "ops";
            throw new HydraConfigException(s);
        }
        String token = (String)i.next();
        if (!token.equalsIgnoreCase("ops")) {
            throw new StatConfigException("Unexpected token: " + token);
        }
        this.parseOpsParam(i, expr);
        return expr;
    }

    private void parseStatSpecId(ListIterator i, StatSpec statspec) {
        StatSpecId statspecid = new StatSpecId();
        statspecid.setSystemName(this.parseStatSpecIdComponent(i, statspec, "system name", true));
        statspecid.setTypeName(this.parseStatSpecIdComponent(i, statspec, "type name", true));
        statspecid.setInstanceName(this.parseStatSpecIdComponent(i, statspec, "instance name", true));
        statspecid.setStatName(this.parseStatSpecIdComponent(i, statspec, "stat name", true));
        statspec.setId(statspecid);
    }

    private String parseStatSpecIdComponent(ListIterator i, StatSpec statspec, String component, boolean required) {
        String s;
        block3: {
            s = null;
            try {
                s = (String)i.next();
                if (!s.equalsIgnoreCase("filter") && !s.equalsIgnoreCase("combine") && !s.equalsIgnoreCase("ops") && !s.equalsIgnoreCase("trimspec")) break block3;
                if (required) {
                    this.malformedStatSpecId(component);
                    break block3;
                }
                i.previous();
                return null;
            }
            catch (NoSuchElementException e) {
                if (!required) break block3;
                this.malformedStatSpecId(component);
            }
        }
        return s;
    }

    private void malformedStatSpecId(String component) {
        throw new StatConfigException("Missing " + component + ", stat spec id must be specified as <system_name> <type_name> <instance_name> <stat_name>");
    }

    private void parseStatSpecParams(ListIterator i, StatSpec statspec) {
        while (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase("filter")) {
                this.parseFilterParam(i, statspec);
                continue;
            }
            if (token.equalsIgnoreCase("combine")) {
                this.parseCombineParam(i, statspec);
                continue;
            }
            if (token.equalsIgnoreCase("ops")) {
                this.parseOpsParam(i, statspec);
                continue;
            }
            if (token.equalsIgnoreCase("trimspec")) {
                this.parseTrimSpecNameParam(i, statspec);
                continue;
            }
            throw new StatConfigException("Unexpected token: " + token);
        }
    }

    private void parseFilterParam(ListIterator i, StatSpec statspec) {
        this.parseEquals(i);
        this.parseFilter(i, statspec);
    }

    private void parseFilter(ListIterator i, StatSpec statspec) {
        block4: {
            try {
                String filter = (String)i.next();
                if (filter.equalsIgnoreCase("perSecond")) {
                    statspec.setFilter(1);
                    break block4;
                }
                if (filter.equalsIgnoreCase("none")) {
                    statspec.setFilter(0);
                    break block4;
                }
                throw new StatConfigException("Illegal filter: " + filter);
            }
            catch (NoSuchElementException e) {
                throw new StatConfigException("Missing filter");
            }
        }
    }

    private void parseCombineParam(ListIterator i, StatSpec statspec) {
        this.parseEquals(i);
        this.parseCombine(i, statspec);
    }

    private void parseCombine(ListIterator i, StatSpec statspec) {
        block5: {
            try {
                String combine = (String)i.next();
                if (combine.equalsIgnoreCase("raw")) {
                    statspec.setCombineType(0);
                    break block5;
                }
                if (combine.equalsIgnoreCase("combine")) {
                    statspec.setCombineType(1);
                    break block5;
                }
                if (combine.equalsIgnoreCase("combineAcrossArchives")) {
                    statspec.setCombineType(2);
                    break block5;
                }
                throw new StatConfigException("Illegal combine: " + combine);
            }
            catch (NoSuchElementException e) {
                throw new StatConfigException("Missing combine");
            }
        }
    }

    private void parseOpsParam(ListIterator i, StatSpec statspec) {
        this.parseEquals(i);
        this.parseOps(i, statspec);
    }

    private void parseOps(ListIterator i, StatSpec statspec) {
        Vector ops = this.parseUnterminatedCommaIdentifierList(i);
        if (ops.size() == 0) {
            throw new StatConfigException("Missing ops");
        }
        for (String op : ops) {
            if (op.equalsIgnoreCase("min")) {
                statspec.setMin(true);
                continue;
            }
            if (op.equalsIgnoreCase("max")) {
                statspec.setMax(true);
                continue;
            }
            if (op.equalsIgnoreCase("max-min")) {
                statspec.setMaxMinusMin(true);
                continue;
            }
            if (op.equalsIgnoreCase("mean")) {
                statspec.setMean(true);
                continue;
            }
            if (op.equalsIgnoreCase("stddev")) {
                statspec.setStddev(true);
                continue;
            }
            if (op.equalsIgnoreCase("min!")) {
                statspec.setMin(true);
                statspec.setMinExpr(true);
                continue;
            }
            if (op.equalsIgnoreCase("max!")) {
                statspec.setMax(true);
                statspec.setMaxExpr(true);
                continue;
            }
            if (op.equalsIgnoreCase("max-min!")) {
                statspec.setMaxMinusMin(true);
                statspec.setMaxMinusMinExpr(true);
                continue;
            }
            if (op.equalsIgnoreCase("mean!")) {
                statspec.setMean(true);
                statspec.setMeanExpr(true);
                continue;
            }
            if (op.equalsIgnoreCase("stddev!")) {
                statspec.setStddev(true);
                statspec.setStddevExpr(true);
                continue;
            }
            if (op.equalsIgnoreCase("min?")) {
                statspec.setMin(true);
                statspec.setMinCompare(true);
                continue;
            }
            if (op.equalsIgnoreCase("max?")) {
                statspec.setMax(true);
                statspec.setMaxCompare(true);
                continue;
            }
            if (op.equalsIgnoreCase("max-min?")) {
                statspec.setMaxMinusMin(true);
                statspec.setMaxMinusMinCompare(true);
                continue;
            }
            if (op.equalsIgnoreCase("mean?")) {
                statspec.setMean(true);
                statspec.setMeanCompare(true);
                continue;
            }
            if (op.equalsIgnoreCase("stddev?")) {
                statspec.setStddev(true);
                statspec.setStddevCompare(true);
                continue;
            }
            throw new StatConfigException("Illegal value for ops");
        }
    }

    private void parseTrimSpecNameParam(ListIterator i, StatSpec statspec) {
        this.parseEquals(i);
        String trimspecName = this.parseJavaIdentifier(i);
        statspec.setTrimSpecName(trimspecName);
    }

    private Vector parseUnterminatedCommaIdentifierList(ListIterator i) {
        Vector<String> list = new Vector<String>();
        String identifier = this.parseIdentifier(i);
        if (identifier.equals(",")) {
            throw new StatConfigException("Found comma instead of identifier");
        }
        list.add(identifier);
        while (i.hasNext()) {
            identifier = this.parseIdentifier(i);
            if (identifier.equals(",")) {
                identifier = this.parseIdentifier(i);
                if (identifier.equals(",")) {
                    throw new StatConfigException("Extra comma");
                }
                list.add(identifier);
                continue;
            }
            i.previous();
            break;
        }
        return list;
    }

    private String parseJavaIdentifier(ListIterator i) {
        try {
            String token = (String)i.next();
            return token;
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Missing java identifier");
        }
    }

    private void parseEquals(ListIterator i) {
        try {
            String token = (String)i.next();
            if (!token.equals("=")) {
                throw new StatConfigException("Missing equals (=) operator, unexpected token: " + token);
            }
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Missing equals (=) operator");
        }
    }

    private void parseDiv(ListIterator i) {
        try {
            String token = (String)i.next();
            if (!token.equals("/")) {
                throw new StatConfigException("Missing division (/) operator, unexpected token: " + token);
            }
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Missing division (/) operator");
        }
    }

    private String parseIdentifier(ListIterator i) {
        try {
            String token = (String)i.next();
            return token;
        }
        catch (NoSuchElementException e) {
            throw new StatConfigException("Missing identifier");
        }
    }

    private String expandSystemProperties(StatConfig statconfig, String token) {
        StringBuffer buf = new StringBuffer();
        StringCharacterIterator i = new StringCharacterIterator(token);
        while (i.current() != '\uffff') {
            char c = i.current();
            block0 : switch (c) {
                case '$': {
                    char cc = i.next();
                    switch (cc) {
                        case '{': {
                            this.gobbleProperty(statconfig, i, buf);
                            break block0;
                        }
                    }
                    buf.append(c);
                    buf.append(cc);
                    break;
                }
                default: {
                    if (c == '\uffff') break;
                    buf.append(c);
                }
            }
            i.next();
        }
        return buf.toString();
    }

    private void gobbleProperty(StatConfig statconfig, StringCharacterIterator i, StringBuffer buf) {
        StringBuffer propKey = new StringBuffer();
        while (i.current() != '\uffff') {
            char c = i.next();
            switch (c) {
                case '}': {
                    String propVal = System.getProperty(propKey.toString());
                    if (propVal == null) {
                        String testDir = statconfig.getTestDir();
                        String testName = statconfig.getTestName();
                        if (testDir == null || testName == null) {
                            throw new StatConfigException("No system property set for " + propKey);
                        }
                        testName = testName.substring(testName.lastIndexOf("/"), testName.lastIndexOf("."));
                        String propFile = testDir + testName + ".prop";
                        StatSpecParser.log().info("Reading system properties from " + propFile);
                        try {
                            Properties props = FileUtil.getProperties(propFile);
                            propVal = props.getProperty(propKey.toString());
                            if (propVal == null) {
                                throw new StatConfigException("No system property set for " + propKey);
                            }
                        }
                        catch (IOException e) {
                            throw new StatConfigException("No system property set for " + propKey);
                        }
                    }
                    buf.append(propVal);
                    statconfig.addSystemProperty(propKey.toString(), propVal);
                    return;
                }
            }
            if (c == '\uffff') continue;
            propKey.append(c);
        }
        throw new StatConfigException("Incomplete system property: " + propKey);
    }

    private String reconstruct(Vector stmt) {
        return this.reconstructMostly(stmt) + ";";
    }

    private String reconstructMostly(Vector stmt) {
        StringBuffer buf = new StringBuffer(100);
        ListIterator i = stmt.listIterator();
        while (i.hasNext()) {
            buf.append(" ");
            buf.append((String)i.next());
        }
        return buf.toString();
    }

    private String getText(String fn) throws FileNotFoundException {
        try {
            return FileUtil.getText(fn);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StatConfigException("Error reading statistics specification file " + fn, e);
        }
    }

    public static void main(String[] args) {
        Log.createLogWriter("parser", "info");
        String fn = args[0];
        StatConfig statconfig = new StatConfig(System.getProperty("user.dir"));
        try {
            StatSpecParser.parseFile(fn, statconfig);
            System.out.println(statconfig);
        }
        catch (FileNotFoundException e) {
            System.out.println("Statistics specification file " + fn + " not found.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (StatConfigException e) {
            System.out.println("Error in statistics specification file: " + fn);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

