/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.internal.StatArchiveReader;
import hydra.Log;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import perffmwk.Expr;
import perffmwk.PerfComparisonException;
import perffmwk.PerfReporter;
import perffmwk.PerfStatValue;
import perffmwk.StatConfig;
import perffmwk.StatConfigException;
import perffmwk.StatSpec;
import perffmwk.TrimSpec;

public class PerfStatReader {
    static Calendar calendar = Calendar.getInstance();

    private static String convertTimestamp(long ms) {
        calendar.setTimeInMillis(ms);
        int hrs = calendar.get(11);
        int mins = calendar.get(12);
        int secs = calendar.get(13);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        return nf.format(hrs) + ":" + nf.format(mins) + ":" + nf.format(secs);
    }

    protected static SortedMap processStatConfig(StatConfig statconfig) {
        List tmpArchives = statconfig.getStatisticArchivesAsList();
        if (tmpArchives == null || tmpArchives.size() == 0) {
            return null;
        }
        ArrayList archives = new ArrayList();
        archives.addAll(tmpArchives);
        ArrayList statspecs = new ArrayList();
        statspecs.addAll(statconfig.getStatSpecInstances().values());
        if (Log.getLogWriter().finestEnabled()) {
            Log.getLogWriter().finest("PerfStatReader: archives ==> " + archives);
            Log.getLogWriter().finest("PerfStatReader: generating from ==> " + statconfig.getStatSpecs().keySet() + "==>" + statconfig.getStatSpecs().values());
        }
        HashMap<String, List<StatArchiveReader.StatValue>> rawValues = new HashMap<String, List<StatArchiveReader.StatValue>>();
        try {
            StatArchiveReader reader = new StatArchiveReader(archives.toArray(new File[archives.size()]), (StatArchiveReader.ValueFilter[])statspecs.toArray(new StatSpec[statspecs.size()]), true);
            for (StatSpec spec : statspecs) {
                StatArchiveReader.StatValue[] values = reader.matchSpec((StatArchiveReader.StatSpec)spec);
                if (Log.getLogWriter().finestEnabled()) {
                    for (int i = 0; i < values.length; ++i) {
                        StatArchiveReader.StatValue value = values[i];
                        long[] times = value.getRawAbsoluteTimeStamps();
                        double[] rawvals = value.getRawSnapshots();
                        double[] vals = value.getSnapshots();
                        Log.getLogWriter().finest(times.length + " timestamps with " + vals.length + " values");
                        String s = "";
                        for (int j = 0; j < Math.min(times.length, vals.length); ++j) {
                            s = s + "\ntime " + PerfStatReader.convertTimestamp(times[j]) + " " + times[j] + " filtered = " + vals[j] + " raw = " + rawvals[j] + " ";
                        }
                        Log.getLogWriter().finest("Values: " + s);
                    }
                    Log.getLogWriter().finest("PerfStatReader: Read spec ==> " + spec);
                    for (int p = 0; p < values.length; ++p) {
                        Log.getLogWriter().finest("PerfStatReader: Initial value[" + p + "]=" + values[p]);
                    }
                }
                rawValues.put(spec.getName(), Arrays.asList(values));
            }
        }
        catch (IOException e) {
            throw new StatConfigException("Unable to read archive", e);
        }
        if (Log.getLogWriter().finerEnabled()) {
            for (String statspecname : rawValues.keySet()) {
                List statspecvalues = (List)rawValues.get(statspecname);
                Log.getLogWriter().finer("PerfStatReader: Raw values ==> " + statspecname + "..." + statspecvalues);
            }
        }
        TreeMap processedValues = new TreeMap();
        for (String statspecname : rawValues.keySet()) {
            List rawValueList = (List)rawValues.get(statspecname);
            ArrayList<PerfStatValue> processedValueList = new ArrayList<PerfStatValue>();
            Iterator j = rawValueList.iterator();
            while (j.hasNext()) {
                StatSpec statspec = statconfig.getStatSpec(statspecname);
                TrimSpec trimspec = statconfig.getTrimSpec(statspec.getTrimSpecName());
                StatArchiveReader.StatValue sv = (StatArchiveReader.StatValue)j.next();
                PerfStatValue psv = PerfStatReader.getPerfStatValue(statspec, trimspec, sv);
                StatArchiveReader.ResourceType type = sv.getType();
                StatArchiveReader.StatDescriptor desc = type.getStat(statspec.getStatName());
                if (desc == null) {
                    String s = "Could not find a StatDescriptor for \"" + statspec.getStatName() + "\"";
                    throw new InternalGemFireException(s);
                }
                if (PerfReporter.brief) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(desc.getDescription());
                    sb.append(" (");
                    sb.append(desc.getUnits());
                    if (statspec.getFilter() == 1) {
                        sb.append("/sec");
                    }
                    sb.append(")");
                    statspec.setDescription(sb.toString());
                }
                processedValueList.add(psv);
                if (!Log.getLogWriter().finestEnabled()) continue;
                Log.getLogWriter().finest("PerfStatReader: PSV: " + psv.toString());
            }
            if (Log.getLogWriter().finestEnabled()) {
                Log.getLogWriter().finest("PerfStatReader: Put " + statspecname + " values as " + processedValueList);
            }
            processedValues.put(statspecname, processedValueList);
        }
        if (Log.getLogWriter().finerEnabled()) {
            for (String statspecname : processedValues.keySet()) {
                List statspecvalues = (List)processedValues.get(statspecname);
                Log.getLogWriter().finer("PerfStatReader: Processed values ==> " + statspecname + "..." + statspecvalues);
            }
        }
        ArrayList exprs = new ArrayList();
        exprs.addAll(statconfig.getExprInstances().values());
        if (Log.getLogWriter().finestEnabled()) {
            Log.getLogWriter().finest("PerfStatReader: exprs ==> " + exprs);
        }
        for (Expr expr : exprs) {
            String numerator = expr.getNumerator().getName();
            String denominator = expr.getDenominator().getName();
            List numerators = (List)processedValues.get(numerator);
            List denominators = (List)processedValues.get(denominator);
            if (Log.getLogWriter().finestEnabled()) {
                Log.getLogWriter().finest("Dividing " + numerator + " by " + denominator + " ==> " + numerators + " OVER " + denominators);
            }
            ArrayList<PerfStatValue> processedValueList = new ArrayList<PerfStatValue>();
            if (numerators.size() != 0 && denominators.size() != 0) {
                for (int j = 0; j < numerators.size(); ++j) {
                    PerfStatValue dpsv;
                    PerfStatValue npsv = (PerfStatValue)numerators.get(j);
                    PerfStatValue psv = npsv.dividedBy(dpsv = (PerfStatValue)denominators.get(j));
                    if (psv == null) continue;
                    processedValueList.add(psv);
                }
            } else if (numerators.size() != 0 && denominators.size() != 0 && numerators.size() != denominators.size()) {
                String s = "Dividing " + numerator + " by " + denominator + " found numerators (" + numerators.size() + ") and denominators (" + denominators.size() + " have different sizes ==> " + numerators + " OVER " + denominators;
                throw new PerfComparisonException(s);
            }
            processedValues.put(expr.getName(), processedValueList);
        }
        return processedValues;
    }

    protected static PerfStatValue getPerfStatValue(StatSpec statspec, TrimSpec trimspec, StatArchiveReader.StatValue sv) {
        long start = trimspec.getStart();
        long end = trimspec.getEnd();
        sv = sv.createTrimmed(start, end);
        if (Log.getLogWriter().finestEnabled()) {
            Log.getLogWriter().finest("PerfStatReader: Trimmed from " + trimspec.getStartStr() + " (" + start + ") to " + trimspec.getEndStr() + " (" + end + ")");
        }
        int filter = statspec.getFilter();
        double mean = -1.0;
        if (filter == 1 && statspec.getMean()) {
            if (start == -1L) {
                start = sv.getRawAbsoluteTimeStamps()[0];
            }
            if (end == -1L) {
                long[] rats = sv.getRawAbsoluteTimeStamps();
                end = rats[rats.length - 1];
            }
            long elapsedSec = (end - start) / 1000L;
            sv.setFilter(0);
            double del = sv.getSnapshotsMaximum() - sv.getSnapshotsMinimum();
            mean = del / (double)elapsedSec;
        }
        sv.setFilter(filter);
        PerfStatValue psv = new PerfStatValue(statspec, trimspec);
        psv.setIsLargerBetter(sv.getDescriptor().isLargerBetter());
        psv.setSamples(sv.getSnapshotsSize());
        if (statspec.getMin()) {
            psv.setMin(sv.getSnapshotsMinimum());
        }
        if (statspec.getMax()) {
            psv.setMax(sv.getSnapshotsMaximum());
        }
        if (statspec.getMaxMinusMin()) {
            psv.setMaxMinusMin(sv.getSnapshotsMaximum() - sv.getSnapshotsMinimum());
        }
        if (statspec.getMean()) {
            if (filter == 1) {
                psv.setMean(mean);
            } else {
                psv.setMean(sv.getSnapshotsAverage());
            }
        }
        if (statspec.getStddev()) {
            psv.setStddev(sv.getSnapshotsStandardDeviation());
        }
        TreeSet<String> archives = new TreeSet<String>();
        StatArchiveReader.ResourceInst[] resources = sv.getResources();
        String productVersion = null;
        for (int i = 0; i < resources.length; ++i) {
            String archive = resources[i].getArchive().getFile().getParentFile().getName();
            if (productVersion == null) {
                productVersion = resources[i].getArchive().getArchiveInfo().getProductVersion();
            }
            if (archives.contains(archive)) continue;
            archives.add(archive);
        }
        psv.setArchives(archives);
        psv.setProductVersion(productVersion);
        return psv;
    }
}

