/*
 * Decompiled with CFR 0.152.
 */
package parReg.wbcl.newWan;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.EventSequenceID;
import event.EventBB;
import hydra.CacheHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.Executor;
import parReg.wbcl.WBCLTestBB;
import util.TestException;
import util.TestHelper;

public class MyAsyncEventListener
implements AsyncEventListener<Object, Object>,
Declarable {
    public static int lastEventTime;
    public int whereIWasRegistered = ProcessMgr.getProcessId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processEvents(List<AsyncEvent<Object, Object>> events) {
        boolean status = false;
        Log.getLogWriter().info("processEvents received List with " + events.size() + " GatewayEvents");
        if (TestConfig.tab().getRandGen().nextInt(1, 100) < 99) {
            status = true;
            for (AsyncEvent<Object, Object> event : events) {
                this.logCall("processEvents", event);
                WBCLTestBB.getBB().getSharedCounters().setIfLarger(WBCLTestBB.lastEventTime, System.currentTimeMillis());
                SharedLock lock = null;
                if (event.getPossibleDuplicate() && null == lock) {
                    lock = WBCLTestBB.getBB().getSharedLock();
                    lock.lock();
                }
                try {
                    this.getDupEventRegion();
                    if (this.hasSeenEvent(event)) {
                        Log.getLogWriter().info("Ignoring event as it is already seen: " + event);
                        continue;
                    }
                    try {
                        Region wbclRegion = CacheHelper.getCache().getRegion("wbclRegion");
                        Object key = event.getKey();
                        Object value = event.getDeserializedValue();
                        Operation op = event.getOperation();
                        if (op.isCreate()) {
                            try {
                                Log.getLogWriter().info("Creating key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                                wbclRegion.create(key, value);
                                Log.getLogWriter().info("Done creating key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                            }
                            catch (EntryExistsException e) {
                                Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent operations; continuing with test");
                                Log.getLogWriter().info("Since this event falsely re-appeared as create event instead of update, so initiating update event to pass hydra test against #48997");
                                Log.getLogWriter().info("Putting key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                                if (value == null) {
                                    wbclRegion.invalidate(key);
                                } else {
                                    wbclRegion.put(key, value);
                                }
                                Log.getLogWriter().info("Done Putting key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                            }
                        } else if (op.isUpdate()) {
                            Log.getLogWriter().info("Putting key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                            wbclRegion.put(key, value);
                            Log.getLogWriter().info("Done Putting key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                        } else if (op.isInvalidate()) {
                            this.throwException("Unexpected INVALIDATE encounted in WBCLEventListener " + op.toString() + ", " + TestHelper.getStackTrace());
                        } else if (op.isDestroy()) {
                            Log.getLogWriter().info("Destroying key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                            try {
                                wbclRegion.destroy(key);
                            }
                            catch (EntryNotFoundException e) {
                                Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent operations; continuing with test");
                            }
                            Log.getLogWriter().info("Done destroying key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                        }
                        this.updateSeenEvent(event);
                    }
                    catch (Exception e) {
                        status = false;
                        this.throwException("WBCL Listener caught unexpected Exception " + e + ", " + TestHelper.getStackTrace(e));
                    }
                }
                finally {
                    if (!event.getPossibleDuplicate()) continue;
                    lock.unlock();
                }
            }
        }
        if (status) {
            Log.getLogWriter().info("WBCLEventListener processed batch of " + events.size() + " events, returning " + status);
        } else {
            Log.getLogWriter().info("WBCLEventListener DID NOT process batch of " + events.size() + " events, returning " + status);
        }
        return status;
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    public void close() {
        this.logCall("close", null);
    }

    public boolean hasSeenEvent(AsyncEvent event) {
        String key = this.keyGeneration(event);
        long currSeqId = event.getEventSequenceID().getSequenceID();
        Object lastSeqId = this.getDupEventRegion().get((Object)key);
        if (lastSeqId == null) {
            return false;
        }
        return (Long)lastSeqId >= currSeqId;
    }

    public void updateSeenEvent(AsyncEvent event) {
        String asyncEventKey = this.keyGeneration(event);
        this.getDupEventRegion().put((Object)asyncEventKey, (Object)event.getEventSequenceID().getSequenceID());
        Log.getLogWriter().info("Key generated for this event is: " + asyncEventKey);
    }

    private String keyGeneration(AsyncEvent event) {
        EventSequenceID eventSeQId = event.getEventSequenceID();
        return eventSeQId.getMembershipID() + "_" + eventSeQId.getThreadID();
    }

    private Region getDupEventRegion() {
        String regionName = "dupEventPRegion";
        Region region = RegionHelper.getRegion(regionName);
        if (region == null) {
            region = RegionHelper.createRegion(regionName);
        }
        return region;
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public String logCall(String methodName, AsyncEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    public String toString(String methodName, AsyncEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + RemoteTestModule.getMyClientName());
        aStr.append(", whereIWasRegistered: " + this.whereIWasRegistered);
        if (event == null) {
            return aStr.toString();
        }
        aStr.append(", Event:" + event);
        return aStr.toString();
    }

    public static void waitForSilence(long desiredSilenceSec, long sleepMS) {
        Log.getLogWriter().info("Waiting for a period of silence for " + desiredSilenceSec + " seconds...");
        long desiredSilenceMS = desiredSilenceSec * 1000L;
        long silenceStartTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        long lastEventTime = WBCLTestBB.getBB().getSharedCounters().read(WBCLTestBB.lastEventTime);
        while (currentTime - silenceStartTime < desiredSilenceMS) {
            try {
                Thread.sleep(sleepMS);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            lastEventTime = WBCLTestBB.getBB().getSharedCounters().read(WBCLTestBB.lastEventTime);
            if (lastEventTime > silenceStartTime) {
                silenceStartTime = lastEventTime;
            }
            currentTime = System.currentTimeMillis();
        }
        long duration = currentTime - silenceStartTime;
        Log.getLogWriter().info("Done waiting, clients have been silent for " + duration + " ms");
    }

    class SerialExecutor
    implements Executor {
        final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
        final Executor executor;
        Runnable active;

        SerialExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.tasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.active == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.active = this.tasks.poll();
            if (this.active != null) {
                this.executor.execute(this.active);
            }
        }
    }
}

