/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.PartitionDescription;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import util.NameBB;
import util.NameFactory;
import util.QueryObject;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class PrTxQueryTest {
    protected static PrTxQueryTest testInstance;
    static Region baseRegion;
    static final String EXTRA_INDEX = "extraIndex";
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    private boolean isPartitioned;
    private ArrayList errorMsgs = new ArrayList();
    private ArrayList errorException = new ArrayList();

    public static synchronized void HydraTask_initializeWithPartitionedRegions() {
        if (testInstance == null) {
            testInstance = new PrTxQueryTest();
            try {
                testInstance.initializePartitionedRegions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    protected void initializePartitionedRegions() {
        if (CacheHelper.getCache() == null) {
            Cache aCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            PartitionDescription pd = rd.getPartitionDescription();
            PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
            PartitionAttributes prAttrs = null;
            String colocatedWith = null;
            int numRegions = PrTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                if (i > 0) {
                    colocatedWith = regionBase + "_" + i;
                    prFactory.setColocatedWith(colocatedWith);
                    prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                }
                Region region = RegionHelper.createRegion(regionName, aFactory);
            }
        }
        this.isPartitioned = true;
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = TestConfig.tab().intAt(PrTxPrms.numOpsPerTask, Integer.MAX_VALUE);
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", minTaskGranularityMS " + this.minTaskGranularityMS + ", numOpsPerTask " + this.numOpsPerTask);
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new PrTxQueryTest();
            try {
                testInstance.initialize();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    protected void initialize() {
        if (CacheHelper.getCache() == null) {
            Cache aCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            Region insertRegion = RegionHelper.createRegion(PrTxPrms.getInsertRegion(), regionConfig);
            this.createIndex(insertRegion, "r1");
            List updateRegions = PrTxPrms.getUpdateRegions();
            int i = 2;
            for (String regionName : updateRegions) {
                Region aRegion = RegionHelper.createRegion(regionName, regionConfig);
                this.createIndex(aRegion, "r" + i);
                ++i;
            }
        }
        this.isPartitioned = false;
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = TestConfig.tab().intAt(PrTxPrms.numOpsPerTask, Integer.MAX_VALUE);
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", minTaskGranularityMS " + this.minTaskGranularityMS + ", numOpsPerTask " + this.numOpsPerTask);
    }

    private void createIndex(Region aRegion, String indexExpr) {
        Cache aCache = CacheHelper.getCache();
        QueryService qs = aCache.getQueryService();
        String regionName = aRegion.getFullPath();
        String fromClause = regionName + " " + indexExpr;
        String fieldName = indexExpr + ".extra";
        try {
            qs.createIndex(EXTRA_INDEX, IndexType.FUNCTIONAL, fieldName, fromClause);
            Log.getLogWriter().info("Created index extraIndex with field " + fieldName + " with fromClause " + fromClause);
        }
        catch (IndexNameConflictException e) {
            Log.getLogWriter().info("createIndex(" + regionName + ") caught Exception " + (Object)((Object)e) + TestHelper.getStackTrace(e));
            throw new TestException("createIndex(" + regionName + ") caught Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
        }
        catch (IndexExistsException e) {
            Log.getLogWriter().info("createIndex(" + regionName + ") caught Exception " + (Object)((Object)e) + TestHelper.getStackTrace(e));
            throw new TestException("createIndex(" + regionName + ") caught Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
        }
        catch (QueryException e) {
            Log.getLogWriter().info("createIndex(" + regionName + ") caught Exception " + (Object)((Object)e) + TestHelper.getStackTrace(e));
            throw new TestException("createIndex(" + regionName + ") caught Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_populateUpdateRegions() {
        testInstance.populateUpdateRegions();
    }

    protected void populateUpdateRegions() {
        for (int i = 0; i < PrTxPrms.getMaxKeys(); ++i) {
            String pKey = NameFactory.getNextPositiveObjectName();
            String nKey = NameFactory.getNextNegativeObjectName();
            List regionNames = PrTxPrms.getUpdateRegions();
            for (String regionName : regionNames) {
                Region aRegion = RegionHelper.getRegion(regionName);
                try {
                    this.createEntry(aRegion, pKey, false);
                    this.createEntry(aRegion, nKey, false);
                }
                catch (EntryExistsException e) {
                    Log.getLogWriter().info("populateUpdateRegions caught " + (Object)((Object)e) + ".  Expected, continuing with test");
                }
            }
        }
        NameBB.getBB().zero("NameBB.POSITIVE_NAME_COUNTER", NameBB.POSITIVE_NAME_COUNTER);
        NameBB.getBB().zero("NameBB.NEGATIVE_NAME_COUNTER", NameBB.NEGATIVE_NAME_COUNTER);
    }

    public static void HydraTask_dumpLocalKeys() {
        testInstance.dumpLocalKeys();
    }

    protected void dumpLocalKeys() {
        StringBuffer aStr = new StringBuffer();
        DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        aStr.append("Keys local to " + dm.toString() + " by region\n");
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Region localRegion = PartitionRegionHelper.getLocalData((Region)aRegion);
            aStr.append("   " + aRegion.getName() + ": " + localRegion.keySet() + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected void createEntry(Region aRegion, Object key, boolean setExtra) {
        long counter = NameFactory.getCounterForName(key);
        QueryObject anObj = new QueryObject(counter, 1, 0, 1);
        if (setExtra) {
            anObj.extra = key;
        }
        Log.getLogWriter().info("operation for " + aRegion.getFullPath() + ":" + key + ", createEntry: calling create for key " + key + ", object " + anObj.toStringFull());
        aRegion.create(key, (Object)anObj);
        Log.getLogWriter().info("operation for " + aRegion.getFullPath() + ":" + key + ", createEntry: done creating key " + key);
    }

    protected void updateEntry(Region aRegion, Object key) {
        QueryObject oldValue = (QueryObject)aRegion.get(key);
        QueryObject newValue = oldValue.modifyWithNewInstance(4, 0, false);
        newValue.extra = key;
        Log.getLogWriter().info("operation for " + aRegion.getFullPath() + ":" + key + ", updateEntry: replacing key " + key + " with " + newValue.toStringFull());
        QueryObject returnVal = (QueryObject)aRegion.put(key, (Object)newValue);
        Log.getLogWriter().info("operation for " + aRegion.getFullPath() + ":" + key + ", updateEntry: Done with call to put (update), returnVal is " + returnVal);
    }

    public static void HydraTask_positiveTx() {
        testInstance.positiveTx();
    }

    protected void positiveTx() {
        long startTime = System.currentTimeMillis();
        int numTxns = 0;
        do {
            Object key = this.getNextPositiveKey();
            this.executeTx(key);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && ++numTxns < this.numOpsPerTask);
    }

    public static void HydraTask_negativeTx() {
        testInstance.negativeTx();
    }

    protected void negativeTx() {
        long startTime = System.currentTimeMillis();
        int numTxns = 0;
        do {
            Object key = this.getNextNegativeKey();
            this.executeTx(key);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && ++numTxns < this.numOpsPerTask);
    }

    protected Object getNextPositiveKey() {
        DistributedMember localDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Region aRegion = RegionHelper.getRegion(PrTxPrms.getInsertRegion());
        String key = null;
        while (key == null) {
            String pKey = NameFactory.getNextPositiveObjectName();
            if (this.isPartitioned) {
                DistributedMember pDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)pKey);
                if (!localDM.equals(pDM)) continue;
                key = pKey;
                continue;
            }
            key = pKey;
        }
        return key;
    }

    protected Object getNextNegativeKey() {
        DistributedMember localDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        Region aRegion = RegionHelper.getRegion(PrTxPrms.getInsertRegion());
        String key = null;
        while (key == null) {
            String pKey = NameFactory.getNextNegativeObjectName();
            if (this.isPartitioned) {
                DistributedMember pDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)pKey);
                if (!localDM.equals(pDM)) continue;
                key = pKey;
                continue;
            }
            key = pKey;
        }
        return key;
    }

    protected void executeTx(Object key) {
        TestHelper.checkForEventError(PrTxBB.getBB());
        long counter = NameFactory.getCounterForName(key);
        if (Math.abs(counter) > (long)PrTxPrms.getMaxKeys()) {
            throw new StopSchedulingOrder("All available entries have been updated");
        }
        TxHelper.begin();
        Region aRegion = RegionHelper.getRegion(PrTxPrms.getInsertRegion());
        this.createEntry(aRegion, key, true);
        List regionNames = PrTxPrms.getUpdateRegions();
        for (String regionName : regionNames) {
            aRegion = RegionHelper.getRegion(regionName);
            this.updateEntry(aRegion, key);
        }
        try {
            TxHelper.commit();
        }
        catch (ConflictException e) {
            Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
        }
    }

    public static void HydraTask_query() {
        testInstance.query();
    }

    protected void query() {
        long startTime = System.currentTimeMillis();
        int numQueries = 0;
        do {
            long counter = 0L;
            Object key = null;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                key = TestConfig.tab().getRandGen().nextBoolean() ? this.getNextPositiveKey() : this.getNextNegativeKey();
            } else {
                String regionName = PrTxPrms.getInsertRegion();
                Region aRegion = RegionHelper.getRegion(regionName);
                Object[] keySet = this.isPartitioned ? PartitionRegionHelper.getLocalData((Region)aRegion).keySet().toArray() : aRegion.keySet().toArray();
                if (keySet.length > 0) {
                    int index = TestConfig.tab().getRandGen().nextInt(0, keySet.length - 1);
                    key = keySet[index];
                }
            }
            if (key == null) continue;
            if (this.isPartitioned) {
                this.queryPartitionedRegionForKey(key);
            } else {
                this.queryForKey(key);
            }
            ++numQueries;
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numQueries < this.numOpsPerTask);
    }

    protected void queryForKey(Object key) {
        QueryService queryService = CacheHelper.getCache().getQueryService();
        SelectResults results = null;
        int hits = 0;
        String regionName2 = PrTxPrms.getInsertRegion();
        Region insertRegion = RegionHelper.getRegion(regionName2);
        StringBuffer aStr = new StringBuffer();
        aStr.append("SELECT DISTINCT * FROM " + insertRegion.getFullPath() + " r1");
        List regionNames = PrTxPrms.getUpdateRegions();
        int i = 2;
        for (String regionName2 : regionNames) {
            Region aRegion = RegionHelper.getRegion(regionName2);
            aStr.append(", " + aRegion.getFullPath() + " r" + i);
            ++i;
        }
        aStr.append(" WHERE r1.extra = '" + key + "'");
        for (i = 2; i <= 4; ++i) {
            aStr.append(" AND r" + i + ".extra = '" + key + "'");
        }
        String qStr = aStr.toString();
        Query query = queryService.newQuery(qStr);
        try {
            Log.getLogWriter().info("Executing query " + qStr);
            results = (SelectResults)query.execute();
        }
        catch (Exception e) {
            Log.getLogWriter().info("query threw " + e + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info(qStr + " returns " + results.toString());
        aStr = new StringBuffer();
        for (Struct s : results) {
            Object[] qResults = s.getFieldValues();
            for (hits = 0; hits < qResults.length; ++hits) {
                QueryObject qo = (QueryObject)qResults[hits];
                aStr.append("qo[" + hits + "] = " + qo.toString() + "\n");
                if (qo.extra.equals(key)) continue;
                throw new TestException("query returned unexpected entry " + qo.toString() + TestHelper.getStackTrace());
            }
        }
        Log.getLogWriter().info("QueryResults for " + key + "\n" + aStr.toString());
        if (hits > 0 && hits != 4) {
            throw new TestException("Expected to find updated entries for " + key + " in all " + regionNames.size() + " regions, but query returned " + hits + " entries");
        }
    }

    protected void queryPartitionedRegionForKey(Object key) {
        QueryService queryService = CacheHelper.getCache().getQueryService();
        SelectResults results = null;
        int hits = 0;
        String regionName2 = PrTxPrms.getInsertRegion();
        Region aRegion = RegionHelper.getRegion(regionName2);
        String qStr = "SELECT DISTINCT * FROM " + aRegion.getFullPath() + " WHERE extra = '" + key + "'";
        Query query = queryService.newQuery(qStr);
        try {
            Log.getLogWriter().info("Executing query " + qStr);
            results = (SelectResults)query.execute();
        }
        catch (Exception e) {
            Log.getLogWriter().info("query threw " + e + " " + TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info(qStr + " returns " + results);
        if (results.size() > 0) {
            List regionNames = PrTxPrms.getUpdateRegions();
            for (String regionName2 : regionNames) {
                aRegion = RegionHelper.getRegion(regionName2);
                qStr = "SELECT DISTINCT * FROM " + aRegion.getFullPath() + " WHERE extra = '" + key + "'";
                query = queryService.newQuery(qStr);
                try {
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    Log.getLogWriter().info("query threw " + e + " " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info(qStr + " returns " + results + " with size " + results.size());
                hits += results.size();
            }
            if (hits != regionNames.size()) {
                throw new TestException("Expected to find updated entries for " + key + " in all " + regionNames.size() + " regions, but query returned " + hits + " entries");
            }
        }
    }
}

