/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import hydra.BridgeHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.List;
import parReg.tx.ParRegViewTest;
import tx.CollectionsTest;
import tx.OpList;
import tx.Operation;
import tx.TxBB;
import tx.TxPrms;
import tx.ViewTest;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class ParRegBridgeView
extends ParRegViewTest {
    public static synchronized void HydraTask_initialize() {
        if (viewTest == null) {
            viewTest = new ParRegBridgeView();
            viewTest.initialize();
            ((ParRegBridgeView)viewTest).initialize(ConfigPrms.getRegionConfig());
            CacheServer bridge = BridgeHelper.getBridgeServer();
            if (bridge != null) {
                String host = RemoteTestModule.getMyHost();
                int dot = host.indexOf(".");
                if (dot > 0) {
                    host = host.substring(0, dot);
                }
                int port = bridge.getPort();
                DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
                String mappingKey = host + ":" + port;
                Log.getLogWriter().info("Posting port to dm mapping to BB: " + mappingKey + ":" + dm);
                TxBB.getBB().getSharedMap().put(mappingKey, dm);
            }
        }
    }

    public static void HydraCloseTask_verifyResourcesReleased() {
        Log.getLogWriter().info("HydraCloseTask_verifyResourcesReleased(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        if (viewTest == null) {
            viewTest = new ParRegBridgeView();
        }
        ((ParRegBridgeView)viewTest).verifyResourcesReleased();
    }

    @Override
    protected void verifyResourcesReleased() {
        String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
        OpList opList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
        OpList txOpList = opList.collapse();
        Log.getLogWriter().info("Entered verifyResourcesReleased, reusing operations from " + txOpList.toString());
        boolean isVisible = this.updatesVisible();
        CollectionsTest validator = new CollectionsTest();
        for (int i = 0; i < txOpList.numOps(); ++i) {
            Operation op = txOpList.getOperation(i);
            Log.getLogWriter().info("Executing operation " + op);
            TxHelper.begin();
            if (isVisible) {
                if (op.isEntryDestroy()) {
                    op.setOpName("entry-create");
                } else if (op.isEntryInvalidate()) {
                    op.setOpName("entry-update");
                } else {
                    op.setOpName("entry-update");
                }
                op.setNewValue(new Integer(0));
            }
            validator.executeOperation(op);
            try {
                TxHelper.commit();
                continue;
            }
            catch (ConflictException e) {
                throw new TestException("Unexpected ConflictException " + TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraCloseTask_validateTxConsistency() {
        Log.getLogWriter().info("HydraCloseTask_validateTxConsistency(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        if (viewTest == null) {
            viewTest = new ParRegBridgeView();
        }
        ((ParRegBridgeView)viewTest).validateTxConsistency();
    }

    @Override
    protected void validateTxConsistency() {
        Log.getLogWriter().info("Entered validateTxConsistency(TX_NUMBER = " + TxBB.getBB().getSharedCounters().read(TxBB.TX_NUMBER) + ")");
        try {
            this.validateTxOps(this.updatesVisible());
        }
        catch (TestException e) {
            Log.getLogWriter().info("Listing current values of each entry involved in the commit");
            String opListKey = (String)TxBB.getBB().getSharedMap().get(TxBB.TX_OPLIST_KEY);
            OpList txOpList = (OpList)TxBB.getBB().getSharedMap().get(opListKey);
            for (int i = 0; i < txOpList.numOps(); ++i) {
                Operation op = txOpList.getOperation(i);
                String regionName = op.getRegionName();
                Region aRegion = CacheUtil.getCache().getRegion(regionName);
                String key = (String)op.getKey();
                Log.getLogWriter().info("Operation(" + i + ") = " + op.toString());
                Log.getLogWriter().info("Current value of <" + regionName + "><" + key + "> = <" + ParRegBridgeView.getValueInVM(aRegion, key) + ">");
            }
            throw e;
        }
    }

    @Override
    protected boolean updatesVisible() {
        boolean isVisible = false;
        Integer mapValue = (Integer)TxBB.getBB().getSharedMap().get(TxBB.CommitStateTrigger);
        int commitStateTrigger = mapValue;
        Boolean listenerProcessedCommit = (Boolean)TxBB.getBB().getSharedMap().get("afterCommitProcessed");
        if (commitStateTrigger == 9 || commitStateTrigger == 8 || commitStateTrigger == 6 || listenerProcessedCommit.booleanValue()) {
            isVisible = true;
        }
        Log.getLogWriter().info("updatesVisible(" + TxPrms.toStringForCommitStateTrigger(commitStateTrigger) + ") returning " + isVisible);
        return isVisible;
    }

    @Override
    public void setupCommitTestCallbacks(String commitStatePrm) {
        int commitStateTrigger = TxPrms.getCommitStateTrigger(commitStatePrm);
        TxBB.getBB().getSharedMap().put(TxBB.CommitStateTrigger, new Integer(commitStateTrigger));
        Log.getLogWriter().info("TxPrms.commitStateTrigger = " + commitStatePrm + "(" + commitStateTrigger + ")");
    }

    protected void postClientVmInfoToBB() {
        PoolImpl pool = (PoolImpl)PoolManager.find((String)"brloader");
        if (pool != null) {
            ServerLocation delegate = pool.getServerAffinityLocation();
            int delegatePort = delegate.getPort();
            String delegateHost = delegate.getHostName();
            int dot = delegateHost.indexOf(".");
            if (dot != -1) {
                delegateHost = delegateHost.substring(0, dot);
            }
            Log.getLogWriter().info("Delegate is " + delegateHost + ":" + delegatePort);
            ClientVmInfo delegateVmInfo = null;
            ClientVmInfo nonDelegateVmInfo = null;
            List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
            for (BridgeHelper.Endpoint endpoint : endpoints) {
                if (endpoint.getHost().equalsIgnoreCase(delegateHost) && endpoint.getPort() == delegatePort) {
                    delegateVmInfo = new ClientVmInfo(endpoint);
                    continue;
                }
                nonDelegateVmInfo = new ClientVmInfo(endpoint);
            }
            TxBB.getBB().getSharedMap().put("DelegateVmInfo", delegateVmInfo);
            TxBB.getBB().getSharedMap().put("NonDelegateServerVmInfo", nonDelegateVmInfo);
            Log.getLogWriter().info("Writing delegateVmInfo to BB: " + delegateVmInfo);
            Log.getLogWriter().info("Writing nonDelegateVmInfo to BB: " + nonDelegateVmInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killCommittor() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killCommittor ... killing tx edge client vm");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            try {
                ViewTest.killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killCommittor interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        int stopMode = -21;
        String commitStatePrm = TestConfig.tab().stringAt(TxPrms.commitStateTrigger, null);
        if (commitStatePrm != null && TxPrms.getCommitStateTrigger(commitStatePrm) == 6) {
            stopMode = -20;
        }
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing committor", stopMode, -32);
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killDelegate() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killDelegate ... ");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            try {
                ViewTest.killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killDelegate interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing delegate", -21, -32, (ClientVmInfo)TxBB.getBB().getSharedMap().get("DelegateVmInfo"));
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_killDataHost() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In killDataHost ...");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            try {
                ViewTest.killSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killDataHost interrupted, did not kill VM");
            }
        }
        Boolean timeToStop = (Boolean)TxBB.getBB().getSharedMap().get("timeToStop");
        if (timeToStop.equals(Boolean.FALSE)) {
            ClientVmMgr.stop("product invoked CommitTestCallback, killing data host", -21, -32, (ClientVmInfo)TxBB.getBB().getSharedMap().get("NonDelegateServerVmInfo"));
        } else {
            Log.getLogWriter().info("killCommittor invoked, signalled by waitForDist to allow test to continue normally.  Not killing this VM");
        }
    }
}

