/*
 * Decompiled with CFR 0.152.
 */
package parReg.fixedPartitioning;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.FixedPartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import getInitialImage.InitImageBB;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.colocation.Month;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.FunctionServiceTest;
import parReg.execute.PartitionObjectHolder;
import parReg.execute.PrimaryExecutionFunction;
import parReg.fixedPartitioning.FixedKeyResolver;
import parReg.fixedPartitioning.FixedPartitioningTest;
import util.BaseValueHolder;
import util.NameBB;
import util.NameFactory;
import util.PRObserver;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class KeyCallbackResolverTest
extends FixedPartitioningTest {
    public static synchronized void HydraTask_p2p_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new KeyCallbackResolverTest();
            isBridgeClient = false;
            KeyCallbackResolverTest.setDataStoreSequenceId();
            ((KeyCallbackResolverTest)testInstance).initialize("dataStore");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
        }
    }

    public static synchronized void HydraTask_p2p_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new KeyCallbackResolverTest();
            isBridgeClient = false;
            ((KeyCallbackResolverTest)testInstance).initialize("accessor");
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new KeyCallbackResolverTest();
            isBridgeClient = false;
            KeyCallbackResolverTest.setDataStoreSequenceId();
            String key = "VmId_" + RemoteTestModule.getMyVmid();
            String cacheXmlFile = key + ".xml";
            File aFile = new File(cacheXmlFile);
            if (!aFile.exists()) {
                theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
                BridgeHelper.startBridgeServer("bridge");
            }
            ((KeyCallbackResolverTest)testInstance).initialize("dataStore");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            isBridgeConfiguration = true;
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new KeyCallbackResolverTest();
            ((KeyCallbackResolverTest)testInstance).initialize("accessor");
            Pool pool = PoolHelper.createPool("edgeDescript");
            isBridgeConfiguration = true;
        }
    }

    public static void HydraTask_executeFunctions() {
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("key")) {
            FixedPartitioningTest.HydraTask_executeFunctionAllKeys();
        } else if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("callBackArg")) {
            Set<Region<?, ?>> regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
            for (Region<?, ?> aRegion : regionSet) {
                ((KeyCallbackResolverTest)testInstance).executeWithCallBackFilter(aRegion);
                ((FunctionServiceTest)testInstance).executeFunctionAllBuckets(aRegion);
            }
        }
    }

    @Override
    protected void loadRegions() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = this.sc.incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, for Region shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate;
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            try {
                Object value = this.getValueToAdd(key);
                Month callBackArg = Month.months[(int)(shouldAddCount % 12L)];
                this.loadRegion(key, value, callBackArg);
                this.sc.increment(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + " out of " + numKeysToCreate);
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    public void loadRegion(Object key, Object value, Month callBackArg) {
        block3: {
            Set<Region<?, ?>> regionSet;
            block2: {
                regionSet = ((FixedPartitioningTest)testInstance).getTestRegions();
                InitImageBB.getBB().getSharedMap().put(key, callBackArg);
                if (!TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("key")) break block2;
                FixedKeyResolver resolverKey = new FixedKeyResolver(key, callBackArg);
                for (Region<?, ?> aRegion : regionSet) {
                    aRegion.put((Object)resolverKey, value);
                }
                break block3;
            }
            if (!TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("callBackArg")) break block3;
            PartitionObjectHolder keyHolder = new PartitionObjectHolder(key, callBackArg);
            FixedKeyResolver resolverArg = new FixedKeyResolver(key, callBackArg);
            for (Region<?, ?> aRegion : regionSet) {
                aRegion.put((Object)keyHolder, value, (Object)resolverArg);
            }
        }
    }

    public Object getKeyWrapper(Object keyName) {
        Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(keyName);
        if (callBackArg == null) {
            callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(keyName, callBackArg);
        }
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("key")) {
            FixedKeyResolver resolverKey = new FixedKeyResolver(keyName, callBackArg);
            return resolverKey;
        }
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("callBackArg")) {
            PartitionObjectHolder keyHolder = new PartitionObjectHolder(keyName, callBackArg);
            return keyHolder;
        }
        throw new TestException("Invalid congifuration - test uses either key/callback implementing resolver");
    }

    public Object getCallBackWrapper(Object keyName) {
        Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(keyName);
        if (callBackArg == null) {
            callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(keyName, callBackArg);
        }
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("key")) {
            return null;
        }
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("callBackArg")) {
            FixedKeyResolver resolverArg = new FixedKeyResolver(keyName, callBackArg);
            return resolverArg;
        }
        throw new TestException("Invalid congifuration - test uses either key/callback implementing resolver");
    }

    public void executeWithCallBackFilter(Region aRegion) {
        ArrayList list;
        HashSet<Object> filterSet = new HashSet<Object>();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            String key = NameFactory.OBJECT_NAME_PREFIX + TestConfig.tab().getRandGen().nextInt(this.keyIntervals.getNumKeys());
            Object callBackArg = this.getCallBackWrapper(key);
            filterSet.add(callBackArg);
        } else {
            int numCallbackArgs = 10;
            for (int i = 1; i <= numCallbackArgs; ++i) {
                String key = NameFactory.OBJECT_NAME_PREFIX + TestConfig.tab().getRandGen().nextInt(this.keyIntervals.getNumKeys());
                Object callBackArg = this.getCallBackWrapper(key);
                filterSet.add(callBackArg);
            }
        }
        Log.getLogWriter().info("Executing function on " + (filterSet.size() == 1 ? " single node" : "multiple nodes") + " with filter size as " + filterSet.size());
        PrimaryExecutionFunction function = new PrimaryExecutionFunction();
        ArrayListResultCollector resultCollectorList = new ArrayListResultCollector();
        Execution dataSet = FunctionService.onRegion((Region)aRegion).withCollector((ResultCollector)resultCollectorList).withFilter(filterSet);
        try {
            list = (ArrayList)dataSet.execute((Function)function).getResult();
        }
        catch (Exception e) {
            Log.getLogWriter().info("Caught " + e + ", " + e.getStackTrace());
            throw new TestException("Caught Exception during function execution ", e);
        }
        HashSet<String> quarterSet = new HashSet<String>();
        for (Object e : filterSet) {
            Month month = (Month)((FixedKeyResolver)e).getRoutingHint();
            String quarter = month.getQuarter();
            quarterSet.add(quarter);
        }
        boolean numPrimariesPerPartition = true;
        if (numPrimariesPerPartition) {
            if (list.size() == quarterSet.size()) {
                Log.getLogWriter().info("Got the expected result from the onRegion() execution " + list.size());
            } else {
                throw new TestException(" The filter used had the primary quarters " + quarterSet + " where each node have only one primary partition. Expected result set be of size " + quarterSet.size() + " but got " + list.size() + " and result is " + list);
            }
        }
    }

    @Override
    protected void addNewKey(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        Log.getLogWriter().info("In addNewKey " + key + " in the region " + aRegion.getName());
        ValueHolder value = new ValueHolder(key.toString(), this.randomValues);
        aRegion.put(key, (Object)value, callbackArg);
    }

    @Override
    public void invalidate(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        Log.getLogWriter().info("Invalidating " + key + " in the region " + aRegion.getName());
        aRegion.invalidate(key, callbackArg);
    }

    @Override
    public void destroy(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        Log.getLogWriter().info("Destroying " + key + " in the region " + aRegion.getName());
        aRegion.destroy(key, callbackArg);
    }

    @Override
    public void updateExistingKey(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        Log.getLogWriter().info("Update existing key " + key + " in the region " + aRegion.getName());
        BaseValueHolder existingValue = (BaseValueHolder)aRegion.get(key, callbackArg);
        ValueHolder newValue = new ValueHolder(key.toString(), this.randomValues);
        if (existingValue == null) {
            throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
        }
        if (existingValue.myValue instanceof String) {
            throw new TestException("Trying to update a key which was already updated: " + existingValue.myValue);
        }
        newValue.myValue = "updated_" + key.toString();
        aRegion.put(key, (Object)newValue, callbackArg);
    }

    @Override
    public void get(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        Object existingValue = null;
        existingValue = aRegion.get(key, callbackArg);
        if (existingValue == null) {
            throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
        }
    }

    @Override
    public void localInvalidate(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        aRegion.localInvalidate(key, callbackArg);
    }

    @Override
    public void localDestroy(Region aRegion, Object keyName) {
        Object key = this.getKeyWrapper(keyName);
        Object callbackArg = this.getCallBackWrapper(keyName);
        aRegion.localDestroy(key, callbackArg);
    }

    @Override
    public void verifyRegionContents(Region aRegion) {
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("callBackArg")) {
            Log.getLogWriter().info("This test uses callBackArg as Resolver and hence cannot check contaisKey() that does not use callBackArg. Hence returning without validating");
            return;
        }
        InitImageBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        StringBuffer errStr = new StringBuffer();
        long numKeys = aRegion.size();
        if ((long)this.totalNumKeys != numKeys) {
            String tmpStr = "Expected " + this.totalNumKeys + " keys, but there are " + numKeys;
            Log.getLogWriter().info(tmpStr);
            errStr.append(tmpStr + "\n");
        }
        Log.getLogWriter().info("In verifyRegionContents, region has " + numKeys + " keys");
        long lastLogTime = System.currentTimeMillis();
        for (int i = 1; i <= this.totalNumKeys; ++i) {
            String keyName = NameFactory.getObjectNameForCounter(i);
            Object key = this.getKeyWrapper(keyName);
            try {
                Object value;
                if (i >= this.keyIntervals.getFirstKey(1000) && i <= this.keyIntervals.getLastKey(1000) || i >= this.keyIntervals.getFirstKey(1006) && i <= this.keyIntervals.getLastKey(1006)) {
                    this.checkContainsKey(aRegion, key, true, "key was untouched");
                    this.checkContainsValueForKey(aRegion, key, true, "key was untouched");
                    value = aRegion.get(key);
                    this.checkValue(key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1001) && i <= this.keyIntervals.getLastKey(1001)) {
                    this.checkContainsKey(aRegion, key, true, "key was invalidated");
                    this.checkContainsValueForKey(aRegion, key, false, "key was invalidated");
                } else if (i >= this.keyIntervals.getFirstKey(1002) && i <= this.keyIntervals.getLastKey(1002)) {
                    this.checkContainsKey(aRegion, key, true, "key was locally invalidated");
                    this.checkContainsValueForKey(aRegion, key, true, "key was locally invalidated");
                    value = aRegion.get(key);
                    this.checkValue(key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1003) && i <= this.keyIntervals.getLastKey(1003)) {
                    this.checkContainsKey(aRegion, key, false, "key was destroyed");
                    this.checkContainsValueForKey(aRegion, key, false, "key was destroyed");
                } else if (i >= this.keyIntervals.getFirstKey(1004) && i <= this.keyIntervals.getLastKey(1004)) {
                    this.checkContainsKey(aRegion, key, true, "key was locally destroyed");
                    this.checkContainsValueForKey(aRegion, key, true, "key was locally destroyed");
                    value = aRegion.get(key);
                    this.checkValue(key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1005) && i <= this.keyIntervals.getLastKey(1005)) {
                    this.checkContainsKey(aRegion, key, true, "key was updated");
                    this.checkContainsValueForKey(aRegion, key, true, "key was updated");
                    value = aRegion.get(key);
                    this.checkUpdatedValue(key, value);
                } else if (i > this.keyIntervals.getNumKeys()) {
                    this.checkContainsKey(aRegion, key, true, "key was new");
                    this.checkContainsValueForKey(aRegion, key, true, "key was new");
                    value = aRegion.get(key);
                    this.checkValue(key, value);
                }
            }
            catch (TestException e) {
                Log.getLogWriter().info(TestHelper.getStackTrace(e));
                errStr.append(e.getMessage() + "\n");
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Verified key " + i + " out of " + this.totalNumKeys);
            lastLogTime = System.currentTimeMillis();
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void checkUpdatedValue(Object key, Object value) {
        if (!(value instanceof BaseValueHolder)) throw new TestException("Expected value " + TestHelper.toString(value) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)value;
        String keyName = key.toString();
        if (!(vh.myValue instanceof String)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a String indicating it was updated, but the value for this key is " + TestHelper.toString(vh));
        String aStr = (String)vh.myValue;
        String expectedStr = "updated_" + keyName;
        if (aStr.equals(expectedStr)) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void checkValue(Object key, Object value) {
        long keyCounter;
        if (!(value instanceof BaseValueHolder)) throw new TestException("For key " + key + ", expected value " + TestHelper.toString(value) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)value;
        if (key instanceof FixedPartitionResolver) {
            String counter = ((FixedPartitionResolver)key).getName();
            keyCounter = NameFactory.getCounterForName(counter);
        } else {
            keyCounter = NameFactory.getCounterForName(key);
        }
        if (!(vh.myValue instanceof Long)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a Long for " + TestHelper.toString(vh));
        Long aLong = (Long)vh.myValue;
        long longValue = aLong;
        if (keyCounter == longValue) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }
}

