/*
 * Decompiled with CFR 0.152.
 */
package parReg.fixedPartitioning;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.FixedPartitionBlackboard;
import hydra.FixedPartitionPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.PartitionPrms;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import parReg.colocation.Month;
import parReg.fixedPartitioning.FPRExpirationTest;
import util.PRObserver;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class FPRTxParRegTest
extends ParRegTest {
    public final String VM_PARTITIONS = "vm_partitions_";
    public static final String DATASTORE_SEQUENCE_ID = "dataStore_sequence_id_";
    protected static Long dataStoreSequenceId;
    protected static Cache theCache;

    public static void StartTask_initialize() {
        HydraVector primaryPartitions = TestConfig.tab().vecAt(FixedPartitionPrms.partitionNames);
        int redundantCopies = TestConfig.tab().intAt(PartitionPrms.redundantCopies);
        ArrayList secondaryPartitions = new ArrayList();
        for (int i = 0; i < redundantCopies; ++i) {
            secondaryPartitions.addAll(primaryPartitions);
        }
        Log.getLogWriter().info("RedundantCopies is " + redundantCopies);
        Log.getLogWriter().info("PrimaryPartitions are " + primaryPartitions);
        Log.getLogWriter().info("Secondary partitions are " + secondaryPartitions);
        FixedPartitionBlackboard.getInstance().getSharedMap().put("PrimaryPartitions", primaryPartitions);
        FixedPartitionBlackboard.getInstance().getSharedMap().put("SecondaryPartitions", secondaryPartitions);
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new FPRTxParRegTest();
            FPRExpirationTest.setDataStoreSequenceId();
            ((FPRTxParRegTest)testInstance).initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            if (FPRTxParRegTest.testInstance.isBridgeConfiguration) {
                FPRTxParRegTest.testInstance.isBridgeClient = true;
                FPRTxParRegTest.testInstance.isDataStore = false;
                ParRegUtil.registerInterest(FPRTxParRegTest.testInstance.aRegion);
            }
        }
        FPRTxParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_initializeDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new FPRTxParRegTest();
            FPRExpirationTest.setDataStoreSequenceId();
            ((FPRTxParRegTest)testInstance).initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            FPRTxParRegTest.testInstance.isDataStore = true;
            if (FPRTxParRegTest.testInstance.isBridgeConfiguration) {
                FPRTxParRegTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        FPRTxParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_initializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new FPRTxParRegTest();
            ((FPRTxParRegTest)testInstance).initializeRegion("accessorRegion");
            testInstance.initializeInstance();
            FPRTxParRegTest.testInstance.isDataStore = false;
            if (FPRTxParRegTest.testInstance.isBridgeConfiguration) {
                FPRTxParRegTest.testInstance.isBridgeClient = true;
                ParRegUtil.registerInterest(FPRTxParRegTest.testInstance.aRegion);
            }
        }
        FPRTxParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_reinitializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new FPRTxParRegTest();
            testInstance.HA_reinitializeRegion();
            testInstance.initializeInstance();
            FPRTxParRegTest.testInstance.isDataStore = false;
        }
        FPRTxParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_reinitializeDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new FPRTxParRegTest();
            testInstance.HA_reinitializeRegion();
            testInstance.initializeInstance();
            FPRTxParRegTest.testInstance.isDataStore = true;
        }
        FPRTxParRegTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    @Override
    public void initializeRegion(String regDescriptName) {
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        if (theCache == null || CacheHelper.getCache() == null) {
            theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        }
        String regionName = RegionHelper.getRegionDescription(regDescriptName).getRegionName();
        this.aRegion = theCache.getRegion(regionName);
        if (this.aRegion != null) {
            Log.getLogWriter().info("Region " + this.aRegion.getName() + " already exists");
            return;
        }
        this.aRegion = RegionHelper.createRegion(regionName, regDescriptName);
        Log.getLogWriter().info("Created region " + this.aRegion.getName() + " with attributes " + this.aRegion.getAttributes());
        String cacheXmlFile = key + ".xml";
        File aFile = new File(cacheXmlFile);
        if (!aFile.exists()) {
            this.createXmlFile(aFile);
        }
        ParRegBB.getBB().getSharedMap().put(key, regDescriptName);
    }

    public void createXmlFile(File aFile) {
        if (!aFile.exists()) {
            try {
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(aFile), true);
                CacheXmlGenerator.generate((Cache)theCache, (PrintWriter)pw);
                pw.close();
            }
            catch (IOException ex) {
                throw new TestException("IOException during cache.xml generation to " + aFile + " : ", ex);
            }
        }
    }

    @Override
    public String HA_reinitializeRegion(String cachePrmsName) {
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String regDescriptName = (String)ParRegBB.getBB().getSharedMap().get(key);
        this.reInitializeRegion(regDescriptName);
        Log.getLogWriter().info("After recreating " + this.aRegion.getFullPath() + ", size is " + this.aRegion.size());
        if (InitImagePrms.useTransactions()) {
            TxHelper.setTransactionManager();
        }
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            try {
                this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
                Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
            }
            catch (IllegalArgumentException e) {
                String exceptStr = e.toString();
                if (exceptStr.indexOf("Service named " + LOCK_SERVICE_NAME + " already created") >= 0) {
                    Log.getLogWriter().info("Caught " + e + "; continuing test because lock service already exists");
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        return regDescriptName;
    }

    public void reInitializeRegion(String regDescriptName) {
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String cacheXmlFile = key + ".xml";
        File aFile = new File(cacheXmlFile);
        if (ds != null && ds.isConnected()) {
            this.initializeRegion(regDescriptName);
        } else {
            this.createCacheFromXml(cacheXmlFile);
        }
    }

    public void createCacheFromXml(String cacheXmlFile) {
        Log.getLogWriter().info("Creating cache using the xml file " + cacheXmlFile);
        theCache = CacheHelper.createCacheFromXml(cacheXmlFile);
        this.aRegion = theCache.getRegion("/partitionedRegion");
    }

    public static void HydraTask_verifyFixedPartitioning() {
        ((FPRTxParRegTest)testInstance).verifyPrimaryFixedPartitioning();
        ((FPRTxParRegTest)testInstance).verifySecondaryFixedPartitioning();
    }

    protected void verifyPrimaryFixedPartitioning() {
        PartitionedRegion pr = (PartitionedRegion)this.aRegion;
        List primaryBucketList = pr.getLocalPrimaryBucketsListTestOnly();
        Log.getLogWriter().info("Primary buckets for the partitioned region " + this.aRegion.getName() + " is " + primaryBucketList);
        HashMap<String, Set<Integer>> partition2Buckets = new HashMap<String, Set<Integer>>();
        if (primaryBucketList == null || primaryBucketList.size() == 0) {
            Log.getLogWriter().info("There are no primary buckets on this member");
            return;
        }
        List primaryPartitionsForPr = pr.getPrimaryFixedPartitionAttributes_TestsOnly();
        List<String> primaryPartitions = this.getPartitionNames(primaryPartitionsForPr);
        for (Integer bucketId : primaryBucketList) {
            Set keySet = pr.getBucketKeys(bucketId.intValue());
            Month routingObject = null;
            for (Object key : keySet) {
                Set<Integer> bucketIdSet;
                routingObject = (Month)ParRegBB.getBB().getSharedMap().get(key);
                String partitionName = routingObject.getQuarter();
                if (!primaryPartitions.contains(partitionName)) {
                    throw new TestException(" For the region " + pr.getName() + " for the key ," + key + " in the primary bucket " + bucketId + " the getPartition returned " + partitionName + " but the primary partitions on the node is " + primaryPartitions);
                }
                Log.getLogWriter().info(" For the region " + pr.getName() + " for the key ," + key + " in the primary bucket " + bucketId + " the getPartition returned " + partitionName + " and the primary partitions on the node is " + primaryPartitions);
                if (partition2Buckets.get(partitionName) == null) {
                    bucketIdSet = new HashSet<Integer>();
                    bucketIdSet.add(bucketId);
                    partition2Buckets.put(partitionName, bucketIdSet);
                    continue;
                }
                bucketIdSet = (Set)partition2Buckets.get(partitionName);
                if (bucketIdSet.contains(bucketId)) continue;
                bucketIdSet.add(bucketId);
            }
        }
    }

    protected void verifySecondaryFixedPartitioning() {
        PartitionedRegion pr = (PartitionedRegion)this.aRegion;
        if (pr.getLocalBucketsListTestOnly() == null || pr.getLocalBucketsListTestOnly().size() == 0) {
            Log.getLogWriter().info("There are no buckets on this member");
            return;
        }
        Log.getLogWriter().info("All local buckets for the partitioned region " + this.aRegion.getName() + " is " + pr.getLocalBucketsListTestOnly());
        HashSet bucketSet = new HashSet(pr.getLocalBucketsListTestOnly());
        bucketSet.removeAll(pr.getLocalPrimaryBucketsListTestOnly());
        Log.getLogWriter().info("Secondary buckets for the partitioned region " + pr.getName() + " on this member are " + bucketSet);
        HashMap<String, Set<Integer>> partition2Buckets = new HashMap<String, Set<Integer>>();
        List secondaryPartitionsForPr = pr.getSecondaryFixedPartitionAttributes_TestsOnly();
        List<String> secondaryPartitions = this.getPartitionNames(secondaryPartitionsForPr);
        for (Integer bucketId : bucketSet) {
            Set keySet = pr.getBucketKeys(bucketId.intValue());
            Month routingObject = null;
            for (Object key : keySet) {
                Set<Integer> bucketIdSet;
                routingObject = (Month)ParRegBB.getBB().getSharedMap().get(key);
                String partitionName = routingObject.getQuarter();
                if (!secondaryPartitions.contains(partitionName)) {
                    throw new TestException(" For the region " + pr.getName() + " for the key ," + key + " in the secondary bucket " + bucketId + " the getPartition returned " + partitionName + " but the secondary partitions on the node is " + secondaryPartitions);
                }
                Log.getLogWriter().info(" For the region " + pr.getName() + " for the key ," + key + " in the secondary bucket " + bucketId + " the getPartition returned " + partitionName + " and the secondary partitions on the node is " + secondaryPartitions);
                if (partition2Buckets.get(partitionName) == null) {
                    bucketIdSet = new HashSet<Integer>();
                    bucketIdSet.add(bucketId);
                    partition2Buckets.put(partitionName, bucketIdSet);
                    continue;
                }
                bucketIdSet = (Set)partition2Buckets.get(partitionName);
                if (bucketIdSet.contains(bucketId)) continue;
                bucketIdSet.add(bucketId);
            }
        }
    }

    protected void verifyPartitionNumBuckets(PartitionedRegion pr, List<FixedPartitionAttributesImpl> fpas, Map<String, Set<Integer>> partition2Buckets) {
        for (FixedPartitionAttributes fixedPartitionAttributes : fpas) {
            String partitionName = fixedPartitionAttributes.getPartitionName();
            HashSet bucketIdsOnMemberForPR = new HashSet();
            if (partition2Buckets.get(partitionName) != null) {
                Set<Integer> bucketIdSetForPartition = partition2Buckets.get(partitionName);
                int expectedNumBucketsForPartition = fixedPartitionAttributes.getNumBuckets();
                if (bucketIdSetForPartition.size() != expectedNumBucketsForPartition) {
                    throw new TestException("For the partitioned region " + pr.getName() + " for partition name " + partitionName + " expected number of buckets is " + expectedNumBucketsForPartition + " (" + fixedPartitionAttributes + ") but found " + bucketIdSetForPartition.size() + " bucket ids for this partition is " + bucketIdSetForPartition);
                }
                Log.getLogWriter().info("For the partitioned region " + pr.getName() + " for partition name " + partitionName + " found the expected number of buckets " + expectedNumBucketsForPartition + " bucket ids are " + bucketIdSetForPartition);
                if (!Collections.disjoint(bucketIdSetForPartition, bucketIdsOnMemberForPR)) {
                    throw new TestException("For the partitioned region " + pr.getName() + " for partition name " + partitionName + " bucket is shared with other partitions. Partition2Bucket map is " + partition2Buckets);
                }
            }
            Log.getLogWriter().info("Partition to bucket map for the partitioned region " + pr.getName() + " is " + partition2Buckets);
        }
    }

    protected List<String> getPartitionNames(List<FixedPartitionAttributesImpl> fpas) {
        ArrayList<String> partitionNames = new ArrayList<String>();
        for (FixedPartitionAttributesImpl fpa : fpas) {
            String partitionName = fpa.getPartitionName();
            partitionNames.add(partitionName);
        }
        return partitionNames;
    }
}

