/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.GatewayPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.ExecutionAndColocationTest;
import parReg.execute.HashMapResultCollector;
import parReg.execute.KeysOperationsFunction;
import util.PRObserver;
import util.TestException;

public class FunctionExecutionWithDistributedRegion
extends ExecutionAndColocationTest {
    protected static final String KEY_SET = "Key Set";

    private static FunctionExecutionWithDistributedRegion getTestInstance() {
        return (FunctionExecutionWithDistributedRegion)testInstance;
    }

    public static synchronized void HydraTask_HA_initReplicatedDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new FunctionExecutionWithDistributedRegion();
            ((FunctionExecutionWithDistributedRegion)testInstance).initInstance("replicateServerRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            RegionAttributes attr = FunctionExecutionWithDistributedRegion.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            if (prAttr == null) {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(-1L));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(-1L));
            } else {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(prAttr.getRecoveryDelay()));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(prAttr.getStartupRecoveryDelay()));
            }
        }
    }

    public static synchronized void HydraTask_HA_initEmptyDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new FunctionExecutionWithDistributedRegion();
            ((FunctionExecutionWithDistributedRegion)testInstance).initInstance("emptyServerRegion");
            RegionAttributes attr = FunctionExecutionWithDistributedRegion.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            if (prAttr == null) {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(-1L));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(-1L));
            } else {
                ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(prAttr.getRecoveryDelay()));
                ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(prAttr.getStartupRecoveryDelay()));
            }
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("server");
            }
        }
    }

    public static synchronized void HydraTask_HA_initClients() {
        if (testInstance == null) {
            testInstance = new FunctionExecutionWithDistributedRegion();
            ((FunctionExecutionWithDistributedRegion)testInstance).initInstance("clientRegion");
            if (isBridgeConfiguration) {
                Log.getLogWriter().info("Registering interest on the region");
                ParRegUtil.registerInterest(FunctionExecutionWithDistributedRegion.testInstance.aRegion);
            }
        }
    }

    public static void HydraTask_executeFunctionAllKeysHA() {
        ((FunctionExecutionWithDistributedRegion)testInstance).executeFunctionWithMapCollector();
        ((FunctionExecutionWithDistributedRegion)testInstance).executeFunctionWithListCollector();
    }

    public static void HydraTask_putKeySetInBB() {
        ((FunctionExecutionWithDistributedRegion)testInstance).putKeySetInBB();
    }

    @Override
    public void initInstance(String regDescriptName) {
        super.initInstance();
        this.highAvailability = TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false);
        Cache myCache = CacheHelper.createCache("cache1");
        ((FunctionExecutionWithDistributedRegion)testInstance).registerFunctions();
        InternalResourceManager.ResourceObserver ro = ParRegPrms.getResourceObserver();
        if (ro != null) {
            InternalResourceManager rm = InternalResourceManager.getInternalResourceManager((Cache)myCache);
            InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)ro);
        }
        this.aRegion = RegionHelper.createRegion(regDescriptName);
        isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        isGatewayConfiguration = TestConfig.tab().stringAt(GatewayPrms.names, null) != null;
        this.lockOperations = TestConfig.tab().booleanAt(ParRegPrms.lockOperations, false);
        if (this.lockOperations) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            this.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public void executeFunctionWithMapCollector() {
        Log.getLogWriter().info("executeFunctionWithMapCollector()");
        KeysOperationsFunction getAllKeysFunction = new KeysOperationsFunction();
        FunctionService.registerFunction((Function)getAllKeysFunction);
        HashMapResultCollector resultCollectorMap = new HashMapResultCollector();
        Set keySet = null;
        HashMap myMap = null;
        keySet = this.aRegion.getAttributes().getDataPolicy() == DataPolicy.EMPTY ? (Set)ParRegBB.getBB().getSharedMap().get(KEY_SET) : this.aRegion.keySet();
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorMap);
        try {
            ResultCollector rc = dataSet.withFilter(keySet).execute(new KeysOperationsFunction().getId());
            myMap = (HashMap)rc.getResult(200L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new TestException("Got this exception " + e.getMessage() + " Cause " + e.getCause(), e);
        }
        if (keySet.size() != myMap.size()) {
            throw new TestException("Expected result collector returned map size to be " + keySet.size() + " but got the value " + myMap.size());
        }
        Log.getLogWriter().info("Got the expected size for the map " + myMap.size());
        Iterator iterator = myMap.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        Object value = null;
        Object referenceValue = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            referenceValue = this.aRegion.get(key);
            if (value != null && referenceValue != null) {
                if (!value.equals(referenceValue)) {
                    throw new TestException("For the key " + key + " the values found in map is " + value + " and that in region is " + referenceValue);
                }
                Log.getLogWriter().info("For the key " + key + " the values found the expected values in map and region " + value);
                continue;
            }
            if (value == null && referenceValue == null) {
                Log.getLogWriter().info("Got expected null for the key " + key);
                continue;
            }
            throw new TestException("Expected value for the key " + key + " to be " + referenceValue + " but got the value " + value);
        }
    }

    public void executeFunctionWithListCollector() {
        Log.getLogWriter().info("executeFunctionWithListCollector()");
        ArrayListResultCollector resultCollectorList = new ArrayListResultCollector();
        Set keySet = null;
        ArrayList myList = null;
        keySet = this.aRegion.getAttributes().getDataPolicy() == DataPolicy.EMPTY ? (Set)ParRegBB.getBB().getSharedMap().get(KEY_SET) : this.aRegion.keySet();
        Execution dataSet = FunctionService.onRegion((Region)this.aRegion).withCollector((ResultCollector)resultCollectorList).withArgs((Object)"MultiNode");
        try {
            myList = (ArrayList)dataSet.withFilter(keySet).execute(new KeysOperationsFunction().getId()).getResult(200L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new TestException("Got this exception " + e.getMessage() + " Cause " + e.getCause(), e);
        }
        if (keySet.size() != myList.size()) {
            throw new TestException("Expected result collector returned map size to be " + keySet.size() + " but got the value " + myList.size());
        }
        Log.getLogWriter().info("Got the expected size for the map " + myList.size());
    }

    @Override
    public void putKeySetInBB() {
        HashSet keySet = new HashSet();
        Set keys = this.aRegion.keySet();
        for (Object key : keys) {
            keySet.add(key);
        }
        if (ParRegBB.getBB().getSharedMap().get(KEY_SET) == null) {
            ParRegBB.getBB().getSharedMap().put(KEY_SET, keySet);
        }
    }
}

