/*
 * Decompiled with CFR 0.152.
 */
package parReg.eviction;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import expiration.ExpirPrms;
import expiration.ExpirationBB;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import parReg.eviction.ParRegExpirationBB;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class ParRegExpirationTest {
    protected static ParRegExpirationTest testInstance;
    protected static Cache theCache;
    protected static String[] regionNames;
    protected static ArrayList bridgeRegionDescriptions;
    protected static ArrayList edgeRegionDescriptions;
    protected static final int TTLDestroyIndex = 0;
    protected static final int TTLInvalIndex = 1;
    protected static final int IdleTODestroyIndex = 2;
    protected static final int IdleTOInvalIndex = 3;
    protected static final int CustomTTLDestroyIndex = 4;
    protected static final int CustomTTLInvalIndex = 5;
    protected static final int CustomIdleTODestroyIndex = 6;
    protected static final int CustomIdleTOInvalIndex = 7;
    protected static final int numRegions = 8;

    public static void StartTask_initialize() {
        for (int i = 0; i < regionNames.length; ++i) {
            RegionDescription regDescription = RegionHelper.getRegionDescription(regionNames[i]);
            ExpirationBB.getBB().getSharedMap().put(regionNames[i], regDescription);
        }
    }

    public static synchronized void HydraTask_initializeControlThread() {
        if (testInstance == null) {
            testInstance = new ParRegExpirationTest();
            testInstance.initializeControlThread();
        }
    }

    public static synchronized void HydraTask_initServers() {
        if (testInstance == null) {
            testInstance = new ParRegExpirationTest();
            HydraVector regionDescriptionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
            for (String regionDescription : regionDescriptionNames) {
                if (regionDescription.startsWith("bridge")) {
                    bridgeRegionDescriptions.add(regionDescription);
                    continue;
                }
                if (regionDescription.startsWith("edge")) {
                    edgeRegionDescriptions.add(regionDescription);
                    continue;
                }
                throw new TestException("Test configuration issue - region name not valid " + regionDescription);
            }
            Log.getLogWriter().info("bridgeRegionDescriptions are " + bridgeRegionDescriptions);
            Log.getLogWriter().info("edgeRegionDescriptions are " + edgeRegionDescriptions);
            testInstance.initializeServers();
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_initClients() {
        if (testInstance == null) {
            testInstance = new ParRegExpirationTest();
            HydraVector regionDescriptionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
            for (String regionDescription : regionDescriptionNames) {
                if (regionDescription.startsWith("bridge")) {
                    bridgeRegionDescriptions.add(regionDescription);
                    continue;
                }
                if (regionDescription.startsWith("edge")) {
                    edgeRegionDescriptions.add(regionDescription);
                    continue;
                }
                throw new TestException("Test configuration issue - region name not valid " + regionDescription);
            }
            testInstance.initializeClients();
        }
    }

    public static void HydraTask_controlEntryTTLDestroy() {
        testInstance.controlEntryTTLDestroy();
    }

    public static void HydraTask_controlEntryTTLInval() {
        testInstance.controlEntryTTLInval();
    }

    public static void HydraTask_controlEntryIdleTODestroy() {
        testInstance.controlEntryIdleTODestroy();
    }

    public static void HydraTask_controlEntryIdleTOInval() {
        testInstance.controlEntryIdleTOInval();
    }

    public static void HydraTask_customEntryTTLDestroy() {
        testInstance.customEntryTTLDestroy();
    }

    public static void HydraTask_customEntryTTLInval() {
        testInstance.customEntryTTLInval();
    }

    public static void HydraTask_customEntryIdleTODestroy() {
        testInstance.customEntryIdleTODestroy();
    }

    public static void HydraTask_customEntryIdleTOInval() {
        testInstance.customEntryIdleTOInval();
    }

    protected void initializeControlThread() {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        for (int i = 0; i < regionNames.length; ++i) {
            RegionDescription regDescription = (RegionDescription)ExpirationBB.getBB().getSharedMap().get(regionNames[i]);
            RegionHelper.createRegion(regionNames[i], regDescription.getName());
        }
    }

    protected void initializeServers() {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        for (String regionDescriptionName : bridgeRegionDescriptions) {
            RegionDescription regDescription = RegionHelper.getRegionDescription(regionDescriptionName);
            String regionName = regDescription.getRegionName();
            RegionHelper.createRegion(regionName, regionDescriptionName);
        }
    }

    public void initializeClients() {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        for (String regionDescriptionName : edgeRegionDescriptions) {
            RegionDescription regDescription = RegionHelper.getRegionDescription(regionDescriptionName);
            RegionAttributes attributes = RegionHelper.getRegionAttributes(regDescription.getName());
            String poolName = attributes.getPoolName();
            if (poolName != null) {
                PoolHelper.createPool(poolName);
            }
            String regionName = regDescription.getRegionName();
            Region aRegion = theCache.createRegion(regionName, attributes);
            aRegion.registerInterest((Object)"ALL_KEYS");
        }
    }

    public void controlEntryTTLDestroy() {
        String regionName = regionNames[0];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String keyPrefix = regionName + "_";
        int numKeys = this.populateRegion(aRegion, keyPrefix);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_TTLDestroy", ParRegExpirationBB.numAfterCreateEvents_TTLDestroy, numKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterDestroyEvents_TTLDestroy", ParRegExpirationBB.numAfterDestroyEvents_TTLDestroy, numKeys * expectedVmsForEvents, true, 600000L);
        int regionSize = aRegion.keySet().size();
        if (regionSize != 0) {
            throw new TestException("Expected region to have all its entries destroyed, but it has " + regionSize + " keys");
        }
        Log.getLogWriter().info("As expected all entries in the region are destroyed in TTL with Destroy action");
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_TTLDestroy);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterDestroyEvents_TTLDestroy);
    }

    public void controlEntryTTLInval() {
        String regionName = regionNames[1];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String keyPrefix = regionName + "_";
        int numKeys = this.populateRegion(aRegion, keyPrefix);
        String key2 = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key2 + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key2, new Integer(numKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_TTLInvalidate", ParRegExpirationBB.numAfterCreateEvents_TTLInvalidate, numKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterInvalidateEvents_TTLInvalidate", ParRegExpirationBB.numAfterInvalidateEvents_TTLInvalidate, numKeys * expectedVmsForEvents, true, 600000L);
        for (String key2 : aRegion.keySet()) {
            try {
                Object value = aRegion.get((Object)key2);
                if (value == null) continue;
                throw new TestException("Found key " + key2 + " with non-null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("As expected all entries in the region are invalidated in TTL with Invalidate action, region size is " + aRegion.size());
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_TTLInvalidate);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterInvalidateEvents_TTLInvalidate);
    }

    public void controlEntryIdleTODestroy() {
        String regionName = regionNames[2];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String keyPrefix = regionName + "_";
        int numKeys = this.populateRegion(aRegion, keyPrefix);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_IdleTODestroy", ParRegExpirationBB.numAfterCreateEvents_IdleTODestroy, numKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterDestroyEvents_IdleTODestroy", ParRegExpirationBB.numAfterDestroyEvents_IdleTODestroy, numKeys * expectedVmsForEvents, true, 600000L);
        int regionSize = aRegion.keys().size();
        if (regionSize != 0) {
            throw new TestException("Expected region to have all its entries destroyed, but it has " + regionSize + " keys");
        }
        Log.getLogWriter().info("As expected all entries in the region are destroyed in Idle TO  with Destroy action");
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_IdleTODestroy);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterDestroyEvents_IdleTODestroy);
    }

    public void controlEntryIdleTOInval() {
        String regionName = regionNames[3];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String keyPrefix = regionName + "_";
        int numKeys = this.populateRegion(aRegion, keyPrefix);
        String key2 = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key2 + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key2, new Integer(numKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_IdleTOInvalidate", ParRegExpirationBB.numAfterCreateEvents_IdleTOInvalidate, numKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterInvalidateEvents_IdleTOInvalidate", ParRegExpirationBB.numAfterInvalidateEvents_IdleTOInvalidate, numKeys * expectedVmsForEvents, true, 600000L);
        for (String key2 : aRegion.keySet()) {
            try {
                Object value = aRegion.get((Object)key2);
                if (value == null) continue;
                throw new TestException("Found key " + key2 + " with non-null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("As expected all entries in the region are invalidated in Idle TO  with Invalidate action, region size is " + aRegion.size());
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_IdleTOInvalidate);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterInvalidateEvents_IdleTOInvalidate);
    }

    public void customEntryTTLDestroy() {
        String regionName = regionNames[4];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String expiryKeyPrefix = "Expire_" + regionName + "_";
        int expireNumKeys = this.populateRegion(aRegion, expiryKeyPrefix);
        String expireKey = regionName + "_expireNumKeys";
        Log.getLogWriter().info("Putting " + expireKey + ", " + expireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(expireKey, new Integer(expireNumKeys));
        String noExpiryKeyPrefix = "NotExpire_" + regionName + "_";
        int noExpireNumKeys = this.populateRegion(aRegion, noExpiryKeyPrefix);
        String noExpireKey = regionName + "_noExpireNumKeys";
        Log.getLogWriter().info("Putting " + noExpireKey + ", " + noExpireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(noExpireKey, new Integer(noExpireNumKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomExpiryTTLDestroy", ParRegExpirationBB.numAfterCreateEvents_CustomExpiryTTLDestroy, expireNumKeys * expectedVmsForEvents, true, 600000L);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomNoExpiryTTLDestroy", ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryTTLDestroy, noExpireNumKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterDestroyEvents_CustomTTLDestroy", ParRegExpirationBB.numAfterDestroyEvents_CustomTTLDestroy, expireNumKeys * expectedVmsForEvents, true, 600000L);
        Set keySet = aRegion.keySet();
        if (keySet.size() != noExpireNumKeys) {
            throw new TestException("Expected the region size after expiration to be the number of non expiry keys put into region " + noExpireNumKeys + " but has " + aRegion.size());
        }
        Log.getLogWriter().info("Got the expected size of region after expiration as " + noExpireNumKeys);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (!key.startsWith("Expire_")) continue;
            throw new TestException("Unexpected key " + key + " in the region " + aRegion.getName() + " after expiration");
        }
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomExpiryTTLDestroy);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryTTLDestroy);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterDestroyEvents_CustomTTLDestroy);
    }

    public void customEntryTTLInval() {
        String regionName = regionNames[5];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String expiryKeyPrefix = "Expire_" + regionName + "_";
        int expireNumKeys = this.populateRegion(aRegion, expiryKeyPrefix);
        String expireKey = regionName + "_expireNumKeys";
        Log.getLogWriter().info("Putting " + expireKey + ", " + expireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(expireKey, new Integer(expireNumKeys));
        String noExpiryKeyPrefix = "NotExpire_" + regionName + "_";
        int noExpireNumKeys = this.populateRegion(aRegion, noExpiryKeyPrefix);
        String noExpireKey = regionName + "_noExpireNumKeys";
        Log.getLogWriter().info("Putting " + noExpireKey + ", " + noExpireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(noExpireKey, new Integer(noExpireNumKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomExpiryTTLInvalidate", ParRegExpirationBB.numAfterCreateEvents_CustomExpiryTTLInvalidate, expireNumKeys * expectedVmsForEvents, true, 600000L);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomNoExpiryTTLInvalidate", ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryTTLInvalidate, noExpireNumKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterInvalidateEvents_CustomTTLInvalidate", ParRegExpirationBB.numAfterInvalidateEvents_CustomTTLInvalidate, expireNumKeys * expectedVmsForEvents, true, 600000L);
        for (Object key : aRegion.keySet()) {
            try {
                Object value = aRegion.get(key);
                if (value != null && key.toString().startsWith("Expire_")) {
                    throw new TestException("Found key " + key + " which is not supposed to be expired with non-null value " + value);
                }
                if (value != null || key.toString().startsWith("Expire_")) continue;
                throw new TestException("Found key " + key + " which is supposed to be expired with null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomExpiryTTLInvalidate);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryTTLInvalidate);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterInvalidateEvents_CustomTTLInvalidate);
    }

    public void customEntryIdleTODestroy() {
        String regionName = regionNames[6];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String expiryKeyPrefix = "Expire_" + regionName + "_";
        int expireNumKeys = this.populateRegion(aRegion, expiryKeyPrefix);
        String expireKey = regionName + "_expireNumKeys";
        Log.getLogWriter().info("Putting " + expireKey + ", " + expireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(expireKey, new Integer(expireNumKeys));
        String noExpiryKeyPrefix = "NotExpire_" + regionName + "_";
        int noExpireNumKeys = this.populateRegion(aRegion, noExpiryKeyPrefix);
        String noExpireKey = regionName + "_noExpireNumKeys";
        Log.getLogWriter().info("Putting " + noExpireKey + ", " + noExpireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(noExpireKey, new Integer(noExpireNumKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomExpiryIdleTODestroy", ParRegExpirationBB.numAfterCreateEvents_CustomExpiryIdleTODestroy, expireNumKeys * expectedVmsForEvents, true, 600000L);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomNoExpiryIdleTODestroy", ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryIdleTODestroy, noExpireNumKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterDestroyEvents_CustomIdleTODestroy", ParRegExpirationBB.numAfterDestroyEvents_CustomIdleTODestroy, expireNumKeys * expectedVmsForEvents, true, 600000L);
        Set keySet = aRegion.keySet();
        if (keySet.size() != noExpireNumKeys) {
            throw new TestException("Expected the region size after expiration to be the number of non expiry keys put into region " + noExpireNumKeys + " but has " + aRegion.size());
        }
        Log.getLogWriter().info("Got the expected size of region after expiration as " + noExpireNumKeys);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (!key.startsWith("Expire_")) continue;
            throw new TestException("Unexpected key " + key + " in the region " + aRegion.getName() + " after expiration");
        }
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomExpiryIdleTODestroy);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryIdleTODestroy);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterDestroyEvents_CustomIdleTODestroy);
    }

    public void customEntryIdleTOInval() {
        String regionName = regionNames[7];
        Region aRegion = CacheHelper.getCache().getRegion(regionName);
        String expiryKeyPrefix = "Expire_" + regionName + "_";
        int expireNumKeys = this.populateRegion(aRegion, expiryKeyPrefix);
        String expireKey = regionName + "_expireNumKeys";
        Log.getLogWriter().info("Putting " + expireKey + ", " + expireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(expireKey, new Integer(expireNumKeys));
        String noExpiryKeyPrefix = "NotExpire_" + regionName + "_";
        int noExpireNumKeys = this.populateRegion(aRegion, noExpiryKeyPrefix);
        String noExpireKey = regionName + "_noExpireNumKeys";
        Log.getLogWriter().info("Putting " + noExpireKey + ", " + noExpireNumKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(noExpireKey, new Integer(noExpireNumKeys));
        int expectedVmsForEvents = 1;
        if (TestConfig.tab().booleanAt(ExpirPrms.isBridgeClientConfiguration, false)) {
            expectedVmsForEvents = TestConfig.tab().intAt(ExpirPrms.numClientVms) + 1;
        }
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomExpiryIdleTOInvalidate", ParRegExpirationBB.numAfterCreateEvents_CustomExpiryIdleTOInvalidate, expireNumKeys * expectedVmsForEvents, true, 600000L);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterCreateEvents_CustomNoExpiryIdleTOInvalidate", ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryIdleTOInvalidate, noExpireNumKeys * expectedVmsForEvents, true, 600000L);
        ParRegExpirationBB.getBB().getSharedCounters().increment(ParRegExpirationBB.numPopulationTask_Completed);
        TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numAfterInvalidateEvents_CustomIdleTOInvalidate", ParRegExpirationBB.numAfterInvalidateEvents_CustomIdleTOInvalidate, expireNumKeys * expectedVmsForEvents, true, 600000L);
        for (Object key : aRegion.keySet()) {
            try {
                Object value = aRegion.get(key);
                if (value != null && key.toString().startsWith("Expire_")) {
                    throw new TestException("Found key " + key + " which is not supposed to be expired with non-null value " + value);
                }
                if (value != null || key.toString().startsWith("Expire_")) continue;
                throw new TestException("Found key " + key + " which is supposed to be expired with null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        ParRegExpirationBB.getBB().printSharedCounters();
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomExpiryIdleTOInvalidate);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterCreateEvents_CustomNoExpiryIdleTOInvalidate);
        ParRegExpirationBB.getBB().getSharedCounters().zero(ParRegExpirationBB.numAfterInvalidateEvents_CustomIdleTOInvalidate);
    }

    protected int populateRegion(Region aRegion, String keyPrefix) {
        String regionName = aRegion.getName();
        Log.getLogWriter().info("Populating region " + regionName + ", aRegion is " + TestHelper.regionToString(aRegion, true));
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long msToRun = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Putting for " + msToRun + " ms");
        int numKeys = 0;
        long startTimeMs = System.currentTimeMillis();
        do {
            String key = keyPrefix + ++numKeys;
            Long value = new Long(numKeys);
            try {
                Log.getLogWriter().info("Putting key " + key + ", value " + value + " into region " + regionName);
                if (TestConfig.tab().booleanAt(ExpirPrms.useTransactions, false)) {
                    TxHelper.begin();
                }
                long putStart = System.currentTimeMillis();
                aRegion.put((Object)key, (Object)value);
                long putEnd = System.currentTimeMillis();
                long duration = putEnd - putStart;
                Log.getLogWriter().info("Done putting key " + key + ", value " + value + " into region " + regionName + ", put took " + duration + " ms");
                if (duration > 30000L) {
                    throw new TestException("Put took a suspiciously long time, " + duration + " ms");
                }
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            finally {
                if (TxHelper.exists()) {
                    TxHelper.commitExpectSuccess();
                }
            }
        } while (System.currentTimeMillis() - startTimeMs < msToRun);
        Log.getLogWriter().info("Done putting into " + regionName + " for " + msToRun + " ms, put " + numKeys + " keys/values");
        return numKeys;
    }

    public static void killClient() {
        try {
            TestHelper.waitForCounter(ParRegExpirationBB.getBB(), "numPopulationTask_Completed", ParRegExpirationBB.numPopulationTask_Completed, 8L, true, 600000L);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -20, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    static {
        bridgeRegionDescriptions = new ArrayList();
        edgeRegionDescriptions = new ArrayList();
        regionNames = new String[8];
        ParRegExpirationTest.regionNames[0] = "TTLDestroy";
        ParRegExpirationTest.regionNames[1] = "TTLInval";
        ParRegExpirationTest.regionNames[2] = "IdleTODestroy";
        ParRegExpirationTest.regionNames[3] = "IdleTOInval";
        ParRegExpirationTest.regionNames[4] = "CustomTTLDestroy";
        ParRegExpirationTest.regionNames[5] = "CustomTTLInval";
        ParRegExpirationTest.regionNames[6] = "CustomIdleTODestroy";
        ParRegExpirationTest.regionNames[7] = "CustomIdleTOInval";
    }
}

