/*
 * Decompiled with CFR 0.152.
 */
package parReg.colocation;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RegionHelper;
import java.util.HashSet;
import java.util.Set;
import parReg.colocation.ParRegColocation;
import parReg.execute.UpdateBBPartitionListener;
import rebalance.RebalancePrms;
import rebalance.RebalanceUtil;
import util.TestException;

public class ParRegColocationWithListener
extends ParRegColocation {
    private static RebalanceOperation rebalanceOp;

    public static void HydraTask_verifyEmptyRecreatedBuckets() {
        PartitionedRegion aRegion;
        String regionName;
        String regionDescriptName = null;
        Set recreatedBucketSet = new HashSet();
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            regionDescriptName = (String)regionDescriptNames.get(j);
            regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            aRegion = (PartitionedRegion)theCache.getRegion(regionName);
            if (aRegion.getPartitionListeners() == null || aRegion.getPartitionListeners().length <= 1) continue;
            UpdateBBPartitionListener partitionListener = (UpdateBBPartitionListener)aRegion.getPartitionListeners()[1];
            recreatedBucketSet = partitionListener.getReCreatedBucketSet();
        }
        for (int i = 0; i < regionDescriptNames.size(); ++i) {
            regionDescriptName = (String)regionDescriptNames.get(i);
            regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            aRegion = (PartitionedRegion)theCache.getRegion(regionName);
            if (aRegion.getPartitionListeners() != null && aRegion.getPartitionListeners().length != 0) continue;
            ParRegColocationWithListener.validateEmptyBuckets(aRegion, recreatedBucketSet);
        }
    }

    public static void HydraTask_rebalanceTask() {
        Log.getLogWriter().info("In HydraTask_rebalanceTask");
        ParRegColocationWithListener.rebalance();
    }

    public static void validateEmptyBuckets(PartitionedRegion aRegion, Set recreatedBucketSet) {
        Log.getLogWriter().info("Recreated bucket set is " + recreatedBucketSet);
        for (Object bucketId : recreatedBucketSet) {
            try {
                Set bucketKeys = aRegion.getBucketKeys(((Integer)bucketId).intValue());
                if (bucketKeys.size() == 0) continue;
                throw new TestException("For the bucketId " + bucketId + " of region " + aRegion.getName() + " bucket is not empty as expected");
            }
            catch (Exception e) {
                throw new TestException("Caught Exception ", e);
            }
        }
    }

    public static void rebalance() {
        ResourceManager rm = CacheHelper.getCache().getResourceManager();
        RebalanceFactory factory = rm.createRebalanceFactory();
        HashSet<String> includedRegionSet = new HashSet<String>();
        for (int i = 1; i <= 1; ++i) {
            PartitionedRegion includedRegion = (PartitionedRegion)theCache.getRegion("/clientRegion" + i);
            if (includedRegion == null) {
                throw new TestException("Test Issue: Included region cannot be null");
            }
            includedRegionSet.add(includedRegion.getName());
        }
        Log.getLogWriter().info("Included regions for rebalancing " + includedRegionSet);
        factory.includeRegions(includedRegionSet);
        RebalanceOperation rebalanceOp = factory.start();
        try {
            RebalanceResults rebalanceResults = rebalanceOp.getResults();
            Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
        }
        catch (Exception e) {
            throw new TestException("Caught the exception ", e);
        }
    }

    public static void setResourceObserver() {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("setResourceObserver() expects hydra client to have created cache and PR via initialization tasks");
        }
        ResourceManager rm = myCache.getResourceManager();
        InternalResourceManager.ResourceObserver ro = RebalancePrms.getResourceObserver();
        if (ro != null) {
            InternalResourceManager cfr_ignored_0 = (InternalResourceManager)rm;
            InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)ro);
            Log.getLogWriter().info("Installed ResourceObserver " + ro.toString());
        }
    }
}

