/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxSerializable;
import hydra.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import parReg.ParRegUtil;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import util.BaseValueHolder;
import util.TestException;
import util.TestHelper;

public class ParRegUtilVersionHelper {
    public static void verifyMyValue(Object key, Object expectedValue, Object valueToCheck, int compareStrategy) {
        if (valueToCheck == null) {
            if (expectedValue != null) {
                throw new TestException("For key " + key + ", expected myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(valueToCheck));
            }
        } else if (valueToCheck instanceof BaseValueHolder || valueToCheck instanceof PdxInstance) {
            BaseValueHolder actualVH = PdxTest.toValueHolder(valueToCheck);
            if (actualVH.myValue == null) {
                Log.getLogWriter().info("valueToCheck is " + TestHelper.toString(valueToCheck));
                Log.getLogWriter().info("actualVH is " + TestHelper.toString(actualVH));
                throw new TestException("For key " + key + ", " + TestHelper.toString(actualVH) + " has unexpected null myValue field, expect it to be " + TestHelper.toString(expectedValue));
            }
            if (compareStrategy == ParRegUtil.EQUAL) {
                if (!actualVH.myValue.equals(expectedValue)) {
                    Log.getLogWriter().info("expectedValue is " + TestHelper.toString(expectedValue));
                    Log.getLogWriter().info("valueToCheck is " + TestHelper.toString(valueToCheck));
                    Log.getLogWriter().info("actualVH is " + TestHelper.toString(actualVH));
                    throw new TestException("For key " + key + ", expected ValueHolder.myValue to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualVH));
                }
            } else if (compareStrategy == ParRegUtil.EQUIVALENT && actualVH.myValue.toString().equals(expectedValue.toString())) {
                Log.getLogWriter().info("valueToCheck is " + TestHelper.toString(valueToCheck));
                Log.getLogWriter().info("actualVH is " + TestHelper.toString(actualVH));
                throw new TestException("For key " + key + ", expected ValueHolder.myValue to be " + expectedValue + ", but it is " + actualVH.myValue);
            }
            if (actualVH instanceof PdxSerializable) {
                String searchStr = "updated_";
                if (expectedValue.toString().startsWith(searchStr)) {
                    actualVH.verifyMyFields(expectedValue.toString(), Long.valueOf(expectedValue.toString().substring(searchStr.length())));
                } else {
                    actualVH.verifyMyFields(Long.valueOf(expectedValue.toString()));
                }
            }
        } else {
            throw new TestException("Expected value for key " + key + " to be an instance of ValueHolder, but it is " + TestHelper.toString(valueToCheck));
        }
    }

    public static String getVersionTagStr(Region aRegion, Object key) {
        String versionTagStr = "";
        RegionAttributes attr = aRegion.getAttributes();
        if (attr.getConcurrencyChecksEnabled()) {
            VersionTag version = null;
            try {
                version = ((LocalRegion)aRegion).getVersionTag(key);
            }
            catch (EntryDestroyedException entryDestroyedException) {
                // empty catch block
            }
            versionTagStr = ", my version=" + version;
        }
        return versionTagStr;
    }

    public static void dumpBackingMap(Region aRegion) {
        ((LocalRegion)aRegion).dumpBackingMap();
    }

    public static String compareBucketMaps(Object _dump1, Object _dump2) {
        BucketDump dump1 = (BucketDump)_dump1;
        BucketDump dump2 = (BucketDump)_dump2;
        StringBuilder aStr = new StringBuilder();
        ParRegUtilVersionHelper.compareRVVs(aStr, dump1, dump2);
        Map map1 = dump1.getValues();
        Map versions1 = dump1.getVersions();
        String map1LogStr = ParRegUtilVersionHelper.getBucketMapStr(map1);
        Map map2 = dump2.getValues();
        Map versions2 = dump2.getVersions();
        String map2LogStr = ParRegUtilVersionHelper.getBucketMapStr(map2);
        if (map1.size() != map2.size()) {
            aStr.append("Bucket map <" + map1LogStr + "> is size " + map1.size() + " and bucket map <" + map2LogStr + "> is size " + map2.size() + "\n");
        }
        for (Object key : map1.keySet()) {
            VersionTag version = (VersionTag)versions1.get(key);
            Object value = PdxTestVersionHelper.toBaseObject(map1.get(key));
            if (map2.containsKey(key)) {
                VersionTag map2Version = (VersionTag)versions2.get(key);
                Object map2Value = PdxTestVersionHelper.toBaseObject(map2.get(key));
                try {
                    ParRegUtil.verifyValue(key, value, map2Value, ParRegUtil.EQUAL);
                    ParRegUtilVersionHelper.verifyVersionTags(version, map2Version);
                }
                catch (TestException e) {
                    String version1Str = version == null ? "" : " version " + version;
                    String version2Str = map2Version == null ? "" : " version " + map2Version;
                    aStr.append("Bucket map <" + map1LogStr + "> has key " + key + ", value " + TestHelper.toString(value) + version1Str + ", but bucket map <" + map2LogStr + "> has key " + key + ", value " + TestHelper.toString(map2Value) + version2Str + "; " + e.getMessage() + "\n");
                }
                continue;
            }
            aStr.append("Bucket map <" + map1LogStr + "> contains key " + key + ", but bucket map <" + map2LogStr + "> does not contain key " + key + "\n");
        }
        Set map1Keys = map1.keySet();
        Set map2Keys = map2.keySet();
        map2Keys.removeAll(map1Keys);
        if (map2Keys.size() != 0) {
            aStr.append("Found extra keys in bucket map <" + map2LogStr + ">, that were not found in bucket map <" + map1LogStr + ">: " + map2Keys + "\n");
        }
        if (aStr.length() > 0) {
            Log.getLogWriter().info("Bucket map 1: " + map1);
            Log.getLogWriter().info("Bucket map 2: " + map2);
        }
        return aStr.toString();
    }

    private static String getBucketMapStr(Map<Object, Object> bucketMap) {
        String bucketMapStr = bucketMap.toString();
        StringBuilder reducedStr = new StringBuilder();
        int index = bucketMapStr.indexOf("{");
        if (index < 0) {
            return bucketMapStr;
        }
        reducedStr.append(bucketMapStr.substring(0, index));
        index = bucketMapStr.lastIndexOf("}");
        if (index < 0) {
            return bucketMapStr;
        }
        reducedStr.append(bucketMapStr.substring(index + 1, bucketMapStr.length()));
        return reducedStr.toString();
    }

    private static void compareRVVs(StringBuilder aStr, BucketDump dump1, BucketDump dump2) {
        RegionVersionVector rvv1 = dump1.getRvv();
        RegionVersionVector rvv2 = dump2.getRvv();
        if (rvv1 == null) {
            if (rvv2 != null) {
                aStr.append(dump2 + " has an RVV, but " + dump1 + " does not");
            }
        } else if (rvv2 == null) {
            aStr.append(dump1 + " has an RVV, but " + dump2 + " does not");
        } else {
            HashMap rvv2Members = new HashMap(rvv1.getMemberToVersion());
            HashMap rvv1Members = new HashMap(rvv1.getMemberToVersion());
            for (Map.Entry entry : rvv1Members.entrySet()) {
                VersionSource memberId = (VersionSource)entry.getKey();
                RegionVersionHolder versionHolder1 = (RegionVersionHolder)entry.getValue();
                RegionVersionHolder versionHolder2 = (RegionVersionHolder)rvv2Members.remove(memberId);
                if (versionHolder2 == null || versionHolder1.equals((Object)versionHolder2)) continue;
                aStr.append(dump1 + " RVV does not match RVV for " + dump2 + "\n");
                aStr.append("RVV for " + dump1 + ":" + versionHolder1 + "\n");
                aStr.append("RVV for " + dump2 + ":" + versionHolder2 + "\n");
            }
        }
    }

    private static void verifyVersionTags(VersionTag version, VersionTag version2) {
        boolean equal;
        boolean bl = version == null && version2 == null || version != null & version2 != null && version.equals((Object)version2) ? true : (equal = false);
        if (!equal) {
            throw new TestException("Version tag mismatch");
        }
    }
}

