/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.persistence.ConflictingPersistentDataException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.persistence.RevokedPersistentDataException;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.distributed.PoolCancelledException;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DiskStoreHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import util.PRObserver;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class ParRegCreateDestroy {
    protected static ParRegCreateDestroy testInstance;
    protected static List regionDescriptNames;
    protected static List bridgeRegionDescriptNames;
    protected static int destroyThreshold;
    protected static final int ENTRIES_TO_PUT = 50;
    protected static Cache theCache;
    protected static boolean isBridgeConfiguration;
    protected static boolean isBridgeClient;
    private static int selection;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize();
            testInstance = new ParRegCreateDestroy();
            testInstance.initialize();
        }
        Log.getLogWriter().info("isBridgeConfiguration: " + isBridgeConfiguration);
        Log.getLogWriter().info("isBridgeClient: " + isBridgeClient);
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new ParRegCreateDestroy();
            testInstance.initialize();
            BridgeHelper.startBridgeServer("bridge");
        }
        isBridgeClient = false;
        Log.getLogWriter().info("isBridgeConfiguration: " + isBridgeConfiguration);
        Log.getLogWriter().info("isBridgeClient: " + isBridgeClient);
    }

    protected void initialize() {
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        isBridgeConfiguration = bridgeNames != null;
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int i = 0; i < regionNames.size(); ++i) {
            String regionDescriptName = (String)regionNames.get(i);
            if (regionDescriptName.startsWith("bridge")) {
                bridgeRegionDescriptNames.add(regionDescriptName);
                continue;
            }
            regionDescriptNames.add(regionDescriptName);
        }
        if (isBridgeConfiguration && bridgeRegionDescriptNames.size() != regionDescriptNames.size()) {
            throw new TestException("Error in test configuration; need equal number of region descriptions for bridge servers and bridge clients");
        }
        Log.getLogWriter().info("bridgeRegionDescriptNames is " + bridgeRegionDescriptNames);
        Log.getLogWriter().info("regionDescriptNames is " + regionDescriptNames);
        theCache = CacheHelper.createCache("cache1");
        destroyThreshold = (int)((double)regionDescriptNames.size() * 0.8);
        Log.getLogWriter().info("destroyThreshold is " + destroyThreshold);
        Log.getLogWriter().info("ENTRIES_TO_PUT is 50");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_createDestroy() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        try {
            do {
                testInstance.doCreateDestroy();
            } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        }
        finally {
            if (isBridgeConfiguration) {
                for (Region r : theCache.rootRegions()) {
                    ClientHelper.release(r);
                }
            }
        }
    }

    public static void HydraTask_createDestroyWithPersistence() {
        int secondsToRun = TestConfig.tab().intAt(ParRegPrms.secondsToRun);
        ParRegTest.checkForLastIteration(secondsToRun);
        ParRegCreateDestroy.HydraTask_createDestroy();
        if (ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop) > 1L) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.Pausing);
            throw new StopSchedulingTaskOnClientOrder("Stopping this thread from tasks");
        }
    }

    public static void HydraTask_revokeWaitingMembers() {
        for (int i = 1; i <= 100; ++i) {
            RecoveryTestVersionHelper.forceRecovery(false);
        }
        long numThreadsStopped = ParRegBB.getBB().getSharedCounters().read(ParRegBB.Pausing);
        Log.getLogWriter().info("NumThreadsStopped counter is " + numThreadsStopped);
        if (numThreadsStopped >= (long)(TestHelper.getNumThreads() - 1)) {
            throw new StopSchedulingTaskOnClientOrder("Stopping admin thread");
        }
    }

    public static void HydraTask_createRegions() {
        testInstance.doCreateRegionsOnly();
    }

    protected void doCreateRegionsOnly() {
        if (isBridgeConfiguration && !isBridgeClient) {
            Log.getLogWriter().info("Inside bridge server");
            this.doCreateRegions(bridgeRegionDescriptNames);
        } else if (isBridgeConfiguration) {
            this.doCreateRegions(regionDescriptNames);
        } else {
            long numOfAccessors = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfAccessors);
            if (ParRegBB.getBB().getSharedMap().get("Vm Id: " + RemoteTestModule.getMyVmid()) == null) {
                ParRegBB.getBB().getSharedMap().put("Vm Id: " + RemoteTestModule.getMyVmid(), "NotAnAccessor");
            }
            if (numOfAccessors <= TestConfig.tab().longAt(ParRegPrms.numberOfAccessors, 0L) || ParRegBB.getBB().getSharedMap().get("Vm Id: " + RemoteTestModule.getMyVmid()).toString().equalsIgnoreCase("Accessor")) {
                Iterator iterator = regionDescriptNames.iterator();
                ArrayList<String> accessorRegionDescriptNames = new ArrayList<String>();
                while (iterator.hasNext()) {
                    String regionDescription = (String)iterator.next();
                    if (!regionDescription.startsWith("aRegion")) continue;
                    accessorRegionDescriptNames.add(regionDescription);
                }
                this.doCreateRegions(accessorRegionDescriptNames);
            } else {
                Iterator iterator = regionDescriptNames.iterator();
                ArrayList<String> nonAccessorRegionDescriptNames = new ArrayList<String>();
                while (iterator.hasNext()) {
                    String regionDescription = (String)iterator.next();
                    if (regionDescription.startsWith("aRegion")) continue;
                    nonAccessorRegionDescriptNames.add(regionDescription);
                }
                this.doCreateRegions(nonAccessorRegionDescriptNames);
            }
        }
    }

    public void doCreateRegions(List regionDescriptNames) {
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            Region aRegion;
            String poolName;
            String regionDescriptName = (String)regionDescriptNames.get(j);
            System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
            String diskStoreName = attributes.getDiskStoreName();
            if (diskStoreName != null) {
                DiskStoreHelper.createDiskStore(diskStoreName);
            }
            if ((poolName = attributes.getPoolName()) != null) {
                PoolHelper.createPool(poolName);
            }
            try {
                aRegion = theCache.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
                Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
                continue;
            }
            catch (RegionExistsException e) {
                Log.getLogWriter().info("Using existing partitioned region " + regionName);
                aRegion = e.getRegion();
                if (aRegion != null) continue;
                throw new TestException("RegionExistsException.getRegion returned null");
            }
        }
    }

    private void checkPutException(RuntimeException e, Region aRegion) {
        if (e instanceof RegionDestroyedException) {
            Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuing test");
            return;
        }
        if (e instanceof CancelException) {
            Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuing test");
            return;
        }
        if (e instanceof PartitionedRegionStorageException) {
            String errStr = e.toString();
            if (errStr.indexOf(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString()) >= 0 || errStr.indexOf(PRHARedundancyProvider.TIMEOUT_MSG.toLocalizedString()) >= 0 || errStr.indexOf("putAll at server applied partial keys due to exception") >= 0) {
                Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuing test");
                return;
            }
            throw e;
        }
        if (e instanceof ServerConnectivityException) {
            String errStr;
            if (!isBridgeClient) {
                throw e;
            }
            if (e.getCause() instanceof RegionDestroyedException) {
                Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuing test");
                return;
            }
            if (e.getCause() instanceof PartitionedRegionStorageException && ((errStr = e.toString()).indexOf(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString()) >= 0 || errStr.indexOf(PRHARedundancyProvider.TIMEOUT_MSG.toLocalizedString()) >= 0 || errStr.indexOf("putAll at server applied partial keys due to exception") >= 0)) {
                Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuing test");
                return;
            }
            throw e;
        }
        if (e instanceof CacheWriterException) {
            if (!isBridgeClient) {
                throw e;
            }
            String errStr = e.toString();
            if (errStr.indexOf("Either the specified region, key or value was invalid. ") >= 0 || errStr.indexOf("The BridgeWriter has been closed") >= 0 || errStr.indexOf(PRHARedundancyProvider.TIMEOUT_MSG.toLocalizedString()) >= 0 || errStr.indexOf("was not found during put request") >= 0 || errStr.indexOf("RegionDestroyedException") >= 0) {
                Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuing test");
                return;
            }
            if (errStr.indexOf("Failed to put entry") >= 0) {
                throw new TestException("Bug 37120 detected: " + TestHelper.getStackTrace(e));
            }
            throw e;
        }
        if (e instanceof PartitionOfflineException) {
            Log.getLogWriter().info("Caught expected exception " + e + " while putting into " + aRegion.getFullPath() + "; continuting test");
            return;
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateDestroy() {
        block39: {
            String poolName;
            int randInt;
            Set rootRegions = theCache.rootRegions();
            Region aRegion = null;
            String regionDescriptName = null;
            if (isBridgeConfiguration && !isBridgeClient) {
                randInt = TestConfig.tab().getRandGen().nextInt(0, bridgeRegionDescriptNames.size() - 1);
                regionDescriptName = (String)bridgeRegionDescriptNames.get(randInt);
            } else {
                randInt = TestConfig.tab().getRandGen().nextInt(0, regionDescriptNames.size() - 1);
                regionDescriptName = (String)regionDescriptNames.get(randInt);
            }
            System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
            if (attributes.getDiskStoreName() != null) {
                DiskStoreHelper.createDiskStore(attributes.getDiskStoreName());
            }
            if ((poolName = attributes.getPoolName()) != null) {
                PoolHelper.createPool(poolName);
            }
            try {
                aRegion = theCache.createRegion(regionName, attributes);
                Log.getLogWriter().info("Created partitioned region " + regionName + " with region descript name " + regionDescriptName);
            }
            catch (RegionExistsException e) {
                Log.getLogWriter().info("Using existing partitioned region " + regionName);
                aRegion = e.getRegion();
                if (aRegion == null) {
                    throw new TestException("RegionExistsException.getRegion returned null");
                }
            }
            catch (BridgeWriterException bwe) {
                if (bwe.getCause() instanceof CancelException) {
                    Log.getLogWriter().info("Caught expected exception " + (Object)((Object)bwe) + " while creating the region " + aRegion.getFullPath() + "; continuing test");
                    return;
                }
                if (isBridgeClient) {
                    String errStr = bwe.toString();
                    if (errStr.indexOf("The BridgeWriter has been closed") >= 0) {
                        Log.getLogWriter().info("Caught expected exception " + (Object)((Object)bwe) + " while creating region; continuing test");
                        return;
                    }
                }
                throw bwe;
            }
            catch (ConflictingPersistentDataException e) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + " while creating region; continuing test");
                return;
            }
            catch (RevokedPersistentDataException e) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + " while creating region; continuing test");
                return;
            }
            Log.getLogWriter().info("Putting 50 entries into " + aRegion.getFullPath());
            ++selection;
            HashMap<String, Integer> mapToPut = new HashMap<String, Integer>();
            for (int i = 1; i <= 50; ++i) {
                mapToPut.put("" + System.currentTimeMillis(), new Integer(i));
            }
            try {
                aRegion.putAll(mapToPut);
            }
            catch (PoolCancelledException e) {
                Throwable cause = e;
                do {
                    if ((cause = cause.getCause()) != null) continue;
                    throw e;
                } while (cause instanceof ServerOperationException);
                if (!(cause instanceof RuntimeException)) {
                    throw e;
                }
                this.checkPutException((RuntimeException)cause, aRegion);
            }
            catch (RuntimeException e) {
                this.checkPutException(e, aRegion);
            }
            rootRegions = theCache.rootRegions();
            if (rootRegions.size() >= destroyThreshold) {
                Iterator it = rootRegions.iterator();
                aRegion = (Region)it.next();
                if (isBridgeConfiguration) {
                    ClientHelper.release(aRegion);
                }
                try {
                    int randInt2 = TestConfig.tab().getRandGen().nextInt(1, 100);
                    if (randInt2 <= 33) {
                        Log.getLogWriter().info("Destroying " + aRegion.getFullPath());
                        aRegion.destroyRegion();
                    } else if (randInt2 <= 66) {
                        Log.getLogWriter().info("Locally destroying " + aRegion.getFullPath());
                        aRegion.localDestroyRegion();
                    } else {
                        Log.getLogWriter().info("Closing " + aRegion.getFullPath());
                        aRegion.close();
                    }
                }
                catch (RegionDestroyedException e) {
                    Log.getLogWriter().info("Caught expected exception " + ((Object)((Object)e)).getClass().getName() + "; continuing test");
                }
                catch (ServerConnectivityException e) {
                    if (isBridgeClient) {
                        if (e.getCause() instanceof RegionDestroyedException) {
                            Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + " while putting into " + aRegion.getFullPath() + "; continuing test");
                            break block39;
                        }
                        throw e;
                    }
                    throw e;
                }
                catch (CacheWriterException e) {
                    String errStr = e.toString();
                    if (errStr.indexOf("Either the specified region or key was invalid") >= 0) {
                        throw new TestException("Bug 37039 detected: " + TestHelper.getStackTrace(e));
                    }
                    if (errStr.indexOf("RegionDestroyedException") >= 0) {
                        Log.getLogWriter().info("Caught expected exception " + ((Object)((Object)e)).getClass().getName() + "; continuing test");
                        break block39;
                    }
                    if (errStr.indexOf("was not found during destroy region request") >= 0) {
                        Log.getLogWriter().info("Caught expected exception " + ((Object)((Object)e)).getClass().getName() + "; continuing test");
                        break block39;
                    }
                    throw e;
                }
                finally {
                    ClientHelper.release(aRegion);
                }
            }
        }
    }

    public static void shutdownHook() {
        ParRegUtil.dumpAllPartitionedRegions();
    }

    static {
        regionDescriptNames = new ArrayList();
        bridgeRegionDescriptNames = new ArrayList();
        isBridgeConfiguration = false;
        isBridgeClient = true;
        selection = 0;
    }
}

