/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import admin.AdminTest;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import parReg.ParRegAlertListener;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import parReg.colocation.KeyResolver;
import parReg.colocation.Month;
import parReg.execute.PartitionObjectHolder;
import parReg.execute.RoutingHolder;
import util.CacheDefPrms;
import util.CacheDefinition;
import util.CacheUtil;
import util.DeclarativeGenerator;
import util.NameFactory;
import util.RandomValuesPrms;
import util.RegionDefPrms;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;

public class FillTest
extends ParRegTest {
    protected long myLocalMaxMemoryMB = 0L;
    protected long lowerThresholdNumEntries = 0L;
    protected long upperThresholdNumEntries = 0L;
    protected String myAlertCounterName;
    protected int myAlertCounter;
    protected int numVMs;
    static boolean alertAdded = false;
    static final String ExceededLocalMaxMemoryMsg = "has exceeded local maximum memory configuration ";
    static final String CounterPrefix = "AlertForLocalMaxMemory";
    protected static final int FIXED_LENGTH_KEY_SIZE = 20;

    public static synchronized void HydraTask_initializeDataStore() {
        if (testInstance == null) {
            testInstance = new FillTest();
            ((FillTest)testInstance).initializeWithRegDef("region1");
            testInstance.initializeInstance();
        }
    }

    public static synchronized void HydraTask_initializeAccessor() {
        if (testInstance == null) {
            testInstance = new FillTest();
            ((FillTest)testInstance).initializeForAccessor("region1");
            testInstance.initializeInstance();
        }
    }

    protected void initializeWithRegDef(String specName) {
        this.cacheDef = CacheDefinition.createCacheDefinition(CacheDefPrms.cacheSpecs, "cache1");
        this.regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, specName);
        Properties localProps = this.regDef.getParRegLocalProperties();
        if (localProps == null) {
            localProps = new Properties();
        }
        this.myLocalMaxMemoryMB = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.LocalMaxMemoryCounter);
        localProps.setProperty("LOCAL_MAX_MEMORY", String.valueOf(this.myLocalMaxMemoryMB));
        this.regDef.setParRegLocalProperties(localProps);
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String xmlFile = key + ".xml";
        DeclarativeGenerator.createDeclarativeXml(key + ".xml", this.cacheDef, this.regDef, true);
        this.aRegion = CacheUtil.createRegion(this.cacheDef, this.regDef, xmlFile);
    }

    protected void initializeForAccessor(String specName) {
        this.cacheDef = CacheDefinition.createCacheDefinition(CacheDefPrms.cacheSpecs, "cache1");
        this.regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, specName);
        Properties localProps = this.regDef.getParRegLocalProperties();
        if (localProps == null) {
            localProps = new Properties();
        }
        localProps.setProperty("LOCAL_MAX_MEMORY", String.valueOf(0));
        this.regDef.setParRegLocalProperties(localProps);
        if (this.regDef.getDataPolicy() != null && this.regDef.getDataPolicy() == DataPolicy.PERSISTENT_PARTITION) {
            this.regDef.setDataPolicy(DataPolicy.PARTITION);
        }
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String xmlFile = key + ".xml";
        DeclarativeGenerator.createDeclarativeXml(key + ".xml", this.cacheDef, this.regDef, true);
        this.aRegion = CacheUtil.createRegion(this.cacheDef, this.regDef, xmlFile);
    }

    @Override
    public void initializeInstance() {
        super.initializeInstance();
        this.numVMs = TestHelper.getNumVMs();
        if (this.myLocalMaxMemoryMB != 0L) {
            this.myAlertCounterName = CounterPrefix + this.myLocalMaxMemoryMB;
            this.myAlertCounter = ParRegBB.getBB().getSharedCounter(this.myAlertCounterName);
            this.myAlertCounterName = "ParRegBB." + this.myAlertCounterName;
            long localMaxMemoryBytes = this.myLocalMaxMemoryMB * 1024L * 1024L;
            int entrySize = TestConfig.tab().intAt(RandomValuesPrms.elementSize);
            long numEntriesForLocalMaxMem = localMaxMemoryBytes / (long)entrySize;
            int allowance = (int)((double)localMaxMemoryBytes * 0.25 / (double)entrySize);
            this.lowerThresholdNumEntries = numEntriesForLocalMaxMem - (long)(++allowance);
            this.upperThresholdNumEntries = numEntriesForLocalMaxMem + (long)allowance;
            Log.getLogWriter().info("    Local max memory for this vm: " + this.myLocalMaxMemoryMB + "MB\n                      Entry size: " + entrySize + "bytes\nNum entries for local max memory: " + numEntriesForLocalMaxMem + "\n       Num entries for allowance: " + allowance + "\n     Lower threshold num entries: " + this.lowerThresholdNumEntries + "\n     Upper threshold num entries: " + this.upperThresholdNumEntries);
        }
    }

    public static synchronized void HydraTask_addAlertListener() {
        if (!alertAdded) {
            ParRegAlertListener listener = new ParRegAlertListener();
            Log.getLogWriter().info("Adding " + listener + " to " + AdminTest.testInstance.ds);
            AdminTest.testInstance.ds.addAlertListener((AlertListener)listener);
            alertAdded = true;
        }
    }

    public static void HydraTask_disconnect() {
        CacheUtil.disconnect();
        testInstance = null;
        ParRegBB.getBB().getSharedCounters().zero(ParRegBB.LocalMaxMemoryCounter);
    }

    public static void HydraTask_addToRegion() {
        ((FillTest)testInstance).addToRegion();
    }

    protected void addToRegion() {
        long startTime = System.currentTimeMillis();
        do {
            Object key = FillTest.getFixedLengthKey();
            Object value = this.randomValues.getRandomObject();
            Log.getLogWriter().info("Putting key " + key + " value " + TestHelper.toString(value));
            this.aRegion.put(key, value);
            Log.getLogWriter().info("Done putting key " + key);
            MasterController.sleepForMs(300);
            this.checkAlertError();
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        this.endTestIfOver();
    }

    public static void HydraTask_addToRegionWithPartitionResolver() {
        ((FillTest)testInstance).addToRegionWithPartitionResolver();
    }

    protected void addToRegionWithPartitionResolver() {
        if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("callbackarg")) {
            Log.getLogWriter().info("Inside callback");
            this.addToRegionCallbackPartitionResolver();
        } else if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("key")) {
            Log.getLogWriter().info("Inside key");
            this.addToRegionKeyPartitionResolver();
        } else if (TestConfig.tab().stringAt(ParRegPrms.partitionResolverData).equalsIgnoreCase("value")) {
            Log.getLogWriter().info("Inside value");
            this.addToRegionValueRoutingResolver();
        }
    }

    protected void addToRegionValueRoutingResolver() {
        long startTime = System.currentTimeMillis();
        do {
            String keyName = FillTest.getFixedLengthKey().toString();
            Object valueObject = this.randomValues.getRandomObject();
            Log.getLogWriter().info("Putting key " + keyName + " value " + TestHelper.toString(valueObject));
            Month routingObjectHolder = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            PartitionObjectHolder key = new PartitionObjectHolder(keyName, routingObjectHolder);
            PartitionObjectHolder value = new PartitionObjectHolder(valueObject, routingObjectHolder);
            this.aRegion.put((Object)key, (Object)value);
            Log.getLogWriter().info("Done putting key " + key);
            MasterController.sleepForMs(300);
            this.checkAlertError();
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        this.endTestIfOver();
    }

    protected void addToRegionKeyPartitionResolver() {
        long startTime = System.currentTimeMillis();
        do {
            String keyName = FillTest.getFixedLengthKey().toString();
            Object value = this.randomValues.getRandomObject();
            Log.getLogWriter().info("Putting key " + keyName + " value " + TestHelper.toString(value));
            Month routingObjectHolder = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            KeyResolver key = new KeyResolver(keyName, routingObjectHolder);
            this.aRegion.put((Object)key, value);
            Log.getLogWriter().info("Done putting key " + key);
            MasterController.sleepForMs(300);
            this.checkAlertError();
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        this.endTestIfOver();
    }

    protected void addToRegionCallbackPartitionResolver() {
        long startTime = System.currentTimeMillis();
        do {
            String keyName = FillTest.getFixedLengthKey().toString();
            Object value = this.randomValues.getRandomObject();
            Log.getLogWriter().info("Putting key " + keyName + " value " + TestHelper.toString(value));
            Month routingObjectHolder = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            PartitionObjectHolder key = new PartitionObjectHolder(keyName, routingObjectHolder);
            KeyResolver callBackArg = new KeyResolver(keyName, routingObjectHolder);
            this.aRegion.put((Object)key, value, (Object)callBackArg);
            Log.getLogWriter().info("Done putting key " + key);
            MasterController.sleepForMs(300);
            this.checkAlertError();
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        this.endTestIfOver();
    }

    public static void HydraTask_monitorAlerts() {
        ((FillTest)testInstance).monitorAlerts();
    }

    protected void monitorAlerts() {
        long startTime = System.currentTimeMillis();
        do {
            long counter;
            if ((counter = ParRegBB.getBB().getSharedCounters().read(this.myAlertCounter)) > 0L) {
                long localSize = ParRegUtil.getLocalSize(this.aRegion);
                String key = "Alert-" + this.myLocalMaxMemoryMB + "MB: approximate num keys at time of alert";
                ParRegBB.getBB().getSharedMap().put(key, new Long(localSize));
                Log.getLogWriter().info("Detected alert for localMaxMemory " + this.myLocalMaxMemoryMB + ", put key " + key + " value " + localSize + " into blackboard");
                throw new StopSchedulingTaskOnClientOrder("This VM caused an alert for localMaxMemory " + this.myLocalMaxMemoryMB + "; local data store size is " + localSize + ", upperThresholdNumEntries: " + this.upperThresholdNumEntries + ", lowerThresholdNumEntries: " + this.lowerThresholdNumEntries);
            }
            MasterController.sleepForMs(50);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    public static synchronized void HydraTask_verify() {
        ((FillTest)testInstance).verify();
    }

    protected void verify() {
        ParRegBB.getBB().print();
        this.checkAlertError();
        StringBuffer errStr = new StringBuffer();
        long counterValue = ParRegBB.getBB().getSharedCounters().read(this.myAlertCounter);
        Log.getLogWriter().info("BB counter " + this.myAlertCounterName + " has value " + counterValue);
        int numAlertsExpected = this.numVMs - 1;
        if (counterValue != (long)numAlertsExpected) {
            errStr.append("Expected " + numAlertsExpected + " alerts to be received for exceeded this VM's localMaxMemory setting of " + this.myLocalMaxMemoryMB + ", but received " + counterValue + "\n");
        }
        boolean foundAlert = false;
        Map sharedMap = ParRegBB.getBB().getSharedMap().getMap();
        for (Object key : sharedMap.keySet()) {
            String keyStr;
            Log.getLogWriter().info("Considering key " + key);
            if (!(key instanceof String) || (keyStr = (String)key).indexOf("Alert") < 0) continue;
            int index1 = keyStr.indexOf("MB");
            int index2 = keyStr.lastIndexOf("-", index1 - 1);
            int maxMemoryForThisAlert = Integer.valueOf(keyStr.substring(index2 + 1, index1));
            Log.getLogWriter().info("For key " + key + ", maxMemoryForThisAlert is " + maxMemoryForThisAlert);
            if ((long)maxMemoryForThisAlert != this.myLocalMaxMemoryMB) continue;
            foundAlert = true;
            long numEntriesAtAlertTime = (Long)sharedMap.get(key);
            if (numEntriesAtAlertTime < this.lowerThresholdNumEntries || numEntriesAtAlertTime > this.upperThresholdNumEntries) {
                errStr.append("Alert for localMaxMemory " + maxMemoryForThisAlert + " occurred at unexpected time, num entries in this VM at the time of the alert is " + numEntriesAtAlertTime + ", but expected it to be between " + this.lowerThresholdNumEntries + " and " + this.upperThresholdNumEntries);
                break;
            }
            Log.getLogWriter().info("Alert for localMaxMemory " + maxMemoryForThisAlert + " occurred at expected time, num entries in this VM at the time of the alert is " + numEntriesAtAlertTime + ", lower theshold is " + this.lowerThresholdNumEntries + " and upperThreshold is " + this.upperThresholdNumEntries);
            break;
        }
        if (!foundAlert) {
            errStr.append("Did not detect an alert for localMaxMemory setting " + this.myLocalMaxMemoryMB + "\n");
        }
        if (errStr.length() != 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static synchronized void HydraTask_verifyCustomPartitioning() {
        ((FillTest)testInstance).verifyCustomPartitioning();
    }

    protected void verifyCustomPartitioning() {
        PartitionedRegion pr = (PartitionedRegion)this.aRegion;
        int totalBuckets = pr.getTotalNumberOfBuckets();
        RegionAttributes attr = this.aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        int redundantCopies = prAttr.getRedundantCopies();
        int expectedNumCopies = redundantCopies + 1;
        int verifyBucketCopiesBucketId = 0;
        while (verifyBucketCopiesBucketId < totalBuckets) {
            Log.getLogWriter().info("Verifying data for bucket id " + verifyBucketCopiesBucketId + " out of " + totalBuckets + " buckets");
            List listOfMaps = null;
            try {
                listOfMaps = pr.getAllBucketEntries(verifyBucketCopiesBucketId);
            }
            catch (ForceReattemptException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            int size = listOfMaps.size();
            if (size == 0) {
                Log.getLogWriter().info("Bucket " + verifyBucketCopiesBucketId + " is empty");
                ++verifyBucketCopiesBucketId;
                continue;
            }
            if (size != expectedNumCopies) {
                throw new TestException("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, but have " + listOfMaps.size());
            }
            Log.getLogWriter().info("For bucketId " + verifyBucketCopiesBucketId + ", expected " + expectedNumCopies + " bucket copies, and have " + listOfMaps.size());
            Log.getLogWriter().info("Validating co-location for all the redundant copies of the bucket with Id : " + verifyBucketCopiesBucketId);
            for (int i = 0; i < listOfMaps.size(); ++i) {
                BucketDump dump = (BucketDump)listOfMaps.get(i);
                Map map = dump.getValues();
                this.verifyCustomPartition(map, verifyBucketCopiesBucketId);
                this.verifyUniqueBucketForCustomPartioning(verifyBucketCopiesBucketId);
            }
            ++verifyBucketCopiesBucketId;
        }
    }

    protected void verifyCustomPartition(Map map, int bucketid) {
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        RoutingHolder key = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getKey() instanceof KeyResolver) {
                key = (KeyResolver)entry.getKey();
            } else if (entry.getKey() instanceof PartitionObjectHolder) {
                key = (PartitionObjectHolder)entry.getKey();
            }
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid) == null) {
                Log.getLogWriter().info("RoutingObject for the bucket id to be set in the BB");
                ParRegBB.getBB().getSharedMap().put("RoutingObjectForBucketid:" + bucketid, key.getRoutingHint().toString());
                ParRegBB.getBB().getSharedMap().put("RoutingObjectKeyBucketid:" + bucketid, key);
                Log.getLogWriter().info("BB value set to " + key.getRoutingHint().toString());
                continue;
            }
            Log.getLogWriter().info("Checking the value for the routing object ");
            String blackBoardRoutingObject = (String)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketid);
            String keyRoutingObject = key.getRoutingHint().toString();
            if (!keyRoutingObject.equalsIgnoreCase(blackBoardRoutingObject)) {
                throw new TestException("Expected same routing objects for the entries in this bucket id " + bucketid + "but got different values " + blackBoardRoutingObject + " and " + keyRoutingObject);
            }
            Log.getLogWriter().info("Got the expected values " + blackBoardRoutingObject + " and " + keyRoutingObject + " for the keys " + ParRegBB.getBB().getSharedMap().get("RoutingObjectKeyBucketid:" + bucketid) + " and " + key);
        }
    }

    protected void verifyUniqueBucketForCustomPartioning(int bucketId) {
        if (bucketId == 0) {
            Log.getLogWriter().info("This is the first bucket, so no validation required as there is no bucket to be compared");
            return;
        }
        for (int i = 0; i < bucketId; ++i) {
            if (ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i) == null) continue;
            String referenceValue = (String)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + i);
            String currentValue = (String)ParRegBB.getBB().getSharedMap().get("RoutingObjectForBucketid:" + bucketId);
            Log.getLogWriter().info("currentValue: " + currentValue);
            Log.getLogWriter().info("referenceValue: " + referenceValue);
            if (currentValue.equalsIgnoreCase(referenceValue)) {
                throw new TestException("Two buckets with the id " + i + " and " + bucketId + " have the same routing Object " + referenceValue);
            }
            Log.getLogWriter().info("As expected the bucket with ids " + i + " and " + bucketId + " have the different routing Object " + currentValue + " and " + referenceValue);
        }
    }

    public static void dumpBuckets() {
        ((FillTest)testInstance).dumpAllTheBuckets();
    }

    public void dumpAllTheBuckets() {
        try {
            PartitionedRegion pr = (PartitionedRegion)this.aRegion;
            pr.dumpAllBuckets(false, Log.getLogWriter().convertToLogWriterI18n());
        }
        catch (ReplyException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassCastException e) {
            Log.getLogWriter().info("Not dumping data stores on " + this.aRegion + " because it is not a PartitionedRegion (probably because it's a region  from a bridge client");
        }
    }

    public static void HydraTask_verifyPR() {
        ((FillTest)testInstance).verifyPR();
    }

    public void verifyPR() {
        try {
            ParRegUtil.verifyPRMetaData(this.aRegion);
        }
        catch (Exception e) {
            throw new TestException(e.getMessage());
        }
        catch (TestException e) {
            throw new TestException(e.getMessage());
        }
        try {
            ParRegUtil.verifyPrimaries(this.aRegion, this.redundantCopies);
        }
        catch (Exception e) {
            throw new TestException(e.getMessage());
        }
        catch (TestException e) {
            throw new TestException(e.getMessage());
        }
    }

    static String getExpectedAlertMsg(int MB) {
        return ExceededLocalMaxMemoryMsg + MB + " Mb, currentsize is " + MB + " Mb";
    }

    protected void checkAlertError() {
        Object error = ParRegBB.getBB().getSharedMap().get("Error");
        if (error != null) {
            throw new TestException(error.toString());
        }
    }

    protected void endTestIfOver() {
        long largestLMM = ParRegBB.getBB().getSharedCounters().read(ParRegBB.LocalMaxMemoryCounter);
        int i = 1;
        while ((long)i <= largestLMM) {
            String counterName = CounterPrefix + i;
            int counter = ParRegBB.getBB().getSharedCounter(counterName);
            counterName = "ParRegBB." + counterName;
            long counterValue = ParRegBB.getBB().getSharedCounters().read(counter);
            if (counterValue < (long)(this.numVMs - 1)) {
                return;
            }
            ++i;
        }
        throw new StopSchedulingOrder("All alerts have been caused and received");
    }

    protected static Object getFixedLengthKey() {
        String key = NameFactory.getNextPositiveObjectName().toString();
        StringBuffer aStr = new StringBuffer();
        aStr.append(key);
        while (aStr.length() < 20) {
            aStr.append(" ");
        }
        return aStr.toString();
    }
}

