/*
 * Decompiled with CFR 0.152.
 */
package orderPolicy;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import hct.HctPrms;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.GatewaySenderHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.IOException;
import java.util.List;
import orderPolicy.OrderPolicyBB;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;
import wan.CacheClientPrms;
import wan.CacheServerPrms;
import wan.WANBlackboard;
import wan.WANClient;

public class OrderPolicyTest
extends WANClient {
    protected static RandomValues randomValues = new RandomValues();
    protected static OrderPolicyTest testInstance;
    public HydraThreadLocal uniqueKeyIndex = new HydraThreadLocal();
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;

    public static synchronized void initPeerForOrderPolicyTest() {
        if (testInstance == null) {
            String cacheConfig = TestConfig.tasktab().stringAt(CacheClientPrms.cacheConfig, TestConfig.tab().stringAt(CacheClientPrms.cacheConfig, null));
            String regionConfig = TestConfig.tasktab().stringAt(CacheClientPrms.regionConfig, TestConfig.tab().stringAt(CacheClientPrms.regionConfig, null));
            testInstance = new OrderPolicyTest();
            Log.getLogWriter().info("testInstance = " + testInstance);
            testInstance.createCache(cacheConfig);
            testInstance.createGatewaySender();
            testInstance.createRegion(REGION_NAME, regionConfig);
            testInstance.createGatewayHub();
            randomValues = new RandomValues();
            testInstance.initTaskTime();
        }
    }

    public static synchronized void initServerForOrderPolicyTest() {
        if (testInstance == null) {
            String cacheConfig = TestConfig.tasktab().stringAt(CacheServerPrms.cacheConfig, TestConfig.tab().stringAt(CacheServerPrms.cacheConfig, null));
            String regionConfig = TestConfig.tasktab().stringAt(CacheServerPrms.regionConfig, TestConfig.tab().stringAt(CacheServerPrms.regionConfig, null));
            String bridgeConfig = TestConfig.tasktab().stringAt(CacheServerPrms.bridgeConfig, TestConfig.tab().stringAt(CacheServerPrms.bridgeConfig, null));
            testInstance = new OrderPolicyTest();
            testInstance.createCache(cacheConfig);
            testInstance.createGatewaySender();
            testInstance.createRegion(REGION_NAME, regionConfig);
            OrderPolicyTest.initPdxDiskStore();
            testInstance.startBridgeServer(bridgeConfig);
            testInstance.createGatewayHub();
            randomValues = new RandomValues();
            testInstance.initTaskTime();
        }
    }

    public static synchronized void initEdgeForOrderPolicyTest() {
        if (testInstance == null) {
            String cacheConfig = TestConfig.tab().stringAt(CacheClientPrms.cacheConfig);
            String regionConfig = TestConfig.tab().stringAt(CacheClientPrms.regionConfig);
            testInstance = new OrderPolicyTest();
            Cache cache = testInstance.createCache(cacheConfig);
            Region region = testInstance.createRegion(REGION_NAME, regionConfig);
            PoolImpl mybw = ClientHelper.getPool(region);
            ServerLocation primaryEndpoint = mybw.getPrimary();
            Log.getLogWriter().info("The primary server endpoint is " + primaryEndpoint);
            region.registerInterest((Object)"ALL_KEYS", CacheClientPrms.getInterestPolicy());
            Log.getLogWriter().info(region.getFullPath() + ": Registered interest in ALL_KEYS");
            randomValues = new RandomValues();
            testInstance.initTaskTime();
        }
    }

    protected void initTaskTime() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
    }

    public static void startGatewayHubTask() {
        String gatewayConfig = TestConfig.tab().stringAt(CacheServerPrms.gatewayConfig);
        testInstance.startGatewayHub(gatewayConfig);
        testInstance.startQueueMonitor();
    }

    protected void createGatewaySender() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        if (senderConfig != null) {
            GatewaySenderHelper.createGatewaySenders(senderConfig);
        }
    }

    public static void initializeInstanceTask() {
        Log.getLogWriter().info("testInstance = " + testInstance);
        testInstance.initializeInstance();
    }

    protected void initializeInstance() {
        OrderPolicyBB bb = OrderPolicyBB.getBB();
        int vmId = RemoteTestModule.getMyVmid();
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        String mapKey = "vm_" + vmId + "_thr_" + tid;
        if (bb.getSharedMap().get(mapKey) == null) {
            bb.getSharedMap().put(mapKey, 0);
        }
        this.uniqueKeyIndex.set(new Integer(tid));
    }

    public static void putsForThreadOrderPolicyTask() throws Exception {
        testInstance.putsForThreadOrderPolicy();
    }

    protected void putsForThreadOrderPolicy() {
        OrderPolicyBB bb = OrderPolicyBB.getBB();
        Region region = RegionHelper.getRegion(REGION_NAME);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        int vmId = RemoteTestModule.getMyVmid();
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        String currentOpsStr = "vm_" + vmId + "_thr_" + tid;
        long mytid = Thread.currentThread().getId();
        String callbackArg = "vm_" + vmId + "_thr_" + mytid;
        int opNum = (Integer)bb.getSharedMap().get(currentOpsStr);
        int keyCounter = (Integer)this.uniqueKeyIndex.get();
        int numWorkingThreads = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long startTime = System.currentTimeMillis();
        do {
            TestHelper.checkForEventError(WANBlackboard.getInstance());
            OrderPolicyTest.startNoKillZone();
            for (long i = 1L; i <= (long)ITERATIONS; ++i) {
                String key = NameFactory.getObjectNameForCounter(keyCounter);
                ValueHolder vh = new ValueHolder((Object)key, randomValues, new Integer(opNum));
                Log.getLogWriter().info("putting: " + key + ":" + vh.toString() + ":" + callbackArg);
                region.put((Object)key, (Object)vh, (Object)callbackArg);
                ++opNum;
            }
            OrderPolicyTest.endNoKillZone();
            bb.getSharedMap().put(currentOpsStr, new Integer(opNum));
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    public static void putsForKeyOrderPolicyTask() throws Exception {
        testInstance.putsForKeyOrderPolicy();
    }

    protected void putsForKeyOrderPolicy() {
        OrderPolicyBB bb = OrderPolicyBB.getBB();
        Region region = RegionHelper.getRegion(REGION_NAME);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        int vmId = RemoteTestModule.getMyVmid();
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        String callbackArg = "vm_" + vmId + "_thr_" + tid;
        int opNum = (Integer)bb.getSharedMap().get(callbackArg);
        int keyCounter = (Integer)this.uniqueKeyIndex.get();
        long startTime = System.currentTimeMillis();
        do {
            TestHelper.checkForEventError(WANBlackboard.getInstance());
            OrderPolicyTest.startNoKillZone();
            for (long i = 1L; i <= (long)ITERATIONS; ++i) {
                String key = NameFactory.getObjectNameForCounter(keyCounter);
                ValueHolder vh = new ValueHolder((Object)key, randomValues, new Integer(opNum));
                Log.getLogWriter().info("putting: " + key + ":" + vh.toString() + ":" + callbackArg);
                region.put((Object)key, (Object)vh, (Object)callbackArg);
                ++opNum;
            }
            OrderPolicyTest.endNoKillZone();
            bb.getSharedMap().put(callbackArg, new Integer(opNum));
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    public static synchronized void pauseGatewayHub() {
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        Log.getLogWriter().info("Sleeping for " + sleepMs + "ms");
        MasterController.sleepForMs(sleepMs);
        GatewayHub hub = null;
        List hubs = CacheHelper.getCache().getGatewayHubs();
        if (hubs.size() > 0) {
            hub = (GatewayHub)CacheHelper.getCache().getGatewayHubs().get(0);
        }
        int restartWaitSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        if (hub != null) {
            Log.getLogWriter().info("Pausing GatewayHub " + hub.toString() + " resuming in " + restartWaitSec + " seconds");
            hub.pauseGateways();
        }
        MasterController.sleepForMs(restartWaitSec * 1000);
        Log.getLogWriter().info("Resuming GatewayHub " + hub.toString());
        hub.resumeGateways();
        Log.getLogWriter().info("Resumed GatewayHub " + hub.toString());
    }

    public static synchronized void stopGatewayHub() {
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        Log.getLogWriter().info("Sleeping for " + sleepMs + "ms");
        MasterController.sleepForMs(sleepMs);
        GatewayHub hub = null;
        List hubs = CacheHelper.getCache().getGatewayHubs();
        if (hubs.size() > 0) {
            hub = (GatewayHub)CacheHelper.getCache().getGatewayHubs().get(0);
        }
        int restartWaitSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        if (hub != null) {
            Log.getLogWriter().info("Stopping GatewayHub " + hub.toString() + " restarting in " + restartWaitSec + " seconds");
            hub.stop();
        }
        MasterController.sleepForMs(restartWaitSec * 1000);
        try {
            Log.getLogWriter().info("Starting GatewayHub " + hub.toString());
            hub.startGateways();
            Log.getLogWriter().info("Started GatewayHub " + hub.toString());
        }
        catch (IOException ioe) {
            throw new TestException("startGateways caught unexpected Exception " + ioe + "\n" + TestHelper.getStackTrace(ioe));
        }
    }

    public static void checkForEventErrors() {
        OrderPolicyTest.waitForQueuesToDrain();
        TestHelper.checkForEventError(WANBlackboard.getInstance());
    }
}

