/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import objects.ConfigurableObject;
import objects.ObjectValidationException;

public class SmallObject
implements ConfigurableObject,
DataSerializable {
    protected int id;
    protected String name;

    public void init(int index) {
        this.id = index;
        this.name = "joe";
    }

    public int getIndex() {
        return this.id;
    }

    public void validate(int index) {
        int actualIndex = this.getIndex();
        if (actualIndex != index) {
            throw new ObjectValidationException("Expected index " + index + ", got " + actualIndex);
        }
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public boolean equals(Object o) {
        if (o instanceof SmallObject) {
            SmallObject other = (SmallObject)o;
            if (this.id == other.id) {
                return true;
            }
        }
        return false;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
        DataSerializer.writeString((String)this.name, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.name = DataSerializer.readString((DataInput)in);
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(SmallObject.class, 23){

            public DataSerializable newInstance() {
                return new SmallObject();
            }
        });
    }
}

