/*
 * Decompiled with CFR 0.152.
 */
package objects;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import objects.ConfigurableObject;
import objects.Portfolio;
import parReg.query.Position;

public class PRPortfolio
extends Portfolio
implements ConfigurableObject,
Serializable {
    protected String myVersion = "tests/objects.PRPortfolio";
    protected static final Random rng = new Random();
    protected int NUM_OF_TYPES = 10;
    protected int MAX_NUM_OF_POSITIONS = 5;
    protected int NUM_OF_SECURITIES = 200;
    private int MAX_QTY = 100;
    private int MAX_PRICE = 100;
    protected String name = "name";
    protected Map positions = new HashMap();
    public String undefinedTestField = null;

    public PRPortfolio() {
    }

    public PRPortfolio(String name, int id) {
        this.name = name;
        this.ID = id;
        this.status = id % 2 == 0 ? "active" : "inactive";
        this.type = "type" + id % this.NUM_OF_TYPES;
        this.setPositions();
    }

    public int getId() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setId(int id) {
        this.ID = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void init(int i) {
        this.name = new Integer(i).toString();
        this.ID = i;
        this.status = i % 2 == 0 ? "active" : "inactive";
        this.type = "type" + i % this.NUM_OF_TYPES;
        this.setPositions();
    }

    private void setPositions() {
        int numOfPositions = 2;
        if (numOfPositions == 0) {
            ++numOfPositions;
        }
        int secId = rng.nextInt(this.NUM_OF_SECURITIES);
        for (int i = 0; i < numOfPositions; ++i) {
            Properties props = this.getProps();
            if ((secId += i * 7) > this.NUM_OF_SECURITIES) {
                secId -= this.NUM_OF_SECURITIES;
            }
            props.setProperty("secId", new Integer(secId).toString());
            Position pos = new Position();
            pos.init(props);
            this.positions.put(pos.getSecId(), pos);
        }
    }

    @Override
    public void validate(int index) {
    }

    @Override
    public int getIndex() {
        return this.ID;
    }

    public Map getPositions() {
        return this.positions;
    }

    protected Properties getProps() {
        Properties props = new Properties();
        Double qty = new Double((double)rng.nextInt(this.MAX_QTY) * 100.0);
        Double mktValue = new Double(rng.nextDouble() * (double)this.MAX_PRICE);
        props.setProperty("qty", qty.toString());
        props.setProperty("mktValue", mktValue.toString());
        return props;
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (anObj.getClass().getName().equals(this.getClass().getName())) {
            PRPortfolio np = (PRPortfolio)anObj;
            if (!(np.name.equals(this.name) && np.ID == this.ID && np.type.equals(this.type) && np.status.equals(this.status))) {
                return false;
            }
            if (np.positions == null) {
                if (this.positions != null) {
                    return false;
                }
            } else {
                if (np.positions.size() != this.positions.size()) {
                    return false;
                }
                for (Position pos : np.positions.values()) {
                    if (this.positions.containsValue(pos)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + this.name.hashCode();
        result = 37 * result + this.status.hashCode();
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.ID;
        result = 37 * result + this.positions.hashCode();
        return result;
    }

    @Override
    public Map createPdxHelperMap() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("className", this.getClass().getName());
        fieldMap.put("myVersion", this.myVersion);
        fieldMap.put("id", this.ID);
        fieldMap.put("name", this.name);
        fieldMap.put("status", this.status);
        fieldMap.put("type", this.type);
        fieldMap.put("positions", this.positions);
        fieldMap.put("undefinedTestField", this.undefinedTestField);
        return fieldMap;
    }

    @Override
    public void restoreFromPdxHelperMap(Map aMap) {
        this.myVersion = (String)aMap.get("myVersion");
        this.ID = (Integer)aMap.get("id");
        this.name = (String)aMap.get("name");
        this.status = (String)aMap.get("status");
        this.type = (String)aMap.get("type");
        this.positions = (Map)aMap.get("positions");
        this.undefinedTestField = (String)aMap.get("undefinedTestField");
    }
}

