/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import hydra.GsRandom;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import objects.ConfigurableObject;
import objects.FastAssetPrms;
import objects.ObjectValidationException;

public class FastAsset
implements ConfigurableObject,
DataSerializable {
    private static final GsRandom rng;
    private int assetId;
    private double value;

    public void init(int anAssetId) {
        this.assetId = anAssetId;
        this.value = rng.nextDouble(1.0, FastAssetPrms.getMaxValue());
    }

    public FastAsset copy() {
        FastAsset asset = new FastAsset();
        asset.setAssetId(this.getAssetId());
        asset.setValue(this.getValue());
        return asset;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int i) {
        this.assetId = i;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public int getIndex() {
        return this.assetId;
    }

    public void validate(int index) {
        int encodedIndex = this.getIndex();
        if (encodedIndex != index) {
            String s = "Expected index " + index + ", got " + encodedIndex;
            throw new ObjectValidationException(s);
        }
    }

    public String toString() {
        return "FastAsset [assetId=" + this.assetId + " value=" + this.value + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FastAsset) {
            FastAsset asset = (FastAsset)obj;
            return this.assetId == asset.assetId;
        }
        return false;
    }

    public int hashCode() {
        return this.assetId;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.assetId);
        out.writeDouble(this.value);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.assetId = in.readInt();
        this.value = in.readDouble();
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(FastAsset.class, 24){

            public DataSerializable newInstance() {
                return new FastAsset();
            }
        });
        rng = new GsRandom(12L);
    }
}

