/*
 * Decompiled with CFR 0.152.
 */
package newWan.discovery;

import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.cache.wan.DistributedSystemListener;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import newWan.discovery.DynamicDiscoveryBB;

public class MyDistributedSystemListener
implements DistributedSystemListener {
    public static List<String> siteAddedList = new ArrayList<String>();
    public static List<String> siteRemovedList = new ArrayList<String>();

    public void removedDistributedSystem(int remoteDsId) {
        long siteRemovedcount = DynamicDiscoveryBB.getInstance().getSharedCounters().incrementAndRead(DynamicDiscoveryBB.SITE_REMOVED_LISTENER_INVOCATION_COUNTER);
        String remoteDsName = DistributedSystemHelper.getDistributedSystemName(remoteDsId);
        Log.getLogWriter().info("In " + this.getMyUniqueName() + " removed distributed system " + remoteDsId);
        if (!siteRemovedList.contains(remoteDsName)) {
            siteRemovedList.add(remoteDsName);
        } else {
            DynamicDiscoveryBB.throwException("Duplicate invocation of MyDistributedSystemListener.removedDistributedSystem for " + remoteDsName);
        }
        List locators = Locator.getLocators();
        ConcurrentMap gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
        if (gfLocMap.containsKey(remoteDsId)) {
            DynamicDiscoveryBB.throwException("Expected remote site " + remoteDsId + " to be removed , but it is found with locators " + gfLocMap.get(remoteDsId) + ". InternalLocator.getAllLocatorsInfo=" + gfLocMap);
        } else {
            Log.getLogWriter().info("In MyDistributedSystemListener.removedDistributedSystem: InternalLocator.getAllLocatorsInfo=" + gfLocMap);
        }
    }

    public void addedDistributedSystem(int remoteDsId) {
        long siteAddedcount = DynamicDiscoveryBB.getInstance().getSharedCounters().incrementAndRead(DynamicDiscoveryBB.SITE_ADDED_LISTENER_INVOCATION_COUNTER);
        String remoteDsName = DistributedSystemHelper.getDistributedSystemName(remoteDsId);
        Log.getLogWriter().info("In " + this.getMyUniqueName() + " added distributed system " + remoteDsId);
        if (!siteAddedList.contains(remoteDsName)) {
            siteAddedList.add(remoteDsName);
        } else {
            DynamicDiscoveryBB.throwException("Duplicate invocation of addedDistributedSystem for " + remoteDsName);
        }
        List locators = Locator.getLocators();
        ConcurrentMap gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
        if (!gfLocMap.containsKey(remoteDsId)) {
            DynamicDiscoveryBB.throwException("Expected remote site " + remoteDsId + " in " + this.getMyUniqueName() + " , but it is not found. InternalLocator.getAllLocatorsInfo=" + gfLocMap);
        } else {
            Log.getLogWriter().info("In MyDistributedSystemListener.addedDistributedSystem: InternalLocator.getAllLocatorsInfo=" + gfLocMap);
        }
    }

    private String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }
}

