/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import msgsim.commands;

public class sockserver
implements commands {
    public static final boolean DEBUG = Boolean.getBoolean("debugServer");
    private static final int NUMBER_OF_SERVERS = Integer.getInteger("numServers", 3);
    private static final InetAddress[] serverAddresses = new InetAddress[NUMBER_OF_SERVERS];
    private static int serverNumber;
    private static final AtomicInteger ProcessorId;
    private static final Map<Integer, int[]> ProcessorIdHolder;
    private static final ConnectionPool connectionPool;
    private static final Socket[] sharedConnections;
    private static final Socket[] sharedUndorderedConnections;
    private static final ThreadLocal<Socket[]> threadOwnedConnections;
    private static final ThreadLocal<Socket[]> threadOwnedUnorderedConnections;
    private static final ThreadLocal<Boolean> isReaderThread;
    private volatile boolean exit = false;
    private boolean handOffListeners = false;
    private boolean nio = false;
    private boolean preferPooledSockets = false;
    private boolean preferThreadOwnedAckSockets = false;
    private boolean preferThreadOwnedSockets = false;
    private byte[] payload = new byte[Integer.getInteger("payloadSize", 0).intValue()];
    private int scenarioThreads = 1;
    private Executor handlers;
    private commands.MessagingScenario scenario = commands.MessagingScenario.SERVER;
    private Thread serverThread;
    private ThreadGroup handlerGroup = new ThreadGroup("Handler Group"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.err.println("Unhandled exception in thread " + t.getName() + ":");
            e.printStackTrace(System.err);
            super.uncaughtException(t, e);
        }
    };

    private static SocketAddress createSocketAddress(InetAddress address, int port) {
        return new InetSocketAddress(address, port);
    }

    private static SocketAddress createSocketAddress(int serverNumber) {
        assert (serverAddresses != null) : "The server addresses were not properly initialized!";
        assert (serverNumber >= 0 && serverNumber < NUMBER_OF_SERVERS) : "The server number (" + serverNumber + ") must be between 0 inclusive and " + NUMBER_OF_SERVERS + "exclusive!";
        return sockserver.createSocketAddress(serverAddresses[serverNumber], 15963 + serverNumber);
    }

    private static DataInput getInputStream(Socket socket) throws IOException {
        return new DataInputStream(socket.getInputStream());
    }

    private static DataOutput getOutputStream(Socket socket) throws IOException {
        return new DataOutputStream(socket.getOutputStream());
    }

    private static void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void logForDebugging(String message) {
        if (DEBUG) {
            sockserver.logForInfo(message);
        }
    }

    private static void logForError(String message, Throwable e) {
        StringWriter writer = new StringWriter(500);
        writer.append(message);
        writer.append(System.getProperty("line.separator"));
        e.printStackTrace(new PrintWriter(writer));
        sockserver.logForInfo(writer.toString());
    }

    private static void logForInfo(String message) {
        System.out.printf("Server %1$d [%2$s]: %3$s%n", serverNumber, Thread.currentThread().getName(), message);
    }

    private static void writeBytes(DataOutput out, byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            out.write(data);
        }
    }

    public static void main(String[] args) throws Exception {
        sockserver server = new sockserver();
        server.parseCommandLineArguments(args);
        server.validateServerNumber();
        if (!server.scenario.isExit()) {
            server.serve();
        }
        server.runScenario();
    }

    private sockserver() {
        this.handlers = Executors.newCachedThreadPool(new ThreadFactory(){
            private AtomicLong threadNumber = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(sockserver.this.handlerGroup, runnable, "Handler Thread " + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    private void parseCommandLineArguments(String[] args) {
        for (int index = 0; index < args.length; ++index) {
            if ("nio".equals(args[index])) {
                this.nio = true;
                continue;
            }
            if ("scenario".equals(args[index])) {
                this.scenario = commands.MessagingScenario.valueOf(Integer.parseInt(args[++index]));
                continue;
            }
            if ("scenarioThreads".equals(args[index])) {
                this.scenarioThreads = Integer.parseInt(args[++index]);
                continue;
            }
            if ("server".equals(args[index])) {
                serverNumber = Integer.parseInt(args[++index]);
                continue;
            }
            System.err.println("Unknown command line argument (" + args[index] + ")!");
        }
    }

    private void validateServerNumber() {
        assert (serverNumber >= 0 & serverNumber < NUMBER_OF_SERVERS) : "The server number (" + serverNumber + ") is not valid; the server number should be between 0 inclusive and " + NUMBER_OF_SERVERS + " exclusive!";
    }

    private void serve() {
        Runnable serverThreadRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = sockserver.this.nio ? ServerSocketChannel.open().socket() : new ServerSocket();
                    serverSocket.setReuseAddress(true);
                    serverSocket.bind(sockserver.createSocketAddress(serverNumber));
                    sockserver.logForInfo("server (" + serverNumber + ") is listening for and accepting connections...");
                    while (!sockserver.this.exit) {
                        Socket clientSocket = serverSocket.accept();
                        clientSocket.setTcpNoDelay(true);
                        sockserver.this.handlers.execute(sockserver.this.createReaderThreadRunnable(clientSocket));
                    }
                }
                catch (IOException e) {
                    sockserver.logForInfo("Server thread for server (" + serverNumber + ") threw an IOException: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        };
        this.serverThread = new Thread(this.handlerGroup, serverThreadRunnable, "Server Thread");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    private Runnable createReaderThreadRunnable(final Socket clientSocket) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    isReaderThread.set(true);
                    DataInput in = sockserver.getInputStream(clientSocket);
                    DataOutput out = sockserver.getOutputStream(clientSocket);
                    block21: while (true) {
                        commands.MessageProtocolCommand command = this.readCommand(in);
                        sockserver.logForDebugging("received command: " + (Object)((Object)command));
                        if (command.isInvalid()) {
                            return;
                        }
                        switch (command) {
                            case INIT: {
                                sockserver.logForInfo("Initializing server (" + serverNumber + ")...");
                                sockserver.this.preferThreadOwnedSockets = false;
                                sockserver.this.preferThreadOwnedAckSockets = false;
                                sockserver.this.preferPooledSockets = false;
                                sockserver.this.handOffListeners = false;
                                out.writeByte(1);
                                continue block21;
                            }
                            case HAND_OFF_LISTENERS: {
                                sockserver.logForInfo("Setting handOffListeners to true...");
                                sockserver.this.handOffListeners = true;
                                out.writeByte(1);
                                continue block21;
                            }
                            case SET_PAYLOAD_SIZE: {
                                int payloadSize = in.readInt();
                                sockserver.logForInfo("Setting payload size to (" + payloadSize + ") bytes...");
                                sockserver.access$1802(sockserver.this, new byte[payloadSize]);
                                out.writeByte(1);
                                continue block21;
                            }
                            case USE_THREAD_OWNED: {
                                sockserver.logForInfo("Setting preference for thread-owned sockets...");
                                sockserver.this.preferThreadOwnedSockets = true;
                                out.writeByte(1);
                                continue block21;
                            }
                            case USE_THREAD_OWNED_UNORDERED: {
                                sockserver.logForInfo("Setting preference for thread-owned sockets on ACK...");
                                sockserver.this.preferThreadOwnedAckSockets = true;
                                out.writeByte(1);
                                continue block21;
                            }
                            case USE_SHARED: {
                                sockserver.logForInfo("Setting preference for shared sockets...");
                                sockserver.this.preferThreadOwnedSockets = false;
                                out.writeByte(1);
                                continue block21;
                            }
                            case USE_POOLED_CONNECTIONS: {
                                sockserver.logForInfo("Setting preference for pooled sockets...");
                                sockserver.this.preferPooledSockets = true;
                                connectionPool.prefill(4);
                                out.writeByte(1);
                                continue block21;
                            }
                            case NORMAL_MESSAGE: {
                                sockserver.logForDebugging("Received message from (" + clientSocket.getInetAddress().toString() + ")...");
                                sockserver.this.processAndAck(in, clientSocket);
                                sockserver.logForDebugging("NORMAL_MESSAGE processing and acknowledgement complete.");
                                continue block21;
                            }
                            case ACK_MESSAGE: {
                                int processorId = in.readInt();
                                sockserver.logForDebugging("Received ACK for message with processorId (" + processorId + ") from (" + clientSocket.getInetAddress() + ")...");
                                int[] processor = (int[])ProcessorIdHolder.get(processorId);
                                if (processor == null) {
                                    sockserver.logForDebugging("could not find processor for id (" + processorId + ")!");
                                    continue block21;
                                }
                                int[] nArray = processor;
                                // MONITORENTER : processor
                                processor[0] = processor[0] + 1;
                                processor.notify();
                                // MONITOREXIT : nArray
                                continue block21;
                            }
                            case PRINT_QUEUE_SIZES: {
                                sockserver.logForDebugging("Printing connection pool (queue) sizes...");
                                connectionPool.logQueueSizes();
                                out.write(1);
                                continue block21;
                            }
                            case EXIT: {
                                sockserver.logForInfo("exiting...");
                                out.write(1);
                                sockserver.this.exit = true;
                                System.exit(0);
                                continue block21;
                            }
                        }
                        sockserver.logForInfo("Unknown command: " + (Object)((Object)command));
                        continue;
                        break;
                    }
                }
                catch (Exception e) {
                    if (!clientSocket.isClosed()) {
                        sockserver.logForError("", e);
                    }
                    sockserver.this.exit = true;
                    return;
                }
                finally {
                    isReaderThread.set(false);
                }
            }

            private commands.MessageProtocolCommand readCommand(DataInput in) throws IOException {
                try {
                    return commands.MessageProtocolCommand.valueOf(in.readByte());
                }
                catch (EOFException e) {
                    return commands.MessageProtocolCommand.INVALID;
                }
                catch (SocketException e) {
                    if (e.getMessage().equals("Connection reset")) {
                        return commands.MessageProtocolCommand.INVALID;
                    }
                    throw e;
                }
            }

            public String toString() {
                return MessageFormat.format("reader thread ({0}) connection @ ({1}:{2})", Thread.currentThread().getName(), clientSocket.getInetAddress().toString(), clientSocket.getPort());
            }
        };
    }

    private void runScenario() throws Exception {
        sockserver.logForInfo("running messaging scenario (" + (Object)((Object)this.scenario) + ")...");
        switch (this.scenario) {
            case SERVER: {
                break;
            }
            case THREAD_OWNED_CONNECTIONS: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_THREAD_OWNED, false);
                break;
            }
            case THREAD_OWNED_CONNECTIONS_WITH_DOMINO: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_THREAD_OWNED, false);
                break;
            }
            case SHARED_CONNECTIONS: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_SHARED, false);
                break;
            }
            case SHARED_CONNECTIONS_WITH_DOMINO: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_THREAD_OWNED_UNORDERED, false);
                break;
            }
            case POOLED_CONNECTIONS: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_POOLED_CONNECTIONS, false);
                break;
            }
            case POOLED_CONNECTIONS_WITH_DOMINO: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_POOLED_CONNECTIONS, false);
                break;
            }
            case HANDOFF_LISTENERS: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_SHARED, false);
                this.commandAll(commands.MessageProtocolCommand.HAND_OFF_LISTENERS, false);
                break;
            }
            case HANDOFF_LISTENERS_WITH_DOMINO: {
                this.initPayload();
                this.commandAll(commands.MessageProtocolCommand.USE_THREAD_OWNED_UNORDERED, false);
                this.commandAll(commands.MessageProtocolCommand.HAND_OFF_LISTENERS, false);
                break;
            }
            case EXIT: {
                this.commandAll(commands.MessageProtocolCommand.EXIT, false);
                return;
            }
            default: {
                sockserver.logForDebugging("unimplemented scenario: " + (Object)((Object)this.scenario));
                System.exit(1);
            }
        }
        ThreadCollection.spawn(this.scenarioThreads, this.createScenarioThreadRunnable(), "Messaging Thread").join();
        this.commandAll(commands.MessageProtocolCommand.PRINT_QUEUE_SIZES, false);
        this.commandAll(commands.MessageProtocolCommand.EXIT, false);
    }

    private void initPayload() throws Exception {
        this.commandAll(commands.MessageProtocolCommand.INIT, false);
        this.commandAll(commands.MessageProtocolCommand.SET_PAYLOAD_SIZE, false);
        this.sendToAll(this.payload.length, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandAll(commands.MessageProtocolCommand command, boolean requireAck) throws Exception {
        Socket[] serverConnections = this.getServerConnections(true);
        try {
            for (int serverNumber = 0; serverNumber < NUMBER_OF_SERVERS; ++serverNumber) {
                if (serverConnections[serverNumber] == null || serverConnections[serverNumber].isClosed()) continue;
                try {
                    Socket socket = serverConnections[serverNumber];
                    synchronized (socket) {
                        sockserver.logForDebugging("sending " + (Object)((Object)command) + " to server " + serverNumber + "...");
                        sockserver.getOutputStream(serverConnections[serverNumber]).writeByte(command.toByte());
                        if (requireAck) {
                            sockserver.getInputStream(serverConnections[serverNumber]).readByte();
                        }
                        continue;
                    }
                }
                catch (SocketException e) {
                    sockserver.logForInfo("exception '" + e.getMessage() + "' reported for server " + serverNumber);
                }
            }
        }
        finally {
            this.returnSockets(serverConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToAll(int data, boolean includeSelf) throws Exception {
        Socket[] serverConnections = this.getServerConnections(includeSelf);
        try {
            for (int serverNumber = 0; serverNumber < NUMBER_OF_SERVERS; ++serverNumber) {
                if (!includeSelf) {
                    if (serverNumber == sockserver.serverNumber) continue;
                }
                try {
                    sockserver.logForDebugging("sending " + data + " to " + serverNumber);
                    Socket socket = serverConnections[serverNumber];
                    synchronized (socket) {
                        sockserver.getOutputStream(serverConnections[serverNumber]).writeInt(data);
                        sockserver.getInputStream(serverConnections[serverNumber]).readByte();
                        continue;
                    }
                }
                catch (SocketException e) {
                    sockserver.logForInfo("exception '" + e.getMessage() + "' reported for server " + serverNumber);
                }
            }
        }
        finally {
            this.returnSockets(serverConnections);
        }
    }

    private Runnable createScenarioThreadRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    int numOps = Integer.getInteger("numOps", 500000);
                    switch (sockserver.this.scenario) {
                        case SERVER: {
                            sockserver.join(sockserver.this.serverThread);
                            break;
                        }
                        case THREAD_OWNED_CONNECTIONS: {
                            sockserver.this.preferThreadOwnedSockets = true;
                            sockserver.this.distributedAckDriver(numOps, false);
                            break;
                        }
                        case THREAD_OWNED_CONNECTIONS_WITH_DOMINO: {
                            sockserver.this.preferThreadOwnedSockets = true;
                            sockserver.this.distributedAckDriver(numOps, true);
                            break;
                        }
                        case SHARED_CONNECTIONS: {
                            sockserver.this.preferThreadOwnedSockets = false;
                            sockserver.this.distributedAckDriver(numOps, false);
                            break;
                        }
                        case SHARED_CONNECTIONS_WITH_DOMINO: {
                            sockserver.this.preferThreadOwnedSockets = false;
                            sockserver.this.distributedAckDriver(numOps, false);
                            break;
                        }
                        case POOLED_CONNECTIONS: {
                            sockserver.this.preferPooledSockets = true;
                            sockserver.this.distributedAckDriver(numOps, false);
                            break;
                        }
                        case POOLED_CONNECTIONS_WITH_DOMINO: {
                            sockserver.this.preferPooledSockets = true;
                            sockserver.this.distributedAckDriver(numOps, true);
                            break;
                        }
                        case HANDOFF_LISTENERS: {
                            sockserver.this.preferThreadOwnedSockets = false;
                            sockserver.this.handOffListeners = true;
                            sockserver.this.distributedAckDriver(numOps, false);
                            break;
                        }
                        case HANDOFF_LISTENERS_WITH_DOMINO: {
                            sockserver.this.preferThreadOwnedSockets = false;
                            sockserver.this.handOffListeners = true;
                            sockserver.this.distributedAckDriver(numOps, false);
                            break;
                        }
                        default: {
                            sockserver.logForDebugging("unimplemented scenario: " + (Object)((Object)sockserver.this.scenario));
                            System.exit(1);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    sockserver.logForDebugging("uncaught exception in scenario thread: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        };
    }

    private void distributedAckDriver(int numberOfOperations, boolean simulateListeners) throws Exception {
        int logCount = Math.max(numberOfOperations / 10, 1);
        sockserver.logForInfo("Sending (" + numberOfOperations + ") messages...");
        for (int count = 0; count < numberOfOperations; ++count) {
            if (count % logCount == 0) {
                sockserver.logForInfo("Completed (" + count + ") message operations...");
            }
            this.sendMessageAndWaitForAck(simulateListeners);
        }
        sockserver.logForInfo("Completed all (" + numberOfOperations + ") message operations.");
    }

    private void processAndAck(DataInput in, final Socket socket) throws Exception {
        final int pid = in.readInt();
        final int serverId = in.readUnsignedByte();
        final boolean simulateListener = in.readBoolean();
        this.readPayload(in);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (simulateListener) {
                        sockserver.this.sendMessageAndWaitForAck(false);
                    }
                    sockserver.this.sendAck(serverId, pid, socket);
                }
                catch (Exception e) {
                    throw new RuntimeException("error sending ack", e);
                }
            }
        };
        if (this.handOffListeners) {
            this.handlers.execute(r);
        } else {
            r.run();
        }
    }

    private void readPayload(DataInput in) throws Exception {
        if (this.payload.length > 0) {
            sockserver.logForDebugging("reading payload...");
            in.readFully(new byte[this.payload.length]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageAndWaitForAck(boolean simulateListener) throws Exception {
        byte[] pbytes = new byte[6];
        pbytes[4] = (byte)serverNumber;
        pbytes[5] = (byte)(simulateListener ? 1 : 0);
        Integer processorId = this.preferPooledSockets || this.preferThreadOwnedSockets ? 0 : this.getProcessorId(pbytes);
        try {
            this.sendCommandAndWaitForAck(commands.MessageProtocolCommand.NORMAL_MESSAGE, processorId, pbytes, this.payload);
        }
        finally {
            if (processorId > 0) {
                ProcessorIdHolder.remove(processorId);
            }
        }
    }

    private Integer getProcessorId(byte[] pbytes) {
        assert (pbytes != null && pbytes.length >= 6) : "Expected a byte array of size 6!";
        int processorId = ProcessorId.getAndIncrement();
        pbytes[0] = (byte)(processorId / 0x1000000 & 0xFF);
        pbytes[1] = (byte)(processorId / 65536 & 0xFF);
        pbytes[2] = (byte)(processorId / 256 & 0xFF);
        pbytes[3] = (byte)(processorId & 0xFF);
        ProcessorIdHolder.put(processorId, new int[1]);
        return processorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommandAndWaitForAck(commands.MessageProtocolCommand command, int processorId, byte[] processorBytes, byte[] payload) throws Exception {
        Socket[] serverSockets = this.getServerConnections(true);
        try {
            for (int serverNumber = 0; serverNumber < NUMBER_OF_SERVERS; ++serverNumber) {
                if (serverNumber == sockserver.serverNumber) continue;
                sockserver.logForDebugging("sending " + (Object)((Object)command) + " to server " + serverNumber + "...");
                Socket socket = serverSockets[serverNumber];
                synchronized (socket) {
                    DataOutput out = sockserver.getOutputStream(serverSockets[serverNumber]);
                    out.writeByte(command.toByte());
                    sockserver.writeBytes(out, processorBytes);
                    sockserver.writeBytes(out, payload);
                    continue;
                }
            }
            if (processorId > 0) {
                this.waitForAcks(processorId);
            } else {
                this.readAcksFromOthers(serverSockets);
            }
        }
        finally {
            this.returnSockets(serverSockets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void waitForAcks(Integer processorId) throws Exception {
        int[] count = ProcessorIdHolder.get(processorId);
        int lastCount = 0;
        sockserver.logForDebugging("waiting for " + (NUMBER_OF_SERVERS - 1) + " acks for processorId " + processorId);
        while (true) {
            if (count[0] >= NUMBER_OF_SERVERS - 1) {
                sockserver.logForDebugging("done waiting for acks");
                ProcessorIdHolder.remove(processorId);
                return;
            }
            int[] nArray = count;
            // MONITORENTER : count
            count.wait(10L);
            // MONITOREXIT : nArray
            if (!DEBUG || count[0] == lastCount) continue;
            sockserver.logForDebugging("received " + count[0] + " acks for processorId " + processorId);
            lastCount = count[0];
        }
    }

    private void readAcksFromOthers(Socket[] serverConnections) throws Exception {
        for (int serverNumber = 0; serverNumber < NUMBER_OF_SERVERS; ++serverNumber) {
            if (serverNumber == sockserver.serverNumber) continue;
            sockserver.getInputStream(serverConnections[serverNumber]).readByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck(int serverId, int processorId, Socket socket) throws Exception {
        if (processorId == 0) {
            sockserver.logForDebugging("sending a direct ack");
            sockserver.getOutputStream(socket).writeByte(1);
        } else {
            sockserver.logForDebugging("sending ack to server " + serverId + " for processor " + processorId);
            Socket ackSocket = this.getAckSocket(serverId);
            try {
                Socket socket2 = ackSocket;
                synchronized (socket2) {
                    DataOutput out = sockserver.getOutputStream(ackSocket);
                    out.writeByte(commands.MessageProtocolCommand.ACK_MESSAGE.toByte());
                    out.writeInt(processorId);
                }
            }
            finally {
                this.returnAckSocket(serverId, ackSocket);
            }
        }
    }

    private Socket[] getServerConnections(boolean includeSelf) throws Exception {
        Socket[] serverConnections = this.preferPooledSockets ? connectionPool.getFromPool(includeSelf) : (this.preferThreadOwnedSockets ? threadOwnedConnections.get() : sharedConnections);
        if (!this.preferPooledSockets) {
            this.createMissingSockets(serverConnections, includeSelf);
        }
        return serverConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createMissingSockets(Socket[] serverConnections, boolean includeSelf) throws Exception {
        boolean needNewSocket = false;
        for (int serverNumber = 0; serverNumber < NUMBER_OF_SERVERS; ++serverNumber) {
            if (serverConnections[serverNumber] != null && !serverConnections[serverNumber].isClosed()) continue;
            if (!includeSelf) {
                if (serverNumber == sockserver.serverNumber) continue;
            }
            needNewSocket = true;
            break;
        }
        if (!needNewSocket) return;
        Socket[] socketArray = serverConnections;
        synchronized (serverConnections) {
            for (int serverNumber = 0; serverNumber < NUMBER_OF_SERVERS; ++serverNumber) {
                if (serverConnections[serverNumber] != null && !serverConnections[serverNumber].isClosed()) continue;
                if (!includeSelf) {
                    if (serverNumber == sockserver.serverNumber) continue;
                }
                this.createSocket(serverConnections, serverNumber);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    private void createSocket(Socket[] serverConnections, int serverNumber) throws Exception {
        serverConnections[serverNumber] = null;
        try {
            serverConnections[serverNumber] = new Socket();
            serverConnections[serverNumber].setTcpNoDelay(true);
            serverConnections[serverNumber].connect(sockserver.createSocketAddress(serverNumber));
        }
        catch (ConnectException e) {
            sockserver.logForError("Failed to connect to server #" + serverNumber + "!", e);
        }
    }

    private Socket getAckSocket(int serverNumber) throws Exception {
        Socket[] serverConnections = null;
        if (this.preferPooledSockets) {
            sockserver.logForDebugging("using pooled connection for ack");
            return connectionPool.get(serverNumber);
        }
        if (this.preferThreadOwnedAckSockets) {
            sockserver.logForDebugging("using thread-owned connection for ack");
            serverConnections = threadOwnedUnorderedConnections.get();
        } else {
            sockserver.logForDebugging("using shared connection for ack");
            serverConnections = sharedUndorderedConnections;
        }
        if (serverConnections[serverNumber] == null || serverConnections[serverNumber].isClosed()) {
            this.createSocket(serverConnections, serverNumber);
        }
        return serverConnections[serverNumber];
    }

    void returnAckSocket(int serverId, Socket socket) {
        if (this.preferPooledSockets) {
            connectionPool.returnToPool(serverId, socket);
        }
    }

    private boolean returnSockets(Socket[] serverSocks) {
        if (this.preferPooledSockets) {
            connectionPool.returnToPool(serverSocks);
            return true;
        }
        return false;
    }

    static /* synthetic */ byte[] access$1802(sockserver x0, byte[] x1) {
        x0.payload = x1;
        return x1;
    }

    static {
        String commaDelimitedServerAddresses = System.getProperty("serverAddr", null);
        try {
            if (commaDelimitedServerAddresses == null || "".equals(commaDelimitedServerAddresses.trim())) {
                for (int index = 0; index < serverAddresses.length; ++index) {
                    sockserver.serverAddresses[index] = InetAddress.getLocalHost();
                }
            } else {
                String[] serverAddresses = commaDelimitedServerAddresses.split(",");
                assert (serverAddresses.length == NUMBER_OF_SERVERS) : "The number of server addresses must match the number of servers specified with the numServers System property!";
                for (int index = 0; index < serverAddresses.length; ++index) {
                    sockserver.serverAddresses[index] = InetAddress.getByName(serverAddresses[index]);
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        serverNumber = -1;
        ProcessorId = new AtomicInteger(1);
        ProcessorIdHolder = new ConcurrentHashMap<Integer, int[]>();
        connectionPool = new QueuedConnectionsPool(NUMBER_OF_SERVERS);
        sharedConnections = new Socket[NUMBER_OF_SERVERS];
        sharedUndorderedConnections = new Socket[NUMBER_OF_SERVERS];
        threadOwnedConnections = new ThreadLocal<Socket[]>(){

            @Override
            protected Socket[] initialValue() {
                return new Socket[NUMBER_OF_SERVERS];
            }
        };
        threadOwnedUnorderedConnections = new ThreadLocal<Socket[]>(){

            @Override
            protected Socket[] initialValue() {
                return new Socket[NUMBER_OF_SERVERS];
            }
        };
        isReaderThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    private static class QueuedConnectionsPool
    implements ConnectionPool {
        private Queue<Socket[]> connectionsQueue;
        private ThreadLocal<Socket[]> allocatedConnections = new ThreadLocal();

        private QueuedConnectionsPool(int numServers) {
            this.connectionsQueue = new ConcurrentLinkedQueue<Socket[]>();
        }

        @Override
        public Socket get(int serverId) throws Exception {
            Socket[] s = this.getFromPool(true);
            this.allocatedConnections.set(s);
            return s[serverId];
        }

        @Override
        public Socket[] getFromPool(boolean includeSelf) throws Exception {
            Socket[] socks = this.connectionsQueue.poll();
            if (socks == null) {
                socks = new Socket[NUMBER_OF_SERVERS];
                sockserver.logForDebugging("creating new socket collection");
                for (int index = 0; index < NUMBER_OF_SERVERS; ++index) {
                    try {
                        socks[index] = new Socket(serverAddresses[index], 15963 + index);
                        socks[index].setTcpNoDelay(true);
                        continue;
                    }
                    catch (ConnectException e) {
                        sockserver.logForInfo("unable to connect to server #" + index);
                        e.printStackTrace();
                    }
                }
            }
            return socks;
        }

        @Override
        public void returnToPool(int serverId, Socket socket) {
            this.connectionsQueue.add(this.allocatedConnections.get());
            this.allocatedConnections.set(null);
        }

        @Override
        public void returnToPool(Socket[] sockets) {
            this.connectionsQueue.add(sockets);
        }

        @Override
        public void prefill(int numberOfSocketSets) throws Exception {
            int index;
            Object[] socketSets = new Object[numberOfSocketSets];
            sockserver.logForInfo("pre-filling socket pool with " + numberOfSocketSets + " connections per server");
            for (index = 0; index < numberOfSocketSets; ++index) {
                socketSets[index] = this.getFromPool(true);
            }
            for (index = 0; index < numberOfSocketSets; ++index) {
                this.returnToPool((Socket[])socketSets[index]);
            }
        }

        @Override
        public void logQueueSizes() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("Server " + serverNumber + " pool size = " + this.connectionsQueue.size());
            System.out.println(sb.toString());
        }
    }

    private static class QueuedConnectionPool
    implements ConnectionPool {
        Queue<Socket>[] socketQueues;

        QueuedConnectionPool(int numServers) {
            this.socketQueues = new Queue[numServers];
            for (int i = 0; i < this.socketQueues.length; ++i) {
                this.socketQueues[i] = new ConcurrentLinkedQueue<Socket>();
            }
        }

        @Override
        public Socket get(int serverId) throws Exception {
            Socket sock = this.socketQueues[serverId].poll();
            if (sock == null) {
                sockserver.logForDebugging("creating new socket for server " + serverId);
                try {
                    sock = new Socket(serverAddresses[serverId], 15963 + serverId);
                    sock.setTcpNoDelay(true);
                }
                catch (ConnectException e) {
                    sockserver.logForInfo("unable to connect to server #" + serverId);
                    e.printStackTrace();
                }
            }
            return sock;
        }

        @Override
        public Socket[] getFromPool(boolean includeSelf) throws Exception {
            Socket[] result = new Socket[NUMBER_OF_SERVERS];
            for (int index = 0; index < NUMBER_OF_SERVERS; ++index) {
                if (!includeSelf && index == serverNumber) continue;
                result[index] = this.get(index);
            }
            return result;
        }

        @Override
        public void returnToPool(int serverId, Socket socket) {
            this.socketQueues[serverId].add(socket);
        }

        @Override
        public void returnToPool(Socket[] serverSockets) {
            for (int serverId = 0; serverId < serverSockets.length; ++serverId) {
                if (serverSockets[serverId] == null) continue;
                this.socketQueues[serverId].add(serverSockets[serverId]);
            }
        }

        @Override
        public void prefill(int numberOfSocketSets) throws Exception {
            int count;
            Object[] socketSets = new Object[numberOfSocketSets];
            sockserver.logForInfo("pre-filling socket pool with " + numberOfSocketSets + " connections per server");
            for (count = 0; count < numberOfSocketSets; ++count) {
                socketSets[count] = this.getFromPool(true);
            }
            for (count = 0; count < numberOfSocketSets; ++count) {
                this.returnToPool((Socket[])socketSets[count]);
            }
        }

        @Override
        public void logQueueSizes() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("Server " + serverNumber + " pool sizes = [");
            int len = this.socketQueues.length;
            for (int i = 0; i < len; ++i) {
                sb.append(this.socketQueues[i].size());
                if (i + 1 >= len) continue;
                sb.append(", ");
            }
            sb.append("]");
            System.out.println(sb.toString());
        }
    }

    private static interface ConnectionPool {
        public Socket get(int var1) throws Exception;

        public Socket[] getFromPool(boolean var1) throws Exception;

        public void returnToPool(int var1, Socket var2);

        public void returnToPool(Socket[] var1);

        public void prefill(int var1) throws Exception;

        public void logQueueSizes();
    }

    private static final class ThreadCollection {
        private final Collection<Thread> threads = new LinkedList<Thread>();

        private ThreadCollection() {
        }

        public static ThreadCollection spawn(int numberOfThreads, Runnable runner, String threadBasename) {
            ThreadCollection collection = new ThreadCollection();
            while (numberOfThreads-- > 0) {
                collection.startThread(runner, threadBasename);
            }
            return collection;
        }

        private Thread startThread(Runnable runnable, String threadBasename) {
            Thread thread = this.createThread(runnable, threadBasename);
            thread.start();
            this.threads.add(thread);
            return thread;
        }

        private Thread createThread(Runnable runnable, String threadBasename) {
            assert (threadBasename != null) : "The basename of the Thread cannot be null!";
            Thread thread = new Thread(runnable, threadBasename.trim() + " " + this.threads.size());
            thread.setDaemon(false);
            return thread;
        }

        public void join() throws InterruptedException {
            for (Thread thread : this.threads) {
                thread.join();
            }
        }
    }
}

