/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.util.PasswordUtil;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.EvictionAttributesData;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.MembershipAttributesData;
import com.gemstone.gemfire.management.PartitionAttributesData;
import com.gemstone.gemfire.management.RegionAttributesData;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.util.CommandStringBuilder;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientDescription;
import hydra.ClientPrms;
import hydra.ClientVmInfo;
import hydra.DistributedSystemBlackboard;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.GsRandom;
import hydra.HostHelper;
import hydra.HydraVector;
import hydra.JMXManagerBlackboard;
import hydra.JMXManagerHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.PortBlackboard;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import management.cli.TestableGfsh;
import management.test.cli.CliHelperFunction;
import management.test.cli.CommandBB;
import management.test.cli.CommandHelpText;
import management.test.cli.CommandOutputValidator;
import management.test.cli.CommandPrms;
import management.test.cli.CommandTestVersionHelper;
import management.test.cli.DeployTestFunction;
import management.test.cli.MemberDescription;
import management.test.cli.ResultValidator;
import management.test.cli.ResultValidatorHelper;
import management.test.cli.ValidationInfo;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import parReg.ParRegUtil;
import recovDelay.PrState;
import util.ClassBuilder;
import util.DeclarativeGenerator;
import util.NameFactory;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class CommandTest {
    private static final String VERSION = "v7.5.Beta";
    private static final String CMD_ALTER_DISKSTORE = "alter disk-store";
    private static final String CMD_ALTER_REGION = "alter region";
    private static final String CMD_ALTER_RUNTIME = "alter runtime";
    private static final String CMD_CREATE_ASYNC_EVENT_QUEUE = "create async-event-queue";
    private static final String CMD_CREATE_DISK_STORE = "create disk-store";
    private static final String CMD_CREATE_INDEX = "create index";
    private static final String CMD_CLOSE_DURABLE_CQ = "close durable-cq";
    private static final String CMD_CLOSE_DURABLE_CLIENT = "close durable-client";
    private static final String CMD_DEPLOY = "deploy";
    private static final String CMD_DESCRIBE_CONFIG = "describe config";
    private static final String CMD_DESCRIBE_MEMBER = "describe member";
    private static final String CMD_DESCRIBE_REGION = "describe region";
    private static final String CMD_DESCRIBE_DISKSTORE = "describe disk-store";
    private static final String CMD_DESCRIBE_CONNECTION = "describe connection";
    private static final String CMD_DESTROY_INDEX = "destroy index";
    private static final String CMD_DESTROY_REGION = "destroy region";
    private static final String CMD_ENCRYPT_PASSWORD = "encrypt password";
    private static final String CMD_EXPORT_CONFIG = "export config";
    private static final String CMD_EXPORT_STACKTRACES = "export stack-traces";
    private static final String CMD_GET = "get";
    private static final String CMD_LIST_ASYNC_EVENT_QUEUE = "list async-event-queues";
    private static final String CMD_LIST_DURABLE_CQS = "list durable-cqs";
    private static final String CMD_LIST_FUNCTIONS = "list functions";
    private static final String CMD_LIST_MEMBERS = "list members";
    private static final String CMD_LIST_REGIONS = "list regions";
    private static final String CMD_LIST_DISKSTORES = "list disk-stores";
    private static final String CMD_LIST_INDEXES = "list indexes";
    private static final String CMD_LOCATE_ENTRY = "locate entry";
    private static final String CMD_PUT = "put";
    private static final String CMD_REMOVE = "remove";
    private static final String CMD_SHOW_DEADLOCKS = "show dead-locks";
    private static final String CMD_SHOW_METRICS = "show metrics";
    private static final String CMD_SHOW_SUBSCRIPTION_QUEUE_SIZE = "show subscription-queue-size";
    private static final String CMD_SLEEP = "sleep";
    private static final String CMD_STATUS_LOCATOR = "status locator";
    private static final String CMD_STATUS_SERVER = "status server";
    private static final String CMD_UNDEPLOY = "undeploy";
    private static final String CMD_VERSION = "version";
    private static final String PARM_PREFIX = " --";
    private static final String PARM_CATEGORIES = "categories";
    private static final String PARM_DIR = "dir";
    private static final String PARM_DISK_DIRS = "disk-dirs";
    private static final String PARM_EXPRESSION = "expression";
    private static final String PARM_FILE = "file";
    private static final String PARM_GROUP = "group";
    private static final String PARM_HIDE_DEFAULTS = "hide-defaults";
    private static final String PARM_HOST = "host";
    private static final String PARM_KEY = "key";
    private static final String PARM_MATCHES = "matches";
    private static final String PARM_MEMBER = "member";
    private static final String PARM_NAME = "name";
    private static final String PARM_PID = "pid";
    private static final String PARM_PORT = "port";
    private static final String PARM_REGION = "region";
    private static final String PARM_WITH_STATS = "with-stats";
    private static final String PARM_TYPE = "type";
    private static final String PARM_VALUE = "value";
    private static final String PARM_DURABLE_CLIENT_ID = "durable-client-id";
    private static final String PARM_ID = "id";
    private static final String PARM_LISTENER = "listener";
    private static final String PARM_DURABLE_CQ_NAME = "durable-cq-name";
    private static final String PARM_BATCH_SIZE = "batch-size";
    private static final String PARM_PERSISTENT = "persistent";
    private static final String PARM_DISK_STORE = "disk-store";
    private static final String PARM_MAXIMUM_QUEUE_MEMORY = "max-queue-memory";
    private static final String PARM_LISTENER_PARAM_AND_VALUE = "listener-param";
    private static final String PARM_ALLOW_FORCE_COMPACTION = "allow-force-compaction";
    private static final String PARM_AUTO_COMPACT = "auto-compact";
    private static final String PARM_COMPACTION_THRESHOLD = "compaction-threshold";
    private static final String PARM_MAX_OPLOG_SIZE = "max-oplog-size";
    private static final String PARM_QUEUE_SIZE = "queue-size";
    private static final String PARM_TIME_INTERVAL = "time-interval";
    private static final String PARM_WRITE_BUFFER_SIZE = "write-buffer-size";
    private static final String PARM_VALUE_SEP = "=";
    private static final String PARM_SPACE = " ";
    private static final String GROUP_ADMIN = "adminGroup";
    private static final String GROUP_LOCATOR = "locatorGroup";
    private static final String GROUP_MEMBER = "memberGroup";
    private static final String UNCOMP_REGION_NAME = "unCompressedDataTestRegion";
    private static final String COMP_REGION_NAME = "compressedDataTestRegion";
    private static final String COMPRESSION_PUT_VALUE = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam volutpat lacinia mauris ut fringilla. Maecenas nec sodales neque. In et diam a enim facilisis blandit. Maecenas cursus luctus arcu eget congue. Nunc mi ligula, porttitor molestie aliquet ac, cursus eget turpis. Mauris id porta lacus. Suspendisse adipiscing turpis vitae neque euismod at tristique neque luctus. In pulvinar malesuada rutrum.";
    public static CommandTest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    public TestableGfsh shell = null;
    private int shellManagerMemberVmId = -1;
    private static PrintWriter commandOutputFile = null;
    private static JMXConnectorServer connectorService = null;
    private static List<String> definedGroups = null;
    private static final String xmlFileNameKeyPrefix = "xmlForVmId_";
    private static final String memberNameKeyPrefix = "nameForVmId_";
    private static final String groupsKeyPrefix = "groupsForVmId_";
    private static final String memberIdKeyPrefix = "memberIdForVmId_";
    private static final String memberKeyPrefix = "memberForVmId_";
    private static final String regionNamesKey = "regionNames";
    private static final String regionAttrKey = "regionAttrs";
    private static final String joinDSOnlyKey = "connectDsOnlyInVmId_";
    private static final String createCacheOnlyKey = "createCacheOnlyInVmId_";
    private static final String locatorVmIdsKey = "locatorVmIds";
    private static final String jmxManagerVmIdsKey = "jmxManagerVmIds";
    private static final String isManagerKeyPrefix = "isManagerVmId_";
    private static final String expectManagerKeyPrefix = "expectManagerVmId_";
    private static final String memberWithCacheMemberIdKeyPrefix = "memberWithCacheMemberIdForVmId_";
    private static final String jmxManagerSettingKeyPrefix = "jmxManagerForVmId_";
    private static final String cmdErrorKey = "cmdError";
    private static final String dataErrorKey = "dataError";
    private static final String memberDescriptionKey = "memberDescription";
    private static final String helpErrorKey = "helpError";
    private static final String asyncEventQueueIdKey = "asyncEventQueueIds";

    public static synchronized void HydraTask_createLocator() throws Throwable {
        DistributedSystemHelper.createLocator();
        CommandBB.getBB().getSharedMap().remove(locatorVmIdsKey);
    }

    public static synchronized void HydraTask_startLocatorAndDS() throws Throwable {
        DistributedSystemHelper.startLocatorAndAdminDS();
        SharedLock lock = CommandBB.getBB().getSharedLock();
        lock.lock();
        try {
            HashMap<Integer, String> locatorVmIdMap = (HashMap<Integer, String>)CommandBB.getBB().getSharedMap().get(locatorVmIdsKey);
            if (locatorVmIdMap == null) {
                locatorVmIdMap = new HashMap<Integer, String>();
            }
            locatorVmIdMap.put(RemoteTestModule.getMyVmid(), RemoteTestModule.getMyHost());
            CommandBB.getBB().getSharedMap().put(locatorVmIdsKey, locatorVmIdMap);
        }
        finally {
            lock.unlock();
        }
        CommandTest.writeExpectedJmxManagerToBB();
        CommandBB.getBB().getSharedMap().put(memberWithCacheMemberIdKeyPrefix + RemoteTestModule.getMyVmid(), DistributedSystemHelper.getDistributedSystem().getDistributedMember());
    }

    public static synchronized void HydraTask_configurableInit() {
        int numMembersJoinDSOnly = CommandPrms.getNumMembersJoinDSOnly();
        int numMembersCreateCacheOnly = CommandPrms.getNumMembersCreateCacheOnly();
        long configurableInitCounter = CommandBB.getBB().getSharedCounters().incrementAndRead(CommandBB.configurableInitCounter);
        SharedMap sm = CommandBB.getBB().getSharedMap();
        if (sm.containsKey(joinDSOnlyKey + RemoteTestModule.getMyVmid()) || numMembersJoinDSOnly > 0 && configurableInitCounter <= (long)numMembersJoinDSOnly) {
            CommandTest.HydraTask_initializeDS();
            Log.getLogWriter().info("Joined distributed system only (no cache creation or regions)");
            CommandBB.getBB().getSharedMap().put(joinDSOnlyKey + RemoteTestModule.getMyVmid(), true);
        } else if (sm.containsKey(createCacheOnlyKey + RemoteTestModule.getMyVmid()) || numMembersCreateCacheOnly > 0 && configurableInitCounter <= (long)(numMembersJoinDSOnly + numMembersCreateCacheOnly)) {
            CommandTest.HydraTask_initializeDS();
            CommandTest.HydraTask_initializeCache();
            Log.getLogWriter().info("Joined distributed system and created cache only (no regions)");
            CommandBB.getBB().getSharedMap().put(createCacheOnlyKey + RemoteTestModule.getMyVmid(), true);
        } else {
            CommandTest.HydraTask_initializeDS();
            CommandTest.HydraTask_initializeCache();
            CommandTest.HydraTask_initializeRegions();
            Log.getLogWriter().info("Joined distributed system, created cache and regions");
        }
    }

    public static synchronized void HydraTask_initializeDS() {
        if (testInstance == null) {
            DistributedSystemHelper.connect();
            testInstance = new CommandTest();
            testInstance.initializeInstance();
            if (CommandTest.testInstance.isBridgeConfiguration) {
                CommandTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new CommandTest();
            CommandTest.HydraTask_initializeCache();
            testInstance.initializeInstance();
            if (CommandTest.testInstance.isBridgeConfiguration) {
                CommandTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initializeCache() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache("cache1");
            CommandBB.getBB().getSharedMap().put(memberWithCacheMemberIdKeyPrefix + RemoteTestModule.getMyVmid(), DistributedSystemHelper.getDistributedSystem().getDistributedMember());
            CommandTest.writeExpectedJmxManagerToBB();
        }
    }

    private static void writeExpectedJmxManagerToBB() {
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        GemFireDescription gfd = cd.getGemFireDescription();
        Boolean jmxManager = gfd.getJMXManager();
        Boolean jmxManagerStart = gfd.getJMXManagerStart();
        if (jmxManager != null && jmxManager.booleanValue() && jmxManagerStart != null && jmxManagerStart.booleanValue()) {
            CommandBB.getBB().getSharedMap().put(expectManagerKeyPrefix + RemoteTestModule.getMyVmid(), new Boolean(true));
        }
    }

    public static void HydraTask_writeJmxManagerSettingToBB() {
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        GemFireDescription gfd = cd.getGemFireDescription();
        Boolean jmxManager = gfd.getJMXManager();
        if (jmxManager != null) {
            CommandBB.getBB().getSharedMap().put(jmxManagerSettingKeyPrefix + RemoteTestModule.getMyVmid(), jmxManager);
        }
    }

    public static synchronized void HydraTask_initializeRegions() {
        if (CacheHelper.getCache().rootRegions().size() == 0) {
            CommandTestVersionHelper.createRegions();
        }
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new CommandTest();
            CommandTest.HydraTask_initializeCache();
            CommandTestVersionHelper.createRegions();
            testInstance.initializeInstance();
            if (CommandTest.testInstance.isBridgeConfiguration) {
                CommandTest.testInstance.isBridgeClient = true;
                CommandTest.registerInterest();
            }
        }
    }

    public static synchronized void HydraTask_multiRegionAccessorInit() {
        if (testInstance == null) {
            testInstance = new CommandTest();
            Cache theCache = CacheHelper.createCache("cache1");
            Map regionMap = (Map)CommandBB.getBB().getSharedMap().get(regionAttrKey);
            for (String regName : regionMap.keySet()) {
                String[] tokens = regName.split("/");
                String totalPath = "";
                for (String regPathToken : tokens) {
                    if (regPathToken.length() == 0) continue;
                    totalPath = totalPath + "/" + regPathToken;
                    Region aRegion = theCache.getRegion(totalPath);
                    Log.getLogWriter().info("totalPath is " + totalPath + " aRegion is " + aRegion);
                    if (aRegion != null) continue;
                    RegionAttributes attr = (RegionAttributes)regionMap.get(totalPath);
                    if (attr == null) {
                        throw new TestException("Test problem: attr is null for region " + totalPath);
                    }
                    AttributesFactory fac = new AttributesFactory(attr);
                    DataPolicy dp = attr.getDataPolicy();
                    if (dp.withReplication()) {
                        fac.setDataPolicy(DataPolicy.EMPTY);
                        fac.setEvictionAttributes(null);
                    } else if (dp.withPartitioning()) {
                        PartitionAttributesFactory prFac = new PartitionAttributesFactory(attr.getPartitionAttributes());
                        prFac.setLocalMaxMemory(0);
                        fac.setPartitionAttributes(prFac.create());
                    }
                    fac.setDiskStoreName(null);
                    int lastIndex = totalPath.lastIndexOf("/");
                    String regionCreationName = totalPath.substring(lastIndex + 1);
                    if (lastIndex > 0) {
                        String parentPath = totalPath.substring(0, lastIndex);
                        Log.getLogWriter().info("Parent path is " + parentPath);
                        Region parent = theCache.getRegion(parentPath);
                        Log.getLogWriter().info("Creating subregion " + regionCreationName + " of " + parent.getFullPath());
                        parent.createSubregion(regionCreationName, fac.create());
                        Log.getLogWriter().info("Done creating subregion " + regionCreationName + " of " + parent.getFullPath());
                        continue;
                    }
                    Log.getLogWriter().info("Creating root region " + regionCreationName);
                    theCache.createRegion(regionCreationName, fac.create());
                    Log.getLogWriter().info("Done creating root region " + regionCreationName);
                }
            }
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    private void initializeInstance() {
        if (CommandPrms.getCreateProxyRegions() && CommandPrms.getCreateClientRegions()) {
            throw new TestException("Both CommandPrms.createProxyRegions and CommandPrms.createClientRegions are true");
        }
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        Log.getLogWriter().info("isBridgeConfiguration is " + this.isBridgeConfiguration);
        CommandTestVersionHelper.saveMemberMbeanInBlackboard();
        CommandTest.initBlackboard();
    }

    private static void initBlackboard() {
        int myVmId = RemoteTestModule.getMyVmid();
        DistributedMember member = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        SharedMap sharedMap = CommandBB.getBB().getSharedMap();
        sharedMap.put(memberNameKeyPrefix + myVmId, CommandTestVersionHelper.getName(member));
        sharedMap.put(groupsKeyPrefix + myVmId, CommandTestVersionHelper.getGroups(member));
        sharedMap.put(memberIdKeyPrefix + myVmId, member.getId());
        sharedMap.put(memberKeyPrefix + myVmId, member);
    }

    public static synchronized void HydraTask_createXmlFile() {
        if (CacheHelper.getCache() == null) {
            return;
        }
        String fileName = CommandTest.getXmlFileName(RemoteTestModule.getMyVmid());
        File aFile = new File(fileName);
        if (aFile.exists()) {
            return;
        }
        DeclarativeGenerator.createDeclarativeXml(fileName, CacheHelper.getCache(), false, true);
        CommandBB.getBB().getSharedMap().put(xmlFileNameKeyPrefix + RemoteTestModule.getMyVmid(), aFile.getAbsolutePath());
    }

    protected static String getXmlFileName(int vmId) {
        String xmlFileNamePrefix = "vmId_";
        String fileName = "vmId_" + vmId + ".xml";
        return fileName;
    }

    public synchronized void initShell() {
        if (this.shell == null) {
            String[] argss = new String[]{};
            SharedLock lock = CommandBB.getBB().getSharedLock();
            try {
                lock.lock();
                Gfsh.SUPPORT_MUTLIPLESHELL = true;
                String shellId = Thread.currentThread().getName();
                this.shell = new TestableGfsh(shellId, true, argss);
                this.shell.setEnvProperty("APP_QUIET_EXECUTION", "true");
                int commandWaitSec = CommandPrms.getCommandWaitSec();
                Log.getLogWriter().info("Setting testable shell timeout to " + commandWaitSec + " seconds");
                this.shell.setTimeout(commandWaitSec);
                this.shell.start();
                Log.getLogWriter().info("Started testable shell: " + this.shell);
                this.startCommandOutputFile();
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            finally {
                lock.unlock();
            }
        }
    }

    private synchronized void startCommandOutputFile() {
        if (commandOutputFile == null) {
            String fileName = "commandOutput_" + RemoteTestModule.getMyPid();
            try {
                commandOutputFile = new PrintWriter(new FileOutputStream(new File(fileName)));
            }
            catch (FileNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    protected static void registerInterest() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + aRegion.getFullPath());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
        }
    }

    public static synchronized void HydraTask_startManagerIfRequired() {
        CommandTest.startManagerIfRequired();
    }

    public static void HydraTask_verifyAutoManagers() {
        Log.getLogWriter().info("In HydraTask_verifyAutoManagers");
        boolean thisMemberIsManager = false;
        boolean isManager = false;
        Cache theCache = CacheHelper.getCache();
        if (theCache != null) {
            ManagementService service = ManagementService.getManagementService((Cache)theCache);
            isManager = service.isManager();
            String clientName = System.getProperty("clientName");
            ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
            GemFireDescription gfd = cd.getGemFireDescription();
            Boolean jmxManager = gfd.getJMXManager();
            boolean thisMemberIsEligible = false;
            if (jmxManager == null) {
                if (clientName.contains("locator")) {
                    thisMemberIsEligible = true;
                }
            } else {
                thisMemberIsEligible = jmxManager;
            }
            Log.getLogWriter().info("This member isManager: " + isManager + ", this member is eligible to be a manager: " + thisMemberIsEligible);
            if (isManager) {
                if (!thisMemberIsEligible) {
                    throw new TestException("This member is a manager but it is not eligible");
                }
                boolean expectLocatorManagers = CommandPrms.getExpectLocatorManagers();
                if (expectLocatorManagers) {
                    if (!clientName.contains("locator")) {
                        throw new TestException("This member is a manager and not a locator; expect managers only in locators");
                    }
                } else if (clientName.contains("locator")) {
                    throw new TestException("This member is a manager and a locator; expect manager only in non-locator members");
                }
            }
            CommandBB.getBB().getSharedMap().put(isManagerKeyPrefix + RemoteTestModule.getMyVmid(), isManager);
        }
    }

    public static void HydraTask_verifyAutoNumManagers() {
        int numLocators = 0;
        int numCliJvms = 0;
        HydraVector clientNames = TestConfig.tab().vecAt(ClientPrms.names);
        for (Object name : clientNames) {
            String nameStr = (String)name;
            if (nameStr.contains("locator")) {
                ++numLocators;
            }
            if (!nameStr.contains("cli")) continue;
            ++numCliJvms;
        }
        Log.getLogWriter().info("num locators " + numLocators + ", numCliJvms " + numCliJvms);
        Map aMap = CommandBB.getBB().getSharedMap().getMap();
        int isManagerCount = 0;
        int numEligible = 0;
        HashSet currentManagerSet = new HashSet();
        boolean jmxManagerWasSet = false;
        for (Object key : aMap.keySet()) {
            boolean isManager;
            if (key instanceof String && ((String)key).startsWith(isManagerKeyPrefix) && (isManager = ((Boolean)aMap.get(key)).booleanValue())) {
                ++isManagerCount;
                currentManagerSet.add(key);
            }
            if (!(key instanceof String) || !((String)key).startsWith(jmxManagerSettingKeyPrefix)) continue;
            jmxManagerWasSet = true;
            boolean jmxManager = (Boolean)aMap.get(key);
            if (!jmxManager) continue;
            ++numEligible;
        }
        if (numEligible == 0 && !jmxManagerWasSet) {
            numEligible = numLocators;
        }
        Log.getLogWriter().info("Current number of managers: " + isManagerCount + ", " + currentManagerSet);
        Log.getLogWriter().info("num members eligible to be a manager: " + numEligible);
        int expectedMaxNumManagers = Math.min(numCliJvms, numEligible);
        Log.getLogWriter().info("expectedMaxNumManagers is " + expectedMaxNumManagers);
        if (isManagerCount > expectedMaxNumManagers) {
            throw new TestException("Expected no more than " + expectedMaxNumManagers + " jmxManagers, but detected " + isManagerCount + ": " + currentManagerSet);
        }
    }

    public static void HydraTask_verifyNoManagers() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("This member is not a manager because it does not have a cache");
            return;
        }
        ManagementService service = ManagementService.getManagementService((Cache)theCache);
        boolean isManager = service.isManager();
        Log.getLogWriter().info("This member isManager: " + isManager);
        if (isManager) {
            throw new TestException("Expect " + service + ".isManager() to be false, but it is " + isManager);
        }
    }

    public static void HydraTask_verifyManagers() {
        String key = expectManagerKeyPrefix + RemoteTestModule.getMyVmid();
        Boolean expectManager = (Boolean)CommandBB.getBB().getSharedMap().get(key);
        if (expectManager == null) {
            expectManager = false;
        }
        Log.getLogWriter().info("In HydraTask_verifyManager, expect this member to be a manager: " + expectManager);
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("This member is not a manager because it does not have a cache");
            if (expectManager.booleanValue()) {
                throw new TestException("Expected this member to be a jmxManager, but it does not have a cache so can't be a jmxManager");
            }
        } else {
            ManagementService service = ManagementService.getManagementService((Cache)theCache);
            boolean isManager = service.isManager();
            Log.getLogWriter().info("This member isManager: " + isManager);
            if (expectManager != isManager) {
                throw new TestException("Expect " + service + ".isManager() to be " + expectManager + ", but it is " + isManager);
            }
        }
    }

    public static synchronized void HydraTask_becomeManager() {
        if (connectorService == null) {
            if (CacheHelper.getCache() == null) {
                Log.getLogWriter().info("HydraTask_becomeManager-Returning without creating a manager because there is no cache in this member");
                return;
            }
            int vmId = RemoteTestModule.getMyVmid();
            Map managerMap = FederationBlackboard.getBB().getManagerONs();
            if (managerMap == null || !managerMap.containsKey("vmId" + vmId)) {
                long mgrCnt = CommandBB.getBB().getSharedCounters().incrementAndRead(CommandBB.managerCount);
                Log.getLogWriter().info("HydraTask_becomeManager-The current manager count is " + mgrCnt);
                String nbrOfManagers = CommandPrms.getNbrOfManagers();
                Log.getLogWriter().info("HydraTask_becomeManager-nbrOfManagers:" + nbrOfManagers);
                if (nbrOfManagers.indexOf("all") < 0) {
                    try {
                        int nbrOfMgrsToCreate = Integer.parseInt(nbrOfManagers);
                        Log.getLogWriter().info("HydraTask_becomeManager-nbrOfMgrsToCreate:" + nbrOfMgrsToCreate);
                        if (mgrCnt > (long)nbrOfMgrsToCreate) {
                            Log.getLogWriter().info("HydraTask_becomeManager-Returning without creating a manager");
                            return;
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new TestException("Invalid 'nbrOfManagers' option.  Must be a valid number or the word 'all'");
                    }
                }
            }
            Log.getLogWriter().info("HydraTask_becomeManager-Creating a manager");
            ManagementUtil.saveMemberManagerInBlackboard();
            ManagementService service = ManagementService.getManagementService((Cache)CacheHelper.getCache());
            service.startManager();
            HydraUtil.sleepForReplicationJMX();
            if (!ManagementUtil.checkIfCommandsAreLoadedOrNot()) {
                throw new TestException("Member failed to load any commands");
            }
            CommandTest.startRmiConnector();
        }
    }

    protected static synchronized void startRmiConnector() {
        int port = AvailablePortHelper.getRandomAvailableTCPPort();
        String vmId = "vmId" + RemoteTestModule.getMyVmid();
        try {
            LocateRegistry.createRegistry(port);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + InetAddress.getLocalHost().getHostName() + ":" + port + "/jmxrmi");
            connectorService = JMXConnectorServerFactory.newJMXConnectorServer(url, null, ManagementFactory.getPlatformMBeanServer());
            connectorService.start();
            Log.getLogWriter().info("JMX RMI Connector started at url " + url.toString());
            FederationBlackboard.getBB().addManagingNode(vmId, url.toString());
        }
        catch (RemoteException e) {
            throw new TestException("Could not start RMI Connector on " + vmId, e);
        }
        catch (MalformedURLException e) {
            throw new TestException("Could not start RMI Connector on " + vmId, e);
        }
        catch (UnknownHostException e) {
            throw new TestException("Could not start RMI Connector on " + vmId, e);
        }
        catch (IOException e) {
            throw new TestException("Could not start RMI Connector on " + vmId, e);
        }
    }

    public static void HydraTask_sleep() {
        int sleepForMs = CommandPrms.getSleepForMs();
        Log.getLogWriter().info("sleepForMs=" + sleepForMs);
        MasterController.sleepForMs(sleepForMs);
    }

    public static synchronized void HydraTask_initAndConnectCLI() {
        if (testInstance == null) {
            testInstance = new CommandTest();
        }
        if (CommandTest.testInstance.shell == null) {
            JMXManagerBlackboard.getInstance().print();
            testInstance.initShell();
            CommandTest.connectCLI();
        }
    }

    public static synchronized void HydraTask_initCLI() {
        if (testInstance == null) {
            testInstance = new CommandTest();
        }
        if (CommandTest.testInstance.shell == null) {
            JMXManagerBlackboard.getInstance().print();
            testInstance.initShell();
        }
    }

    public static synchronized void HydraTask_connectCLI() {
        if (testInstance != null) {
            CommandTest.connectCLI();
        }
    }

    public static synchronized void HydraTask_initShell() {
        if (testInstance == null) {
            testInstance = new CommandTest();
        }
        if (CommandTest.testInstance.shell == null) {
            FederationBlackboard.getBB().printSharedMap();
            testInstance.initShell();
            testInstance.connectToManagingNode(testInstance.getRandomManagingMember());
        }
    }

    public static void HydraTask_serialDeployTest() {
        testInstance.serialDeployTest();
    }

    public static void HydraTask_deployTest() {
        testInstance.deployTest();
    }

    public static void HydraTask_concDeployTest() {
        testInstance.concDeployTest();
    }

    public static void HydraTask_execDisconnectedCommands() {
        testInstance.basicCommandTest();
        testInstance.cmdVersionTest();
    }

    public static void HydraTask_execConnectedCommands() {
        testInstance.basicCommandTest();
        testInstance.cmdVersionTest();
        testInstance.cmdDescribeConfigTest();
        testInstance.cmdDescribeConnectionTest();
        testInstance.cmdDescribeDiskStoreTest();
        testInstance.cmdDescribeMemberTest();
        testInstance.cmdDescribeRegionTest();
        testInstance.cmdListDiskStoreTest(CommandPrms.getRegionsAdded());
        testInstance.cmdListMemberTest();
        testInstance.cmdListRegionTest();
        testInstance.cmdListFunctionTest(CommandPrms.getFunctionsRegistered());
        testInstance.cmdListIndexTest(CommandPrms.getIndexAdded());
        testInstance.cmdStatusLocatorTest();
        testInstance.cmdStatusServerTest();
        testInstance.cmdShowDeadLockTest();
        testInstance.cmdShowMetricsTest();
        testInstance.cmdExportStackTraceTest();
        testInstance.cmdAlterDiskStoreTest();
        testInstance.cmdAlterRuntimeTest();
        testInstance.cmdCreateIndexTest();
        testInstance.cmdDestroyIndexTest();
        testInstance.destroyRegionTest();
        testInstance.encryptTest();
        testInstance.cmdPutTest();
        testInstance.cmdGetTest();
        testInstance.cmdLocateTest();
        testInstance.cmdRemoveTest();
    }

    public static void HydraTask_checkForCommandErrors() {
        CommandTest.checkForErrors(cmdErrorKey);
        CommandTest.checkForErrors("cmdError_thr" + RemoteTestModule.getCurrentThread().getThreadId());
    }

    public static void HydraTask_addFunction() {
        testInstance.addFunction();
    }

    public static void HydraTask_addIndex() {
        testInstance.addIndex();
    }

    public static void HydraTask_CmdListDiskStoreTest() {
        testInstance.cmdListDiskStoreTest(CommandPrms.getRegionsAdded());
    }

    public static void HydraTask_verifyOfflineHelpCommand() {
        testInstance.verifyHelpCommand();
        testInstance.verifyHelpAvailability(false);
        testInstance.verifyHelpDescription();
    }

    public static void HydraTask_verifyOnlineHelpCommand() {
        testInstance.verifyHelpCommand();
        testInstance.verifyHelpAvailability(true);
        testInstance.verifyHelpDescription();
    }

    public static void HydraTask_verifyHelpForCommands() {
        testInstance.verifyHelpForCommands();
    }

    public static void HydraTask_checkForHelpErrors() {
        CommandTest.checkForErrors(helpErrorKey);
    }

    public static void HydraTask_verifyDataTest() {
        testInstance.verifyDataTest();
        testInstance.verifyExportImportDataTest();
        testInstance.verifyShowMetricsDataTest();
    }

    public static void HydraTask_checkForDataErrors() {
        CommandTest.checkForErrors(dataErrorKey);
    }

    public static void HydraTask_verifyCompressedDataTest() {
        testInstance.verifyCompressedDataTest();
    }

    public static void HydraTask_checkCompressedPerfStats() {
        testInstance.checkCompressedPerfStats();
    }

    public static void HydraTask_memberTests() {
        testInstance.cmdListMemberTest();
        testInstance.cmdDescribeMemberTest();
    }

    public static void HydraTask_regionTests() {
        testInstance.cmdListRegionTest();
        testInstance.cmdDescribeRegionTest();
    }

    public static void HydraTask_listFunctionTest() {
        boolean functionsAreRegistered = CommandPrms.getFunctionsRegistered();
        Log.getLogWriter().info("HydraTask_listFunctionTest-functionsAreRegistered=" + functionsAreRegistered);
        testInstance.cmdListFunctionTest(functionsAreRegistered);
    }

    public static void HydraTask_createIndexTest() {
        testInstance.cmdCreateIndexTest();
    }

    public static void HydraTask_listIndexTest() {
        boolean indexesAreAdded = CommandPrms.getIndexAdded();
        Log.getLogWriter().info("HydraTask_listIndexTest-indexesAreAdded=" + indexesAreAdded);
        testInstance.cmdListIndexTest(indexesAreAdded);
    }

    public static void HydraTask_regionCommands() {
        testInstance.doRegionCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_writeRegionNamesToBB() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        Set rootRegions = theCache.rootRegions();
        HashSet allRegions = new HashSet();
        allRegions.addAll(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        HashSet<String> regionNames = new HashSet<String>();
        HashMap<String, RegionAttributes> regMap = new HashMap<String, RegionAttributes>();
        for (Region aRegion : allRegions) {
            String regName = aRegion.getFullPath();
            regionNames.add(regName);
            AttributesFactory fac = new AttributesFactory(aRegion.getAttributes());
            RegionAttributes attr = fac.create();
            regMap.put(regName, fac.create());
        }
        SharedLock lock = CommandBB.getBB().getSharedLock();
        lock.lock();
        try {
            HashSet existingSet = (HashSet)CommandBB.getBB().getSharedMap().get(regionNamesKey);
            if (existingSet == null) {
                existingSet = new HashSet();
            }
            existingSet.addAll(regionNames);
            CommandBB.getBB().getSharedMap().put(regionNamesKey, existingSet);
            TreeMap existingMap = (TreeMap)CommandBB.getBB().getSharedMap().get(regionAttrKey);
            if (existingMap == null) {
                existingMap = new TreeMap();
            }
            existingMap.putAll(regMap);
            CommandBB.getBB().getSharedMap().put(regionAttrKey, existingMap);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_writeMemberDescriptionToBB() {
        MemberDescription memDesc = new MemberDescription();
        memDesc.setVmID(RemoteTestModule.getMyVmid());
        memDesc.setMember(DistributedSystemHelper.getDistributedSystem().getDistributedMember());
        memDesc.setClientName(System.getProperty("clientName"));
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        Set rootRegions = theCache.rootRegions();
        HashSet allRegions = new HashSet();
        allRegions.addAll(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        for (Region aRegion : allRegions) {
            memDesc.addRegion(aRegion);
        }
        SharedLock lock = CommandBB.getBB().getSharedLock();
        lock.lock();
        try {
            HashMap<Integer, MemberDescription> aMap = (HashMap<Integer, MemberDescription>)CommandBB.getBB().getSharedMap().get(memberDescriptionKey);
            if (aMap == null) {
                aMap = new HashMap<Integer, MemberDescription>();
            }
            aMap.put(memDesc.getVmID(), memDesc);
            CommandBB.getBB().getSharedMap().put(memberDescriptionKey, aMap);
        }
        finally {
            lock.unlock();
        }
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
        connectorService = null;
    }

    public static void HydraTask_clearManagers() {
        connectorService = null;
        FederationBlackboard.getBB().getSharedMap().remove("MANAGERS");
        CommandBB.getBB().getSharedCounters().zero(CommandBB.managerCount);
        CommandBB.getBB().getSharedCounters().zero(CommandBB.configurableInitCounter);
    }

    public static void HydraTask_rebalanceController() {
        testInstance.rebalanceController();
    }

    public static void HydraTask_load() {
        if (CacheHelper.getCache() == null) {
            throw new StopSchedulingTaskOnClientOrder("This member has no cache and cannot participate in loading regions with data");
        }
        int numToLoadEachRegion = CommandPrms.getNumToLoadEachRegion();
        int CHUNK_SIZE = 50;
        RandomValues rv = new RandomValues();
        HashSet regionSet = new HashSet(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(regionSet);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        boolean doneWithLoad = false;
        HashMap<String, ValueHolder> putAllMap = new HashMap<String, ValueHolder>();
        for (int i = 1; i <= CHUNK_SIZE; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            if (NameFactory.getCounterForName(key) > (long)numToLoadEachRegion) {
                doneWithLoad = true;
                break;
            }
            ValueHolder value = new ValueHolder(key, rv);
            putAllMap.put(key, value);
        }
        if (putAllMap.size() > 0) {
            Log.getLogWriter().info("Created putAll map of size " + putAllMap.size());
            for (Region aRegion : regionSet) {
                Log.getLogWriter().info("Calling putAll with map of size " + putAllMap.size() + " with region " + aRegion.getFullPath());
                aRegion.putAll(putAllMap);
            }
        }
        if (doneWithLoad) {
            throw new StopSchedulingTaskOnClientOrder("Load is complete");
        }
    }

    public static void HydraTask_logRegions() {
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    public static void HydraTask_logBBs() {
        JMXManagerBlackboard.getInstance().print();
        CommandBB.getBB().print();
        PortBlackboard.getInstance().print();
        DistributedSystemBlackboard.getInstance().print();
    }

    public static void HydraTask_stopStart() {
        testInstance.stopStart();
    }

    public static void HydraTask_logManagerStatus() {
        CommandTestVersionHelper.logManagerStatus();
    }

    public static void HydraTask_verifyMemberMBeans() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("Cache does not exist in this jvm so cannot verify MBeans");
        } else {
            ManagementService service = ManagementService.getExistingManagementService((Cache)theCache);
            if (service.isManager()) {
                HashSet<DistributedMember> membersFromBB = new HashSet<DistributedMember>();
                Map sharedMap = CommandBB.getBB().getSharedMap().getMap();
                for (Object key : sharedMap.keySet()) {
                    if (!(key instanceof String) || !((String)key).startsWith(memberWithCacheMemberIdKeyPrefix)) continue;
                    membersFromBB.add((DistributedMember)sharedMap.get(key));
                }
                Log.getLogWriter().info("Expect this member to have " + membersFromBB.size() + " member MBeans: " + membersFromBB);
                long timeLimitMs = 120000L;
                int sleepTimeMs = 5000;
                long startTime = System.currentTimeMillis();
                int nullCount = 0;
                TreeMap<String, MemberMXBean> beanMap = new TreeMap<String, MemberMXBean>();
                do {
                    if (nullCount > 0) {
                        Log.getLogWriter().info("Unable to obtain " + nullCount + " MBeans, sleeping for " + 5000 + " ms before trying again");
                        MasterController.sleepForMs(5000);
                    }
                    nullCount = 0;
                    beanMap = new TreeMap();
                    for (DistributedMember member : membersFromBB) {
                        ObjectName memberMBeanName = service.getMemberMBeanName(member);
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        MemberMXBean mbean = JMX.newMBeanProxy(server, memberMBeanName, MemberMXBean.class, false);
                        if (mbean == null) {
                            ++nullCount;
                        }
                        beanMap.put(member.getId(), mbean);
                    }
                    Log.getLogWriter().info("Obtained " + beanMap.size() + " MBeans: " + beanMap + " containing " + nullCount + " null MBeans");
                } while (nullCount > 0 && System.currentTimeMillis() - startTime < 120000L);
                if (nullCount > 0) {
                    HashSet missingBeanSet = new HashSet();
                    for (Object key : beanMap.keySet()) {
                        Object value = beanMap.get(key);
                        if (value != null) continue;
                        missingBeanSet.add(key);
                    }
                    throw new TestException("Unable to obtain " + membersFromBB.size() + " member MBeans in " + 120000L + " ms, missing " + missingBeanSet.size() + " member beans for members: " + missingBeanSet);
                }
            } else {
                Log.getLogWriter().info("This member is not a manager so cannot verify MBeans");
            }
        }
    }

    public static void HydraTask_verifyRegionMBeans() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("Cache does not exist in this jvm so cannot verify region MBeans");
        } else {
            CommandTest.verifyDistributedRegionMBeans();
            CommandTest.verifyLocalRegionMBeans();
        }
    }

    private static Set<DistributedRegionMXBean> getDistributedRegionMBeans() {
        return CommandTest.getRegionMBeans("GemFire:service=Region,name=*,type=Distributed", DistributedRegionMXBean.class);
    }

    private static Set<RegionMXBean> getLocalRegionMBeans() {
        return CommandTest.getRegionMBeans("GemFire:service=Region,name=*,type=Member,member=*", RegionMXBean.class);
    }

    private static Set getRegionMBeans(String beanQueryStr, Class beanClass) {
        ObjectName objectNamePattern;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            objectNamePattern = ObjectName.getInstance(beanQueryStr);
        }
        catch (MalformedObjectNameException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NullPointerException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Set<ObjectName> regionNames = server.queryNames(objectNamePattern, null);
        ArrayList regionMBeansList = new ArrayList();
        for (ObjectName name : regionNames) {
            Object mbean = JMX.newMXBeanProxy(server, name, beanClass, false);
            regionMBeansList.add(mbean);
        }
        HashSet regionMBeansSet = new HashSet(regionMBeansList);
        Log.getLogWriter().info("region ObjectNames, size " + regionNames.size() + ": " + CommandTest.setToString(regionNames));
        Log.getLogWriter().info("region MBeans, size " + regionMBeansSet.size() + ": " + CommandTest.setToString(regionMBeansSet));
        if (regionMBeansSet.size() != regionMBeansList.size()) {
            throw new TestException("Region MBeans (list) is size " + regionMBeansList.size() + ": " + regionMBeansList + ", but region MBeans (set) size is " + regionMBeansSet.size() + ": " + regionMBeansSet + "; expected equals sizes");
        }
        return regionMBeansSet;
    }

    private static void verifyDistributedRegionMBeans() {
        ManagementService service = ManagementService.getExistingManagementService((Cache)CacheHelper.getCache());
        Log.getLogWriter().info("Verifying distributed region MBeans in this member, isManager: " + service.isManager());
        Set<DistributedRegionMXBean> regionMBeans = CommandTest.getDistributedRegionMBeans();
        if (service.isManager()) {
            StringBuffer errStr = new StringBuffer();
            Map memberDescMap = (Map)CommandBB.getBB().getSharedMap().get(memberDescriptionKey);
            if (memberDescMap.size() == 0) {
                throw new TestException("Cannot do region MBean validation, CommandBB shared map does not have a value for key memberDescription; test might need to add CommandTest.HydraTask_writeMemberDescriptionToBB() in all members that define regions");
            }
            HashSet<String> expectedRegionNames = new HashSet<String>();
            for (MemberDescription memDesc : memberDescMap.values()) {
                expectedRegionNames.addAll(memDesc.getRegions());
            }
            CommandTest.verifyDistributedRegionMBeans(regionMBeans, expectedRegionNames);
        } else {
            if (regionMBeans.size() > 0) {
                throw new TestException("Expected this member to not have any distributed region MBeans, but it has " + regionMBeans.size() + ": " + regionMBeans);
            }
            Log.getLogWriter().info("Found " + regionMBeans.size() + " distributed region MBeans as expected");
        }
        Log.getLogWriter().info("Done verifying presence of " + regionMBeans.size() + " distributed region MBeans");
    }

    private static void verifyLocalRegionMBeans() {
        ManagementService service = ManagementService.getExistingManagementService((Cache)CacheHelper.getCache());
        Log.getLogWriter().info("Verifying presence of local region MBeans in this member, isManager: " + service.isManager());
        if (service.isManager()) {
            CommandTest.verifyLocalRegionMBeans_manager();
        } else {
            CommandTest.verifyLocalRegionMBeans_nonManager();
        }
    }

    private static void verifyLocalRegionMBeans_manager() {
        Set<RegionMXBean> localRegionMBeans = CommandTest.getLocalRegionMBeans();
        HashMap<String, HashSet<RegionMXBean>> memberMBeanMap = new HashMap<String, HashSet<RegionMXBean>>();
        for (RegionMXBean regionMXBean : localRegionMBeans) {
            String member = regionMXBean.getMember();
            HashSet<RegionMXBean> MBeanSet = (HashSet<RegionMXBean>)memberMBeanMap.get(member);
            if (MBeanSet == null) {
                MBeanSet = new HashSet<RegionMXBean>();
                memberMBeanMap.put(member, MBeanSet);
            }
            MBeanSet.add(regionMXBean);
        }
        StringBuilder aStr = new StringBuilder();
        for (String key : memberMBeanMap.keySet()) {
            Set value = (Set)memberMBeanMap.get(key);
            aStr.append(key + "(value is set containing " + value.size() + " elements)\n");
            aStr.append(CommandTest.setToString(value));
        }
        Log.getLogWriter().info("Verifying presence of local MBeans in this manager member: " + aStr.toString());
        Map map = (Map)CommandBB.getBB().getSharedMap().get(memberDescriptionKey);
        Log.getLogWriter().info("Looking for missing or extra members in " + localRegionMBeans.size() + " MBeans");
        HashSet<String> expectedMembers = new HashSet<String>();
        for (MemberDescription memDesc : map.values()) {
            if (memDesc.getRegions().size() <= 0) continue;
            expectedMembers.add(memDesc.getMember().toString());
        }
        Set foundMembers = memberMBeanMap.keySet();
        HashSet missingMembers = new HashSet(expectedMembers);
        missingMembers.removeAll(foundMembers);
        HashSet extraMembers = new HashSet(foundMembers);
        extraMembers.removeAll(expectedMembers);
        if (missingMembers.size() > 0) {
            throw new TestException("local region MBeans in manager member is missing MBeans for members: " + missingMembers);
        }
        if (extraMembers.size() > 0) {
            throw new TestException("local region MBeans in manager member as unexpected MBeans for members: " + extraMembers);
        }
        for (String member : memberMBeanMap.keySet()) {
            Log.getLogWriter().info("Verifing local region MBeans for member " + member);
            Set MBeanList = (Set)memberMBeanMap.get(member);
            for (MemberDescription memDesc : map.values()) {
                if (!memDesc.getMember().equals(member)) continue;
                Set<String> expectedRegionFullPaths = memDesc.getRegions();
                CommandTest.verifyRegionMBeans(MBeanList, expectedRegionFullPaths);
            }
        }
        Log.getLogWriter().info("Done verifying presence of " + localRegionMBeans.size() + " region MBeans");
        CommandTest.verifyRegionMBeanValues(localRegionMBeans);
    }

    private static void verifyLocalRegionMBeans_nonManager() {
        Set<RegionMXBean> localRegionMBeans = CommandTest.getLocalRegionMBeans();
        Set<Region> allRegions = CommandTest.getAllRegions();
        HashSet<String> expectedRegionPaths = new HashSet<String>();
        for (Region aRegion : allRegions) {
            expectedRegionPaths.add(aRegion.getFullPath());
        }
        CommandTest.verifyRegionMBeans(localRegionMBeans, expectedRegionPaths);
        String thisMember = DistributedSystemHelper.getDistributedSystem().getDistributedMember().toString();
        Log.getLogWriter().info("Verifying each of " + localRegionMBeans.size() + " has the correct member information");
        for (RegionMXBean MBean : localRegionMBeans) {
            String MBeanMember = MBean.getMember();
            if (MBeanMember.equals(thisMember)) continue;
            throw new TestException("Expected region MBean " + MBean + " to reference member " + thisMember + " but it references " + MBeanMember);
        }
        Log.getLogWriter().info("Done verifying presence of " + localRegionMBeans.size() + " region MBeans");
        CommandTest.verifyRegionMBeanValues(localRegionMBeans);
    }

    private static Set<Region> getAllRegions() {
        HashSet<Region> regionSet = new HashSet<Region>(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(regionSet);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        return regionSet;
    }

    private static void verifyDistributedRegionMBeans(Set<DistributedRegionMXBean> regionMBeans, Set<String> expectedRegionPaths) {
        HashSet<String> MBeanRegionPaths = new HashSet<String>();
        for (DistributedRegionMXBean regMBean : regionMBeans) {
            MBeanRegionPaths.add(regMBean.getFullPath());
        }
        CommandTest._verifyRegionMBeans(MBeanRegionPaths, expectedRegionPaths);
    }

    private static void verifyRegionMBeans(Set<RegionMXBean> regionMBeans, Set<String> expectedRegionPaths) {
        HashSet<String> MBeanRegionPaths = new HashSet<String>();
        for (RegionMXBean regMBean : regionMBeans) {
            MBeanRegionPaths.add(regMBean.getFullPath());
        }
        CommandTest._verifyRegionMBeans(MBeanRegionPaths, expectedRegionPaths);
    }

    private static void _verifyRegionMBeans(Set<String> MBeanRegionPaths, Set<String> expectedRegionPaths) {
        Log.getLogWriter().info("Expected " + expectedRegionPaths.size() + " regions with region MBeans: " + expectedRegionPaths);
        Log.getLogWriter().info("Found " + MBeanRegionPaths.size() + " region paths in MBeans: " + MBeanRegionPaths);
        StringBuffer errStr = new StringBuffer();
        ArrayList<String> missing = new ArrayList<String>(expectedRegionPaths);
        missing.removeAll(MBeanRegionPaths);
        ArrayList<String> extra = new ArrayList<String>(MBeanRegionPaths);
        extra.removeAll(expectedRegionPaths);
        ArrayList<String> duplicates = new ArrayList<String>(MBeanRegionPaths);
        for (String regPath : expectedRegionPaths) {
            duplicates.remove(regPath);
        }
        if (missing.size() != 0) {
            errStr.append("These regions do not have region MBeans in this member: " + missing + "\n");
        }
        if (extra.size() != 0) {
            errStr.append("Found extra region MBeans in this member for these regions: " + extra + "\n");
        }
        if (duplicates.size() != 0) {
            errStr.append("Region MBeans for these regions were found more than once in this member: " + duplicates + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Verified region path in " + MBeanRegionPaths.size() + " MBeans");
    }

    private static void verifyRegionMBeanValues(Set<RegionMXBean> regionMBeans) {
        for (RegionMXBean regionMBean : regionMBeans) {
            CommandTest.verifyRegionMBeanValues(regionMBean);
        }
    }

    private static void verifyRegionMBeanValues(RegionMXBean regionMBean) {
        Log.getLogWriter().info("Verifying values in region MBean " + regionMBean);
        Method[] methods = RegionMXBean.class.getDeclaredMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method aMethod : methods) {
            methodNames.add(aMethod.getName());
        }
        ValidationInfo info = (ValidationInfo)CommandTest.getValueFromFunction(regionMBean);
        Log.getLogWriter().info("For " + regionMBean + ", validation info is " + info);
        String methodName = "getEntryCount";
        Object expectedValue = new Long(info.localEntryCount.intValue());
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, "Bug 46991 detected; ");
        methodNames.remove(methodName);
        methodName = "getConfiguredRedundancy";
        expectedValue = info.prAttr == null ? -1 : info.prAttr.getRedundantCopies();
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, "Bug 46733 detected; ");
        methodNames.remove(methodName);
        methodName = "getRegionType";
        expectedValue = info.dataPolicy.toString();
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, null);
        methodNames.remove(methodName);
        methodName = "getName";
        String regionFullPath = regionMBean.getFullPath();
        expectedValue = regionFullPath.substring(regionFullPath.lastIndexOf("/") + 1);
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, null);
        methodNames.remove(methodName);
        methodName = "isPersistentEnabled";
        expectedValue = info.withPersistence;
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, null);
        methodNames.remove(methodName);
        methodName = "getParentRegion";
        expectedValue = info.parentRegionName;
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, null);
        methodNames.remove(methodName);
        methodName = "getPrimaryBucketCount";
        expectedValue = info.primaryBucketCount;
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, null);
        methodNames.remove(methodName);
        methodName = "isGatewayEnabled";
        expectedValue = info.gatewayEnabled;
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, null);
        methodNames.remove(methodName);
        methodName = "getNumBucketsWithoutRedundancy";
        expectedValue = new Integer(0);
        if (!info.dataPolicy.withPartitioning()) {
            expectedValue = new Integer(-1);
        }
        CommandTest.verifyValue(expectedValue, methodName, regionMBean, "Bug 46997 detected");
        methodNames.remove(methodName);
        String[] rates = new String[]{"getDestroyRate", "getDiskReadsRate", "getPutAllRate", "getLruDestroyRate", "getPutsRate", "getCreatesRate", "getDiskWritesRate", "getGetsRate"};
        String[] prOnlyrates = new String[]{"getPutLocalRate", "getPutRemoteRate"};
        expectedValue = info.prAttr == null ? new Float(-1.0f) : new Float(0.0f);
        for (String prOnlyrate : prOnlyrates) {
            CommandTest.verifyValue(expectedValue, prOnlyrate, regionMBean, null);
            methodNames.remove(prOnlyrate);
        }
        CommandTest.verifyRegionAttributes(info, regionMBean);
        methodNames.remove("listRegionAttributes");
        CommandTest.verifyPartitionAttributes(info, regionMBean);
        methodNames.remove("listPartitionAttributes");
        CommandTest.verifyMembershipAttributes(info, regionMBean);
        methodNames.remove("listMembershipAttributes");
        CommandTest.verifyEvictionAttributes(info, regionMBean);
        methodNames.remove("listEvictionAttributes");
        Log.getLogWriter().info("xxx listFixedPartitionAttributes: " + regionMBean.listFixedPartitionAttributes());
        CommandTest.verifySubregions(info, regionMBean);
        methodNames.remove("listSubRegionPaths");
        Log.getLogWriter().info("The following methods on RegionMXBean were not verified: " + methodNames);
    }

    private static void verifySubregions(ValidationInfo info, RegionMXBean regionMBean) {
        String aStr;
        String[] result = regionMBean.listSubregionPaths(false);
        HashSet<String> actual = new HashSet<String>(Arrays.asList(result));
        Log.getLogWriter().info(regionMBean + ".listSubregionPaths(false): " + actual);
        HashSet<String> missing = new HashSet<String>(info.directSubregions);
        missing.removeAll(actual);
        HashSet<String> extra = new HashSet<String>(actual);
        extra.removeAll(info.directSubregions);
        if (missing.size() > 0) {
            aStr = "The following subregions were missing from the result of " + regionMBean + ".listSubRegionPaths(false): " + missing + "; actual result is " + actual;
            Log.getLogWriter().info(aStr);
            CommandTest.saveErrorByThread(aStr);
        }
        if (extra.size() > 0) {
            aStr = "The following extra subregions were found in the result of " + regionMBean + ".listSubRegionPaths(false), " + extra + "; actual result is " + actual;
            Log.getLogWriter().info(aStr);
            CommandTest.saveErrorByThread(aStr);
        }
        result = regionMBean.listSubregionPaths(true);
        actual = new HashSet<String>(Arrays.asList(result));
        Log.getLogWriter().info(regionMBean + ".listSubregionPaths(false): " + actual);
        missing = new HashSet<String>(info.allSubregions);
        missing.removeAll(actual);
        extra = new HashSet<String>(actual);
        extra.removeAll(info.allSubregions);
        if (missing.size() > 0) {
            aStr = "The following subregions were missing from the result of " + regionMBean + ".listSubRegionPath(true), " + missing + "; actual result is " + actual;
            Log.getLogWriter().info(aStr);
            CommandTest.saveErrorByThread(aStr);
        }
        if (extra.size() > 0) {
            aStr = "The following extra subregions were found in the result of " + regionMBean + ".listSubRegionPaths(true), " + extra + "; actual result is " + actual;
            Log.getLogWriter().info(aStr);
            CommandTest.saveErrorByThread(aStr);
        }
    }

    private static void verifyRegionAttributes(ValidationInfo info, RegionMXBean regionMBean) {
        RegionAttributesData attr = regionMBean.listRegionAttributes();
        Log.getLogWriter().info("listRegionAttributes for " + regionMBean + " is: " + attr.toString());
        ArrayList<String> expectedInToString = new ArrayList<String>();
        Method[] methods = RegionAttributesData.class.getDeclaredMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method aMethod : methods) {
            methodNames.add(aMethod.getName());
        }
        String methodName = "getCacheListeners";
        Object expectedValue = info.cacheListeners;
        if (expectedValue != null) {
            CacheLoader value = new String[info.cacheListeners.size()];
            for (int i = 0; i < info.cacheListeners.size(); ++i) {
                value[i] = info.cacheListeners.get(i).getClass().getName();
            }
            expectedValue = value;
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("cacheListeners=" + Arrays.toString((String[])expectedValue));
        methodNames.remove(methodName);
        methodName = "getCacheLoaderClassName";
        expectedValue = info.cacheLoader;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("cacheLoaderClassName=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getCacheWriterClassName";
        expectedValue = info.cacheWriter;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("cacheWriterClassName=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getCompressor";
        expectedValue = info.compressor;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("compressor=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getConcurrencyLevel";
        expectedValue = info.concurrencyLevel;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("concurrencyLevel=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getCustomEntryIdleTimeout";
        expectedValue = info.customEntryIdleTimeout;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("customEntryIdleTimeout=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getCustomEntryTimeToLive";
        expectedValue = info.customEntryTimeToLive;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("customEntryTimeToLive=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getDataPolicy";
        expectedValue = info.dataPolicy;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("dataPolicy=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getDiskStoreName";
        expectedValue = info.diskStoreName;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("diskStoreName=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getEntryIdleTimeout";
        expectedValue = info.entryIdleTimeout;
        if (expectedValue != null) {
            expectedValue = info.entryIdleTimeout.getTimeout();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("entryIdleTimeout=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getEnableOffHeapMemory";
        expectedValue = info.enableOffHeapMemory;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("enableOffHeapMemory=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getEntryTimeToLive";
        expectedValue = info.entryTimeToLive;
        if (expectedValue != null) {
            expectedValue = info.entryTimeToLive.getTimeout();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("entryTimeToLive=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getGatewayHubId";
        expectedValue = info.gatewayHubId;
        if (expectedValue != null && (expectedValue = expectedValue.toString()).equals("")) {
            expectedValue = null;
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, "Bug 46987 detected; ");
        if (attr.getGatewayHubId() != null && attr.getGatewayHubId().equals("") && attr.toString().contains("gatewayHubId=null")) {
            CommandTest.saveErrorByThread("Bug 46987 detected; getGatewayHubId returns empty String, but result of toString() on RegionAttributesData returns gatewayHubId=null: result of toSring(): " + attr.toString());
        }
        expectedInToString.add("gatewayHubId=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getInitialCapacity";
        expectedValue = info.initialCapacity;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("initialCapacity=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getInterestPolicy";
        expectedValue = info.interestPolicy;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("interestPolicy=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getKeyConstraintClassName";
        expectedValue = info.keyConstraint;
        if (expectedValue != null) {
            expectedValue = info.keyConstraint.getName();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("keyConstraintClassName=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getLoadFactor";
        expectedValue = info.loadFactor;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("loadFactor=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getPoolName";
        expectedValue = info.poolName;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("poolName=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getRegionIdleTimeout";
        expectedValue = info.regionIdleTimeout;
        if (expectedValue != null) {
            expectedValue = info.regionIdleTimeout.getTimeout();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("regionIdleTimeout=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getRegionTimeToLive";
        expectedValue = info.regionTimeToLive;
        if (expectedValue != null) {
            expectedValue = info.regionTimeToLive.getTimeout();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("regionTimeToLive=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getScope";
        expectedValue = info.scope;
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("scope=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getValueConstraintClassName";
        expectedValue = info.valueConstraint;
        if (expectedValue != null) {
            expectedValue = info.valueConstraint.getName();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("valueConstraintClassName=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isAsyncConflationEnabled";
        expectedValue = info.asyncConflationEnabled;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("asyncConflationEnabled=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isCloningEnabled";
        expectedValue = info.cloningEnabled;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("cloningEnabled=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isDiskSynchronous";
        expectedValue = info.diskSynchronous;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("diskSynchronous=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isGatewayEnabled";
        expectedValue = info.gatewayEnabled;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("gatewayEnabled=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isIgnoreJTA";
        expectedValue = info.ignoreJTA;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("ignoreJTA=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isIndexMaintenanceSynchronous";
        expectedValue = info.indexMaintenanceSynchronous;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("indexMaintenanceSynchronous=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isLockGrantor";
        expectedValue = info.lockGrantor;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("lockGrantor=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isMulticastEnabled";
        expectedValue = info.multicastEnabled;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("multicastEnabled=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isStatisticsEnabled";
        expectedValue = info.statisticsEnabled;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("statisticsEnabled=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isSubscriptionConflationEnabled";
        expectedValue = info.subscriptionConflationEnabled;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("subscriptionConflationEnabled=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "isHdfsWriteOnly";
        expectedValue = info.hdfsWriteOnly;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("hdfsWriteOnly=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getHdfsStoreName";
        expectedValue = info.hdfsStoreName;
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("hdfsStoreName=" + expectedValue);
        methodNames.remove(methodName);
        Collections.sort(expectedInToString);
        CommandTest.verifyAttrToString(attr.getClass().getSimpleName(), expectedInToString, attr.toString(), null);
        methodNames.remove("toString");
        CommandTest.verifyMethodNames(attr.getClass().getSimpleName(), methodNames);
    }

    private static void verifyPartitionAttributes(ValidationInfo info, RegionMXBean regionMBean) {
        PartitionAttributesData attr = regionMBean.listPartitionAttributes();
        if (info.prAttr == null) {
            if (attr != null) {
                CommandTest.saveErrorByThread("" + regionMBean + " does not represent a PR, but listPartitionAttributes() is " + attr);
            }
            return;
        }
        if (attr == null) {
            CommandTest.saveErrorByThread("" + regionMBean + " represents a PR, but listPartitionAttributes() is null");
            return;
        }
        Log.getLogWriter().info("listPartitionAttributes for " + regionMBean + " is: " + attr.toString());
        ArrayList<String> expectedInToString = new ArrayList<String>();
        Method[] methods = PartitionAttributesData.class.getDeclaredMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method aMethod : methods) {
            methodNames.add(aMethod.getName());
        }
        String methodName = "getColocatedWith";
        Object expectedValue = info.prAttr.getColocatedWith();
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("colocatedWith=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getLocalMaxMemory";
        expectedValue = info.prAttr.getLocalMaxMemory();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("localMaxMemory=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getPartitionListeners";
        PartitionListener[] listArr = info.prAttr.getPartitionListeners();
        ArrayList<String> aList = new ArrayList<String>();
        for (PartitionListener listener : listArr) {
            aList.add(listener.getClass().getName());
        }
        expectedValue = aList.toArray(new String[0]);
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("partitionListeners=" + ((Object)aList).toString());
        methodNames.remove(methodName);
        methodName = "getPartitionResolver";
        expectedValue = info.prAttr.getPartitionResolver();
        if (expectedValue != null) {
            expectedValue = info.prAttr.getPartitionResolver().getClass().getName();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("partitionResolver=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getRecoveryDelay";
        expectedValue = info.prAttr.getRecoveryDelay();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("recoveryDelay=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getRedundantCopies";
        expectedValue = info.prAttr.getRedundantCopies();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("redundantCopies=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getStartupRecoveryDelay";
        expectedValue = info.prAttr.getStartupRecoveryDelay();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("startupRecoveryDelay=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getTotalMaxMemory";
        expectedValue = info.prAttr.getTotalMaxMemory();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("totalMaxMemory=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getTotalNumBuckets";
        expectedValue = info.prAttr.getTotalNumBuckets();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("totalNumBuckets=" + expectedValue);
        methodNames.remove(methodName);
        CommandTest.verifyAttrToString(attr.getClass().getSimpleName(), expectedInToString, attr.toString(), null);
        methodNames.remove("toString");
        CommandTest.verifyMethodNames(attr.getClass().getSimpleName(), methodNames);
    }

    private static void verifyMembershipAttributes(ValidationInfo info, RegionMXBean regionMBean) {
        MembershipAttributesData attr = regionMBean.listMembershipAttributes();
        String allAttrStr = attr.toString();
        Log.getLogWriter().info("listMembershipAttributes for " + regionMBean + " is: " + allAttrStr);
        ArrayList<String> expectedInToString = new ArrayList<String>();
        Method[] methods = MembershipAttributesData.class.getDeclaredMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method aMethod : methods) {
            methodNames.add(aMethod.getName());
        }
        String methodName = "getLossAction";
        Object expectedValue = info.membershipAttr.getLossAction();
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("lossAction=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getRequiredRoles";
        expectedValue = info.membershipAttr.getRequiredRoles();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("requiredRoles=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getResumptionAction";
        expectedValue = info.membershipAttr.getResumptionAction();
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("resumptionAction=" + expectedValue);
        methodNames.remove(methodName);
        CommandTest.verifyAttrToString(attr.getClass().getSimpleName(), expectedInToString, attr.toString(), null);
        methodNames.remove("toString");
        CommandTest.verifyMethodNames(attr.getClass().getSimpleName(), methodNames);
    }

    private static void verifyEvictionAttributes(ValidationInfo info, RegionMXBean regionMBean) {
        EvictionAttributesData attr = regionMBean.listEvictionAttributes();
        Log.getLogWriter().info("listEvictionAttributes for " + regionMBean + " is: " + attr.toString());
        ArrayList<String> expectedInToString = new ArrayList<String>();
        Method[] methods = EvictionAttributesData.class.getDeclaredMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method aMethod : methods) {
            methodNames.add(aMethod.getName());
        }
        Log.getLogWriter().info("EvictionAttributes is: " + info.evictionAttr);
        String methodName = "getAlgorithm";
        Object expectedValue = info.evictionAttr.getAlgorithm().toString();
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        expectedInToString.add("algorithm=" + expectedValue);
        methodNames.remove(methodName);
        methodName = "getAction";
        expectedValue = info.evictionAttr.getAction();
        if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, null);
        if (!info.evictionAttr.getAlgorithm().isNone()) {
            expectedInToString.add("action=" + expectedValue);
        }
        methodNames.remove(methodName);
        methodName = "getMaximum";
        EvictionAlgorithm algorithm = info.evictionAttr.getAlgorithm();
        expectedValue = null;
        if (algorithm.isLRUEntry() || algorithm.isLRUMemory()) {
            expectedValue = info.evictionAttr.getMaximum();
            expectedInToString.add("maximum=" + expectedValue);
        }
        CommandTest.verifyValue(expectedValue, methodName, attr, "Bug 46894 detected; ");
        methodNames.remove(methodName);
        CommandTest.verifyAttrToString(attr.getClass().getSimpleName(), expectedInToString, attr.toString(), "Bug 46895 detected; ");
        methodNames.remove("toString");
        CommandTest.verifyMethodNames(attr.getClass().getSimpleName(), methodNames);
    }

    protected static void verifyMethodNames(String className, Set methodNames) {
        if (methodNames.size() != 0) {
            String aStr = "The following methods on " + className + " were not verified: " + methodNames;
            Log.getLogWriter().info(aStr);
            String namesStr = methodNames.toString();
            if (namesStr.startsWith("set") || namesStr.contains(" set")) {
                CommandTest.saveErrorByThread("Bug 46834 (" + className + ") detected; API has public setter methods");
            } else {
                throw new TestException(aStr);
            }
        }
    }

    private static void verifyAttrToString(String attrClassName, List<String> components, String actual, String errStrPrefix) {
        if (actual.contains(attrClassName + "@")) {
            CommandTest.saveErrorByThread("Bug 46787 (" + attrClassName + ") detected; toString() on " + attrClassName + " returned: " + actual);
            return;
        }
        if (actual.contains("{")) {
            CommandTest.saveErrorByThread("Bug 46831 (contains {) detected; " + actual);
            return;
        }
        if (actual.contains("=,") || actual.contains("=]")) {
            CommandTest.saveErrorByThread("Bug 46831 (contains empty string ',=' with no value) detected; " + actual);
            return;
        }
        StringBuilder expectedStr = new StringBuilder();
        expectedStr.append(attrClassName + " [");
        for (int i = 0; i < components.size(); ++i) {
            expectedStr.append(components.get(i));
            if (i >= components.size() - 1) continue;
            expectedStr.append(", ");
        }
        expectedStr.append("]");
        if (actual.equals(expectedStr.toString())) {
            Log.getLogWriter().info("Verified: " + actual);
        } else {
            String result = CommandTest.formatExceptionTextDifference(attrClassName + ".toString()", actual, expectedStr.toString()).toString();
            if (errStrPrefix != null) {
                result = errStrPrefix + result;
            }
            Log.getLogWriter().info(result);
            CommandTest.saveErrorByThread(result);
        }
    }

    protected static Object getValueFromFunction(RegionMXBean regionMBean) {
        String member = regionMBean.getMember();
        Execution exe = FunctionService.onMember((DistributedMember)CommandTest.getMemberFor(member));
        String[] args = new String[]{"" + RemoteTestModule.getCurrentThread().getThreadId(), regionMBean.getFullPath()};
        Log.getLogWriter().info("Executing " + exe + " with args " + Arrays.asList(args));
        ResultCollector result = exe.withArgs((Object)args).execute((Function)new CliHelperFunction());
        Object returnValue = ((ArrayList)result.getResult()).get(0);
        return returnValue;
    }

    private static DistributedMember getMemberFor(String member) {
        Log.getLogWriter().info("Looking for DistributedMember for " + member);
        Map aMap = (Map)CommandBB.getBB().getSharedMap().get(memberDescriptionKey);
        for (MemberDescription memberDesc : aMap.values()) {
            if (!memberDesc.getMember().toString().equals(member)) continue;
            Log.getLogWriter().info("Returning " + memberDesc.getMember());
            return memberDesc.getMember();
        }
        throw new TestException("Could not find DistributedMember for " + member);
    }

    private static void verifyValue(Object expectedValue, String methodName, Object baseObject, String errStrPrefix) {
        try {
            Method aMethod = baseObject.getClass().getDeclaredMethod(methodName, null);
            Object value = aMethod.invoke(baseObject, (Object[])null);
            boolean valueIsCorrect = false;
            if (expectedValue == null) {
                valueIsCorrect = value == null;
            } else if (value == null) {
                valueIsCorrect = false;
            } else if (value.getClass().isArray() && expectedValue.getClass().isArray()) {
                valueIsCorrect = true;
                if (value.getClass().getComponentType() == expectedValue.getClass().getComponentType()) {
                    Object[] valueArr = (Object[])value;
                    Object[] expectedValArr = (Object[])expectedValue;
                    if (valueArr.length == expectedValArr.length) {
                        for (int i = 0; i < valueArr.length; ++i) {
                            if (valueArr[i].equals(expectedValArr[i])) continue;
                            valueIsCorrect = false;
                        }
                    } else {
                        valueIsCorrect = false;
                    }
                } else {
                    valueIsCorrect = false;
                }
            } else {
                valueIsCorrect = expectedValue.equals(value);
            }
            if (valueIsCorrect) {
                Log.getLogWriter().info(baseObject.getClass().getName() + "." + methodName + "() returned " + TestHelper.toString(value) + " as expected for " + baseObject);
            } else {
                String aStr = "";
                if (errStrPrefix != null) {
                    aStr = errStrPrefix;
                }
                aStr = aStr + "Expected " + baseObject.getClass().getName() + "." + methodName + "() to return " + TestHelper.toString(expectedValue) + " but it returned " + TestHelper.toString(value) + "; " + baseObject.getClass().getName() + " is " + baseObject;
                Log.getLogWriter().info(aStr);
                CommandTest.saveErrorByThread(aStr);
            }
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
    }

    private static void saveErrorByThread(String errStr) {
        Log.getLogWriter().info(errStr);
        int ERROR_LIMIT = 30;
        String LAST_ERROR_VALUE = "No more errors being logged to blackbooard, hit limit of 30";
        String bbKey = "cmdError_thr" + RemoteTestModule.getCurrentThread().getThreadId();
        ArrayList<String> aList = (ArrayList<String>)CommandBB.getBB().getSharedMap().get(bbKey);
        if (aList == null) {
            aList = new ArrayList<String>();
            aList.add(errStr + "\n");
        } else if (aList.size() >= 30) {
            String lastValue = (String)aList.get(aList.size() - 1);
            if (lastValue.startsWith("No more errors being logged to blackbooard, hit limit of 30")) {
                return;
            }
            aList.add("No more errors being logged to blackbooard, hit limit of 30");
        } else if (errStr.startsWith("Bug ") && errStr.contains("detected")) {
            String bugDetectedStr = errStr.substring(0, errStr.indexOf("detected"));
            if (!((Object)aList).toString().contains(bugDetectedStr)) {
                aList.add(errStr + "\n");
            }
        } else if (!((Object)aList).toString().contains(errStr)) {
            aList.add(errStr + "\n");
        }
        CommandBB.getBB().getSharedMap().put(bbKey, aList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_recordManagerStatus() {
        ManagementService service;
        Cache theCache = CacheHelper.getCache();
        if (theCache != null && (service = ManagementService.getExistingManagementService((Cache)theCache)).isManager()) {
            SharedLock lock = CommandBB.getBB().getSharedLock();
            lock.lock();
            try {
                HashMap<Integer, String> vmIdMap = (HashMap<Integer, String>)CommandBB.getBB().getSharedMap().get(jmxManagerVmIdsKey);
                if (vmIdMap == null) {
                    vmIdMap = new HashMap<Integer, String>();
                }
                vmIdMap.put(RemoteTestModule.getMyVmid(), RemoteTestModule.getMyHost());
                CommandBB.getBB().getSharedMap().put(jmxManagerVmIdsKey, vmIdMap);
            }
            finally {
                lock.unlock();
            }
        }
        Log.getLogWriter().info("Returning from HydraTask_recordManagerStatus, jmxManagers is " + CommandBB.getBB().getSharedMap().get(jmxManagerVmIdsKey));
    }

    public static void HydraTask_dataRateVerificationInit() {
        Log.getLogWriter().info("HydraTask_dataRateVerificationInit-Start");
        CommandBB.getBB().getSharedCounters().zero(CommandBB.dataRateDoOps);
        CommandBB.getBB().getSharedCounters().zero(CommandBB.dataRatePutCntr);
        testInstance.initDataRateRegion();
        Log.getLogWriter().info("HydraTask_dataRateVerificationInit-End");
    }

    public static void HydraTask_dataRateController() {
        Log.getLogWriter().info("HydraTask_dataRateController-Start");
        boolean haveErrors = testInstance.dataRateInitialVerification();
        if (!haveErrors) {
            CommandBB.getBB().getSharedCounters().increment(CommandBB.dataRateDoOps);
            testInstance.dataRateCheck(false);
            CommandBB.getBB().getSharedCounters().zero(CommandBB.dataRateDoOps);
            testInstance.dataRateCheck(true);
        }
        long dataRatePutCntr = CommandBB.getBB().getSharedCounters().read(CommandBB.dataRatePutCntr);
        Log.getLogWriter().info("HydraTask_dataRateController-dataRatePutCntr=" + dataRatePutCntr);
        Log.getLogWriter().info("HydraTask_dataRateController-End");
    }

    public static void HydraTask_dataRateOperations() {
        Log.getLogWriter().info("HydraTask_dataRateOperations-Start");
        long dataRateDoOps = CommandBB.getBB().getSharedCounters().read(CommandBB.dataRateDoOps);
        if (dataRateDoOps > 0L) {
            testInstance.dataRateOperations();
        }
        Log.getLogWriter().info("HydraTask_dataRateOperations-End");
    }

    private void stopStart() {
        this.getManagerVmIds();
    }

    private Set<Integer>[] getManagerVmIds() {
        return new Set[0];
    }

    private void initDataRateRegion() {
        Log.getLogWriter().info("initDataRateRegion-Start");
        this.runDataCommand("create region --type=REPLICATE --name=dataRateVerificationRegion");
        this.execSleepCommad("5");
        Log.getLogWriter().info("initDataRateRegion-End");
    }

    private boolean dataRateInitialVerification() {
        Log.getLogWriter().info("dataRateInitialVerification-Start");
        boolean haveErrors = false;
        String regionName = "dataRateVerificationRegion";
        String command = "show metrics --categories=cache";
        ArrayList<String> cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "totalRegionCount"), "1");
        Log.getLogWriter().info("dataRateInitialVerification-Show Metrics-Plain");
        command = "show metrics --categories=cluster,region --region=/" + regionName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "region entry count"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "missCount"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "hitCount"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "hitRatio"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "getsRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "putsRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "createsRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "destroyRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "putAllRate"), "0");
        Log.getLogWriter().info("dataRateInitialVerification-Show Metrics-Region");
        String memberName = this.getResultValue(this.runDataCommand("describe region --name=" + regionName), "Hosting Members", ":");
        command = "show metrics --categories=region --member=" + memberName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "totalRegionCount"), "1");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "totalRegionEntryCount"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "createsRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "destroyRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "totalMissCount"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "totalHitCount"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "getsRate"), "0");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "putsRate"), "0");
        Log.getLogWriter().info("dataRateInitialVerification-Show Metrics-Member");
        ArrayList errorList = (ArrayList)CommandBB.getBB().getSharedMap().get(dataErrorKey);
        if (errorList != null && errorList.size() > 0) {
            haveErrors = true;
        }
        Log.getLogWriter().info("dataRateInitialVerification-End-haveErrors=" + haveErrors);
        return haveErrors;
    }

    private void dataRateCheck(boolean checkingForZeroRate) {
        Log.getLogWriter().info("dataRateCheck-Start");
        String regionName = "dataRateVerificationRegion";
        String cmdShowMetricsRegion = "show metrics --categories=cluster,region --region=/" + regionName;
        String memberName = this.getResultValue(this.runDataCommand("describe region --name=" + regionName), "Hosting Members", ":");
        String cmdShowMetricsMember = "show metrics --categories=region --member=" + memberName;
        boolean done = false;
        do {
            ArrayList<String> cmdResultLines = this.runDataCommand(cmdShowMetricsRegion);
            float createsRateRegion = Float.parseFloat(this.getResultValue(cmdResultLines, "createsRate"));
            float putsRateRegion = Float.parseFloat(this.getResultValue(cmdResultLines, "putsRate"));
            float getsRateRegion = Float.parseFloat(this.getResultValue(cmdResultLines, "getsRate"));
            float destroysRateRegion = Float.parseFloat(this.getResultValue(cmdResultLines, "destroyRate"));
            Log.getLogWriter().info("dataRateCheck-Show Metrics-Region");
            cmdResultLines = this.runDataCommand(cmdShowMetricsMember);
            float createsRateMember = Float.parseFloat(this.getResultValue(cmdResultLines, "createsRate"));
            float putsRateMember = Float.parseFloat(this.getResultValue(cmdResultLines, "putsRate"));
            float getsRateMember = Float.parseFloat(this.getResultValue(cmdResultLines, "getsRate"));
            float destroysRateMember = Float.parseFloat(this.getResultValue(cmdResultLines, "destroyRate"));
            Log.getLogWriter().info("dataRateCheck-Show Metrics-Member");
            if (checkingForZeroRate) {
                done = createsRateRegion == 0.0f && createsRateMember == 0.0f && putsRateRegion == 0.0f && putsRateMember == 0.0f && getsRateRegion == 0.0f && getsRateMember == 0.0f;
                continue;
            }
            boolean bl = done = createsRateRegion > 0.0f && createsRateMember > 0.0f && putsRateRegion > 0.0f && putsRateMember > 0.0f && getsRateRegion > 0.0f && getsRateMember > 0.0f;
        } while (!done);
        Log.getLogWriter().info("dataRateCheck-End");
    }

    private void dataRateOperations() {
        Log.getLogWriter().info("dataRateOperations-Start");
        String keyPrefix = "Object_";
        int nbrToPut = 10;
        int nbrToHit = 5;
        RandomValues someRandomValues = new RandomValues();
        boolean keyFound = false;
        HashSet regionSet = new HashSet(CacheHelper.getCache().rootRegions());
        while (CommandBB.getBB().getSharedCounters().read(CommandBB.dataRateDoOps) > 0L) {
            HashMap<String, ValueHolder> putAllMap = new HashMap<String, ValueHolder>();
            Object key = NameFactory.getNextPositiveObjectName();
            long keyAsALong = NameFactory.getCounterForName(key);
            long maxKey = keyAsALong + (long)nbrToPut;
            while (keyAsALong < maxKey) {
                putAllMap.put((String)key, new ValueHolder((String)key, someRandomValues));
                CommandBB.getBB().getSharedCounters().increment(CommandBB.dataRatePutCntr);
                key = NameFactory.getNextPositiveObjectName();
                keyAsALong = NameFactory.getCounterForName(key);
            }
            for (Region aRegion : regionSet) {
                aRegion.putAll(putAllMap);
                Log.getLogWriter().info("dataRateOperations-key=" + key);
                aRegion.put(key, (Object)new ValueHolder((String)key, someRandomValues));
                int theBigestKey = new Long(NameFactory.getPositiveNameCounter()).intValue() - 1;
                Log.getLogWriter().info("dataRateOperations-theBigestKey=" + theBigestKey);
                for (int i = 0; i < nbrToHit; ++i) {
                    key = TestConfig.tab().getRandGen().nextInt(1, theBigestKey);
                    aRegion.get((Object)(keyPrefix + key));
                }
                key = TestConfig.tab().getRandGen().nextInt(theBigestKey, theBigestKey + 50);
                aRegion.get((Object)(keyPrefix + key));
            }
        }
        long dataRatePutCntr = CommandBB.getBB().getSharedCounters().read(CommandBB.dataRatePutCntr);
        Log.getLogWriter().info("dataRateOperations-dataRatePutCntr=" + dataRatePutCntr);
        Log.getLogWriter().info("dataRateOperations-End");
    }

    private void encryptTest() {
        Log.getLogWriter().info("encryptTest-Start");
        String expectedOutput = "Parameter \"password\" is required. Use \"help <command name>\" for assistance.";
        this.checkCommand(CMD_ENCRYPT_PASSWORD, expectedOutput);
        String invalid = " --invalid=";
        expectedOutput = "Parameter \"password\" is required. Use \"help <command name>\" for assistance.\nParameter invalid is not applicable for " + CMD_ENCRYPT_PASSWORD.trim();
        this.checkCommand(CMD_ENCRYPT_PASSWORD + invalid, expectedOutput);
        String pword = "mypassword";
        String outStr = this.execCommand("encrypt password --password=" + pword);
        String tword = PasswordUtil.decrypt((String)("encrypted(" + outStr.trim() + ")"));
        this.checkCommand(CMD_ENCRYPT_PASSWORD + invalid, expectedOutput);
        if (!tword.equals(pword)) {
            throw new TestException("Results of \"encrypt password\" could not be decrypted.\n\"encrypt password\" returned: " + outStr);
        }
        this.execCommandLine("encrypt password \\");
        outStr = this.execCommand(" --password=" + pword);
        tword = PasswordUtil.decrypt((String)("encrypted(" + outStr.trim() + ")"));
        if (!tword.equals(pword)) {
            throw new TestException("Results of \"encrypt password\" continuation test could not be decrypted.\n\"encrypt password\" returned: " + outStr);
        }
        Log.getLogWriter().info("encryptTest-End");
    }

    private void cmdPutTest() {
        Log.getLogWriter().info("cmdPutTest-Start");
        this.runDataCommand("create region --type=REPLICATE --name=myTestRegion");
        this.execSleepCommad("5");
        CmdOptionInfo keyOption = new CmdOptionInfo(PARM_KEY, "", "myKey1", true, false);
        CmdOptionInfo valueOption = new CmdOptionInfo(PARM_VALUE, "", "myValue1", true, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "", "myTestRegion", true, false);
        CmdOptionInfo skipIfExistsOption = new CmdOptionInfo("skip-if-exists", "", "", false, true);
        CmdOptionInfo[] options = new CmdOptionInfo[]{keyOption, valueOption, regionOption, skipIfExistsOption};
        this.checkNamedParams(CMD_PUT, options);
        this.checkMultiLineExecution(CMD_PUT, options);
        this.checkRegionOption(CMD_PUT, new CmdOptionInfo[]{keyOption, valueOption}, regionOption, false);
        this.checkRegionOption(CMD_PUT, new CmdOptionInfo[]{keyOption, valueOption}, regionOption, true);
        Log.getLogWriter().info("cmdPutTest-End");
    }

    private void cmdGetTest() {
        Log.getLogWriter().info("cmdGetTest-Start");
        CmdOptionInfo keyOption = new CmdOptionInfo(PARM_KEY, "", "myKey1", true, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "", "myTestRegion", true, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{keyOption, regionOption};
        this.checkNamedParams(CMD_GET, options);
        this.checkMultiLineExecution(CMD_GET, options);
        this.checkRegionOption(CMD_GET, new CmdOptionInfo[]{keyOption}, regionOption, false);
        this.checkRegionOption(CMD_GET, new CmdOptionInfo[]{keyOption}, regionOption, true);
        Log.getLogWriter().info("cmdGetTest-End");
    }

    private void cmdLocateTest() {
        Log.getLogWriter().info("cmdLocateTest-Start");
        CmdOptionInfo keyOption = new CmdOptionInfo(PARM_KEY, "", "myKey1", true, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "", "myTestRegion", true, false);
        CmdOptionInfo recursiveOption = new CmdOptionInfo("recursive", "Value \"%1\" is not applicable for \"recursive\".", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{keyOption, regionOption, recursiveOption};
        this.checkNamedParams(CMD_LOCATE_ENTRY, options);
        this.checkMultiLineExecution(CMD_LOCATE_ENTRY, options);
        this.checkRegionOption(CMD_LOCATE_ENTRY, new CmdOptionInfo[]{keyOption}, regionOption, false);
        this.checkRegionOption(CMD_LOCATE_ENTRY, new CmdOptionInfo[]{keyOption}, regionOption, true);
        Log.getLogWriter().info("cmdLocateTest-End");
    }

    private void cmdRemoveTest() {
        Log.getLogWriter().info("cmdRemoveTest-Start");
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "", "myTestRegion", true, false);
        CmdOptionInfo allOption = new CmdOptionInfo("all", "", "", false, true);
        CmdOptionInfo keyOption = new CmdOptionInfo(PARM_KEY, "Result    : false", "myKey1", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{regionOption, allOption, keyOption};
        this.checkNamedParams(CMD_REMOVE, options);
        this.checkMultiLineExecution(CMD_REMOVE, options);
        this.checkRegionOption(CMD_REMOVE, regionOption, false);
        this.checkRegionOption(CMD_REMOVE, regionOption, true);
        Log.getLogWriter().info("cmdRemoveTest-End");
    }

    private void rebalanceController() {
        int msToSleep = 20000;
        GsRandom gsRand = TestConfig.tab().getRandGen();
        Log.getLogWriter().info("Sleeping for 20000ms to allow ops to run");
        MasterController.sleepForMs(20000);
        List candidateVMs = StopStartVMs.getAllVMs();
        for (int i = 0; i < candidateVMs.size(); ++i) {
            ClientVmInfo info = (ClientVmInfo)candidateVMs.get(i);
            if (info.getVmid() != this.shellManagerMemberVmId) continue;
            candidateVMs.remove(i);
        }
        int numToStop = CommandPrms.getNumToStop();
        ArrayList targetVMs = new ArrayList();
        targetVMs.addAll(candidateVMs);
        while (targetVMs.size() > numToStop) {
            targetVMs.remove(gsRand.nextInt(0, targetVMs.size() - 1));
        }
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 1; i <= targetVMs.size(); ++i) {
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        StopStartVMs.stopVMs(targetVMs, stopModeList);
        String rebResult = this.execCommand("rebalance");
        this.checkRebalanceResult(rebResult);
        Log.getLogWriter().info("Sleeping for 20000ms after stopping " + targetVMs);
        MasterController.sleepForMs(20000);
        StopStartVMs.startVMs(targetVMs);
        rebResult = this.execCommand("rebalance");
        this.checkRebalanceResult(rebResult);
    }

    private void checkRebalanceResult(String rebResult) {
        StringBuffer errStr = new StringBuffer();
        ArrayList<String> expectedRegNames = new ArrayList<String>();
        Map attrMap = (Map)CommandBB.getBB().getSharedMap().get(regionAttrKey);
        for (String regName : attrMap.keySet()) {
            RegionAttributes attr = (RegionAttributes)attrMap.get(regName);
            if (!attr.getDataPolicy().withPartitioning()) continue;
            expectedRegNames.add(regName);
        }
        ArrayList<String> actualRegNames = new ArrayList<String>();
        String[] lineArr = rebResult.split("\n");
        for (int i = 0; i < lineArr.length; ++i) {
            String line = lineArr[i];
            if (!line.contains("Rebalanced partition regions")) continue;
            int numWordsBeforeNamedRegions = 3;
            String[] wordArr = line.split("[\\s]+");
            for (int j = 3; j < wordArr.length; ++j) {
                actualRegNames.add(wordArr[j]);
            }
            if (wordArr.length > 3) continue;
            errStr.append("Bug 45567 detected; rebalance results contains rebalance stats without naming any regions in line " + (i + 1) + " of output, line is |" + line + "| (see logs for full rebalance output\n");
        }
        HashSet<String> actualRegNamesSet = new HashSet<String>();
        actualRegNamesSet.addAll(actualRegNames);
        HashSet<String> missingRegNames = new HashSet<String>();
        missingRegNames.addAll(expectedRegNames);
        missingRegNames.removeAll(actualRegNamesSet);
        HashSet<String> extraRegNames = new HashSet<String>();
        extraRegNames.addAll(actualRegNames);
        extraRegNames.removeAll(expectedRegNames);
        if (missingRegNames.size() != 0) {
            errStr.append("The following partitioned regions were not present in rebalance results: " + missingRegNames + " \n");
        }
        if (extraRegNames.size() != 0) {
            errStr.append("The following partitioned regions were unexpected in rebalance results: " + extraRegNames + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    private void doRegionCommands() {
        this.execCommand(CMD_LIST_MEMBERS);
        this.execCommand(CMD_LIST_REGIONS);
        this.execCommand(CMD_LIST_DISKSTORES);
        this.execCommand("list deployed");
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand(CMD_LIST_INDEXES);
        this.execCommand(CMD_VERSION);
        Set allRegions = (Set)CommandBB.getBB().getSharedMap().get(regionNamesKey);
        if (allRegions != null) {
            Iterator iterator = allRegions.iterator();
            while (iterator.hasNext()) {
                String regionName;
                String regionNameWithSlash = regionName = (String)iterator.next();
                String regionNameWithoutSlash = regionName;
                if (regionName.startsWith("/")) {
                    regionNameWithoutSlash = regionName.substring(1);
                } else {
                    regionNameWithSlash = "/" + regionName;
                }
                String commandWithSlash = "describe region --name=" + regionNameWithSlash;
                String commandWithoutSlash = "describe region --name=" + regionNameWithoutSlash;
                String presentationStrWithSlash = this.execCommand(commandWithSlash);
                String string = this.execCommand(commandWithoutSlash);
            }
        }
    }

    private void logStrDifferences(String str1, String str2) {
        int str2Length;
        StringBuffer aStr = new StringBuffer();
        int str1Length = str1.length();
        if (str1Length == (str2Length = str2.length())) {
            aStr.append("Str1 and str2 are both of length " + str1Length);
        } else {
            aStr.append("Str1 length is " + str1Length + " and str2 length is " + str2Length + "\n");
        }
        for (int i = 0; i < Math.min(str1Length, str2Length); ++i) {
            char ch2;
            char ch1 = str1.charAt(i);
            if (ch1 == (ch2 = str2.charAt(i))) continue;
            aStr.append("Str1 and str2 differ at index " + i + "\n");
            aStr.append("str1: " + str1 + "\n");
            aStr.append("str2: " + str2 + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    protected static long logExecutionNumber() {
        long exeNum = CommandBB.getBB().getSharedCounters().incrementAndRead(CommandBB.executionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        return exeNum;
    }

    private void serialDeployTest() {
        CommandTest.logExecutionNumber();
        int numTimesToDeploy = 3;
        Log.getLogWriter().info("Deploying the same jar " + numTimesToDeploy + " times");
        String jtests = System.getProperty("JTESTS");
        String jarPath = jtests + File.separator + ".." + File.separator + "extraJars" + File.separator + "jar1.jar";
        String expectedDeployedFileName = "vf.gf#jar1.jar#1";
        File deployedFile = new File(expectedDeployedFileName);
        Log.getLogWriter().info("jar path is " + jarPath);
        for (int i = 1; i <= numTimesToDeploy; ++i) {
            String groupName;
            String command = "deploy --jar=" + jarPath;
            if (TestConfig.tab().getRandGen().nextBoolean() && (groupName = this.getAvailableGroupName()) != null) {
                command = command + " --group=" + groupName;
            }
            this.execCommand(command);
            if (deployedFile.exists()) continue;
            throw new TestException("After deploy " + deployedFile.getAbsolutePath() + " does not exist");
        }
        String result = this.execCommand("execute function --id=noSuchFunction");
        if (result.contains("locator")) {
            throw new TestException("Bug 46113 detected: Result of execute function shows execution attempt on a locator: " + result);
        }
        this.execCommand(CMD_LIST_FUNCTIONS);
        result = this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
        if (result.contains("locator")) {
            throw new TestException("Bug 45697 detected: Result of execute function shows execution attempt on a locator: " + result);
        }
        if (result.contains("Could not execute")) {
            throw new TestException("Bug 45697 detected: " + result);
        }
        List targetList = StopStartVMs.getAllVMs();
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 1; i <= targetList.size(); ++i) {
            stopModeList.add("mean_kill");
        }
        StopStartVMs.stopStartVMs(targetList, stopModeList);
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
        String command = "undeploy --jar=xyz.jar";
        this.execCommand(command);
        command = "undeploy --jar=jar1.jar";
        this.execCommand(command);
        if (HostHelper.isWindows()) {
            long length = deployedFile.length();
            if (length != 0L) {
                throw new TestException("After undeploying, expect " + deployedFile.getAbsolutePath() + " to be length 0, but it is " + length);
            }
        } else if (deployedFile.exists()) {
            MasterController.sleepForMs(10000);
            if (deployedFile.exists()) {
                throw new TestException("After undeploy " + deployedFile.getAbsolutePath() + " still exists");
            }
        }
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
        StopStartVMs.stopStartVMs(targetList, stopModeList);
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
    }

    private void disconnectMyself() {
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("Closing the cache...");
            CacheHelper.getCache().close();
            Log.getLogWriter().info("Done closing the cache");
        } else {
            Log.getLogWriter().info("Disconnecting...");
            DistributedSystemHelper.disconnect();
            Log.getLogWriter().info("Done disconnecting");
        }
        testInstance = null;
        this.shell.stop();
        this.shell = null;
        connectorService = null;
    }

    private void deployTest() {
        CommandTest.logExecutionNumber();
        int numTimesToDeploy = 3;
        Log.getLogWriter().info("Deploying the same jar " + numTimesToDeploy + " times");
        String jtests = System.getProperty("JTESTS");
        String jarPath = jtests + File.separator + ".." + File.separator + "extraJars" + File.separator + "jar1.jar";
        String expectedDeployedFileName = "vf.gf#jar1.jar#1";
        File deployedFile = new File(expectedDeployedFileName);
        Log.getLogWriter().info("jar path is " + jarPath);
        for (int i = 1; i <= numTimesToDeploy; ++i) {
            String command = "deploy --jar=" + jarPath;
            this.execCommand(command);
            if (deployedFile.exists()) continue;
            MasterController.sleepForMs(10000);
            if (deployedFile.exists()) continue;
            throw new TestException("After deploy " + deployedFile.getAbsolutePath() + " does not exist");
        }
        String result = this.execCommand("execute function --id=noSuchFunction");
        if (result.contains("locator")) {
            throw new TestException("Bug 46113 detected: Result of execute function shows execution attempt on a locator: " + result);
        }
        this.execCommand(CMD_LIST_FUNCTIONS);
        result = this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
        if (result.contains("locator")) {
            throw new TestException("Bug 45697 detected: Result of execute function shows execution attempt on a locator: " + result);
        }
        if (result.contains("Could not execute")) {
            throw new TestException("Bug 45697 detected: " + result);
        }
        List targetList = StopStartVMs.getAllVMs();
        ArrayList<String> stopModeList = new ArrayList<String>();
        for (int i = 1; i <= targetList.size(); ++i) {
            stopModeList.add("mean_kill");
        }
        StopStartVMs.stopStartVMs(targetList, stopModeList);
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
        String command = "undeploy --jar=xyz.jar";
        this.execCommand(command);
        command = "undeploy --jar=jar1.jar";
        this.execCommand(command);
        if (HostHelper.isWindows()) {
            long length = deployedFile.length();
            if (length != 0L) {
                throw new TestException("After undeploying, expect " + deployedFile.getAbsolutePath() + " to be length 0, but it is " + length);
            }
        } else if (deployedFile.exists()) {
            MasterController.sleepForMs(10000);
            if (deployedFile.exists()) {
                throw new TestException("After undeploy " + deployedFile.getAbsolutePath() + " still exists");
            }
        }
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
        StopStartVMs.stopStartVMs(targetList, stopModeList);
        this.execCommand(CMD_LIST_FUNCTIONS);
        this.execCommand("execute function --id=cli.DeployFcn1 --arguments=1,2");
    }

    private int getNumMembersWithCache() {
        int count = 0;
        Map aMap = CommandBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            String memberStr;
            if (!(key instanceof String) || !((String)key).startsWith(memberWithCacheMemberIdKeyPrefix) || (memberStr = aMap.get(key).toString()).contains("locator")) continue;
            ++count;
        }
        return count;
    }

    private void concDeployTest() {
        CommandTest.logExecutionNumber();
        int numTimesToExecute = 10;
        String jtests = System.getProperty("JTESTS");
        String command = null;
        GsRandom rand = TestConfig.tab().getRandGen();
        String[] availableJars = new String[]{"jar1.jar", "jar2.jar", "jar3.jar"};
        for (int i = 1; i <= numTimesToExecute; ++i) {
            String groupName;
            int randInt = rand.nextInt(0, availableJars.length - 1);
            String jarName = availableJars[randInt];
            String jarPath = jtests + File.separator + ".." + File.separator + "extraJars" + File.separator + jarName;
            command = "deploy --jar=" + jarPath;
            if (TestConfig.tab().getRandGen().nextBoolean() && (groupName = this.getAvailableGroupName()) != null) {
                command = command + " --group=" + groupName;
            }
            Log.getLogWriter().info("Deploying " + jarPath);
            this.execCommand(command);
            Log.getLogWriter().info("Done with command " + command);
            command = "list deployed";
            Log.getLogWriter().info("Listing deployed jars");
            this.execCommand(command);
            Log.getLogWriter().info("Done with command " + command);
            randInt = rand.nextInt(0, availableJars.length - 1);
            jarName = availableJars[randInt];
            command = "undeploy --jar=" + jarName;
            Log.getLogWriter().info("Undeploying " + jarName);
            this.execCommand(command);
            Log.getLogWriter().info("Done with command " + command);
        }
    }

    protected void executeFunction(String fcnName, boolean invokeWithId) {
        ArrayList<Object> functionArgs = new ArrayList<Object>();
        functionArgs.add(RemoteTestModule.getCurrentThread().getThreadId());
        functionArgs.add("abc");
        Execution exe = FunctionService.onMembers((DistributedSystem)CacheHelper.getCache().getDistributedSystem()).withArgs(functionArgs);
        Log.getLogWriter().info("Invoking " + fcnName + " on all members  with args " + functionArgs);
        ResultCollector fcnResult = null;
        if (invokeWithId) {
            fcnResult = exe.execute("cli.DeployFcn1");
        } else {
            Function fcn = (Function)this.instantiateObject(1, fcnName);
            fcnResult = exe.execute(fcn);
        }
        Object result = fcnResult.getResult();
        Log.getLogWriter().info("Result of function is " + result);
    }

    /*
     * Exception decompiling
     */
    protected Object instantiateObject(int versionNumber, String className) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void verifyClassAvailability(int vmId, String[] availableClasses, String[] unavailableClasses) {
        ArrayList<Object> functionArgs = new ArrayList<Object>();
        functionArgs.add(RemoteTestModule.getCurrentThread().getThreadId());
        functionArgs.add("verifyClassAvailability");
        functionArgs.add(Arrays.asList(availableClasses));
        functionArgs.add(Arrays.asList(unavailableClasses));
        Execution exe = null;
        if (vmId == -1) {
            exe = FunctionService.onMembers((DistributedSystem)CacheHelper.getCache().getDistributedSystem()).withArgs(functionArgs);
            Log.getLogWriter().info("Invoking " + DeployTestFunction.class.getName() + " on all members  with args " + functionArgs);
        } else {
            DistributedMember member = (DistributedMember)CommandBB.getBB().getSharedMap().get(memberKeyPrefix + vmId);
            exe = FunctionService.onMember((DistributedSystem)CacheHelper.getCache().getDistributedSystem(), (DistributedMember)member).withArgs(functionArgs);
            Log.getLogWriter().info("Invoking " + DeployTestFunction.class.getName() + " on " + member + " with args " + functionArgs);
        }
        ResultCollector fcnResult = exe.execute((Function)new DeployTestFunction());
        Object result = fcnResult.getResult();
        Log.getLogWriter().info("Result of function is " + result);
    }

    private String runExecCmds(String command) throws TestException {
        String rtnString = null;
        try {
            rtnString = this.execCommand(command);
            Log.getLogWriter().info("All was good when executing the command '" + command + "'!");
        }
        catch (TestException e) {
            Log.getLogWriter().error("An Exception was thrown while executing the following command '" + command + "'.", (Throwable)e);
            throw new TestException("All runExecCmds should run clean.");
        }
        return rtnString;
    }

    private void verifyHelpForCommands() throws TestException {
        Log.getLogWriter().info("verifyHelpForCommands-Start");
        this.checkHelpCommand(CMD_ALTER_DISKSTORE, CommandHelpText.alterDiskStoreCmdHelpText);
        this.checkHelpCommand(CMD_ALTER_REGION, "NAME\n    alter region\nIS AVAILABLE\n    true\nSYNOPSIS\n    Alter a region with the given path and configuration.\nSYNTAX\n    alter region --name=value [--group=value(,value)*] [--entry-idle-time-expiration(=value)?]\n    [--entry-idle-time-expiration-action=value] [--entry-time-to-live-expiration(=value)?]\n    [--entry-time-to-live-expiration-action=value] [--region-idle-time-expiration(=value)?]\n    [--region-idle-time-expiration-action=value] [--region-time-to-live-expiration(=value)?]\n    [--region-time-to-live-expiration-action=value] [--cache-listener=value(,value)*]\n    [--cache-loader=value] [--cache-writer=value] [--async-event-queue-id=value(,value)*]\n    [--gateway-sender-id=value(,value)*] [--enable-cloning(=value)?] [--eviction-max(=value)?]\nPARAMETERS\n    name\n        Name/Path of the region to be altered.\n        Required: true\n    group\n        Group(s) of members on which the region will be altered.\n        Required: false\n    entry-idle-time-expiration\n        How long the region\u2019s entries can remain in the cache without being accessed. The default\n        is no expiration of this type.\n        Required: false\n        Default (if the parameter is specified without value): -1\n    entry-idle-time-expiration-action\n        Action to be taken on an entry that has exceeded the idle expiration.\n        Required: false\n    entry-time-to-live-expiration\n        How long the region\u2019s entries can remain in the cache without being accessed or updated.\n        The default is no expiration of this type.\n        Required: false\n        Default (if the parameter is specified without value): -1\n    entry-time-to-live-expiration-action\n        Action to be taken on an entry that has exceeded the TTL expiration.\n        Required: false\n    region-idle-time-expiration\n        How long the region can remain in the cache without being accessed. The default is no\n        expiration of this type.\n        Required: false\n        Default (if the parameter is specified without value): -1\n    region-idle-time-expiration-action\n        Action to be taken on a region that has exceeded the idle expiration.\n        Required: false\n    region-time-to-live-expiration\n        How long the region can remain in the cache without being accessed or updated. The default\n        is no expiration of this type.\n        Required: false\n        Default (if the parameter is specified without value): -1\n    region-time-to-live-expiration-action\n        Action to be taken on a region that has exceeded the TTL expiration.\n        Required: false\n    cache-listener\n        Fully qualified class name of a plug-in to be instantiated for receiving after-event\n        notification of changes to the region and its entries. Any number of cache listeners can be\n        configured.\n        Required: false\n    cache-loader\n        Fully qualified class name of a plug-in to be instantiated for receiving notification of\n        cache misses in the region. At most, one cache loader can be defined in each member for the\n        region. For distributed regions, a cache loader may be invoked remotely from other members\n        that have the region defined.\n        Required: false\n    cache-writer\n        Fully qualified class name of a plug-in to be instantiated for receiving before-event\n        notification of changes to the region and its entries. The plug-in may cancel the event. At\n        most, one cache writer can be defined in each member for the region.\n        Required: false\n    async-event-queue-id\n        IDs of the Async Event Queues that will be used for write-behind operations.\n        Required: false\n    gateway-sender-id\n        IDs of the Gateway Senders to which data will be routed.\n        Required: false\n    enable-cloning\n        Determines how fromDelta applies deltas to the local cache for delta propagation. When\n        true, the updates are applied to a clone of the value and then the clone is saved to the\n        cache. When false, the value is modified in place in the cache.\n        Required: false\n        Default (if the parameter is specified without value): false\n    eviction-max\n        Maximum value for the Eviction Attributes which the Eviction Algorithm uses to determine\n        when to perform its Eviction Action. The unit of the maximum value is determined by the\n        Eviction Algorithm.\n        Required: false\n        Default (if the parameter is specified without value): 0");
        this.checkHelpCommand(CMD_ALTER_RUNTIME, CommandHelpText.alterRuntimeCmdHelpText);
        this.checkHelpCommand(CMD_CREATE_ASYNC_EVENT_QUEUE, "NAME\n    create async-event-queue\nIS AVAILABLE\n    true\nSYNOPSIS\n    Create Async Event Queue.\nSYNTAX\n    create async-event-queue --id=value --listener=value [--group=value] [--batch-size=value]\n    [--persistent(=value)?] [--disk-store=value] [--max-queue-memory=value]\n    [--listener-param=value(,value)*]\nPARAMETERS\n    id\n        ID of the queue to be created.\n        Required: true\n    group\n        Group(s) of members on which queue will be created. If no group is specified the queue will\n        be created on all members.\n        Required: false\n    batch-size\n        Maximum number of messages that a batch can contain.\n        Required: false\n        Default (if the parameter is not specified): 100\n    persistent\n        Whether events should be persisted to a disk store.\n        Required: false\n        Default (if the parameter is specified without value): true\n        Default (if the parameter is not specified): false\n    disk-store\n        Disk store to be used by this queue.\n        Required: false\n    max-queue-memory\n        Maximum amount of memory, in megabytes, that the queue can consume before overflowing to\n        disk.\n        Required: false\n        Default (if the parameter is not specified): 100\n    listener\n        Fully qualified class name of the AsyncEventListener for this queue.\n        Required: true\n    listener-param\n        Parameter name for the AsyncEventListener.  Optionally, parameter names may be followed by\n        # and a value for the parameter.  Example: --listener-param=loadAll\n        --listener-param=maxRead#1024\n        Required: false");
        this.checkHelpCommand(CMD_CREATE_DISK_STORE, "NAME\n    create disk-store\nIS AVAILABLE\n    true\nSYNOPSIS\n    Create a disk store.\nSYNTAX\n    create disk-store --name=value --dir=value(,value)* [--allow-force-compaction(=value)?]\n    [--auto-compact(=value)?] [--compaction-threshold=value] [--max-oplog-size=value]\n    [--queue-size=value] [--time-interval=value] [--write-buffer-size=value]\n    [--group=value(,value)*]\nPARAMETERS\n    name\n        Name of the disk store to be created.\n        Required: true\n    allow-force-compaction\n        Whether to allow manual compaction through the API or command-line tools.\n        Required: false\n        Default (if the parameter is specified without value): true\n        Default (if the parameter is not specified): false\n    auto-compact\n        Whether to automatically compact a file when it reaches the compaction-threshold.\n        Required: false\n        Default (if the parameter is specified without value): true\n        Default (if the parameter is not specified): true\n    compaction-threshold\n        Percentage of garbage allowed in the file before it is eligible for compaction.\n        Required: false\n        Default (if the parameter is not specified): 50\n    max-oplog-size\n        The largest size, in megabytes, to allow an operation log to become before automatically\n        rolling to a new file.\n        Required: false\n        Default (if the parameter is not specified): 1024\n    queue-size\n        For asynchronous queueing. The maximum number of operations to allow into the write queue\n        before automatically flushing the queue. The default of 0 indicates no limit.\n        Required: false\n        Default (if the parameter is not specified): 0\n    time-interval\n        For asynchronous queueing. The number of milliseconds that can elapse before data is\n        flushed to disk. Reaching this limit or the queue-size limit causes the queue to flush.\n        Required: false\n        Default (if the parameter is not specified): 1000\n    write-buffer-size\n        Size of the buffer used to write to disk.\n        Required: false\n        Default (if the parameter is not specified): 32768\n    dir\n        Directories where the disk store files will be written.  Optionally, directory names may be\n        followed by # and the maximum number of megabytes that the disk store can use in the\n        directory.  Example: --dir=/data/ds1 --dir=/data/ds2#5000\n        Required: true\n    group\n        Group(s) of members on which the disk store will be created. If no group is specified the\n        disk store will be created on all members.\n        Required: false");
        this.checkHelpCommand(CMD_CREATE_INDEX, CommandHelpText.createIndexCmdHelpText);
        this.checkHelpCommand(CMD_CLOSE_DURABLE_CQ, "NAME\n    close durable-cq\nIS AVAILABLE\n    true\nSYNOPSIS\n    Closes the durable cq registered by the durable client and drain events held for the durable cq\n    from the subscription queue.\nSYNTAX\n    close durable-cq --durable-client-id=value --durable-cq-name=value [--member=value]\n    [--group=value]\nPARAMETERS\n    durable-client-id\n        The id of the durable client\n        Required: true\n    durable-cq-name\n        Name of the cq to be closed.\n        Required: true\n    member\n        Name/Id of the member for which the durable client is registered and the cq to be closed.\n        Required: false\n    group\n        Group of members for which the durable client is registered and the cq to be closed.\n        Required: false");
        this.checkHelpCommand(CMD_CLOSE_DURABLE_CLIENT, "NAME\n    close durable-client\nIS AVAILABLE\n    true\nSYNOPSIS\n    Attempts to close the durable client, the client must be disconnected.\nSYNTAX\n    close durable-client --durable-client-id=value [--member=value] [--group=value]\nPARAMETERS\n    durable-client-id\n        The id used to identify the durable client.\n        Required: true\n    member\n        Name/Id of the member for which the durable client is to be closed.\n        Required: false\n    group\n        Group of members for which the subscription queue events are to be counted.\n        Required: false");
        this.checkHelpCommand(CMD_DESCRIBE_CONFIG, CommandHelpText.describeConfigCmdHelpText);
        this.checkHelpCommand(CMD_DESCRIBE_CONNECTION, CommandHelpText.describeConnectionCmdHelpText);
        this.checkHelpCommand(CMD_DESCRIBE_DISKSTORE, CommandHelpText.describeDiskStoreCmdHelpText);
        this.checkHelpCommand(CMD_DESCRIBE_MEMBER, CommandHelpText.describeMemberCmdHelpText);
        this.checkHelpCommand(CMD_DESCRIBE_REGION, CommandHelpText.describeRegionCmdHelpText);
        this.checkHelpCommand(CMD_DESTROY_INDEX, CommandHelpText.destroyIndexCmdHelpText);
        this.checkHelpCommand(CMD_DESTROY_REGION, CommandHelpText.destroyRegionCmdHelpText);
        this.checkHelpCommand(CMD_ENCRYPT_PASSWORD, CommandHelpText.encryptPasswordCmdHelpText);
        this.checkHelpCommand(CMD_EXPORT_CONFIG, CommandHelpText.exportConfigCmdHelpText);
        this.checkHelpCommand(CMD_EXPORT_STACKTRACES, CommandHelpText.exportStacksTraceCmdHelpText);
        this.checkHelpCommand(CMD_LIST_ASYNC_EVENT_QUEUE, "NAME\n    list async-event-queues\nIS AVAILABLE\n    true\nSYNOPSIS\n    Display the Async Event Queues for all members.\nSYNTAX\n    list async-event-queues");
        this.checkHelpCommand(CMD_LIST_DISKSTORES, CommandHelpText.listDiskStoresCmdHelpText);
        this.checkHelpCommand(CMD_LIST_DURABLE_CQS, "NAME\n    list durable-cqs\nIS AVAILABLE\n    true\nSYNOPSIS\n    List durable client cqs associated with the specified durable client id.\nSYNTAX\n    list durable-cqs --durable-client-id=value [--member=value] [--group=value]\nPARAMETERS\n    durable-client-id\n        The id used to identify the durable client\n        Required: true\n    member\n        Name/Id of the member for which the durable client is registered and durable cqs will be\n        displayed.\n        Required: false\n    group\n        Group of members for which the durable client is registered and durable cqs will be\n        displayed.\n        Required: false");
        this.checkHelpCommand(CMD_LIST_FUNCTIONS, CommandHelpText.listFunctionsCmdHelpText);
        this.checkHelpCommand(CMD_LIST_INDEXES, CommandHelpText.listIndexesCmdHelpText);
        this.checkHelpCommand(CMD_LIST_MEMBERS, CommandHelpText.listMembersCmdHelpText);
        this.checkHelpCommand(CMD_LIST_REGIONS, CommandHelpText.listRegionsCmdHelpText);
        this.checkHelpCommand(CMD_SHOW_DEADLOCKS, CommandHelpText.showDeadLocksCmdHelpText);
        this.checkHelpCommand(CMD_SHOW_METRICS, CommandHelpText.showMetricsCmdHelpText);
        this.checkHelpCommand(CMD_STATUS_LOCATOR, CommandHelpText.statusLocatorCmdHelpText);
        this.checkHelpCommand(CMD_STATUS_SERVER, CommandHelpText.statusServerCmdHelpText);
        this.checkHelpCommand(CMD_VERSION, CommandHelpText.versionCmdHelpText);
        this.checkHelpCommand(CMD_SHOW_SUBSCRIPTION_QUEUE_SIZE, "NAME\n    show subscription-queue-size\nIS AVAILABLE\n    true\nSYNOPSIS\n    Shows the number of events in the subscription queue.  If a cq name is provided, counts the number of events\n    in the subscription queue for the specified cq.\nSYNTAX\n    show subscription-queue-size --durable-client-Id=value [--durable-cq-name=value] [--member=value]\n    [--group=value]\nPARAMETERS\n    durable-client-Id\n        The id used to identify the durable client.\n        Required: true\n    durable-cq-name\n        The name that identifies the cq.\n        Required: false\n    member\n        Name/Id of the member for which the subscription events are to be counted.\n        Required: false\n    group\n        Group of members for which the subscription queue events are to be counted.\n        Required: false");
        this.checkHelpCommand(CMD_GET, CommandHelpText.getCmdHelpText);
        this.checkHelpCommand(CMD_LOCATE_ENTRY, CommandHelpText.locateEntryCmdHelpText);
        this.checkHelpCommand(CMD_PUT, CommandHelpText.putCmdHelpText);
        this.checkHelpCommand(CMD_REMOVE, CommandHelpText.removeCmdHelpText);
        Log.getLogWriter().info("verifyHelpForCommands-End");
    }

    private void checkHelpCommand(String command, String expectedOutput) {
        String outputText = this.execHelpCommad(command = command == null ? "help" : "help " + command);
        if (outputText != null) {
            expectedOutput = this.splitAndTrim(expectedOutput);
        }
        if (!outputText.equals(expectedOutput)) {
            CommandTest.saveError(helpErrorKey, this.formatExceptionText(command, outputText, expectedOutput));
        }
    }

    private void verifyHelpCommand() throws TestException {
        Log.getLogWriter().info("verifyHelpCommand-Start");
        List<String> expectedCommands = Arrays.asList(CommandHelpText.expectedCommandsArr);
        List commandList = (List)this.getHelpInfo()[0];
        ArrayList sortedCommandList = new ArrayList();
        sortedCommandList.addAll(commandList);
        Collections.sort(sortedCommandList);
        if (!commandList.equals(sortedCommandList)) {
            Log.getLogWriter().info("verifyHelpCommand-Commands returned from help:\n" + commandList);
            Log.getLogWriter().info("verifyHelpCommand-Sorted commands:\n" + sortedCommandList);
            for (int i = 0; i < commandList.size(); ++i) {
                String sortedCommand;
                String command = (String)commandList.get(i);
                if (command.equals(sortedCommand = (String)sortedCommandList.get(i))) continue;
                throw new TestException("The help commands should be sorted; the command returned from help at index " + i + " is " + command + ", but sorted commands at index " + i + " is " + sortedCommand);
            }
            throw new TestException("Expected commands returned from help to be sorted; see logs for details");
        }
        Log.getLogWriter().info("verifyHelpCommand-Commands are in sorted order");
        boolean error = false;
        String errorString = null;
        ArrayList<String> missingCommands = new ArrayList<String>();
        missingCommands.addAll(expectedCommands);
        missingCommands.removeAll(commandList);
        if (missingCommands.size() > 0) {
            error = true;
            errorString = "The following commands were missing from help:\n" + missingCommands;
        }
        ArrayList extraCommands = new ArrayList();
        extraCommands.addAll(commandList);
        extraCommands.removeAll(expectedCommands);
        if (extraCommands.size() > 0) {
            error = true;
            errorString = errorString == null ? "The following unexpected commands were found in help:\n" + extraCommands : errorString + "\nThe following unexpected commands were found in help:\n" + extraCommands;
        }
        if (error) {
            throw new TestException(errorString);
        }
        Log.getLogWriter().info("verifyHelpCommand-No missing or extra commands detected");
        Log.getLogWriter().info("verifyHelpCommand-End");
    }

    private void verifyHelpAvailability(boolean connected) {
        Log.getLogWriter().info("verifyHelpAvailability-Start");
        Map availabilityMap = (Map)this.getHelpInfo()[1];
        Log.getLogWriter().info("verifyHelpAvailability-Help returned " + availabilityMap);
        Map<String, Boolean> expectedAvailMap = connected ? CommandHelpText.BuildExpectedConnectedHelpAvailabilities() : CommandHelpText.BuildExpectedDisconnectedHelpAvailabilities();
        StringBuffer errStr = new StringBuffer();
        for (String commandName : CommandHelpText.expectedCommandsArr) {
            boolean expectedAvail;
            boolean actualAvail;
            Object avail = availabilityMap.get(commandName);
            if (avail == null) {
                errStr.append(commandName + " was missing from help with connected: " + connected + "\n");
            }
            if ((actualAvail = ((Boolean)avail).booleanValue()) == (expectedAvail = expectedAvailMap.get(commandName).booleanValue())) continue;
            errStr.append("Incorrect command availability found for command " + commandName + " , expected " + (expectedAvail ? "Available" : "Not Available") + ", but found " + (actualAvail ? "Available" : "Not Available") + " when connected: " + connected + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("verifyHelpAvailability-Command Availability is correct.  Connected=" + connected);
        Log.getLogWriter().info("verifyHelpAvailability-End");
    }

    private void verifyHelpDescription() {
        Log.getLogWriter().info("verifyHelpDescription-Start");
        Map<String, String> expectedDescriptions = CommandHelpText.BuildExpectedHelpDescriptions();
        Map descriptionMap = (Map)this.getHelpInfo()[2];
        StringBuffer errStr = new StringBuffer();
        for (String commandName : CommandHelpText.expectedCommandsArr) {
            Log.getLogWriter().info("Verifying description for command: " + commandName);
            Object desc = descriptionMap.get(commandName);
            if (desc == null) {
                errStr.append(commandName + " was missing from help\n");
                continue;
            }
            Object actualDesc = desc;
            String expectedDesc = expectedDescriptions.get(commandName);
            if (expectedDesc == null) {
                errStr.append("Do not have expected description for " + commandName + "\n");
                continue;
            }
            if (actualDesc.equals(expectedDesc)) continue;
            errStr.append("Incorrect command description found for command " + commandName + " |\nWas expecting:|" + expectedDesc + "|\n but received:|" + actualDesc + "|\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("verifyDescription-Descriptions are correct");
        Log.getLogWriter().info("verifyHelpDescription-End");
    }

    private Object[] getHelpInfo() {
        String helpText = testInstance.execCommand("help");
        String[] helpLines = helpText.split("\n");
        ArrayList<String> commandList = new ArrayList<String>();
        HashMap<String, Boolean> availabilityMap = new HashMap<String, Boolean>();
        HashMap<String, String> descriptionMap = new HashMap<String, String>();
        String currentCommand = null;
        int helpLinesIndex = 0;
        while (helpLinesIndex < helpLines.length) {
            String line = helpLines[helpLinesIndex];
            String thisLine = line.trim();
            if (thisLine.contains("vailable)")) {
                int index = thisLine.indexOf("(");
                if (index < 0) {
                    throw new TestException("Unexpected format of help line: " + line);
                }
                thisLine = thisLine.substring(0, index);
                if (commandList.contains(thisLine = thisLine.trim())) {
                    throw new TestException(thisLine + " occurs more than once in help output");
                }
                commandList.add(thisLine);
                availabilityMap.put(thisLine, !line.contains("Not Available"));
                currentCommand = thisLine;
                ++helpLinesIndex;
                continue;
            }
            if (currentCommand != null) {
                int currIndex = helpLinesIndex++;
                String description = "";
                while (currentCommand != null) {
                    if (currIndex < helpLines.length) {
                        String currLine = helpLines[currIndex].trim();
                        if (!currLine.contains("vailable)") && currLine.length() > 0) {
                            description = description + PARM_SPACE + currLine;
                            ++currIndex;
                            continue;
                        }
                        description = description.trim();
                        descriptionMap.put(currentCommand, description);
                        helpLinesIndex = currIndex;
                        currentCommand = null;
                        continue;
                    }
                    currentCommand = null;
                }
                continue;
            }
            ++helpLinesIndex;
        }
        Log.getLogWriter().info("descriptionMap is " + descriptionMap);
        return new Object[]{commandList, availabilityMap, descriptionMap};
    }

    private void cmdVersionTest() {
        Log.getLogWriter().info("cmdVersionTest-Start");
        String parm_full = "full";
        CmdOptionInfo fullOption = new CmdOptionInfo(parm_full, "", "", false, true);
        CmdOptionInfo[] options = new CmdOptionInfo[]{fullOption};
        this.checkNamedParams(CMD_VERSION, options);
        fullOption.setValidValue("true");
        this.checkMultiLineExecution(CMD_VERSION, options);
        this.checkCommand(CMD_VERSION, VERSION);
        this.checkCommand("version;", VERSION);
        parm_full = PARM_PREFIX + parm_full;
        this.checkCommand(CMD_VERSION + parm_full + "=false", VERSION);
        String[][] expectedText = new String[][]{{"Java version:", "Native version:", "Source revision:", "Source repository:", "Running on:"}, {null, null, null, null, null}};
        String fullVersionOutputText = this.checkOutputLines(CMD_VERSION + parm_full, expectedText);
        this.checkCommand(CMD_VERSION + parm_full + "=true", fullVersionOutputText);
        Log.getLogWriter().info("cmdVersionTest-End");
    }

    private void verifyDataTest() {
        Log.getLogWriter().info("verifyDataTest-Start");
        String listRegionsCmd = CMD_LIST_REGIONS;
        this.verifyResultContains(listRegionsCmd, this.runDataCommand(listRegionsCmd), "No Regions Found");
        String regionName = "dataTestRegion";
        String createRegionCmd = "create region --type=REPLICATE --name=" + regionName;
        this.verifyResultContains(createRegionCmd, this.runDataCommand(createRegionCmd), "Region \"/" + regionName + "\" created on");
        CommandTest.saveError(dataErrorKey, new StringBuilder("Bug #46391 Detected - Must issue a 'sleep' command to ensure that the region was created prior to any further operations."));
        this.execSleepCommad("5");
        String describeRegionCmd = "describe region --name=" + regionName;
        this.verifyResultValue(describeRegionCmd, this.getResultValue(this.runDataCommand(describeRegionCmd), "size"), "0");
        String showMetricsCmd = "show metrics --region=" + regionName;
        this.verifyResultValue(showMetricsCmd, this.getResultValue(this.runDataCommand(showMetricsCmd), "region entry count"), "0");
        String putCommand = "put --key=key1 --value=value1 --region=/" + regionName;
        ArrayList<String> cmdResultLines = this.runDataCommand(putCommand);
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Old Value", ":"), "<NULL>");
        this.execSleepCommad("5");
        this.verifyResultValue(describeRegionCmd, this.getResultValue(this.runDataCommand(describeRegionCmd), "size"), "1");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(this.runDataCommand(showMetricsCmd), "region entry count"), "1");
        String removeCommand = "remove --key=key1 --region=/" + regionName;
        cmdResultLines = this.runDataCommand(removeCommand);
        this.verifyResultValue(removeCommand, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(removeCommand, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        String command = "destroy region --name=/" + regionName;
        this.verifyResultContains(command, this.runDataCommand(command), "\"/" + regionName + "\"  destroyed successfully.");
        Log.getLogWriter().info("verifyDataTest-End");
    }

    private void verifyExportImportDataTest() {
        Log.getLogWriter().info("verifyExportImportDataTest-Start");
        String regionName = "exportImportTestRegion";
        String listRegionsCmd = CMD_LIST_REGIONS;
        String createRegionCmd = "create region --type=REPLICATE --name=" + regionName;
        String describeRegionCmd = "describe region --name=" + regionName;
        this.verifyResultNotContains(listRegionsCmd, this.runDataCommand(listRegionsCmd), regionName);
        this.verifyResultContains(createRegionCmd, this.runDataCommand(createRegionCmd), "Region \"/" + regionName + "\" created on");
        CommandTest.saveError(dataErrorKey, new StringBuilder("Bug #46391 Detected - Must issue a 'sleep' command to ensure that the region was created prior to any further operations."));
        this.execSleepCommad("5");
        this.verifyResultContains(listRegionsCmd, this.runDataCommand(listRegionsCmd), regionName);
        ArrayList<String> cmdResultLines = this.runDataCommand(describeRegionCmd);
        this.verifyResultValue(describeRegionCmd, this.getResultValue(cmdResultLines, "size"), "0");
        String memberName = this.getResultValue(cmdResultLines, "Hosting Members", ":");
        String command = "put --key=key1 --value=value1 --region=/" + regionName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Old Value", ":"), "<NULL>");
        command = "get --key=key1 --region=/" + regionName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Value  ", ":"), "value1");
        for (int i = 1; i <= 10; ++i) {
            this.runDataCommand("put --key=key" + i + " --value=value1 --region=/" + regionName);
        }
        this.verifyResultValue(describeRegionCmd, this.getResultValue(this.runDataCommand(describeRegionCmd), "size"), "10");
        command = "export data --file=myData.gfd --region=/" + regionName + " --member=" + memberName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultContains(command, cmdResultLines, "Data succesfully exported from region : /" + regionName);
        this.verifyResultContains(command, cmdResultLines, "myData.gfd on host :");
        command = "remove --region=/" + regionName + " --all";
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Message", ":"), "Cleared all keys in the region");
        this.verifyResultValue(describeRegionCmd, this.getResultValue(this.runDataCommand(describeRegionCmd), "size"), "0");
        command = "import data --file=myData.gfd --region=/" + regionName + " --member=" + memberName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultContains(command, cmdResultLines, "to region : /" + regionName);
        this.verifyResultValue(describeRegionCmd, this.getResultValue(this.runDataCommand(describeRegionCmd), "size"), "10");
        command = "get --key=key1 --region=/" + regionName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Value  ", ":"), "value1");
        command = "get --key=key6 --region=/" + regionName;
        cmdResultLines = this.runDataCommand(command);
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Key  ", ":"), "key6");
        this.verifyResultValue(command, this.getResultValue(cmdResultLines, "Value  ", ":"), "value1");
        command = "destroy region --name=/" + regionName;
        this.verifyResultContains(command, this.runDataCommand(command), "\"/" + regionName + "\"  destroyed successfully.");
        this.verifyResultNotContains(listRegionsCmd, this.runDataCommand(listRegionsCmd), regionName);
        Log.getLogWriter().info("verifyExportImportDataTest-End");
    }

    private void verifyShowMetricsDataTest() {
        int i;
        Log.getLogWriter().info("verifyShowMetricsDataTest-Start");
        String totalHitCount = "totalHitCount";
        String regionName = "showMetricsDataTestRegion";
        String showMetricsCmd = "show metrics --categories=cache";
        ArrayList<String> cmdResultLines = this.runDataCommand(showMetricsCmd);
        Log.getLogWriter().info("verifyShowMetricsDataTest-Initial Show Metrics-Plain");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(cmdResultLines, "totalRegionCount"), "0");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(cmdResultLines, "totalRegionEntryCount"), "0");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(cmdResultLines, "totalMissCount"), "0");
        int totalHitCountValue = Integer.parseInt(this.getResultValue(cmdResultLines, "totalHitCount"));
        this.verifyResultGreaterThan(showMetricsCmd, totalHitCountValue, 0);
        String createRegionCmd = "create region --type=REPLICATE --name=" + regionName;
        this.verifyResultContains(createRegionCmd, this.runDataCommand(createRegionCmd), "Region \"/" + regionName + "\" created on");
        CommandTest.saveError(dataErrorKey, new StringBuilder("Bug #46391 Detected - Must issue a 'sleep' command to ensure that the region was created prior to any further operations."));
        this.execSleepCommad("5");
        String showMetricsRegionCmd = "show metrics --categories=cluster,region --region=/" + regionName;
        cmdResultLines = this.runDataCommand(showMetricsRegionCmd);
        Log.getLogWriter().info("verifyShowMetricsDataTest-Initial Show Metrics-Region");
        this.verifyResultValue(showMetricsRegionCmd, this.getResultValue(cmdResultLines, "member count"), "1");
        this.verifyResultValue(showMetricsRegionCmd, this.getResultValue(cmdResultLines, "region entry count"), "0");
        String describeRegionCmd = "describe region --name=";
        String memberName = this.getResultValue(this.runDataCommand(describeRegionCmd + regionName), "Hosting Members", ":");
        String showMetricsMemberCmd = "show metrics --categories=region --member=" + memberName;
        cmdResultLines = this.runDataCommand(showMetricsMemberCmd);
        Log.getLogWriter().info("verifyShowMetricsDataTest-Initial Show Metrics-Member");
        this.verifyResultValue(showMetricsMemberCmd, this.getResultValue(cmdResultLines, "totalRegionCount"), "1");
        this.verifyResultValue(showMetricsMemberCmd, this.getResultValue(cmdResultLines, "totalRegionEntryCount"), "0");
        this.verifyResultValue(showMetricsMemberCmd, this.getResultValue(cmdResultLines, "totalHitCount"), "3");
        for (i = 1; i <= 10; ++i) {
            this.runDataCommand("put --key=key" + i + " --value=value1 --region=/" + regionName);
        }
        for (i = 5; i < 15; ++i) {
            this.runDataCommand("get --key=key" + i + " --region=/" + regionName);
        }
        this.runDataCommand("remove --key=key10 --region=/" + regionName);
        this.execSleepCommad("5");
        cmdResultLines = this.runDataCommand(showMetricsCmd);
        Log.getLogWriter().info("verifyShowMetricsDataTest-2nd Show Metrics-Plain");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(cmdResultLines, "totalRegionCount"), "1");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(cmdResultLines, "totalRegionEntryCount"), "9");
        this.verifyResultValue(showMetricsCmd, this.getResultValue(cmdResultLines, "totalMissCount"), "0");
        int oldTotalHitCountValue = totalHitCountValue;
        totalHitCountValue = Integer.parseInt(this.getResultValue(cmdResultLines, "totalHitCount"));
        this.verifyResultGreaterThan(showMetricsCmd, totalHitCountValue, oldTotalHitCountValue);
        cmdResultLines = this.runDataCommand(showMetricsRegionCmd);
        Log.getLogWriter().info("verifyShowMetricsDataTest-2nd Show Metrics-Region");
        this.verifyResultValue(showMetricsRegionCmd, this.getResultValue(cmdResultLines, "region entry count"), "9");
        cmdResultLines = this.runDataCommand(showMetricsMemberCmd);
        Log.getLogWriter().info("verifyShowMetricsDataTest-2nd Show Metrics-Member");
        this.verifyResultValue(showMetricsMemberCmd, this.getResultValue(cmdResultLines, "totalRegionCount"), "1");
        this.verifyResultValue(showMetricsMemberCmd, this.getResultValue(cmdResultLines, "totalRegionEntryCount"), "9");
        this.verifyResultValue(showMetricsMemberCmd, this.getResultValue(cmdResultLines, "totalHitCount"), "9");
        Log.getLogWriter().info("verifyShowMetricsDataTest-End");
    }

    private void verifyCompressedDataTest() {
        Log.getLogWriter().info("verifyCompressedDataTest-Start");
        String listRegionsCmd = CMD_LIST_REGIONS;
        this.verifyResultContains(listRegionsCmd, this.runDataCommand(listRegionsCmd), "No Regions Found");
        String createRegionCmd = "create region --type=REPLICATE --name=unCompressedDataTestRegion";
        this.verifyResultContains(createRegionCmd, this.runDataCommand(createRegionCmd), "Region \"/unCompressedDataTestRegion\" created on");
        createRegionCmd = "create region --type=REPLICATE --name=compressedDataTestRegion --compressor=com.gemstone.gemfire.compression.SnappyCompressor";
        this.verifyResultContains(createRegionCmd, this.runDataCommand(createRegionCmd), "Region \"/compressedDataTestRegion\" created on");
        this.execSleepCommad("5");
        String describeRegionCmd = "describe region --name=unCompressedDataTestRegion";
        this.verifyResultValue(describeRegionCmd, this.getResultValue(this.runDataCommand(describeRegionCmd), "size"), "0");
        describeRegionCmd = "describe region --name=compressedDataTestRegion";
        ArrayList<String> cmdResultLines = this.runDataCommand(describeRegionCmd);
        this.verifyResultValue(describeRegionCmd, this.getResultValue(cmdResultLines, "compressor"), "com.gemstone.gemfire.compression.SnappyCompressor");
        this.verifyResultValue(describeRegionCmd, this.getResultValue(cmdResultLines, "size"), "0");
        String putCommandPre = "put --key=key1 --value=\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam volutpat lacinia mauris ut fringilla. Maecenas nec sodales neque. In et diam a enim facilisis blandit. Maecenas cursus luctus arcu eget congue. Nunc mi ligula, porttitor molestie aliquet ac, cursus eget turpis. Mauris id porta lacus. Suspendisse adipiscing turpis vitae neque euismod at tristique neque luctus. In pulvinar malesuada rutrum.\" --region=/";
        String putCommand = putCommandPre + UNCOMP_REGION_NAME;
        cmdResultLines = this.runDataCommand(putCommand);
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Old Value", ":"), "<NULL>");
        putCommand = putCommandPre + COMP_REGION_NAME;
        cmdResultLines = this.runDataCommand(putCommand);
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(putCommand, this.getResultValue(cmdResultLines, "Old Value", ":"), "<NULL>");
        this.execSleepCommad("5");
        String getCommand = "get --key=key1 --region=/unCompressedDataTestRegion";
        cmdResultLines = this.runDataCommand(getCommand);
        this.verifyResultValue(getCommand, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(getCommand, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(getCommand, this.getResultValue(cmdResultLines, "Value  ", ":"), COMPRESSION_PUT_VALUE);
        getCommand = "get --key=key1 --region=/compressedDataTestRegion";
        cmdResultLines = this.runDataCommand(getCommand);
        this.verifyResultValue(getCommand, this.getResultValue(cmdResultLines, "Result", ":"), "true");
        this.verifyResultValue(getCommand, this.getResultValue(cmdResultLines, "Key  ", ":"), "key1");
        this.verifyResultValue(getCommand, this.getResultValue(cmdResultLines, "Value  ", ":"), COMPRESSION_PUT_VALUE);
        Log.getLogWriter().info("verifyCompressedDataTest-End");
    }

    private String getResultValue(ArrayList<String> cmdResultLines, String searchString) {
        return this.getResultValue(cmdResultLines, searchString, "|");
    }

    private String getResultValue(ArrayList<String> cmdResultLines, String searchString, String delimeter) {
        String rtnString = new String();
        for (String line : cmdResultLines) {
            if (!line.contains(searchString)) continue;
            int indexOfPipe = line.lastIndexOf(delimeter);
            rtnString = line.substring(indexOfPipe + 2).trim();
            break;
        }
        Log.getLogWriter().info("getResultValue-End '" + searchString + "'=" + rtnString);
        return rtnString;
    }

    private void verifyResultValue(String command, String resultValue, String expectedValue) {
        this.verifyResultValue(command, resultValue, expectedValue, null);
    }

    private void verifyResultValue(String command, String resultValue, String expectedValue, String extraErrorText) {
        if (!resultValue.equals(expectedValue)) {
            StringBuilder exceptionText = new StringBuilder();
            if (extraErrorText != null) {
                exceptionText.append(extraErrorText);
            }
            exceptionText.append("Command: |");
            exceptionText.append(command);
            exceptionText.append("| - Returned unexpected output: |");
            exceptionText.append(resultValue);
            exceptionText.append("| - Expected output: |");
            exceptionText.append(expectedValue).append("|");
            CommandTest.saveError(dataErrorKey, exceptionText);
        }
    }

    private void verifyResultGreaterThan(String command, int resultValue, int expectedValue) {
        this.verifyResultGreaterThan(command, resultValue, expectedValue, null);
    }

    private void verifyResultGreaterThan(String command, int resultValue, int expectedValue, String extraErrorText) {
        if (resultValue < expectedValue) {
            StringBuilder exceptionText = new StringBuilder();
            if (extraErrorText != null) {
                exceptionText.append(extraErrorText);
            }
            exceptionText.append("Command: |");
            exceptionText.append(command);
            exceptionText.append("| - Returned unexpected output: |");
            exceptionText.append(resultValue);
            exceptionText.append("| - is less than the Expected output: |");
            exceptionText.append(expectedValue).append("|");
            CommandTest.saveError(dataErrorKey, exceptionText);
        }
    }

    private void verifyResultContains(String command, ArrayList<String> cmdResultLines, String searchValue) {
        this.verifyResultContains(command, cmdResultLines, searchValue, null);
    }

    private void verifyResultContains(String command, ArrayList<String> cmdResultLines, String searchValue, String extraErrorText) {
        boolean found = false;
        for (String line : cmdResultLines) {
            if (!line.contains(searchValue)) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuilder exceptionText = new StringBuilder();
            if (extraErrorText != null) {
                exceptionText.append(extraErrorText);
            }
            exceptionText.append("The result from the command |");
            exceptionText.append(command);
            exceptionText.append("| was missing the value |");
            exceptionText.append(searchValue).append("|");
            CommandTest.saveError(dataErrorKey, exceptionText);
        }
    }

    private void verifyResultNotContains(String command, ArrayList<String> cmdResultLines, String searchValue) {
        this.verifyResultNotContains(command, cmdResultLines, searchValue, null);
    }

    private void verifyResultNotContains(String command, ArrayList<String> cmdResultLines, String searchValue, String extraErrorText) {
        boolean found = false;
        for (String line : cmdResultLines) {
            if (!line.contains(searchValue)) continue;
            found = true;
            break;
        }
        if (found) {
            StringBuilder exceptionText = new StringBuilder();
            if (extraErrorText != null) {
                exceptionText.append(extraErrorText);
            }
            exceptionText.append("The result from the command |");
            exceptionText.append(command);
            exceptionText.append("| contained (and shouldn't) the value |");
            exceptionText.append(searchValue).append("|");
            CommandTest.saveError(dataErrorKey, exceptionText);
        }
    }

    private static void saveError(String errorKey, StringBuilder newError) {
        Log.getLogWriter().info("saveError-Start newError=" + newError);
        ArrayList<String> errorList = (ArrayList<String>)CommandBB.getBB().getSharedMap().get(errorKey);
        if (errorList == null) {
            errorList = new ArrayList<String>();
        }
        newError.append(" - Executed from line(s): ");
        StringBuilder execLineNbrs = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            if (!stackTrace[i].getClassName().equalsIgnoreCase("management.test.cli.CommandTest")) continue;
            if (execLineNbrs.length() > 0) {
                execLineNbrs.append("-->");
            }
            execLineNbrs.append(stackTrace[i].getLineNumber());
        }
        newError.append(execLineNbrs.toString());
        newError.append("\n");
        errorList.add(newError.toString());
        CommandBB.getBB().getSharedMap().put(errorKey, errorList);
    }

    private static void checkForErrors(String errorKey) {
        ArrayList errorList = (ArrayList)CommandBB.getBB().getSharedMap().get(errorKey);
        if (errorList != null && errorList.size() > 0) {
            errorList.add(0, "Errors (" + errorList.size() + ") were found:\n");
            throw new TestException(errorList.toString());
        }
        Log.getLogWriter().info("*** No Errors Were Found!  Congrats, now go celebrate! ***");
    }

    private static void checkCompressedPerfStats() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            throw new TestException("CommandTest.checkPerfStats-The cache should not be null!");
        }
        HashSet theRegions = new HashSet(cache.rootRegions());
        if (theRegions.size() <= 0) {
            throw new TestException("CommandTest.checkPerfStats-We should have at least ONE region!");
        }
        for (LocalRegion aRegion : theRegions) {
            String regionName = aRegion.getName();
            Compressor compressor = aRegion.getAttributes().getCompressor();
            CachePerfStats regionPerfStats = aRegion.getRegionPerfStats();
            long totalPreCompressedBytes = regionPerfStats.getTotalPreCompressedBytes();
            long totalCompressionTime = regionPerfStats.getTotalCompressionTime();
            long totalCompressions = regionPerfStats.getTotalCompressions();
            long totalPostCompressedBytes = regionPerfStats.getTotalPostCompressedBytes();
            long totalDecompressionTime = regionPerfStats.getTotalDecompressionTime();
            long totalDecompressions = regionPerfStats.getTotalDecompressions();
            Log.getLogWriter().info("CommandTest.checkPerfStats regionName = " + regionName);
            Log.getLogWriter().info("  Compressor=" + (compressor == null ? null : compressor.getClass().getName()));
            Log.getLogWriter().info("  totalPreCompressedBytes   = " + totalPreCompressedBytes);
            Log.getLogWriter().info("  totalCompressionTime   = " + totalCompressionTime);
            Log.getLogWriter().info("  totalCompressions      = " + totalCompressions);
            Log.getLogWriter().info("  totalPostCompressedBytes = " + totalPostCompressedBytes);
            Log.getLogWriter().info("  totalDecompressionTime = " + totalDecompressionTime);
            Log.getLogWriter().info("  totalDecompressions    = " + totalDecompressions);
            Object theValue = aRegion.get((Object)"key1");
            if (!theValue.equals(COMPRESSION_PUT_VALUE)) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The value retrived from the region doesn't equal the one that was put there."));
            }
            if (regionName.equals(COMP_REGION_NAME)) {
                if (!compressor.getClass().getName().equals("com.gemstone.gemfire.compression.SnappyCompressor")) {
                    CommandTest.saveError(dataErrorKey, new StringBuilder("The compressor for the compressed region is incorrect."));
                }
                if (totalCompressions != 1L) {
                    CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of compressions for the compressed region should be one."));
                }
                if (totalPreCompressedBytes != (long)(COMPRESSION_PUT_VALUE.length() + 3)) {
                    CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of pre-compressed bytes for the compressed region is incorrect."));
                }
                if (totalCompressionTime <= 0L) {
                    CommandTest.saveError(dataErrorKey, new StringBuilder("The total compression time for the compressed region should be greater than zero."));
                }
                if (totalDecompressions != 1L) {
                    CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of decompressions for the compressed region should be one."));
                }
                if (totalPostCompressedBytes <= 0L) {
                    CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of post-compressed bytes for the compressed region should be greater than zero."));
                }
                if (totalDecompressionTime > 0L) continue;
                CommandTest.saveError(dataErrorKey, new StringBuilder("The total decompression time for the compressed region should be greater than zero."));
                continue;
            }
            if (!regionName.equals(UNCOMP_REGION_NAME)) continue;
            if (compressor != null) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The compressor for the uncompressed region is incorrect."));
            }
            if (totalCompressions != 0L) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of compressions for the uncompressed region should be zero."));
            }
            if (totalPreCompressedBytes != 0L) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of pre-compressed bytes for the uncompressed region should be zero."));
            }
            if (totalCompressionTime != 0L) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The total compression time for the uncompressed region should be zero."));
            }
            if (totalDecompressions != 0L) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of decompressions for the uncompressed region should be zero."));
            }
            if (totalPostCompressedBytes != 0L) {
                CommandTest.saveError(dataErrorKey, new StringBuilder("The total number of post-compressed bytes for the uncompressed region should be zero."));
            }
            if (totalDecompressionTime == 0L) continue;
            CommandTest.saveError(dataErrorKey, new StringBuilder("The total decompression time for the uncompressed region should be zero."));
        }
    }

    private void basicCommandTest() {
        Log.getLogWriter().info("basicCommandTest-Start");
        this.shell.clearEvents();
        String command = "invalid";
        String expectedOutput = "Command \"" + command + "\" is not valid or is currently not available.";
        this.checkCommand(command, expectedOutput);
        Log.getLogWriter().info("basicCommandTest-End");
    }

    private void cmdAlterDiskStoreTest() {
        Log.getLogWriter().info("cmdAlterDiskStoreTest-Start");
        String diskStoreName = this.getAvailableDiskStoreName();
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "", diskStoreName, true, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "", this.getRandomRegion(), true, false);
        CmdOptionInfo diskDirsOption = new CmdOptionInfo(PARM_DISK_DIRS, "", ".", true, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption, regionOption, diskDirsOption};
        this.checkNamedParams(CMD_ALTER_DISKSTORE, options);
        this.checkMultiLineExecution(CMD_ALTER_DISKSTORE, options);
        Log.getLogWriter().info("cmdAlterDiskStoreTest-End");
    }

    private void cmdAlterRuntimeTest() {
        Log.getLogWriter().info("cmdAlterRuntimeTest-Start");
        String baseError = "Following errors occurred while altering runtime config\n";
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", "", false, false);
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No caching members for group %1 could be found.  Please verify the group and try again.", "", false, false);
        CmdOptionInfo logLevelOption = new CmdOptionInfo("log-level", baseError + "Unknown log-level \"%1\". Valid levels are: all finest finer fine config info warning error severe none.", "", false, false);
        CmdOptionInfo logDiskSpaceLimitOption = new CmdOptionInfo("log-disk-space-limit", baseError + "\"log-disk-space-limit\" value \"%1\" must be a number.", "", false, false);
        CmdOptionInfo logFileSizeLimitOption = new CmdOptionInfo("log-file-size-limit", baseError + "\"log-file-size-limit\" value \"%1\" must be a number.", "", false, false);
        CmdOptionInfo archiveDiskSpaceLimitOption = new CmdOptionInfo("archive-disk-space-limit", baseError + "\"archive-disk-space-limit\" value \"%1\" must be a number.", "", false, false);
        CmdOptionInfo archiveFileSizeLimitOption = new CmdOptionInfo("archive-file-size-limit", baseError + "\"archive-file-size-limit\" value \"%1\" must be a number.", "", false, false);
        CmdOptionInfo statisticSampleRateOption = new CmdOptionInfo("statistic-sample-rate", baseError + "\"statistic-sample-rate\" value \"%1\" must be a number.", "", false, false);
        CmdOptionInfo enableStatisticsOption = new CmdOptionInfo("enable-statistics", "Value for enable-statistics must be either \"true\" or \"false\"", "", false, true);
        CmdOptionInfo[] options = new CmdOptionInfo[]{memberOption, groupOption, logLevelOption, logDiskSpaceLimitOption, logFileSizeLimitOption, archiveDiskSpaceLimitOption, archiveFileSizeLimitOption, statisticSampleRateOption, enableStatisticsOption};
        this.checkNamedParams(CMD_ALTER_RUNTIME, options);
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        memberOption.setValidValue(memberName);
        logLevelOption.setValidValue("info");
        this.checkMultiLineExecution(CMD_ALTER_RUNTIME, options);
        String expectedOutput = "Please provide a relevant parameter(s)";
        this.checkCommand(CMD_ALTER_RUNTIME, expectedOutput);
        expectedOutput = "Please provide a relevant parameter(s)";
        String cmdMemberPart = " --member=" + memberName;
        this.checkCommand(CMD_ALTER_RUNTIME + cmdMemberPart, expectedOutput);
        String groupName = this.getAvailableGroupName();
        String cmdGroupPart = " --group=" + groupName;
        this.checkCommand(CMD_ALTER_RUNTIME + cmdGroupPart, expectedOutput);
        String[][] expectedText = new String[][]{{"Runtime configuration altered successfully for the following member(s)"}, {null}};
        String cmdLogLevelPart = " --log-level=info";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdLogLevelPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdLogLevelPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdLogLevelPart, expectedText);
        String cmdLogDiskSpaceLimitPart = " --log-disk-space-limit=";
        expectedOutput = baseError + "Could not set \"log-disk-space-limit\" to \"-1\" because its value can not be less than \"0\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdLogDiskSpaceLimitPart + "-1", expectedOutput);
        expectedOutput = baseError + "Could not set \"log-disk-space-limit\" to \"1,000,001\" because its value can not be greater than \"1,000,000\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdLogDiskSpaceLimitPart + "1000001", expectedOutput);
        cmdLogDiskSpaceLimitPart = cmdLogDiskSpaceLimitPart + "1000";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdLogDiskSpaceLimitPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdLogDiskSpaceLimitPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdLogDiskSpaceLimitPart, expectedText);
        String cmdLogFileSizeLimitOptionPart = " --log-file-size-limit=";
        expectedOutput = baseError + "Could not set \"log-file-size-limit\" to \"-1\" because its value can not be less than \"0\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdLogFileSizeLimitOptionPart + "-1", expectedOutput);
        expectedOutput = baseError + "Could not set \"log-file-size-limit\" to \"1,000,001\" because its value can not be greater than \"1,000,000\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdLogFileSizeLimitOptionPart + "1000001", expectedOutput);
        cmdLogFileSizeLimitOptionPart = cmdLogFileSizeLimitOptionPart + "1000";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdLogFileSizeLimitOptionPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdLogFileSizeLimitOptionPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdLogFileSizeLimitOptionPart, expectedText);
        String cmdArchiveDiskSpaceLimitPart = " --archive-disk-space-limit=";
        expectedOutput = baseError + "Could not set \"archive-disk-space-limit\" to \"-1\" because its value can not be less than \"0\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdArchiveDiskSpaceLimitPart + "-1", expectedOutput);
        expectedOutput = baseError + "Could not set \"archive-disk-space-limit\" to \"1,000,001\" because its value can not be greater than \"1,000,000\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdArchiveDiskSpaceLimitPart + "1000001", expectedOutput);
        cmdArchiveDiskSpaceLimitPart = cmdArchiveDiskSpaceLimitPart + "1000";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdArchiveDiskSpaceLimitPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdArchiveDiskSpaceLimitPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdArchiveDiskSpaceLimitPart, expectedText);
        String cmdArchiveFileSizeLimitPart = " --archive-file-size-limit=";
        expectedOutput = baseError + "Could not set \"archive-file-size-limit\" to \"-1\" because its value can not be less than \"0\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdArchiveFileSizeLimitPart + "-1", expectedOutput);
        expectedOutput = baseError + "Could not set \"archive-file-size-limit\" to \"1,000,001\" because its value can not be greater than \"1,000,000\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdArchiveFileSizeLimitPart + "1000001", expectedOutput);
        cmdArchiveFileSizeLimitPart = cmdArchiveFileSizeLimitPart + "1000";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdArchiveFileSizeLimitPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdArchiveFileSizeLimitPart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdArchiveFileSizeLimitPart, expectedText);
        String cmdStatisticArchiveFilePart = " --statistic-archive-file=statArchFile";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdStatisticArchiveFilePart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdStatisticArchiveFilePart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdStatisticArchiveFilePart, expectedText);
        String cmdStatisticSampleRatePart = " --statistic-sample-rate=";
        expectedOutput = baseError + "Could not set \"statistic-sample-rate\" to \"-1\" because its value can not be less than \"100\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdStatisticSampleRatePart + "-1", expectedOutput);
        expectedOutput = baseError + "Could not set \"statistic-sample-rate\" to \"60,001\" because its value can not be greater than \"60,000\".";
        this.checkCommand(CMD_ALTER_RUNTIME + cmdStatisticSampleRatePart + "60001", expectedOutput);
        cmdStatisticSampleRatePart = cmdStatisticSampleRatePart + "1000";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdStatisticSampleRatePart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdStatisticSampleRatePart, expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdStatisticSampleRatePart, expectedText);
        String cmdEnableStatisticsPart = " --enable-statistics=";
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdEnableStatisticsPart + "true", expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdEnableStatisticsPart + "false", expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdEnableStatisticsPart + "true", expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdMemberPart + cmdEnableStatisticsPart + "false", expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdEnableStatisticsPart + "true", expectedText);
        this.checkOutputLines(CMD_ALTER_RUNTIME + cmdGroupPart + cmdEnableStatisticsPart + "false", expectedText);
        Log.getLogWriter().info("cmdAlterRuntimeTest-End");
    }

    private void cmdDescribeConfigTest() {
        Log.getLogWriter().info("cmdDescribeConfigTest-Start");
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "", memberName, true, false);
        CmdOptionInfo hideDefaultsOption = new CmdOptionInfo(PARM_HIDE_DEFAULTS, "", "", false, true);
        CmdOptionInfo[] options = new CmdOptionInfo[]{memberOption, hideDefaultsOption};
        this.checkNamedParams(CMD_DESCRIBE_CONFIG, options);
        hideDefaultsOption.setValidValue("true");
        this.checkMultiLineExecution(CMD_DESCRIBE_CONFIG, options);
        Map sharedMap = CommandBB.getBB().getSharedMap().getMap();
        for (String key : sharedMap.keySet()) {
            Log.getLogWriter().info("cmdDescribeConfigTest-key=" + key);
            if (!key.startsWith(memberNameKeyPrefix) && !key.startsWith(memberIdKeyPrefix)) continue;
            String value = (String)sharedMap.get(key);
            Log.getLogWriter().info("cmdDescribeConfigTest-value=" + value);
            String string = this.execCommand("describe config --member=" + value);
        }
        Log.getLogWriter().info("cmdDescribeConfigTest-End");
    }

    private void cmdListMemberTest() {
        int nbrMemberHosts;
        Log.getLogWriter().info("cmdListMemberTest-Start");
        String msg_no_members_found = "No Members Found";
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No Members Found", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{groupOption};
        this.checkNamedParams(CMD_LIST_MEMBERS, options);
        groupOption.setValidValue(this.getAvailableGroupName());
        this.checkMultiLineExecution(CMD_LIST_MEMBERS, options);
        StringBuilder command = new StringBuilder(CMD_LIST_MEMBERS);
        String outputText = this.execCommand(command.toString(), false)[0];
        if (outputText.equals("No Members Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command.toString(), outputText));
        }
        String saveAllOutputText = outputText;
        command.append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_LOCATOR);
        outputText = this.execCommand(command.toString(), false)[0];
        if (outputText.equals("No Members Found") || outputText.equals(saveAllOutputText)) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command.toString(), outputText));
        }
        String saveLocatorOutputText = outputText;
        HostHelper.OSType osType = HostHelper.getLocalHostOS();
        if (HostHelper.isWindows()) {
            CommandTest.saveError(cmdErrorKey, new StringBuilder("Bug #46388 Detected - command continuation character '\\' not working on windows."));
        } else {
            command = new StringBuilder(CMD_LIST_MEMBERS).append("\\").append(System.getProperty("line.separator"));
            command.append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_LOCATOR);
            outputText = this.execCommand(command.toString(), false)[0];
            if (!outputText.equals(saveLocatorOutputText)) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command.toString(), outputText, saveLocatorOutputText));
            }
            command.append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_MEMBER);
            String expectedOutput = "Parameter group can only be specified once";
            this.checkCommand(command.toString(), expectedOutput);
        }
        boolean haveAdminHosts = CommandPrms.haveAdminHosts();
        String saveAdminOutputText = null;
        if (haveAdminHosts) {
            command = new StringBuilder(CMD_LIST_MEMBERS).append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_ADMIN);
            outputText = this.execCommand(command.toString(), false)[0];
            if (outputText.equals("No Members Found") || outputText.equals(saveAllOutputText) || outputText.equals(saveLocatorOutputText)) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command.toString(), outputText));
            }
            saveAdminOutputText = outputText;
        }
        if ((nbrMemberHosts = CommandPrms.getNbrMemberHosts()) > 0) {
            command = new StringBuilder(CMD_LIST_MEMBERS).append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_MEMBER);
            outputText = this.execCommand(command.toString(), false)[0];
            if (outputText.equals("No Members Found") || outputText.equals(saveAllOutputText) || outputText.equals(saveLocatorOutputText) || haveAdminHosts && outputText.equals(saveAdminOutputText)) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command.toString(), outputText));
            }
            for (int i = 1; i <= nbrMemberHosts; ++i) {
                command.append(i);
                outputText = this.execCommand(command.toString(), false)[0];
                if (!outputText.equals("No Members Found") && !outputText.equals(saveAllOutputText) && !outputText.equals(saveLocatorOutputText) && (!haveAdminHosts || !outputText.equals(saveAdminOutputText))) continue;
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command.toString(), outputText));
            }
        }
        Log.getLogWriter().info("cmdListMemberTest-End");
    }

    private void cmdDescribeMemberTest() {
        Log.getLogWriter().info("cmdDescribeMemberTest-Start");
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "Member \"%1\" not found", this.getRandomMember(), true, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption};
        this.checkNamedParams(CMD_DESCRIBE_MEMBER, options);
        this.checkMultiLineExecution(CMD_DESCRIBE_MEMBER, options);
        Map sharedMap = CommandBB.getBB().getSharedMap().getMap();
        for (String key : sharedMap.keySet()) {
            Log.getLogWriter().info("cmdDescribeMemberTest-key=" + key);
            if (!key.startsWith(memberNameKeyPrefix) && !key.startsWith(memberIdKeyPrefix)) continue;
            String value = (String)sharedMap.get(key);
            Log.getLogWriter().info("cmdDescribeMemberTest-value=" + value);
            String command = "describe member --name=" + value;
            String string = this.execCommand(command);
        }
        Log.getLogWriter().info("cmdDescribeMemberTest-End");
    }

    private void cmdListRegionTest() {
        Log.getLogWriter().info("cmdListRegionTest-Start");
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No caching members for group %1 could be found.  Please verify the group and try again.", "", false, false);
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{groupOption, memberOption};
        this.checkNamedParams(CMD_LIST_REGIONS, options);
        groupOption.setValidValue(this.getAvailableGroupName());
        memberOption.setValidValue(this.parseMemberName(this.getMemberInfo(this.getRandomMember())));
        this.checkMultiLineExecution(CMD_LIST_REGIONS, options);
        String msg_no_regions_found = "No Regions Found";
        StringBuilder commandBuilder = new StringBuilder(CMD_LIST_REGIONS);
        String outputText = this.execCommand(commandBuilder.toString()).trim();
        if (outputText.equals("No Regions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(commandBuilder.toString(), outputText));
        }
        String saveAllOutputText = outputText;
        int nbrMemberHosts = CommandPrms.getNbrMemberHosts();
        if (nbrMemberHosts > 0) {
            commandBuilder.append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_MEMBER);
            this.checkCommand(commandBuilder.toString(), saveAllOutputText);
            for (int i = 1; i <= nbrMemberHosts; ++i) {
                this.checkCommand(commandBuilder.toString() + i, saveAllOutputText);
            }
            commandBuilder.append(", ").append(GROUP_MEMBER).append("1");
            outputText = this.execCommand(commandBuilder.toString()).trim();
            if (outputText.equals("No Regions Found")) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(commandBuilder.toString(), outputText));
            }
        }
        Log.getLogWriter().info("cmdListRegionTest-Member");
        commandBuilder = new StringBuilder(CMD_LIST_REGIONS).append(PARM_PREFIX).append(PARM_MEMBER).append(PARM_VALUE_SEP);
        Map sharedMap = CommandBB.getBB().getSharedMap().getMap();
        for (String key : sharedMap.keySet()) {
            if (!key.startsWith(memberNameKeyPrefix) && !key.startsWith(memberIdKeyPrefix)) continue;
            String value = (String)sharedMap.get(key);
            String command = commandBuilder.toString() + value;
            if (value.contains("edge")) {
                outputText = this.execCommand(command, false)[0];
                if (outputText.startsWith("Member ") && outputText.endsWith("could not be found.  Please verify the member name or ID and try again.")) continue;
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText));
                continue;
            }
            this.checkCommand(command, saveAllOutputText);
        }
        Log.getLogWriter().info("cmdListRegionTest-End");
    }

    private void cmdDescribeRegionTest() {
        Log.getLogWriter().info("cmdDescribeRegionTest-Start");
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "Region : %1 not found", this.getRandomRegion(), true, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption};
        this.checkNamedParams(CMD_DESCRIBE_REGION, options);
        this.checkMultiLineExecution(CMD_DESCRIBE_REGION, options);
        for (String regionName : (Set)CommandBB.getBB().getSharedMap().get(regionNamesKey)) {
            String[][] expectedText = new String[][]{{".", "Name", "Data Policy", "Hosting Members"}, {".", regionName.substring(1), null, null}};
            this.checkOutputLines("describe region --name=" + regionName, expectedText);
        }
        Log.getLogWriter().info("cmdDescribeRegionTest-End");
    }

    private void cmdListDiskStoreTest(boolean regionsAreRegistered) {
        Log.getLogWriter().info("cmdListDiskStoreTest-Start-regionsAreRegistered=" + regionsAreRegistered);
        this.checkNamedParams(CMD_LIST_DISKSTORES);
        if (regionsAreRegistered) {
            String[][] expectedText = new String[][]{{"Member Name", "-"}, {"Disk Store ID", "-"}};
            this.checkOutputLines(CMD_LIST_DISKSTORES, expectedText);
        } else {
            this.checkCommand(CMD_LIST_DISKSTORES, "No Disk Stores Found");
        }
        Log.getLogWriter().info("cmdListDiskStoreTest-End");
    }

    private void cmdDescribeDiskStoreTest() {
        Log.getLogWriter().info("cmdDescribeDiskStoreTest-Start");
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "", memberName, true, false);
        String diskStoreName = this.findDiskStoreName(memberName, this.execCommand(CMD_LIST_DISKSTORES));
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "", diskStoreName, true, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{memberOption, nameOption};
        this.checkNamedParams(CMD_DESCRIBE_DISKSTORE, options);
        this.checkMultiLineExecution(CMD_DESCRIBE_DISKSTORE, options);
        Log.getLogWriter().info("cmdDescribeDiskStoreTest-End");
    }

    private void cmdListFunctionTest(boolean functionsAreRegistered) {
        String expectedOutput;
        Log.getLogWriter().info("cmdListFunctionTest-Start-functionsAreRegistered=" + functionsAreRegistered);
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No caching members for group %1 could be found.  Please verify the group and try again.", "", false, false);
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{groupOption, memberOption};
        this.checkNamedParams(CMD_LIST_FUNCTIONS, options);
        groupOption.setValidValue(this.getAvailableGroupName());
        memberOption.setValidValue(this.parseMemberName(this.getMemberInfo(this.getRandomMember())));
        this.checkMultiLineExecution(CMD_LIST_FUNCTIONS, options);
        String msg_no_functions_found = "No Functions Found";
        StringBuilder cmdBuilder = new StringBuilder(CMD_LIST_FUNCTIONS);
        String outputText = this.execCommand(cmdBuilder.toString(), false)[0];
        if (functionsAreRegistered && outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
        } else if (!functionsAreRegistered && !outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Functions Found"));
        }
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        cmdBuilder.append(PARM_PREFIX).append(PARM_MEMBER).append(PARM_VALUE_SEP).append(memberName);
        outputText = this.execCommand(cmdBuilder.toString(), false)[0];
        if (functionsAreRegistered && outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
        } else if (!functionsAreRegistered && !outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Functions Found"));
        }
        int nbrOfMembers = FederationBlackboard.getBB().getMemberONs().size();
        Log.getLogWriter().info("cmdListFunctionTest-nbrOfMembers=" + nbrOfMembers);
        if (nbrOfMembers > 1) {
            String memberName2 = memberName;
            while (memberName2.equals(memberName)) {
                memberName2 = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
            }
            expectedOutput = "Parameter " + memberName2 + " is not applicable for list functions";
            cmdBuilder.append(", ").append(memberName2);
            this.checkCommand(cmdBuilder.toString(), expectedOutput);
        }
        cmdBuilder = new StringBuilder(CMD_LIST_FUNCTIONS).append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_MEMBER);
        outputText = this.execCommand(cmdBuilder.toString(), false)[0];
        if (functionsAreRegistered && outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
        } else if (!functionsAreRegistered && !outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Functions Found"));
        }
        if (CommandPrms.getNbrMemberHosts() > 0) {
            cmdBuilder.append(", ").append(GROUP_MEMBER).append("1");
            outputText = this.execCommand(cmdBuilder.toString(), false)[0];
            if (functionsAreRegistered && outputText.equals("No Functions Found")) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
            } else if (!functionsAreRegistered && !outputText.equals("No Functions Found")) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Functions Found"));
            }
        }
        String matchCLI = "cli.*";
        cmdBuilder = new StringBuilder(CMD_LIST_FUNCTIONS).append(PARM_PREFIX).append(PARM_MATCHES).append(PARM_VALUE_SEP).append("cli.*");
        outputText = this.execCommand(cmdBuilder.toString(), false)[0];
        if (functionsAreRegistered && outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
        } else if (!functionsAreRegistered && !outputText.equals("No Functions Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Functions Found"));
        }
        cmdBuilder = new StringBuilder(CMD_LIST_FUNCTIONS).append(PARM_PREFIX).append(PARM_MEMBER).append(PARM_VALUE_SEP).append(memberName);
        cmdBuilder.append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP).append(GROUP_MEMBER);
        cmdBuilder.append(PARM_PREFIX).append(PARM_MATCHES).append(PARM_VALUE_SEP).append("cli.*");
        expectedOutput = "Please provide either \"member\" or \"group\" option.";
        this.checkCommand(cmdBuilder.toString(), expectedOutput);
        Log.getLogWriter().info("cmdListFunctionTest-End");
    }

    private void addFunction() {
        Log.getLogWriter().info("addFunction-Start");
        Function fcn = (Function)testInstance.instantiateObject(1, "cli.DeployFcn1");
        FunctionService.registerFunction((Function)fcn);
        Log.getLogWriter().info("addFunction-Registered Functions: " + FunctionService.getRegisteredFunctions());
        Log.getLogWriter().info("addFunction-End");
    }

    private void cmdListIndexTest(boolean indexesAreAdded) {
        String outputText;
        Log.getLogWriter().info("cmdListIndexTest-Start-indexesAreAdded=" + indexesAreAdded);
        CmdOptionInfo withStatsOption = new CmdOptionInfo(PARM_WITH_STATS, "", "", false, true);
        CmdOptionInfo[] options = new CmdOptionInfo[]{withStatsOption};
        this.checkNamedParams(CMD_LIST_INDEXES, options);
        withStatsOption.setValidValue("true");
        this.checkMultiLineExecution(CMD_LIST_INDEXES, options);
        String msg_no_indexes_found = "No Indexes Found";
        StringBuilder cmdBuilder = new StringBuilder(CMD_LIST_INDEXES);
        String outputWithoutStats = outputText = this.execCommand(cmdBuilder.toString(), false)[0];
        if (indexesAreAdded && outputText.equals("No Indexes Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
        } else if (!indexesAreAdded && !outputText.equals("No Indexes Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Indexes Found"));
        }
        cmdBuilder.append(PARM_PREFIX).append(PARM_WITH_STATS);
        String outputWithStats = outputText = this.execCommand(cmdBuilder.toString(), false)[0];
        if (indexesAreAdded) {
            if (outputText.equals("No Indexes Found") || outputText.equals(outputWithoutStats)) {
                CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText));
            }
        } else if (!outputText.equals("No Indexes Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(cmdBuilder.toString(), outputText, "No Indexes Found"));
        }
        String command = cmdBuilder.toString() + "=true";
        outputText = this.execCommand(command, false)[0];
        if (indexesAreAdded && !outputText.equals(outputWithStats)) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText, outputWithStats));
        } else if (!indexesAreAdded && !outputText.equals("No Indexes Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText, "No Indexes Found"));
        }
        command = cmdBuilder.toString() + "=false";
        outputText = this.execCommand(command, false)[0];
        if (indexesAreAdded && !outputText.equals(outputWithoutStats)) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText, outputWithoutStats));
        } else if (!indexesAreAdded && !outputText.equals("No Indexes Found")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText, "No Indexes Found"));
        }
        Log.getLogWriter().info("cmdListIndexTest-End");
    }

    private void addIndex() {
        Log.getLogWriter().info("addIndex-Start");
        Cache cache = CacheHelper.getCache();
        if (cache != null) {
            QueryService queryService = cache.getQueryService();
            Region region = cache.getRegion(this.getRandomRegion());
            String regionPath = region.getFullPath();
            Log.getLogWriter().info("addIndex-regionPath=" + regionPath);
            try {
                queryService.createIndex("index1", "myValue", regionPath);
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("addIndex-End");
    }

    private void cmdCreateIndexTest() {
        Log.getLogWriter().info("cmdCreateIndexTest-Start");
        String aRegion = this.getRandomRegion();
        String indexName = "anIndex";
        indexName = indexName + aRegion.substring(1);
        String indexExpression = "myValue";
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "", indexName, true, false);
        CmdOptionInfo expressionOption = new CmdOptionInfo(PARM_EXPRESSION, "", indexExpression, true, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "", aRegion, true, false);
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", memberName, false, false);
        CmdOptionInfo typeOption = new CmdOptionInfo(PARM_TYPE, "Invalid index type,value must be one of the following: range, key or hash.", "", false, false);
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No caching members for group %1 could be found.  Please verify the group and try again.", this.getAvailableGroupName(), false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption, expressionOption, regionOption, memberOption, typeOption, groupOption};
        this.checkNamedParams(CMD_CREATE_INDEX, options);
        this.checkMultiLineExecution(CMD_CREATE_INDEX, options);
        String cmdDestroyIndex = "destroy index --name=" + indexName;
        this.execCommand(cmdDestroyIndex, false);
        this.checkRegionOption(CMD_CREATE_INDEX, new CmdOptionInfo[]{nameOption, expressionOption}, regionOption, false);
        this.execCommand(cmdDestroyIndex);
        this.checkRegionOption(CMD_CREATE_INDEX, new CmdOptionInfo[]{nameOption, expressionOption}, regionOption, true);
        this.execCommand(cmdDestroyIndex);
        StringBuilder cmdBuilder = new StringBuilder(CMD_CREATE_INDEX);
        cmdBuilder.append(PARM_PREFIX).append(PARM_NAME).append(PARM_VALUE_SEP).append(indexName);
        cmdBuilder.append(PARM_PREFIX).append(PARM_EXPRESSION).append(PARM_VALUE_SEP).append(indexExpression);
        cmdBuilder.append(PARM_PREFIX).append(PARM_REGION).append(PARM_VALUE_SEP).append(aRegion);
        String command = cmdBuilder.toString();
        String[][] expectedText = new String[][]{{"Index successfully created with following details", "Name", "Expression", "RegionPath", "Members which contain the index", "1."}, {null, indexName, indexExpression, aRegion, null, null}};
        this.checkOutputLines(command, expectedText);
        this.execCommand(cmdDestroyIndex);
        this.checkOutputLines(command, expectedText);
        String[][] failedText = new String[][]{{"Failed to create index \"" + indexName + "\" due to following reasons", "Index \"" + indexName + "\" already exists.", "Occurred on following members", "1."}, {null, null, null, null}};
        this.checkOutputLines(command, failedText);
        this.execCommand(cmdDestroyIndex);
        Log.getLogWriter().info("cmdCreateIndexTest-Member");
        command = cmdBuilder + PARM_PREFIX + PARM_MEMBER + PARM_VALUE_SEP + memberName;
        this.checkOutputLines(command, expectedText);
        this.execCommand(cmdDestroyIndex);
        Log.getLogWriter().info("cmdCreateIndexTest-Type");
        command = cmdBuilder + PARM_PREFIX + PARM_TYPE + "=range";
        this.checkOutputLines(command, expectedText);
        this.execCommand(cmdDestroyIndex);
        Log.getLogWriter().info("cmdCreateIndexTest-Group");
        command = cmdBuilder + PARM_PREFIX + PARM_GROUP + PARM_VALUE_SEP + this.getAvailableGroupName();
        this.checkOutputLines(command, expectedText);
        this.execCommand(cmdDestroyIndex);
        Log.getLogWriter().info("cmdCreateIndexTest-End");
    }

    private void cmdDestroyIndexTest() {
        Log.getLogWriter().info("cmdDestroyIndexTest-Start");
        String indexName = "anIndexNameToDestroy";
        String indexExpression = "anIndexExpToDestroy";
        String aRegion = this.getRandomRegion();
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "Index \"%1\" could not be destroyed for following reasons", indexName, false, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "Indexes could not be destroyed for following reasons", aRegion, false, false);
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", memberName, false, false);
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No caching members for group %1 could be found.  Please verify the group and try again.", this.getAvailableGroupName(), false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption, regionOption, memberOption, groupOption};
        this.checkNamedParams(CMD_DESTROY_INDEX, options);
        StringBuilder cmdCreateIndexBuilder = new StringBuilder(CMD_CREATE_INDEX);
        cmdCreateIndexBuilder.append(PARM_PREFIX).append(PARM_NAME).append(PARM_VALUE_SEP).append(indexName);
        cmdCreateIndexBuilder.append(PARM_PREFIX).append(PARM_EXPRESSION).append(PARM_VALUE_SEP).append(indexExpression);
        cmdCreateIndexBuilder.append(PARM_PREFIX).append(PARM_REGION).append(PARM_VALUE_SEP).append(aRegion);
        this.execCommand(cmdCreateIndexBuilder.toString());
        this.checkMultiLineExecution(CMD_DESTROY_INDEX, options);
        String outputText = this.execCommand(CMD_LIST_INDEXES);
        if (null != outputText && !outputText.equals("No Indexes Found")) {
            this.execCommand("destroy index --name=" + indexName);
        }
        this.execCommand(cmdCreateIndexBuilder.toString());
        this.checkRegionOption(CMD_DESTROY_INDEX, regionOption, false);
        this.execCommand(cmdCreateIndexBuilder.toString());
        this.checkRegionOption(CMD_DESTROY_INDEX, regionOption, true);
        String expectedOutput = "\"destroy index\" requires that one or more parameters be provided.";
        this.checkCommand(CMD_DESTROY_INDEX, expectedOutput);
        Log.getLogWriter().info("cmdDestroyIndexTest-Name");
        this.execCommand(cmdCreateIndexBuilder.toString());
        String invalid = "invalid";
        StringBuilder cmdBuilder = new StringBuilder(CMD_DESTROY_INDEX).append(PARM_PREFIX).append(PARM_NAME).append(PARM_VALUE_SEP);
        String[][] expectedText = new String[][]{{"Index \"" + invalid + "\" could not be destroyed for following reasons", "Index named \"" + invalid + "\" not found.", "Occurred on following members", "1."}, {null, null, null, null}};
        this.checkOutputLines(cmdBuilder.toString() + invalid, expectedText);
        String[][] successText = new String[][]{{"Index \"" + indexName + "\" successfully destroyed on the following members", "1."}, {null, null}};
        this.checkOutputLines(cmdBuilder.toString() + indexName, successText);
        Log.getLogWriter().info("cmdDestroyIndexTest-Region");
        this.execCommand(cmdCreateIndexBuilder.toString());
        cmdBuilder = new StringBuilder(CMD_DESTROY_INDEX).append(PARM_PREFIX).append(PARM_REGION).append(PARM_VALUE_SEP);
        expectedText = new String[][]{{"Indexes could not be destroyed for following reasons", "Region \"" + invalid + "\" not found.", "Occurred on following members", "1."}, {null, null, null, null}};
        this.checkOutputLines(cmdBuilder.toString() + invalid, expectedText);
        successText[0][0] = "Indexes on region : " + aRegion + " successfully destroyed on the following members";
        this.checkOutputLines(cmdBuilder.toString() + aRegion, successText);
        Log.getLogWriter().info("cmdDestroyIndexTest-Member");
        this.execCommand(cmdCreateIndexBuilder.toString() + PARM_PREFIX + PARM_MEMBER + PARM_VALUE_SEP + memberName);
        cmdBuilder = new StringBuilder(CMD_DESTROY_INDEX).append(PARM_PREFIX).append(PARM_MEMBER).append(PARM_VALUE_SEP);
        successText[0][0] = "Indexes successfully destroyed on the following members";
        this.checkOutputLines(cmdBuilder.toString() + memberName, successText);
        Log.getLogWriter().info("cmdDestroyIndexTest-Group");
        String indexGroup = this.getAvailableGroupName();
        this.execCommand(cmdCreateIndexBuilder.toString() + PARM_PREFIX + PARM_GROUP + PARM_VALUE_SEP + indexGroup);
        cmdBuilder = new StringBuilder(CMD_DESTROY_INDEX).append(PARM_PREFIX).append(PARM_GROUP).append(PARM_VALUE_SEP);
        this.checkOutputLines(cmdBuilder.toString() + indexGroup, successText);
        Log.getLogWriter().info("cmdDestroyIndexTest-End");
    }

    private void destroyRegionTest() {
        String region = "/persist_colAnchorPR_1";
        String expectedResult = "Error occurred while destroying region \"" + region + "\". Reason: The parent region [/persist_colAnchorPR_1] in colocation chain cannot be destroyed, unless all its children [/persist_colPR_3, /persist_colPR_4, /persist_colPR_5, /persist_colPR_6] are destroyed";
        this.checkCommand("destroy region --name=" + region, expectedResult);
        region = "persist_colAnchorPR_1";
        expectedResult = "Error occurred while destroying region \"" + region + "\". Reason: The parent region [/persist_colAnchorPR_1] in colocation chain cannot be destroyed, unless all its children [/persist_colPR_3, /persist_colPR_4, /persist_colPR_5, /persist_colPR_6] are destroyed";
        this.checkCommand("destroy region --name=" + region, expectedResult);
    }

    private void cmdShowDeadLockTest() {
        Log.getLogWriter().info("cmdShowDeadLockTest-Start");
        CmdOptionInfo fileOption = new CmdOptionInfo(PARM_FILE, "Invalid file type, the file extension must be \".txt\"", "file.txt", true, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{fileOption};
        this.checkNamedParams(CMD_SHOW_DEADLOCKS, options);
        this.checkMultiLineExecution(CMD_SHOW_DEADLOCKS, options);
        String filename = "deadlock.txt";
        String command = "show dead-locks --file=" + filename;
        String outputText = this.execCommand(command);
        String msg_no_dead_lock_found = "No dead lock detected.\n\nPlease view the dependencies between the members in file : deadlock.txt";
        if (!outputText.trim().equals("No dead lock detected.\n\nPlease view the dependencies between the members in file : deadlock.txt")) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText, "No dead lock detected.\n\nPlease view the dependencies between the members in file : deadlock.txt"));
        }
        this.checkFileCreation(command, filename);
        Log.getLogWriter().info("cmdShowDeadLockTest-End");
    }

    private void cmdShowMetricsTest() {
        Log.getLogWriter().info("cmdShowMetricsTest-Start");
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", memberName, false, false);
        CmdOptionInfo regionOption = new CmdOptionInfo(PARM_REGION, "Unable to retrieve metrics : Distributed Region MBean for /%1 not found", this.getRandomRegion(), false, false);
        CmdOptionInfo fileOption = new CmdOptionInfo(PARM_FILE, "Invalid file type, the file extension must be \".csv\"", "", false, false);
        CmdOptionInfo portOption = new CmdOptionInfo(PARM_PORT, "If the --port parameter is specified, then the --member parameter must also be specified.", "", false, false);
        CmdOptionInfo categoriesOption = new CmdOptionInfo(PARM_CATEGORIES, "Invalid Categories\n%1", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{memberOption, regionOption, fileOption, portOption, categoriesOption};
        this.checkNamedParams(CMD_SHOW_METRICS, options);
        this.checkMultiLineExecution(CMD_SHOW_METRICS, options);
        this.checkRegionOption(CMD_SHOW_METRICS, regionOption, false);
        this.checkRegionOption(CMD_SHOW_METRICS, regionOption, true);
        StringBuilder cmdBuilder = new StringBuilder(CMD_SHOW_METRICS);
        String expectedTitle = "Cluster-wide Metrics";
        String[][] expectedText = new String[][]{{expectedTitle, "", "Category", "-", "cluster", "cache", "| totalRegionCount", "| totalMissCount", "| totalHitCount", "diskstore", "| diskReadsRate", "| diskWritesRate", "| flushTimeAvgLatency", "| totalBackupInProgress", "query", "| queryRequestRate"}, {null, null, "Value", "-", null, null, null, null, null, null, null, null, null, null, null, null}};
        String command = cmdBuilder.toString();
        String outputText = this.checkOutputLines(command, expectedText);
        String[] categories = new String[]{"cluster", "cache", "diskstore", "query"};
        this.showMetricsCategoriesTest(categories, command, outputText, expectedTitle, null);
        Log.getLogWriter().info("cmdShowMetricsTest-Export-Report-to");
        String filename = "clusterWideMetrics.txt";
        cmdBuilder.append(PARM_PREFIX).append(PARM_FILE).append(PARM_VALUE_SEP);
        command = cmdBuilder.toString() + filename;
        this.checkCommand(command, "Invalid file type, the file extension must be \".csv\"");
        filename = "clusterWideMetrics.csv";
        command = cmdBuilder.toString() + filename;
        expectedText = new String[][]{{expectedTitle, "", "Category", "-", "cluster", "cache", "| totalRegionCount", "| totalMissCount", "| totalHitCount", "diskstore", "| diskReadsRate", "| diskWritesRate", "| flushTimeAvgLatency", "| totalBackupInProgress", "query", "| queryRequestRate", "", "Cluster wide metrics exported to"}, {null, null, "Value", "-", null, null, null, null, null, null, null, null, null, null, null, null, null, filename + "."}};
        outputText = this.checkOutputLines(command, expectedText);
        this.checkFileCreation(command, filename);
        this.showMetricsCategoriesTest(categories, command, outputText, expectedTitle, filename);
        Log.getLogWriter().info("cmdShowMetricsTest-Member");
        cmdBuilder = new StringBuilder(CMD_SHOW_METRICS).append(PARM_PREFIX).append(PARM_MEMBER).append(PARM_VALUE_SEP);
        expectedTitle = "Member Metrics";
        expectedText = new String[][]{{expectedTitle, "", "Category", "-", PARM_MEMBER}, {null, null, "Value", "-", null}};
        categories = new String[]{"communication", "diskstore", "distribution", "eviction", "function", "jvm", "lock", PARM_MEMBER, PARM_REGION, "serialization", "transaction"};
        String memberOne = null;
        String memberTwo = null;
        Map sharedMap = CommandBB.getBB().getSharedMap().getMap();
        for (String key : sharedMap.keySet()) {
            if (!key.startsWith(memberNameKeyPrefix) && !key.startsWith(memberIdKeyPrefix)) continue;
            String value = (String)sharedMap.get(key);
            command = cmdBuilder.toString() + value;
            outputText = this.checkOutputLines(command, expectedText);
            this.showMetricsCategoriesTest(categories, command, outputText, expectedTitle, filename);
            if (!key.startsWith(memberNameKeyPrefix)) continue;
            if (memberOne == null) {
                memberOne = value;
                continue;
            }
            if (memberTwo != null) continue;
            memberTwo = value;
        }
        Log.getLogWriter().info("cmdShowMetricsTest-Region");
        cmdBuilder = new StringBuilder(CMD_SHOW_METRICS).append(PARM_PREFIX).append(PARM_REGION).append(PARM_VALUE_SEP);
        expectedTitle = "Cluster-wide Region Metrics";
        expectedText = new String[][]{{expectedTitle, "", "Category", "-", "cluster"}, {null, null, "Value", "-", null}};
        categories = new String[]{"callback", "cluster", "diskstore", "eviction", "partition", PARM_REGION};
        String regionOne = null;
        String regionTwo = null;
        for (String key : (Set)CommandBB.getBB().getSharedMap().get(regionNamesKey)) {
            command = cmdBuilder.toString() + key;
            outputText = this.checkOutputLines(command, expectedText);
            this.showMetricsCategoriesTest(categories, command, outputText, expectedTitle, filename);
            if (regionOne == null) {
                regionOne = key;
                continue;
            }
            if (regionTwo != null) continue;
            regionTwo = key;
        }
        Log.getLogWriter().info("cmdShowMetricsTest-Member And Region");
        cmdBuilder = new StringBuilder(CMD_SHOW_METRICS).append(PARM_PREFIX).append(PARM_REGION).append(PARM_VALUE_SEP).append(regionOne);
        cmdBuilder.append(PARM_PREFIX).append(PARM_MEMBER).append(PARM_VALUE_SEP).append(memberOne);
        expectedTitle = "Metrics for region:" + regionOne + " On Member " + memberOne;
        expectedText = new String[][]{{expectedTitle, "", "Category", "-", PARM_REGION}, {null, null, "Value", "-", null}};
        categories = new String[]{"callback", "eviction", "diskstore", "partition", PARM_REGION};
        command = cmdBuilder.toString();
        outputText = this.checkOutputLines(command, expectedText);
        this.showMetricsCategoriesTest(categories, command, outputText, expectedTitle, filename);
        Log.getLogWriter().info("cmdShowMetricsTest-End");
    }

    private void showMetricsCategoriesTest(String[] categories, String baseCommand, String outputText, String expectedTitle, String filename) {
        StringBuilder error;
        String command;
        Log.getLogWriter().info("showMetricsCategoriesTest-Start");
        for (String aCategory : categories) {
            if (outputText.contains(aCategory)) continue;
            StringBuilder error2 = new StringBuilder("Command '").append(baseCommand).append("' returned unexpected output:'");
            error2.append(outputText).append("'.  Expected output should contain:'").append(aCategory).append("'.");
            CommandTest.saveError(cmdErrorKey, error2);
        }
        baseCommand = baseCommand + PARM_PREFIX + PARM_CATEGORIES + PARM_VALUE_SEP;
        String multipleCategories = new String();
        for (String aCategory : categories) {
            multipleCategories = multipleCategories + aCategory + ",";
            command = baseCommand + aCategory;
            outputText = this.execCommand(command, false)[0];
            if (!outputText.startsWith(expectedTitle)) {
                error = new StringBuilder("Command '").append(command).append("' returned unexpected output:'");
                error.append(outputText).append("'.  Expected output should start with:'").append(expectedTitle).append("'.");
                CommandTest.saveError(cmdErrorKey, error);
            } else if (!outputText.contains(aCategory)) {
                error = new StringBuilder("Command '").append(command).append("' returned unexpected output:'");
                error.append(outputText).append("'.  Expected output should contain:'").append(aCategory).append("'.");
                CommandTest.saveError(cmdErrorKey, error);
            }
            if (null == filename) continue;
            this.checkFileCreation(command, filename);
        }
        command = baseCommand + multipleCategories;
        outputText = this.execCommand(command, false)[0];
        if (!outputText.startsWith(expectedTitle)) {
            StringBuilder error3 = new StringBuilder("Command '").append(command).append("' returned unexpected output:'");
            error3.append(outputText).append("'.  Expected output should start with:'").append(expectedTitle).append("'.");
            CommandTest.saveError(cmdErrorKey, error3);
        } else {
            for (String aCategory : categories) {
                if (outputText.contains(aCategory)) continue;
                error = new StringBuilder("Command '").append(command).append("' returned unexpected output:'");
                error.append(outputText).append("'.  Expected output should contain:'").append(aCategory).append("'.");
                CommandTest.saveError(cmdErrorKey, error);
            }
        }
        if (null != filename) {
            this.checkFileCreation(command, filename);
        }
        Log.getLogWriter().info("showMetricsCategoriesTest-End");
    }

    private void cmdExportStackTraceTest() {
        Log.getLogWriter().info("cmdExportStackTraceTest-Start");
        String filename = "stacktrace.txt";
        CmdOptionInfo fileOption = new CmdOptionInfo(PARM_FILE, "", filename, true, false);
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "Member %1 could not be found.  Please verify the member name or ID and try again.", memberName, false, false);
        String groupName = this.getAvailableGroupName();
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "No caching members for group %1 could be found.  Please verify the group and try again.", groupName, false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{fileOption, memberOption, groupOption};
        this.checkNamedParams(CMD_EXPORT_STACKTRACES, options);
        this.checkMultiLineExecution(CMD_EXPORT_STACKTRACES, options);
        StringBuilder commandBuilder = new StringBuilder(CMD_EXPORT_STACKTRACES).append(PARM_PREFIX).append(PARM_FILE).append(PARM_VALUE_SEP);
        String command = commandBuilder.toString() + filename;
        String[][] expectedText = new String[][]{{"stack-trace(s) exported to file: ", "On host :"}, {filename, null}};
        this.checkOutputLines(command, expectedText);
        this.checkFileCreation(command, filename);
        filename = "stacktrace_" + memberName + ".txt";
        command = commandBuilder.toString() + filename + PARM_PREFIX + PARM_MEMBER + PARM_VALUE_SEP + memberName;
        expectedText[1][0] = filename;
        this.checkOutputLines(command, expectedText);
        this.checkFileCreation(command, filename);
        filename = "stacktrace_" + groupName + ".txt";
        command = commandBuilder.toString() + filename + PARM_PREFIX + PARM_GROUP + PARM_VALUE_SEP + groupName;
        expectedText[1][0] = filename;
        this.checkOutputLines(command, expectedText);
        this.checkFileCreation(command, filename);
        filename = "stacktrace_" + memberName + "_" + groupName + ".txt";
        command = commandBuilder.toString() + filename + PARM_PREFIX + PARM_MEMBER + PARM_VALUE_SEP + memberName + PARM_PREFIX + PARM_GROUP + PARM_VALUE_SEP + groupName;
        String expectedOutput = "Please provide either \"member\" or \"group\" option.";
        this.checkCommand(command, expectedOutput);
        Log.getLogWriter().info("cmdExportStackTraceTest-End");
    }

    private void cmdExportConfigTest() {
        Log.getLogWriter().info("cmdExportConfigTest-Start");
        CmdOptionInfo memberOption = new CmdOptionInfo(PARM_MEMBER, "", "", false, false);
        CmdOptionInfo groupOption = new CmdOptionInfo(PARM_GROUP, "", "", false, false);
        CmdOptionInfo dirOption = new CmdOptionInfo(PARM_DIR, "", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{memberOption, groupOption, dirOption};
        this.checkNamedParams(CMD_EXPORT_CONFIG, options);
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        memberOption.setValidValue(memberName);
        dirOption.setValidValue(".");
        this.checkMultiLineExecution(CMD_EXPORT_CONFIG, options);
        Log.getLogWriter().info("cmdExportConfigTest-End");
    }

    private void cmdStatusLocatorTest() {
        Log.getLogWriter().info("cmdStatusLocatorTest-Start");
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "No Locator with member name or ID %1 could be found.", "", false, false);
        CmdOptionInfo hostOption = new CmdOptionInfo(PARM_HOST, "The hostname/IP address to which the Locator will be bound is unknown.", "", false, false);
        CmdOptionInfo portOption = new CmdOptionInfo(PARM_PORT, "Value \"%1\" is not applicable for \"port\".", "", false, false);
        CmdOptionInfo pidOption = new CmdOptionInfo(PARM_PID, "Value \"%1\" is not applicable for \"pid\".", "", false, false);
        CmdOptionInfo dirOption = new CmdOptionInfo(PARM_DIR, "The working directory for the Locator could not be found.", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption, hostOption, portOption, pidOption, dirOption};
        this.checkNamedParams(CMD_STATUS_LOCATOR, options);
        Integer vmId = this.getRandomLocatorVmId();
        DistributedSystemHelper.Endpoint dsEndpoint = this.getLocatorInfo(vmId);
        String locatorHost = dsEndpoint.getHost();
        hostOption.setValidValue(locatorHost);
        String locatorPort = new Integer(dsEndpoint.getPort()).toString();
        portOption.setValidValue(locatorPort);
        options = new CmdOptionInfo[]{hostOption, portOption};
        this.checkMultiLineExecution(CMD_STATUS_LOCATOR, options);
        String[][] expectedText = new String[][]{{"Locator in"}, {"is currently not responding."}};
        this.checkOutputLines(CMD_STATUS_LOCATOR, expectedText);
        String locatorName = dsEndpoint.getName();
        expectedText = new String[][]{{"No Locator with member name or ID " + locatorName}, {"could be found."}};
        this.checkOutputLines("status locator --name=" + locatorName, expectedText);
        expectedText = new String[][]{{"Locator in"}, {"is currently not responding."}};
        this.checkOutputLines("status locator --host=" + locatorHost, expectedText);
        expectedText = new String[][]{{"Locator in"}, {"is currently online."}};
        this.checkOutputLines("status locator --port=" + locatorPort, expectedText);
        this.checkOutputLines("status locator --host=" + locatorHost + PARM_PREFIX + PARM_PORT + PARM_VALUE_SEP + locatorPort, expectedText);
        Log.getLogWriter().info("cmdStatusLocatorTest-End");
    }

    private void cmdStatusServerTest() {
        Log.getLogWriter().info("cmdStatusServerTest-Start");
        CmdOptionInfo nameOption = new CmdOptionInfo(PARM_NAME, "No GemFire Cache Server with member name or ID %1 could be found.", "", false, false);
        CmdOptionInfo pidOption = new CmdOptionInfo(PARM_PID, "Value \"%1\" is not applicable for \"pid\".", "", false, false);
        CmdOptionInfo dirOption = new CmdOptionInfo(PARM_DIR, "The working directory for the Server could not be found.", "", false, false);
        CmdOptionInfo[] options = new CmdOptionInfo[]{nameOption, pidOption, dirOption};
        this.checkNamedParams(CMD_STATUS_SERVER, options);
        this.checkMultiLineExecution(CMD_STATUS_SERVER, options);
        String[][] expectedText = new String[][]{{"Server in"}, {"is currently not responding."}};
        this.checkOutputLines(CMD_STATUS_SERVER, expectedText);
        String member = this.getRandomMember();
        expectedText = new String[][]{{"No GemFire Cache Server with member name or ID " + member}, {"could be found."}};
        this.checkOutputLines("status server --name=" + member, expectedText);
        Log.getLogWriter().info("cmdStatusServerTest-End");
    }

    private void cmdDescribeConnectionTest() {
        Log.getLogWriter().info("cmdDescribeConnectionTest-Start");
        this.checkNamedParams(CMD_DESCRIBE_CONNECTION);
        String[][] expectedText = new String[][]{{"Connection", "-"}, {"Endpoints", "-", "]"}};
        this.checkOutputLines(CMD_DESCRIBE_CONNECTION, expectedText);
        Log.getLogWriter().info("cmdDescribeConnectionTest-End");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAvailableGroupName() {
        if (definedGroups == null) {
            definedGroups = new ArrayList<String>();
            CommandTest commandTest = this;
            synchronized (commandTest) {
                HashSet groupSet = new HashSet();
                Map sharedMap = CommandBB.getBB().getSharedMap().getMap();
                for (Object key : sharedMap.keySet()) {
                    if (!(key instanceof String) || !((String)key).startsWith(groupsKeyPrefix)) continue;
                    groupSet.addAll((List)sharedMap.get(key));
                }
                definedGroups.addAll(groupSet);
                Log.getLogWriter().info("definedGroups initialized to: " + definedGroups);
            }
        }
        if (definedGroups.size() > 0) {
            return definedGroups.get(TestConfig.tab().getRandGen().nextInt(0, definedGroups.size() - 1));
        }
        return null;
    }

    private String getRandomManagingMember() {
        Map managersMap = (Map)FederationBlackboard.getBB().getSharedMap().get("MANAGERS");
        if (managersMap == null || managersMap.size() == 0) {
            throw new TestException("Test problem; MANAGERS key in blackboard has value " + managersMap);
        }
        ArrayList managingMembers = new ArrayList();
        managingMembers.addAll(managersMap.keySet());
        int randInt = TestConfig.tab().getRandGen().nextInt(0, managingMembers.size() - 1);
        String chosen = (String)managingMembers.get(randInt);
        Log.getLogWriter().info("Randomly chose managing member " + chosen + PARM_SPACE + managersMap.get(chosen));
        return chosen;
    }

    private String getRandomMember() {
        Map memberMap = FederationBlackboard.getBB().getMemberONs();
        if (memberMap == null || memberMap.size() == 0) {
            throw new TestException("Test problem; MEMBERS vmID in blackboard has value " + memberMap);
        }
        ArrayList members = new ArrayList();
        members.addAll(memberMap.keySet());
        int randInt = TestConfig.tab().getRandGen().nextInt(0, members.size() - 1);
        String chosen = (String)members.get(randInt);
        Log.getLogWriter().info("Randomly chose member " + chosen + PARM_SPACE + memberMap.get(chosen));
        return chosen;
    }

    private String getRandomRegion() {
        Set allRegions = (Set)CommandBB.getBB().getSharedMap().get(regionNamesKey);
        if (allRegions == null || allRegions.size() == 0) {
            throw new TestException("Test problem; There are not 'regions' in the blackboard. " + allRegions);
        }
        ArrayList regionList = new ArrayList();
        regionList.addAll(allRegions);
        int randInt = TestConfig.tab().getRandGen().nextInt(0, regionList.size() - 1);
        String chosen = (String)regionList.get(randInt);
        Log.getLogWriter().info("Randomly chose region '" + chosen + "'.");
        return chosen;
    }

    private Integer getRandomLocatorVmId() {
        Log.getLogWriter().info("getRandomLocatorVmId-Start");
        Map locatorVmIdMap = (Map)CommandBB.getBB().getSharedMap().get(locatorVmIdsKey);
        if (locatorVmIdMap == null) {
            throw new TestException("Test problem; There are not 'locators' in the blackboard. " + locatorVmIdMap);
        }
        ArrayList<Integer> vmIds = new ArrayList<Integer>();
        for (Integer key : locatorVmIdMap.keySet()) {
            vmIds.add(key);
        }
        int index = TestConfig.tab().getRandGen().nextInt(0, vmIds.size() - 1);
        Integer vmId = (Integer)vmIds.get(index);
        Log.getLogWriter().info("getRandomLocatorVmId-End-vmId=" + vmId);
        return vmId;
    }

    private DistributedSystemHelper.Endpoint getLocatorInfo(Integer vmId) {
        Log.getLogWriter().info("getLocatorInfo-Start");
        Object value = DistributedSystemBlackboard.getInstance().getSharedMap().get(vmId);
        Log.getLogWriter().info("getLocatorInfo-value=" + value);
        if (value == null || !(value instanceof DistributedSystemHelper.Endpoint)) {
            throw new TestException("Could not find endpoint for vmId " + vmId + " in " + DistributedSystemBlackboard.class.getName() + ", value in bb is " + (value == null ? "null" : value.getClass().getName()));
        }
        DistributedSystemHelper.Endpoint dsEndpoint = (DistributedSystemHelper.Endpoint)value;
        return dsEndpoint;
    }

    private String getMemberInfo(String vmID) {
        Log.getLogWriter().info("getMemberInfo: vmID=|" + vmID + "|");
        Map memberMap = FederationBlackboard.getBB().getMemberONs();
        if (memberMap == null || memberMap.size() == 0) {
            throw new TestException("Test problem; MEMBERS vmID in blackboard has value " + memberMap);
        }
        String memberInfo = (String)memberMap.get(vmID);
        Log.getLogWriter().info("Member Info for " + vmID + PARM_VALUE_SEP + memberInfo);
        return memberInfo;
    }

    private String parseMemberName(String memberInfo) {
        Log.getLogWriter().info("parseMemberName: memberInfo=|" + memberInfo + "|");
        int expStart = memberInfo.lastIndexOf(PARM_VALUE_SEP);
        if (expStart < 0) {
            throw new TestException("Unexpected format of memberInfo line: " + memberInfo);
        }
        String rtnStr = memberInfo.substring(expStart + 1).trim();
        Log.getLogWriter().info("parseMemberName: rtnStr=|" + rtnStr + "|");
        return rtnStr;
    }

    private String findDiskStoreName(String mbrName, String listDiskStoreOutput) {
        Log.getLogWriter().info("findDiskStoreName-Start-mbrName='" + mbrName + "', listDiskStoreOutput='" + listDiskStoreOutput + "'");
        int start = listDiskStoreOutput.indexOf(mbrName);
        start = listDiskStoreOutput.indexOf("|", listDiskStoreOutput.indexOf("|", start + 1) + 1);
        String diskStoreName = "ds";
        start = listDiskStoreOutput.indexOf(diskStoreName, start + 1) + diskStoreName.length();
        int end = listDiskStoreOutput.indexOf(PARM_SPACE, start + 1);
        diskStoreName = diskStoreName + listDiskStoreOutput.substring(start, end);
        Log.getLogWriter().info("findDiskStoreName-End-diskStoreName='" + diskStoreName + "'");
        return diskStoreName;
    }

    private void connectToManagingNode(String vmID) {
        Log.getLogWriter().info("connectToManagingNode: vmID=" + vmID);
        String url = FederationBlackboard.getBB().getManagingNode(vmID);
        Pattern MY_PATTERN = Pattern.compile("service:jmx:rmi:///jndi/rmi://(.*?):(.*?)/jmxrmi");
        Matcher m = MY_PATTERN.matcher(url);
        String endpoint = null;
        while (m.find()) {
            String s = m.group(1);
            String s2 = m.group(2);
            endpoint = s + "[" + s2 + "]";
        }
        Log.getLogWriter().info("Connecting shell " + this.shell + " to managing node hosted at url " + url);
        this.execCommand("connect --jmx-manager=" + endpoint);
        boolean connected = this.shell.isConnectedAndReady();
        if (!connected) {
            throw new TestException("connect command failed to connect to manager " + endpoint);
        }
        Log.getLogWriter().info("Successfully connected to managing node ");
        String searchStr = "vmId";
        this.shellManagerMemberVmId = Integer.valueOf(vmID.substring(vmID.indexOf(searchStr) + searchStr.length()));
    }

    private void checkCommand(String command, String expectedOutput) {
        String outputText = this.execCommand(command, false)[0];
        if (!outputText.equals(expectedOutput)) {
            CommandTest.saveError(cmdErrorKey, this.formatExceptionText(command, outputText, expectedOutput));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCommand(String command, CommandOutputValidator validator) {
        try {
            Map<String, Object> commandOutput = this.executeCommand(command);
            if (!validator.validate(commandOutput)) {
                Log.getLogWriter().info("Error while validating command output for command " + command + " : " + validator.getFormattedErrors());
                CommandTest.saveError(cmdErrorKey, new StringBuilder(validator.getFormattedErrors()));
            }
        }
        finally {
            Log.getLogWriter().info("Calling clearEvents() on " + this.shell);
            this.shell.clearEvents();
        }
    }

    private Map<String, Object> executeCommand(String command) {
        long duration = this.runCommand(command);
        Log.getLogWriter().info("execCommand-shell.getCompletorOutput() for " + command + PARM_VALUE_SEP + this.shell.getCompletorOutput());
        Map<String, Object> commandOutput = this.shell.getCommandOutput();
        Log.getLogWriter().info("execCommand-commandOutput for " + command + PARM_VALUE_SEP + commandOutput);
        return commandOutput;
    }

    private String checkOutputLines(String command, String[][] expectedText) {
        StringBuilder error;
        int expectedNbrOfLines;
        Log.getLogWriter().info("checkOutputLines-Start");
        String outputText = this.execCommand(command, false)[0];
        String[] outputLines = outputText.split("\n");
        int n = expectedNbrOfLines = expectedText[0].length > expectedText[1].length ? expectedText[0].length : expectedText[1].length;
        if (outputLines.length < expectedNbrOfLines) {
            error = new StringBuilder("Command output format is incorrect for command '");
            error.append(command);
            error.append("'.  Was expecting at least ");
            error.append(expectedText.length);
            error.append(" lines of output, but received:'");
            error.append(outputLines.length);
            error.append("'.");
            CommandTest.saveError(cmdErrorKey, error);
        }
        String[] expectedStartsWith = expectedText[0];
        String[] expectedEndsWith = expectedText[1];
        for (int i = 0; i < outputLines.length && (i != expectedStartsWith.length || i != expectedEndsWith.length); ++i) {
            String outputLine = outputLines[i].trim();
            if (i < expectedStartsWith.length && null != expectedStartsWith[i] && !outputLine.startsWith(expectedStartsWith[i])) {
                error = new StringBuilder("Line ").append(i + 1);
                error.append(" of the output is incorrect for command: |").append(command);
                error.append("|\nWas expecting it to start with: |").append(expectedStartsWith[i]);
                error.append("|\nbut received: |").append(outputLine).append("|");
                CommandTest.saveError(cmdErrorKey, error);
            }
            if (i >= expectedEndsWith.length || null == expectedEndsWith[i] || outputLine.endsWith(expectedEndsWith[i])) continue;
            error = new StringBuilder("Line ").append(i + 1);
            error.append(" of the output is incorrect for command: |").append(command);
            error.append("|\nWas expecting it to end with: |").append(expectedEndsWith[i]);
            error.append("|\nbut received: |").append(outputLine).append("|");
            CommandTest.saveError(cmdErrorKey, error);
        }
        Log.getLogWriter().info("checkOutputLines-End");
        return outputText;
    }

    private StringBuilder formatExceptionText(String command, String receivedText) {
        return this.formatExceptionText(command, receivedText, null);
    }

    private StringBuilder formatExceptionText(String command, String receivedText, String expectedText) {
        return CommandTest.formatExceptionTextDifference(command, receivedText, expectedText);
    }

    private static StringBuilder formatExceptionTextDifference(String command, String receivedText, String expectedText) {
        StringBuilder bldr = new StringBuilder("\nCommand:|");
        bldr.append(command);
        bldr.append("|\nReturned unexpected output: |");
        bldr.append(receivedText);
        if (expectedText != null) {
            bldr.append("|\nExpected output: |");
            bldr.append(expectedText);
        }
        int z = 0;
        for (z = 0; z < expectedText.length() && z < receivedText.length() && receivedText.charAt(z) == expectedText.charAt(z); ++z) {
        }
        bldr.append("|\nMatching text was: |");
        bldr.append(receivedText.substring(0, z));
        bldr.append("|");
        return bldr;
    }

    private void checkNamedParams(String command) {
        this.checkNamedParams(command, new CmdOptionInfo[0]);
    }

    private void checkNamedParams(String command, CmdOptionInfo[] options) {
        String expectedOutput;
        StringBuilder cmdBuilder;
        Log.getLogWriter().info("checkNamedParams-Start");
        String badValue = "badValue";
        String badOption = "badOption";
        StringBuilder errBuilder = null;
        boolean haveRequiredOptions = false;
        for (CmdOptionInfo option : options) {
            if (!option.isRequired()) continue;
            haveRequiredOptions = true;
            break;
        }
        StringBuilder reqOpts = null;
        if (haveRequiredOptions) {
            errBuilder = new StringBuilder();
            for (CmdOptionInfo option : options) {
                if (!option.isRequired()) continue;
                if (errBuilder.length() > 0) {
                    errBuilder.append("\n");
                }
                errBuilder.append("Parameter \"").append(option.getName()).append("\" is required. Use \"help <command name>\" for assistance.");
            }
            this.checkCommand(command, errBuilder.toString());
            cmdBuilder = new StringBuilder(command).append(PARM_PREFIX).append(badOption);
            errBuilder.append("\nParameter ").append(badOption).append(" is not applicable for ").append(command);
            expectedOutput = errBuilder.toString();
            this.checkCommand(cmdBuilder.toString(), expectedOutput);
            cmdBuilder.append(PARM_VALUE_SEP);
            this.checkCommand(cmdBuilder.toString(), expectedOutput);
            cmdBuilder.append(badValue);
            this.checkCommand(cmdBuilder.toString(), expectedOutput);
            for (CmdOptionInfo option : options) {
                String errorMsg;
                if (!option.isRequired() || null == (errorMsg = option.getErrorMsg()) || errorMsg.length() <= 0) continue;
                cmdBuilder = new StringBuilder(command).append(PARM_PREFIX).append(option.getName()).append(PARM_VALUE_SEP).append(badValue);
                expectedOutput = option.getErrorMsg().replace("%1", badValue);
                this.checkCommand(cmdBuilder.toString(), expectedOutput);
            }
            reqOpts = new StringBuilder();
            for (CmdOptionInfo option : options) {
                if (!option.isRequired()) continue;
                reqOpts.append(PARM_PREFIX).append(option.getName()).append(PARM_VALUE_SEP).append(option.getValidValue());
            }
        }
        for (CmdOptionInfo option : options) {
            if (option.isRequired()) continue;
            expectedOutput = "Value is required for parameter \"" + option.getName() + "\"";
            cmdBuilder = new StringBuilder(command);
            if (reqOpts != null) {
                cmdBuilder.append((CharSequence)reqOpts);
            }
            cmdBuilder.append(PARM_PREFIX).append(option.getName());
            if (!option.isBoolean()) {
                this.checkCommand(cmdBuilder.toString(), expectedOutput);
            }
            cmdBuilder.append(PARM_VALUE_SEP);
            this.checkCommand(cmdBuilder.toString(), expectedOutput);
            expectedOutput = option.isBoolean() ? (command.equals(CMD_ALTER_RUNTIME) && option.getName().equals("enable-statistics") ? "Value for enable-statistics must be either \"true\" or \"false\"" : "Value \"" + badValue + "\" is not applicable for \"" + option.getName() + "\".") : option.getErrorMsg().replace("%1", badValue);
            cmdBuilder.append(badValue);
            if (command.equals(CMD_DESTROY_INDEX) && (option.getName().equals(PARM_NAME) || option.getName().equals(PARM_REGION)) || command.equals(CMD_REMOVE) && option.getName().equals(PARM_KEY)) {
                this.checkOutputLines(cmdBuilder.toString(), new String[][]{{expectedOutput}, new String[0]});
                continue;
            }
            this.checkCommand(cmdBuilder.toString(), expectedOutput);
        }
        errBuilder = new StringBuilder("Parameter ").append(badOption).append(" is not applicable for ").append(command);
        expectedOutput = errBuilder.toString();
        cmdBuilder = new StringBuilder(command);
        if (reqOpts != null) {
            cmdBuilder.append((CharSequence)reqOpts);
        }
        cmdBuilder.append(PARM_PREFIX).append(badOption);
        this.checkCommand(cmdBuilder.toString(), expectedOutput);
        cmdBuilder.append(PARM_VALUE_SEP);
        this.checkCommand(cmdBuilder.toString(), expectedOutput);
        cmdBuilder.append(badValue);
        this.checkCommand(cmdBuilder.toString(), expectedOutput);
        Log.getLogWriter().info("checkNamedParams-End");
    }

    private void checkMultiLineExecution(String command, CmdOptionInfo[] options) {
        Log.getLogWriter().info("checkMultiLineExecution-Start");
        HostHelper.OSType osType = HostHelper.getLocalHostOS();
        if (HostHelper.isWindows()) {
            CommandTest.saveError(cmdErrorKey, new StringBuilder("Bug #46388 Detected - command continuation character '\\' not working on windows."));
        } else {
            CommandStringBuilder singleLine = new CommandStringBuilder(command);
            CommandStringBuilder multiLine = new CommandStringBuilder(command);
            for (CmdOptionInfo option : options) {
                String validValue = option.getValidValue();
                if (null == validValue || validValue.length() <= 0) continue;
                singleLine.addOption(option.getName(), validValue);
                multiLine.addNewLine().addOption(option.getName(), validValue);
            }
            boolean hasError = this.runCommandCheckForError(multiLine.toString());
            if (hasError) {
                hasError = this.runCommandCheckForError(singleLine.toString());
                if (hasError) {
                    throw new TestException("There is a problems in the test when testing command '" + command + "' on multiple lines.");
                }
                CommandTest.saveError(cmdErrorKey, new StringBuilder("An error occurred while attempting to execute command '" + command + "' on multiple lines."));
                Log.getLogWriter().info("checkMultiLineExecution-Executing without the ML:hasError=" + hasError);
            }
        }
        Log.getLogWriter().info("checkMultiLineExecution-End");
    }

    private void checkRegionOption(String command, CmdOptionInfo regionOption, boolean withoutSlash) {
        this.checkRegionOption(command, new CmdOptionInfo[0], regionOption, withoutSlash);
    }

    private void checkRegionOption(String command, CmdOptionInfo[] reqOptions, CmdOptionInfo regionOption, boolean withoutSlash) {
        Log.getLogWriter().info("checkRegionOption-Start");
        StringBuilder reqOpts = null;
        if (reqOptions.length > 0) {
            reqOpts = new StringBuilder();
            for (CmdOptionInfo reqOption : reqOptions) {
                reqOpts.append(PARM_PREFIX).append(reqOption.getName()).append(PARM_VALUE_SEP).append(reqOption.getValidValue());
            }
        }
        StringBuilder cmdBuilder = new StringBuilder(command);
        if (reqOpts != null) {
            cmdBuilder.append((CharSequence)reqOpts);
        }
        cmdBuilder.append(PARM_PREFIX).append(regionOption.getName()).append(PARM_VALUE_SEP);
        String regionValue = regionOption.getValidValue();
        Log.getLogWriter().info("checkRegionOption-regionValue(before)" + regionValue);
        if (withoutSlash && regionValue.startsWith("/")) {
            regionValue = regionValue.substring(1);
        } else if (!withoutSlash && !regionValue.startsWith("/")) {
            regionValue = "/" + regionValue;
        }
        Log.getLogWriter().info("checkRegionOption-regionValue(after)" + regionValue);
        this.execCommand(cmdBuilder.toString() + regionValue);
        Log.getLogWriter().info("checkRegionOption-End");
    }

    private void execCommandLine(String command) {
        try {
            this.shell.addChars(command + "\n");
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private String execCommand(String command) {
        String[] resultArr = this.execCommand(command, true);
        return resultArr[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] execCommand(String command, boolean haltOnCommandFailure) {
        try {
            long duration = this.runCommand(command);
            Log.getLogWriter().info("execCommand-shell.getCompletorOutput() for " + command + PARM_VALUE_SEP + this.shell.getCompletorOutput());
            Map<String, Object> commandOutput = this.shell.getCommandOutput();
            Log.getLogWriter().info("execCommand-commandOutput for " + command + PARM_VALUE_SEP + commandOutput);
            boolean exportConfigFilesAreSaved = false;
            for (Object resultObject : commandOutput.values()) {
                if (!(resultObject instanceof CommandResult)) continue;
                CommandResult cr = (CommandResult)resultObject;
                if (cr.hasIncomingFiles() && cr.getNumTimesSaved() == 0) {
                    Log.getLogWriter().info("execCommand-cr.getNumTimesSaved()a" + cr.getNumTimesSaved());
                    try {
                        Log.getLogWriter().info("Attempting to save file for command " + command);
                        cr.saveIncomingFiles(".");
                    }
                    catch (IOException e) {
                        Log.getLogWriter().info("Could not save file for command " + command);
                    }
                    Log.getLogWriter().info("execCommand-cr.getNumTimesSaved()b" + cr.getNumTimesSaved());
                    continue;
                }
                if (!cr.hasIncomingFiles() || cr.getNumTimesSaved() <= 0 || !command.startsWith(CMD_EXPORT_CONFIG)) continue;
                exportConfigFilesAreSaved = true;
            }
            String outputText = this.shell.getOutputText().trim();
            int x = (outputText = outputText.replaceAll("\r", "")).indexOf("\n");
            if (x != -1) {
                outputText = outputText.substring(x).trim();
            }
            if (outputText.startsWith(">") && (x = outputText.indexOf("\n")) != -1) {
                outputText = outputText.substring(x).trim();
            }
            if (outputText.endsWith(">")) {
                outputText = outputText.substring(0, outputText.lastIndexOf("\n")).trim();
            }
            if (outputText.endsWith(">")) {
                outputText = outputText.substring(0, outputText.lastIndexOf("\n")).trim();
            }
            Log.getLogWriter().info("execCommand-outputText for " + command + ":\n" + outputText);
            String presentationStr = "";
            String whiteSpaceErrors = "";
            if (commandOutput.size() == 0) {
                presentationStr = this.stripSpecialCoding(command, outputText);
            } else if (exportConfigFilesAreSaved) {
                presentationStr = "Files are saved.";
            } else {
                String[] tmpArr = this.getPresentationString(commandOutput);
                presentationStr = tmpArr[0];
                whiteSpaceErrors = tmpArr[1];
            }
            this.logCommandOutput(command, presentationStr, whiteSpaceErrors, duration);
            this.checkForFatalErrors(outputText, presentationStr, whiteSpaceErrors);
            if (haltOnCommandFailure) {
                this.checkForCommandFailure(outputText, commandOutput);
            }
            Log.getLogWriter().info("execCommand-outputText for " + command + ":\n" + outputText);
            Log.getLogWriter().info("execCommand-presentationStr for " + command + ":\n" + presentationStr);
            String[] stringArray = new String[]{outputText, presentationStr};
            return stringArray;
        }
        finally {
            Log.getLogWriter().info("Calling clearEvents() on " + this.shell);
            this.shell.clearEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execHelpCommad(String command) {
        try {
            String presentationStr;
            this.runCommand(command);
            String string = presentationStr = this.getHelpPresentationString(this.shell.getCommandOutput());
            return string;
        }
        finally {
            Log.getLogWriter().info("Calling clearEvents() on " + this.shell);
            this.shell.clearEvents();
        }
    }

    private void execSleepCommad() {
        this.execSleepCommad("3");
    }

    private void execSleepCommad(String seconds) {
        try {
            this.runCommand("sleep --time=" + seconds);
        }
        finally {
            Log.getLogWriter().info("Calling clearEvents() on " + this.shell);
            this.shell.clearEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> runDataCommand(String command) {
        Log.getLogWriter().info("runDataCommand-Start-command=" + command);
        ArrayList<String> rtnLines = new ArrayList<String>();
        try {
            this.runCommand(command);
            Map<String, Object> commandOutput = this.shell.getCommandOutput();
            for (String key : commandOutput.keySet()) {
                Object value = commandOutput.get(key);
                if (!(value instanceof CommandResult)) continue;
                CommandResult cr = (CommandResult)value;
                cr.resetToFirstLine();
                while (cr.hasNextLine()) {
                    String[] lines;
                    for (String line : lines = cr.nextLine().split("\n")) {
                        rtnLines.add(line);
                    }
                }
            }
        }
        finally {
            Log.getLogWriter().info("Calling clearEvents() on " + this.shell);
            this.shell.clearEvents();
        }
        Log.getLogWriter().info("runDataCommand-End-(" + command + ")=" + rtnLines);
        return rtnLines;
    }

    private boolean runCommandCheckForError(String command) {
        Log.getLogWriter().info("runCommandCheckForError-Start-command=" + command);
        boolean hasError = false;
        try {
            this.runCommand(command);
            hasError = this.shell.hasError();
        }
        finally {
            Log.getLogWriter().info("Calling clearEvents() on " + this.shell);
            this.shell.clearEvents();
        }
        Log.getLogWriter().info("runCommandCheckForError-End-(" + command + ") hasError=" + hasError);
        return hasError;
    }

    private long runCommand(String command) {
        try {
            Log.getLogWriter().info("runCommand-Executing Command " + command + " with command Mgr " + CommandManager.getInstance());
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long duration = -1L;
        try {
            long startTime = System.currentTimeMillis();
            this.shell.addChars(command).newline();
            this.shell.waitForOutput();
            duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("Command " + command + " took " + duration + " ms");
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return duration;
    }

    private String[] getPresentationString(Map<String, Object> commandOutput) {
        Log.getLogWriter().info("getPresentationString-Start");
        StringBuilder strBldr = new StringBuilder();
        String presentationStr = new String();
        StringBuilder whiteSpaceErrors = new StringBuilder();
        for (String key : commandOutput.keySet()) {
            Object value = commandOutput.get(key);
            if (!(value instanceof CommandResult)) continue;
            CommandResult cr = (CommandResult)value;
            cr.resetToFirstLine();
            while (cr.hasNextLine()) {
                String line = cr.nextLine();
                line = line.replaceAll("\r", "");
                strBldr.append(line).append("\n");
                whiteSpaceErrors.append(this.checkForRightPadding(line));
            }
        }
        presentationStr = strBldr.toString();
        return new String[]{presentationStr, whiteSpaceErrors.toString()};
    }

    private String getHelpPresentationString(Map<String, Object> commandOutput) {
        Log.getLogWriter().info("getHelpPresentationString-Start");
        StringBuilder strBldr = new StringBuilder();
        for (String key : commandOutput.keySet()) {
            Object value = commandOutput.get(key);
            if (!(value instanceof CommandResult)) continue;
            CommandResult cr = (CommandResult)value;
            cr.resetToFirstLine();
            while (cr.hasNextLine()) {
                String line = cr.nextLine();
                strBldr.append(this.splitAndTrim(line));
            }
        }
        return strBldr.toString().trim();
    }

    private String splitAndTrim(String text) {
        String[] lines;
        Log.getLogWriter().info("splitAndTrim-Start");
        StringBuilder strBldr = new StringBuilder();
        for (String line : lines = text.split("\n")) {
            strBldr.append(line.trim());
        }
        return strBldr.toString();
    }

    private String stripSpecialCoding(String command, String text) {
        String[] outputLines;
        Log.getLogWriter().info("stripSpecialCoding-Start");
        StringBuilder strBldr = new StringBuilder();
        for (String outputLine : outputLines = text.split("\n")) {
            if (outputLine.startsWith("Cluster") || outputLine.startsWith("gfsh") || outputLine.startsWith("CommandResult") || outputLine.startsWith(command)) continue;
            strBldr.append(outputLine.trim()).append("\n");
        }
        String rtnString = strBldr.toString().trim();
        return rtnString;
    }

    private void checkForFatalErrors(String outputText, String presentationStr, String whiteSpaceErrors) {
        if (null == outputText) {
            throw new TestException("Unexpected output text:" + outputText);
        }
        if (null == presentationStr || presentationStr.contains("ERROR") || presentationStr.contains("Exception") || presentationStr.contains("null") || presentationStr.trim().length() == 0) {
            throw new TestException("Unexpected command output:" + presentationStr);
        }
        if (whiteSpaceErrors.length() > 0) {
            Log.getLogWriter().info(whiteSpaceErrors);
        }
    }

    private void checkForCommandFailure(Object commandOutput) {
        this.checkForCommandFailure(this.shell.getOutputText(), commandOutput);
    }

    private void checkForCommandFailure(String outputText, Object commandOutput) {
        if (this.shell.hasError()) {
            throw new TestException("Failed with error " + this.shell.getError());
        }
        if (outputText.contains("ERROR") || outputText.contains("Exception")) {
            throw new TestException("Unexpected output text:" + outputText);
        }
        String commandOutputStr = commandOutput.toString();
        if (null == commandOutputStr || commandOutput == null || commandOutputStr.contains("ERROR") || commandOutputStr.contains("Exception")) {
            throw new TestException("Unexpected output text:" + commandOutputStr);
        }
    }

    private String checkForRightPadding(String aStr) {
        Log.getLogWriter().info("checkForRightPadding-Start");
        String[] tokens = aStr.split("\n");
        StringBuilder errStr = new StringBuilder();
        block0: for (String line : tokens) {
            int whiteSpaceCount = 0;
            for (int i = line.length() - 1; i >= 0; --i) {
                char ch = line.charAt(i);
                if (Character.isWhitespace(ch)) {
                    ++whiteSpaceCount;
                    if (i != 0) continue;
                    errStr.append("\"").append(line).append("\" contains ").append(whiteSpaceCount).append(" white space characters on the right\n");
                    continue;
                }
                if (whiteSpaceCount <= 0) continue block0;
                errStr.append("\"").append(line).append("\" contains ").append(whiteSpaceCount).append(" white space characters on the right\n");
                continue block0;
            }
        }
        return errStr.toString();
    }

    private void checkFileCreation(String command, String filename) {
        this.checkFileCreation(command, ".", filename);
    }

    private void checkFileCreation(String command, String path, String filename) {
        File theFile;
        Log.getLogWriter().info("checkFileCreation-Start");
        if (command.startsWith(CMD_SHOW_DEADLOCKS)) {
            File[] files;
            File theDir = new File(path);
            for (File aFile : files = theDir.listFiles()) {
                Log.getLogWriter().info("checkFileCreation-aFileName:" + aFile.getName());
                if (!aFile.getName().startsWith(filename.substring(0, filename.length() - 4))) continue;
                filename = aFile.getName();
                break;
            }
        }
        if (!(theFile = new File(filename)).exists()) {
            throw new TestException("Command '" + command + "' Did not create the file '" + filename + "'.");
        }
        if (theFile.length() == 0L) {
            throw new TestException("Command '" + command + "' created the file '" + filename + "', but of zero length.");
        }
        if (theFile.exists() && (command.startsWith(CMD_SHOW_DEADLOCKS) || command.startsWith(CMD_SHOW_DEADLOCKS))) {
            theFile.renameTo(new File("processed" + filename));
        }
        Log.getLogWriter().info("checkFileCreation-End");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCommandOutput(String command, String output, String errStr, long duration) {
        StringBuilder logStr = new StringBuilder();
        logStr.append("================================================================================\n");
        logStr.append("").append(new Date()).append(" vm_").append(RemoteTestModule.getMyVmid()).append(", thr_").append(RemoteTestModule.getCurrentThread().getThreadId()).append(", pid ").append(RemoteTestModule.getMyPid());
        logStr.append("\nCommand: \"").append(command).append("\"\n");
        logStr.append("Command completed in " + duration + " ms\n");
        logStr.append("Output (starts at beginnning of next line), output length is ").append(output.length()).append(":\n").append(output).append("<--end of output\n");
        if (errStr.length() > 0) {
            logStr.append(errStr).append("\n");
        }
        logStr.append("\n");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            commandOutputFile.print(logStr.toString());
            commandOutputFile.flush();
        }
    }

    private String[] connectToLocator() {
        Map locatorVmIdMap = (Map)CommandBB.getBB().getSharedMap().get(locatorVmIdsKey);
        if (locatorVmIdMap == null) {
            throw new TestException("You must create your own locator with CommandTest.HydraTask_createLocator to connect gfsh to a locator");
        }
        ArrayList<Integer> vmIds = new ArrayList<Integer>();
        ArrayList hosts = new ArrayList();
        for (Integer key : locatorVmIdMap.keySet()) {
            vmIds.add(key);
            hosts.add(locatorVmIdMap.get(key));
        }
        int index = TestConfig.tab().getRandGen().nextInt(0, vmIds.size() - 1);
        Integer vmId = (Integer)vmIds.get(index);
        String host = (String)hosts.get(index);
        Object value = DistributedSystemBlackboard.getInstance().getSharedMap().get(vmId);
        if (value == null || !(value instanceof DistributedSystemHelper.Endpoint)) {
            throw new TestException("Could not find endpoint for vmId " + vmId + " in " + DistributedSystemBlackboard.class.getName() + ", value in bb is " + (value == null ? "null" : value.getClass().getName()));
        }
        int port = ((DistributedSystemHelper.Endpoint)value).getPort();
        String[] result = this.execCommand("connect --locator=" + host + "[" + port + "]", true);
        boolean connected = this.shell.isConnectedAndReady();
        if (!connected) {
            throw new TestException("Connect command failed to connect to locator with vmId " + vmId + " on host " + host + " using port " + port);
        }
        Log.getLogWriter().info("Successfully connected to locator ");
        return result;
    }

    private String[] connectToJMXManager(boolean useHttp) {
        Map vmIdMap = (Map)CommandBB.getBB().getSharedMap().get(jmxManagerVmIdsKey);
        if (vmIdMap == null) {
            throw new TestException("No jmxManagers found in blackboard");
        }
        ArrayList<Integer> vmIds = new ArrayList<Integer>();
        ArrayList hosts = new ArrayList();
        for (Integer key : vmIdMap.keySet()) {
            vmIds.add(key);
            hosts.add(vmIdMap.get(key));
        }
        int index = TestConfig.tab().getRandGen().nextInt(0, vmIds.size() - 1);
        Integer vmId = (Integer)vmIds.get(index);
        String host = (String)hosts.get(index);
        Object value = JMXManagerBlackboard.getInstance().getSharedMap().get(vmId);
        if (value == null || !(value instanceof JMXManagerHelper.Endpoint)) {
            throw new TestException("Could not find endpoint for vmId " + vmId + " in " + JMXManagerBlackboard.class.getName() + ", value in bb is " + (value == null ? "null" : value.getClass().getName()));
        }
        int port = -1;
        String command = null;
        if (useHttp) {
            port = ((JMXManagerHelper.Endpoint)value).getHttpPort();
            command = "connect --use-http --url=http://" + host + ":" + port + "/gemfire/v1";
        } else {
            port = ((JMXManagerHelper.Endpoint)value).getPort();
            command = "connect --jmx-manager=" + host + "[" + port + "]";
        }
        String[] result = this.execCommand(command, true);
        boolean connected = this.shell.isConnectedAndReady();
        if (!connected) {
            throw new TestException("Connect command, " + command + ", failed to connect to jmxManager with vmId " + vmId + " on host " + host + " using port " + port);
        }
        Log.getLogWriter().info("Successfully connected to jmxManager with command: " + command);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void startManagerIfRequired() {
        try {
            Cache theCache = CacheHelper.getCache();
            if (theCache == null) {
                Log.getLogWriter().info("startManagerIfRequired: Not starting a manager because there is no cache in this member");
                return;
            }
            ManagementService service = ManagementService.getManagementService((Cache)CacheHelper.getCache());
            if (service.isManager()) {
                Log.getLogWriter().info("startManagerIfRequired: This member is already a manager");
                return;
            }
            String limitManagersToMembers = CommandPrms.getLimitManagersToMembers();
            if (limitManagersToMembers != null && !limitManagersToMembers.equalsIgnoreCase("all")) {
                List<String> memberNames = Arrays.asList(limitManagersToMembers.split("-"));
                String myName = System.getProperty("clientName");
                boolean withinLimit = false;
                for (String name : memberNames) {
                    if (myName.indexOf(name) < 0) continue;
                    withinLimit = true;
                    break;
                }
                if (!withinLimit) {
                    Log.getLogWriter().info("startManagerIfRequired: Not starting a manager because this member is not " + limitManagersToMembers);
                    return;
                }
            }
            String key = isManagerKeyPrefix + RemoteTestModule.getMyVmid();
            if (!CommandBB.getBB().getSharedMap().containsKey(key)) {
                String nbrOfManagers = CommandPrms.getNbrOfManagers();
                Log.getLogWriter().info("startManagerIfRequired: CommandPrms-nbrOfManagers:" + nbrOfManagers);
                if (!nbrOfManagers.equals("all")) {
                    int nbrOfMgrsToStart;
                    block28: {
                        try {
                            nbrOfMgrsToStart = Integer.parseInt(nbrOfManagers);
                            if (nbrOfMgrsToStart > 0) break block28;
                            Log.getLogWriter().info("startManagerIfRequired: Not starting a manager because CommandPrms-nbrOfManagers is " + nbrOfManagers);
                            return;
                        }
                        catch (NumberFormatException ex) {
                            throw new TestException("Invalid 'nbrOfManagers' option.  Must be a valid number or the word 'all'");
                        }
                    }
                    long mgrCnt = CommandBB.getBB().getSharedCounters().incrementAndRead(CommandBB.managerCount);
                    if (mgrCnt > (long)nbrOfMgrsToStart) {
                        Log.getLogWriter().info("startManagerIfRequired: Not starting a manager to not exceed CommandPrms-nbrOfManagers " + nbrOfManagers);
                        return;
                    }
                }
            }
            String clientName = System.getProperty("clientName");
            ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
            GemFireDescription gfd = cd.getGemFireDescription();
            Boolean jmxManager = gfd.getJMXManager();
            Log.getLogWriter().info("startManagerIfRequired: Starting a manager");
            try {
                service.startManager();
                CommandBB.getBB().getSharedMap().put(isManagerKeyPrefix + RemoteTestModule.getMyVmid(), new Boolean(true));
                CommandBB.getBB().getSharedMap().put(expectManagerKeyPrefix + RemoteTestModule.getMyVmid(), new Boolean(true));
                boolean isManager = service.isManager();
                if (!isManager) {
                    throw new TestException("Called ManagementService.startManager() but isManager() is " + isManager);
                }
                if (jmxManager == null) {
                    if (!clientName.contains("locator")) {
                        throw new TestException("startManager() did not throw " + ManagementException.class.getName());
                    }
                } else if (!jmxManager.booleanValue()) {
                    throw new TestException("startManager() did not throw " + ManagementException.class.getName() + " but jmxManager is " + jmxManager);
                }
            }
            catch (ManagementException e) {
                if (jmxManager == null ? clientName.contains("locator") : jmxManager != false) {
                    throw e;
                }
                String errStr = e.toString();
                if (!errStr.contains("Could not start the manager because the gemfire property \"jmx-manager\" is false.")) {
                    throw e;
                }
                Log.getLogWriter().info("Caught expected " + (Object)((Object)e));
                boolean isManager = service.isManager();
                if (isManager) {
                    throw new TestException("ManagementService.startManager() threw " + (Object)((Object)e) + " but isManager() is " + isManager);
                }
            }
        }
        finally {
            CommandTest.HydraTask_recordManagerStatus();
        }
    }

    public static String[] connectCLI() {
        String howToConnect = CommandPrms.getHowToConnect();
        if (howToConnect == null) {
            if (CommandPrms.getConnectToLocator()) {
                return testInstance.connectToLocator();
            }
            return testInstance.connectToJMXManager(false);
        }
        if (howToConnect.equals("locator")) {
            return testInstance.connectToLocator();
        }
        if (howToConnect.equals("jmxManager")) {
            return testInstance.connectToJMXManager(false);
        }
        if (howToConnect.equals("http")) {
            return testInstance.connectToJMXManager(true);
        }
        throw new TestException("CommandPrms-howToConnect is set to " + howToConnect);
    }

    public static String toHexString(byte[] array) {
        char[] symbols = "0123456789ABCDEF".toCharArray();
        char[] hexValue = new char[array.length * 2];
        for (int i = 0; i < array.length; ++i) {
            int current = array[i] & 0xFF;
            hexValue[i * 2 + 1] = symbols[current & 0xF];
            hexValue[i * 2] = symbols[current >> 4];
        }
        return new String(hexValue);
    }

    private static String setToString(Set aSet) {
        StringBuilder aStr = new StringBuilder();
        for (Object element : aSet) {
            aStr.append("  " + element + "\n");
        }
        return aStr.toString();
    }

    private void writeJarBytesToFile(File jarFile, byte[] jarBytes) throws IOException {
        FileOutputStream outStream = new FileOutputStream(jarFile);
        ((OutputStream)outStream).write(jarBytes);
        ((OutputStream)outStream).close();
    }

    public static void HydraTask_testAsyncEventQueueCommands() {
        if (CommandTest.isMultiHost()) {
            testInstance.cmdCreateAsyncEventQueueTestMultiHost();
        } else {
            testInstance.cmdListAsyncEventQueueTest();
            testInstance.cmdCreateAsyncEventQueueTest();
        }
    }

    public static void HydraTask_testCreateDiskStoreCommands() {
        if (CommandTest.isMultiHost()) {
            testInstance.cmdCreateDiskStoreTestMultiHost();
        } else {
            testInstance.cmdCreateDiskStoreTest();
        }
    }

    private void cmdCreateAsyncEventQueueTest() {
        Log.getLogWriter().info("cmdCreateAsyncEventQueueTest-Start");
        this.verifyThatThereShouldNotBeAnyAsyncEventQueue();
        int asyncEventQueueSize = this.getAsycEventQueueSize();
        CmdOptionInfo withInvalidIdOption = new CmdOptionInfo(PARM_ID, "", "-23", true, true);
        CmdOptionInfo withInvalidListenerOption = new CmdOptionInfo(PARM_LISTENER, "", "-23", true, true);
        this.checkNamedParams(CMD_CREATE_ASYNC_EVENT_QUEUE, new CmdOptionInfo[]{withInvalidIdOption, withInvalidListenerOption});
        String[] members = this.getMembers();
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "-23") + this.prepareCommandParams(PARM_LISTENER, "-23"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator(members)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "ERROR: java.lang.ClassNotFoundException: -23")).add(ResultValidatorHelper.shouldNotHaveValidator("Success")));
        this.deployJarForListener();
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "Create_AsyncEventQueue_1") + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator(this.mergeArrays(members, new String[]{"Success"}))).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length - 1, "ERROR: com.gemstone.gemfire.cache.DiskAccessException: For DiskStore: DEFAULT: Could not lock \"./DRLK_IFDEFAULT.lk\". Other JVMs might have created diskstore with same name using the same directory.")));
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(++asyncEventQueueSize)).add(ResultValidatorHelper.onlyOneOccuranceValidator("Create_AsyncEventQueue_1")));
        String availableDiskStoreName = this.getAvailableDiskStoreName();
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "AsyncEventQueue_To_Test_Dup") + this.prepareCommandParams(PARM_DISK_STORE, availableDiskStoreName) + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator(members)).add(ResultValidatorHelper.shouldNotHaveValidatorWithIgnoreCase("ERROR", "EXCEPTION")));
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "AsyncEventQueue_To_Test_Dup") + this.prepareCommandParams(PARM_DISK_STORE, availableDiskStoreName) + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator(members)).add(ResultValidatorHelper.shouldNotHaveValidatorWithIgnoreCase("SUCCESS")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "ERROR: java.lang.IllegalStateException: A GatewaySender with id  AsyncEventQueue_AsyncEventQueue_To_Test_Dup  is already defined in this cache.")));
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize += 4)).add(ResultValidatorHelper.verifyLineForTabularData("AsyncEventQueue_To_Test_Dup", "100", "false", availableDiskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "AsyncEventQueue_To_Test_Dup")));
        String group = this.getAvailableGroupName();
        List<String> membersByGroup = this.getMembersByGroupName(group);
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "Create_AsyncEventQueue_2") + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener") + this.prepareCommandParams(PARM_GROUP, group) + this.prepareCommandParams(PARM_BATCH_SIZE, "1024") + this.prepareCommandParams(PARM_PERSISTENT, "true") + this.prepareCommandParams(PARM_DISK_STORE, availableDiskStoreName) + this.prepareCommandParams(PARM_MAXIMUM_QUEUE_MEMORY, "512") + this.prepareCommandParams(PARM_LISTENER_PARAM_AND_VALUE, "param1") + this.prepareCommandParams(PARM_LISTENER_PARAM_AND_VALUE, "param2#value2"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(membersByGroup.size())).add(ResultValidatorHelper.onlyOneOccuranceValidator(membersByGroup.toArray(new String[membersByGroup.size()]))).add(ResultValidatorHelper.shouldNotHaveValidatorWithIgnoreCase("ERROR", "EXCEPTION")));
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize + membersByGroup.size())).add(ResultValidatorHelper.verifyLineForTabularData("Create_AsyncEventQueue_2", "1024", "true", availableDiskStoreName, "512", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(membersByGroup.size(), "Create_AsyncEventQueue_2")));
        this.cleanupAsyncEventQueue();
        Log.getLogWriter().info("cmdCreateAsyncEventQueueTest-End");
    }

    private void cmdListAsyncEventQueueTest() {
        Log.getLogWriter().info("cmdListAsyncEventQueueTest-Start");
        String ASYNC_EVENT_QUEUE_NAME = "List_AsyncEventQueue_Test_";
        String MSG_NO_ASYNC_EVENT_QUEUE_FOUND = "No Async Event Queues Found";
        int asyncEventQueueSize = this.getAsycEventQueueSize();
        if (asyncEventQueueSize < 2) {
            this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, "No Async Event Queues Found");
            asyncEventQueueSize = 0;
        } else {
            asyncEventQueueSize -= 2;
        }
        this.deployJarForListener();
        String[] members = this.getMembers();
        String diskStoreName = this.getAvailableDiskStoreName();
        for (int i = 0; i < 10; ++i) {
            CmdOptionInfo withValidIdOption = new CmdOptionInfo(PARM_ID, "", ASYNC_EVENT_QUEUE_NAME + i, true, false);
            CmdOptionInfo withValidListenerOption = new CmdOptionInfo(PARM_LISTENER, "", "com.hydratest.CreateAsyncEventQueueTestListener", true, false);
            CmdOptionInfo withDiskStoreOption = new CmdOptionInfo(PARM_DISK_STORE, "", diskStoreName, false, false);
            this.checkMultiLineExecution(CMD_CREATE_ASYNC_EVENT_QUEUE, new CmdOptionInfo[]{withValidIdOption, withValidListenerOption, withDiskStoreOption});
            asyncEventQueueSize += members.length;
        }
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize)).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_0", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_1", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_2", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_3", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_4", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_5", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_6", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_7", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_8", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.verifyLineForTabularData("List_AsyncEventQueue_Test_9", "100", "false", diskStoreName, "100", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_0")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_1")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_2")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_3")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_4")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_5")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_6")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_7")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_8")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "List_AsyncEventQueue_Test_9")));
        String groupName = this.getAvailableGroupName();
        diskStoreName = this.getAvailableDiskStoreName();
        this.checkMultiLineExecution(CMD_CREATE_ASYNC_EVENT_QUEUE, new CmdOptionInfo[]{new CmdOptionInfo(PARM_ID, "", ASYNC_EVENT_QUEUE_NAME + 11, true, false), new CmdOptionInfo(PARM_LISTENER, "", "com.hydratest.CreateAsyncEventQueueTestListener", true, false), new CmdOptionInfo(PARM_GROUP, "", groupName, false, false), new CmdOptionInfo(PARM_DISK_STORE, "", diskStoreName, false, false), new CmdOptionInfo(PARM_BATCH_SIZE, "", "1024", false, false), new CmdOptionInfo(PARM_PERSISTENT, "", "false", false, false), new CmdOptionInfo(PARM_MAXIMUM_QUEUE_MEMORY, "", "512", false, false)});
        List<String> membersByGroup = this.getMembersByGroupName(groupName);
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize + membersByGroup.size())).add(ResultValidatorHelper.verifyLineForTabularData(ASYNC_EVENT_QUEUE_NAME + 11, "1024", "false", diskStoreName, "512", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(membersByGroup.size(), ASYNC_EVENT_QUEUE_NAME + 11)));
        this.createAndVerifyAsyncEventQueueByAPI();
        this.cleanupAsyncEventQueue();
        Log.getLogWriter().info("cmdListAsyncEventQueueTest-End");
    }

    private void cmdCreateDiskStoreTest() {
        Log.getLogWriter().info("cmdCreateDiskStoreTest-Start");
        int diskStoreCount = this.getAvailableDiskStoreCount();
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(diskStoreCount)));
        this.checkNamedParams(CMD_CREATE_DISK_STORE, new CmdOptionInfo[]{new CmdOptionInfo(PARM_NAME, "", "DiskStore1", true, false), new CmdOptionInfo(PARM_DIR, "", ".", true, false)});
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(diskStoreCount)));
        String availableGroupName = this.getAvailableGroupNameWithOnlyOneMember();
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_1") + this.prepareCommandParams(PARM_DIR, "createDiskStore1_") + this.prepareCommandParams(PARM_GROUP, availableGroupName), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(1)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "ERROR: java.lang.IllegalArgumentException: \"createDiskStore1_\" was not an existing directory.")));
        File diskStoreDir1 = this.createDiskStoreDir("1", availableGroupName);
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_1") + this.prepareCommandParams(PARM_DIR, diskStoreDir1.getAbsolutePath()) + this.prepareCommandParams(PARM_GROUP, availableGroupName), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(1)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "Success")));
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(++diskStoreCount)).add(ResultValidatorHelper.verifyLineForTabularData("CREATE_DISK_STORE_1")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "CREATE_DISK_STORE_1")));
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_1") + this.prepareCommandParams(PARM_DIR, diskStoreDir1.getAbsolutePath()) + this.prepareCommandParams(PARM_GROUP, availableGroupName), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(1)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "Success")));
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(diskStoreCount)).add(ResultValidatorHelper.verifyLineForTabularData("CREATE_DISK_STORE_1")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "CREATE_DISK_STORE_1")));
        this.verifyDiskStore("CREATE_DISK_STORE_1", this.getMembersByGroupName(availableGroupName).get(0), diskStoreDir1.getAbsolutePath());
        String newGroupName = availableGroupName;
        while (newGroupName.equals(availableGroupName)) {
            newGroupName = this.getAvailableGroupNameWithOnlyOneMember();
        }
        File diskStoreDir2 = this.createDiskStoreDir("1", newGroupName);
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_1") + this.prepareCommandParams(PARM_DIR, diskStoreDir2.getAbsolutePath()) + this.prepareCommandParams(PARM_GROUP, newGroupName), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(1)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "Success")));
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(++diskStoreCount)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(2, "CREATE_DISK_STORE_1")));
        this.verifyDiskStore("CREATE_DISK_STORE_1", this.getMembersByGroupName(newGroupName).get(0), diskStoreDir2.getAbsolutePath());
        File diskStoreDir3 = this.createDiskStoreDir("2", newGroupName);
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_2") + this.prepareCommandParams(PARM_DIR, diskStoreDir3.getAbsolutePath() + this.prepareCommandParams(PARM_GROUP, newGroupName)), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(1)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "Success")));
        this.verifyDiskStore("CREATE_DISK_STORE_2", this.getMembersByGroupName(newGroupName).get(0), diskStoreDir3.getAbsolutePath());
        File diskStoreDir4 = this.createDiskStoreDir("3", newGroupName);
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_3") + this.prepareCommandParams(PARM_GROUP, newGroupName) + this.prepareCommandParams(PARM_DIR, diskStoreDir4.getAbsolutePath() + "#143323") + this.prepareCommandParams(PARM_ALLOW_FORCE_COMPACTION, "true") + this.prepareCommandParams(PARM_AUTO_COMPACT, "false") + this.prepareCommandParams(PARM_COMPACTION_THRESHOLD, "67") + this.prepareCommandParams(PARM_MAX_OPLOG_SIZE, "355") + this.prepareCommandParams(PARM_QUEUE_SIZE, "5321") + this.prepareCommandParams(PARM_TIME_INTERVAL, "2023") + this.prepareCommandParams(PARM_WRITE_BUFFER_SIZE, "3110"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(1)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(1, "Success")));
        this.verifyDiskStore("CREATE_DISK_STORE_3", this.getMembersByGroupName(newGroupName).get(0), "Yes", "No", "67", "355", "5321", "2023", "3110", null, diskStoreDir4.getAbsolutePath(), "143323");
        Log.getLogWriter().info("cmdCreateDiskStoreTest-End");
    }

    private void cmdCreateDiskStoreTestMultiHost() {
        Log.getLogWriter().info("cmdCreateDiskStoreTestMultiHost-Start");
        int diskStoreCount = this.getAvailableDiskStoreCount();
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(diskStoreCount)));
        String[] members = this.getMembers();
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_MULTI_1") + this.prepareCommandParams(PARM_DIR, "createDiskStore1_"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "ERROR: java.lang.IllegalArgumentException: \"createDiskStore1_\" was not an existing directory.")));
        this.checkCommand(CMD_CREATE_DISK_STORE + this.prepareCommandParams(PARM_NAME, "CREATE_DISK_STORE_MULTI_1") + this.prepareCommandParams(PARM_DIR, "."), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "Success")));
        this.checkCommand(CMD_LIST_DISKSTORES, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(diskStoreCount + members.length)).add(ResultValidatorHelper.verifyLineForTabularData("CREATE_DISK_STORE_MULTI_1")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "CREATE_DISK_STORE_MULTI_1")));
        for (int i = 0; i < members.length; ++i) {
            this.verifyDiskStore("CREATE_DISK_STORE_MULTI_1", members[i], null);
        }
        Log.getLogWriter().info("cmdCreateDiskStoreTestMultiHost-End");
    }

    private void cmdCreateAsyncEventQueueTestMultiHost() {
        Log.getLogWriter().info("cmdCreateAsyncEventQueueTestMultiHost-Start");
        this.verifyThatThereShouldNotBeAnyAsyncEventQueue();
        int asyncEventQueueSize = this.getAsycEventQueueSize();
        String[] members = this.getMembers();
        this.deployJarForListener();
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "Create_AsyncEventQueue_Multi_1") + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "Success")));
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize += members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator("Create_AsyncEventQueue_Multi_1")));
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "Create_AsyncEventQueue_Multi_1") + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator(members)).add(ResultValidatorHelper.shouldNotHaveValidatorWithIgnoreCase("SUCCESS")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "ERROR: java.lang.IllegalStateException: A GatewaySender with id  AsyncEventQueue_Create_AsyncEventQueue_Multi_1  is already defined in this cache.")));
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize)));
        this.checkCommand(CMD_CREATE_ASYNC_EVENT_QUEUE + this.prepareCommandParams(PARM_ID, "Create_AsyncEventQueue_2_Multi") + this.prepareCommandParams(PARM_LISTENER, "com.hydratest.CreateAsyncEventQueueTestListener") + this.prepareCommandParams(PARM_BATCH_SIZE, "1024") + this.prepareCommandParams(PARM_PERSISTENT, "true") + this.prepareCommandParams(PARM_MAXIMUM_QUEUE_MEMORY, "512") + this.prepareCommandParams(PARM_LISTENER_PARAM_AND_VALUE, "param1") + this.prepareCommandParams(PARM_LISTENER_PARAM_AND_VALUE, "param2#value2"), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(members.length)).add(ResultValidatorHelper.onlyOneOccuranceValidator(members)).add(ResultValidatorHelper.shouldNotHaveValidatorWithIgnoreCase("ERROR", "EXCEPTION")));
        this.checkCommand(CMD_LIST_ASYNC_EVENT_QUEUE, new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidatorForTabularOutut(asyncEventQueueSize + members.length)).add(ResultValidatorHelper.verifyLineForTabularData("Create_AsyncEventQueue_2_Multi", "1024", "true", "", "512", "com.hydratest.CreateAsyncEventQueueTestListener")).add(ResultValidatorHelper.noOfTimesOccuranceValidator(members.length, "Create_AsyncEventQueue_2_Multi")));
        this.cleanupAsyncEventQueue();
        Log.getLogWriter().info("cmdCreateAsyncEventQueueTestMultiHost-End");
    }

    private File createDiskStoreDir(String diskStoreName, String availableGroupName) {
        File diskStore1Dir1 = new File(new File(".").getAbsolutePath(), "DiskStore_" + diskStoreName + "." + availableGroupName);
        diskStore1Dir1.mkdir();
        return diskStore1Dir1;
    }

    private void verifyDiskStore(String diskStoreName, String diskStoreMember, String allowForceCompaction, String autoCompaction, String compactionThreshold, String maxOplogSize, String queueSize, String timeInterval, String writeBufferSize, String pdxMetaDataStored, String diskStoreDirName, String diskStoreSize) {
        this.checkCommand(CMD_DESCRIBE_DISKSTORE + this.prepareCommandParams(PARM_NAME, diskStoreName) + this.prepareCommandParams(PARM_MEMBER, diskStoreMember), new GenericCommandOutputValidator().add(ResultValidatorHelper.noOfLinesValidator(17)).add(ResultValidatorHelper.verifyLineForDescribe("Disk Store ID")).add(ResultValidatorHelper.verifyLineForDescribe("Disk Store Name", diskStoreName)).add(ResultValidatorHelper.verifyLineForDescribe("Member Name", diskStoreMember)).add(ResultValidatorHelper.verifyLineForDescribe("Allow Force Compaction", allowForceCompaction == null ? "No" : allowForceCompaction)).add(ResultValidatorHelper.verifyLineForDescribe("Auto Compaction", autoCompaction == null ? "Yes" : autoCompaction)).add(ResultValidatorHelper.verifyLineForDescribe("Compaction Threshold", compactionThreshold == null ? "50" : compactionThreshold)).add(ResultValidatorHelper.verifyLineForDescribe("Max Oplog Size", maxOplogSize == null ? "1024" : maxOplogSize)).add(ResultValidatorHelper.verifyLineForDescribe("Queue Size", queueSize == null ? "0" : queueSize)).add(ResultValidatorHelper.verifyLineForDescribe("Time Interval", timeInterval == null ? "1000" : timeInterval)).add(ResultValidatorHelper.verifyLineForDescribe("Write Buffer Size", writeBufferSize == null ? "32768" : writeBufferSize)).add(ResultValidatorHelper.verifyLineForDescribe("PDX Serialization Meta-Data Stored", pdxMetaDataStored == null ? "No" : pdxMetaDataStored)).add(ResultValidatorHelper.verifyLineForTabularData(diskStoreDirName, diskStoreSize)));
    }

    private void verifyDiskStore(String diskStoreName, String diskStoreMember, String diskStoreDirName) {
        this.verifyDiskStore(diskStoreName, diskStoreMember, null, null, null, null, null, null, null, null, diskStoreDirName, "2147483647");
    }

    private void createAsyncEventQueueByAPI() {
    }

    private void deployJarForListener() {
        try {
            File jarFile = new File(new File(".").getAbsolutePath(), "CreateAsyncEventQueueTest.jar");
            CopyOnWriteArraySet<String> filesToBeDeleted = new CopyOnWriteArraySet<String>();
            filesToBeDeleted.add(jarFile.getAbsolutePath());
            ClassBuilder classBuilder = new ClassBuilder();
            byte[] jarBytes = classBuilder.createJarFromClassContent("com/hydratest/CreateAsyncEventQueueTestListener", "package com.hydratest;import java.util.List; import java.util.Properties;import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2; import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;public class CreateAsyncEventQueueTestListener implements Declarable2, AsyncEventListener {Properties props;public boolean processEvents(List<AsyncEvent> events) { return true; }public void close() {}public void init(final Properties props) {this.props = props;}public Properties getConfig() {return this.props;}}");
            this.writeJarBytesToFile(jarFile, jarBytes);
            this.execCommand("deploy --dir=" + jarFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new TestException("There is a problems in the test when trying to deploy jar for async event queue", e);
        }
    }

    private void undeployJarForListener() {
        this.execCommand("undeploy --jar=CreateAsyncEventQueueTest.jar");
    }

    private String prepareCommandParams(String paramName, String paramValue) {
        return PARM_SPACE + PARM_PREFIX + paramName + PARM_VALUE_SEP + paramValue + PARM_SPACE;
    }

    private int getAvailableDiskStoreCount() {
        int lines = this.getOutputLines(CMD_LIST_DISKSTORES);
        return (lines -= 2) < 0 ? 0 : lines;
    }

    private int getAsycEventQueueSize() {
        int lines = this.getOutputLines(CMD_LIST_ASYNC_EVENT_QUEUE);
        return (lines -= 2) < 0 ? 0 : lines;
    }

    private int getOutputLines(String command) {
        ArrayList<String> outputText = this.runDataCommand(command);
        return outputText.size();
    }

    private String getAvailableDiskStoreName() {
        String memberName = this.parseMemberName(this.getMemberInfo(this.getRandomMember()));
        String diskStoreName = this.findDiskStoreName(memberName, this.execCommand(CMD_LIST_DISKSTORES));
        return diskStoreName;
    }

    private void createAndVerifyAsyncEventQueueByAPI() {
        this.createAsyncEventQueueByAPI();
    }

    private void cleanupAsyncEventQueue() {
        this.undeployJarForListener();
    }

    private void verifyThatThereShouldNotBeAnyAsyncEventQueue() {
    }

    public String[] mergeArrays(String[] mainArray, String[] addArray) {
        String[] finalArray = new String[mainArray.length + addArray.length];
        System.arraycopy(mainArray, 0, finalArray, 0, mainArray.length);
        System.arraycopy(addArray, 0, finalArray, mainArray.length, addArray.length);
        return finalArray;
    }

    private String[] getMembers() {
        Map memberMap = FederationBlackboard.getBB().getMemberONs();
        String[] members = new String[memberMap.size()];
        int i = 0;
        for (String member : memberMap.values()) {
            members[i++] = this.parseMemberName(member);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getMembersByGroupName(String groupName) {
        try {
            Map<String, Object> commandOutput = this.executeCommand("list members  --group=" + groupName);
            for (Object resultObject : commandOutput.values()) {
                List memberNames;
                CommandResult cr;
                if (!(resultObject instanceof CommandResult) || (cr = (CommandResult)resultObject).getType() != "table") continue;
                TabularResultData table = (TabularResultData)cr.getResultData();
                List list = memberNames = table.retrieveAllValues("Name");
                return list;
            }
        }
        finally {
            this.shell.clearEvents();
        }
        Log.getLogWriter().info("Not able to find any Members with groupName : " + groupName + ". This may led to failurer in test.");
        return null;
    }

    private static boolean isMultiHost() {
        Vector hosts = TestConfig.getInstance().getPhysicalHosts();
        HashSet uniqueuHosts = new HashSet(hosts);
        boolean isMultiHost = uniqueuHosts.size() > 1;
        Log.getLogWriter().info("This test is configured for " + (isMultiHost ? " multi host" : "single host"));
        return isMultiHost;
    }

    private String getAvailableGroupNameWithOnlyOneMember() {
        String groupName;
        List<String> members;
        int i = 0;
        do {
            Log.getLogWriter().info("Trying again to find group name with single member only. retry count :" + i);
        } while ((members = this.getMembersByGroupName(groupName = this.getAvailableGroupName())).size() != 1 && ++i != 5);
        if (i == 5) {
            Log.getLogWriter().info("Tried to find group name with single member but did not find anything. returning random group name which can fail test case");
        }
        return groupName;
    }

    public static void waitForSilence() {
        SilenceListener.waitForSilence(30L, 1000L);
    }

    public static void verifyBucketCopies() {
        Cache aCache = CacheHelper.getCache();
        if (aCache == null) {
            Log.getLogWriter().info("Not verifying bucket copies in this member, there is no cache");
            return;
        }
        HashSet regionSet = new HashSet(aCache.rootRegions());
        HashSet rootRegions = new HashSet(regionSet);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        for (Region aRegion : regionSet) {
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            Log.getLogWriter().info(PrState.getPrPicture(aRegion));
            int rc = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
            Log.getLogWriter().info("Verifying bucket copies for " + aRegion.getFullPath());
            ParRegUtil.verifyBucketCopies(aRegion, rc);
        }
    }

    private class GenericCommandOutputValidator
    implements CommandOutputValidator {
        Set<ResultValidator> validators = new HashSet<ResultValidator>();
        private Set<String> errors = new HashSet<String>();

        private GenericCommandOutputValidator() {
        }

        public GenericCommandOutputValidator add(ResultValidator validator) {
            if (validator != null) {
                this.validators.add(validator);
            }
            return this;
        }

        @Override
        public boolean validate(Map<String, Object> commandOutput) {
            String output = CommandTest.this.getPresentationString(commandOutput)[0];
            Log.getLogWriter().info("Command output to validate: \n" + output);
            for (ResultValidator validator : this.validators) {
                Log.getLogWriter().info("Command output validation result : " + (Object)((Object)validator.validate(output)) + "");
                if (validator.validate(output) != ResultValidator.Status.ERROR) continue;
                this.errors.add(validator.getMessage());
            }
            return this.errors.isEmpty();
        }

        @Override
        public String getFormattedErrors() {
            StringBuilder sb = new StringBuilder();
            for (String error : this.errors) {
                sb.append(error).append("\n");
            }
            return sb.toString();
        }
    }

    private class CmdOptionInfo {
        private String optionName;
        private String errorMsg;
        private String validValue;
        private boolean required;
        private boolean aBoolean;

        private CmdOptionInfo(String optionName, String errorMsg, String validValue, boolean required, boolean aBoolean) {
            this.optionName = optionName;
            this.errorMsg = errorMsg;
            this.validValue = validValue;
            this.aBoolean = aBoolean;
            this.required = required;
        }

        public String getName() {
            return this.optionName;
        }

        public String getValidValue() {
            return this.validValue;
        }

        public void setValidValue(String validValue) {
            this.validValue = validValue;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isBoolean() {
            return this.aBoolean;
        }
    }
}

